/***************************************************************************/
/*                                                                         */
/*                             W I N D O W . H                             */
/*                        Abstract Class Definition                        */
/*                                                                         */
/*     Engine : Window engine                                              */
/*     Content : Class Window                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 3rd, 2002                                  */
/*                                                                         */
/*          This class is part of a set of classes that will manage the    */
/*     drawing and memorisation of windows with it's content on the screen */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Constant Definition                             -*/
/*-------------------------------------------------------------------------*/

// colors

#define Window_COLOR_BORDER        makecol ( 250, 250, 250 )
//#define Window_BASECOLOR_BORDER    250
#define Window_COLOR_FILL          makecol ( 0, 0, 0 )
// ?? offer parametrable colors


//--- Windows type ---

#define Window_TYPE_EMPTY     0
#define Window_TYPE_TITLE     1
#define Window_TYPE_MENU      2
#define Window_TYPE_LIST      3
#define Window_TYPE_DATA      4
#define Window_TYPE_MESSAGE   5
#define Window_TYPE_QUESTION  6
#define Window_TYPE_INPUT     7

// --- Window border type ---

#define Window_BACKGROUND_COLOR     0
#define Window_BACKGROUND_TEXTURE   1

#define Window_BORDER_THICK  0
#define Window_BORDER_THIN   1
#define Window_BORDER_DOUBLE 2
#define Window_BORDER_FLAT   3
#define Window_BORDER_NONE   4

#define Window_TEXTURE_EARTH     0
#define Window_TEXTURE_SCROLL    1
#define Window_TEXTURE_FOREST    2
#define Window_TEXTURE_SLATE     3
#define Window_TEXTURE_ROCK      4

#define Window_COLOR_BLACK    0
#define Window_COLOR_GREEN    1
#define Window_COLOR_BLUE     2
#define Window_COLOR_PURPLE   3
#define Window_COLOR_BROWN    4

// --- WIndow Instruction ---

#define Window_INSTRUCTION_SELECT  1
#define Window_INSTRUCTION_CANCEL  2
#define Window_INSTRUCTION_DISPLAY 4
#define Window_INSTRUCTION_MENU    8
#define Window_INSTRUCTION_SWITCH  16
#define Window_INSTRUCTION_MOVE    32
#define Window_INSTRUCTION_INPUT   64
#define Window_INSTRUCTION_CAMP    128

/*-------------------------------------------------------------------------*/
/*-                         Type Definition                               -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Window_background
{
   int texturedatID; // texture ID number form the datafile
   byte red;
   byte green;
   byte blue;
}s_Window_background;

/*-------------------------------------------------------------------------*/
/*-                          Global Variables                             -*/
/*-------------------------------------------------------------------------*/

extern tiny BORDER_CORNER [ 4 ] [ 5 ] [ 5 ];
extern int BORDER_COLOR [ 5 ] [ 5 ];
extern s_Window_background Window_BACKGROUND [ 5 ];

/*-------------------------------------------------------------------------*/
/*-                       Class Definition                                -*/
/*-------------------------------------------------------------------------*/

class Window
{
   // --- Properties ---

   protected: short p_width; // width of the window with the border
   protected: short p_height; // height of the windows with the border
   protected: short p_x_pos; // X relative position of the window
   protected: short p_y_pos; // Y relative position of the window
   private: bool p_hidden; // indicates if the window should be hidden
   private: Window *p_ptr_next; // pointer of the next element
   private: Window *p_ptr_previous; // pointer on the previous object.
   protected: BITMAP* p_backup; // bitmap backuping the display of the window

   private: static Window *p_ptr_last; // pointer on the last element
   private: static Window *p_ptr_first; // pointer of the first element

   private: static tiny p_nb_open; // contains the number of windows currently opened
                            // should be initialised to 0
   private: static tiny p_border_type; // type of border to draw
   private: static tiny p_bg_mode; // draw color or textured background
   private: static tiny p_bg_color;
   private: static tiny p_bg_texture;
   
   protected: static tiny p_inst_order; // instructions to draw on the screen
   protected: static short p_inst_center_x; // center x position of the instruction
   protected: static short p_inst_y; // y position of the instruction
   protected: static const char *p_inst_string; // use string if order = -1

   // --- Constructor & Destructors

   public: Window ( void );
   public: virtual ~Window ( void );

   // --- Property Method ---

   public: short width ( void );
   public: short height ( void );
   public: short x_pos ( void );
   public: short y_pos ( void );
   public: Window* next ( void );
   public: Window* previous ( void );

   public: static tiny nb_open ( void );
   public: static tiny border_type ( void );
   public: static void border_type ( tiny type );
   public: static tiny background_color ( void );
   public: static void background_color ( tiny color );
   public: static tiny background_texture ( void );
   public: static void background_texture ( tiny texture );
   public: static tiny background_mode ( void );
   public: static void background_mode ( tiny mode );
   public: static void instruction ( short center_x, short y );
   public: static void instruction ( short center_x, short y, tiny order );
   public: static void instruction ( short center_x, short y, const char *str );

   // --- Mehtods ---

   public: void hide ( void );  // last window is alsways shown
   public: void unhide ( void );
   public: static short show_all ( void );
   public: static void draw_all ( void ); // the last window is drawn instead of shown
   public: static void refresh_all ( void );
   public: void draw ( void ); // used internaly -> try show_all or draw_all

   // --- Private Methods ---

//   private: void draw_border ( void );
   protected: void border_fill ( void );
   protected: static void draw_instruction ( void );


   // --- Virtual Methods ---

   public: virtual void preshow ( void ) = 0;
   public: virtual void refresh ( void ) = 0;
   public: virtual short show ( void ) = 0; // used internaly -> try show_all
   public: virtual tiny type ( void ) = 0;

   // --- Operators ---
};

/*-------------------------------------------------------------------------*/
/*-                     Global Variable Definition                        -*/
/*-------------------------------------------------------------------------*/


