/***************************************************************************/
/*                                                                         */
/*                            W I N D A T A . H                            */
/*                              Class Header                               */
/*                                                                         */
/*     Content : Class WinData                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 13th, 2002                                 */
/*                                                                         */
/*          Class who inherit from window which manage a window with       */
/*     various data in it.                                                 */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Class Definition                             -*/
/*-------------------------------------------------------------------------*/

template<class t_datatype>
class WinData : public Window
{
   /// --- Properties ---

   private: t_datatype *p_parameter; // parameter to pass to the drawing function
   private: void (*p_procedure)(t_datatype&, short, short ); // pointer to the function

   // --- Constructor & Destructor ---

   public: WinData ( void (*proc)( t_datatype&, short, short ),
                     t_datatype &param, short x_pos, short y_pos, short width,
                     short height );
//   public: ~WinData ( void );

   // --- property methods ---

   public: void parameter ( t_datatype &param );

   // --- Virtual Functions ---

   public: virtual void preshow ( void );
   public: virtual void refresh ( void );
   public: virtual short show ( void );
   public: virtual tiny type ( void );

};
