/***************************************************************************/
/*                                                                         */
/*                           W E A P O N . H                               */
/*                          Class Definition                               */
/*                                                                         */
/*     Content : Class Weapon                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : June 5th, 2002                                      */
/*                                                                         */
/*          This class contains the weapon statistic modifiers which will  */
/*     be applied to the weapon's manuver statistics.                      */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                         Constant parameter                            -*/
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*-                             Constants                                 -*/
/*-------------------------------------------------------------------------*/

// Weapon damage Type

#define Weapon_DMGTYPE_NORMAL       0
#define Weapon_DMGTYPE_PIERCE       1  // Armor Piercing, no DR??
#define Weapon_DMGTYPE_SPLASH       2  // Apply Cover
#define Weapon_DMGTYPE_DRAIN        3  // Ignore Defense, no DR, no PD only AD
#define Weapon_DMGTYPE_DEFENSELESS  4  // No AD ???
#define Weapon_DMGTYPE_AUTOHIT      5  // No hit roll ???

// Size
/*#define Weapon_SIZE_TINY              0
#define Weapon_SIZE_SMALL             1
#define Weapon_SIZE_MEDIUM            2
#define Weapon_SIZE_LARGE             3
#define Weapon_SIZE_HUGE              4*/

// category

#define Weapon_CATEGORY_NONE        0
#define Weapon_CATEGORY_MELEE       1
#define Weapon_CATEGORY_SWORD       2
#define Weapon_CATEGORY_BOW         3
#define Weapon_CATEGORY_MECHANIC    8
#define Weapon_CATEGORY_UNBALANCED  16
#define Weapon_CATEGORY_THROWN      32
#define Weapon_CATEGORY_MAGICAL     64

// Attack Range
#define Weapon_RANGE_MELEE            0
#define Weapon_RANGE_SHORT            1
#define Weapon_RANGE_LONG             2

// Attribute Required
#define Weapon_ATTRIB_STR             0
#define Weapon_ATTRIB_INT             1
#define Weapon_ATTRIB_DEX             2

// NB_hand
#define Weapon_ONEHANDED              1
#define Weapon_TWOHANDED              2

/*-------------------------------------------------------------------------*/
/*-                           Type Definition                             -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Weapon
{
   dbs_Item item_data a_packed;
   byte category a_packed;
   tiny range a_packed;
   tiny nb_hand a_packed;
   tiny attribute a_packed;
   tiny dmg_type a_packed;   
   tiny static_dmg a_packed;
   tiny dmg_x a_packed;
   tiny dmg_z a_packed;
   tiny nb_max_attack a_packed;
   tiny AD a_packed;
   tiny hitbonus a_packed;
}dbs_Weapon a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Weapon : public Item
{

   /*--- Properties ---*/

   private: tiny p_dmg_x;
   private: tiny p_dmg_z; // extra damage bonus
   private: tiny p_dmg_type;
   private: byte p_category;
   private: tiny p_range;
   private: tiny p_static_dmg;
   private: tiny p_nb_hand;
   private: tiny p_attribute;
   private: tiny p_nb_max_attack;
   private: tiny p_AD; // AD bonus for parrying
   private: tiny p_hitbonus; // extra attack bonus

   /*--- Constructor & Destructors ---*/

   public: Weapon ( void );
   public: Weapon ( DBTag weptag );
   public: ~Weapon ( void );

   /*--- Property Methods ---*/

   public: tiny dmg_x ( void );
   public: void dmg_x ( tiny value );
   public: tiny dmg_z ( void );
   public: void dmg_z ( tiny value );
   public: tiny dmg_type ( void );
   public: void dmg_type ( tiny value );
   public: byte category ( void );
   public: void category ( byte value );
   public: tiny range ( void );
   public: void range ( tiny value );
   public: tiny static_dmg ( void );
   public: void static_dmg ( tiny value );
   public: tiny nb_hand ( void );
   public: void nb_hand ( tiny value );
   public: tiny attribute ( void );
   public: void attribute ( tiny value );
   public: tiny nb_max_attack ( void );
   public: void nb_max_attack ( tiny value );
   public: tiny AD ( void );
   public: void AD ( tiny value );
   public: tiny hitbonus ( void );
   public: void hitbonus ( tiny value );

/*   public: const char* sizeS ( void );
   public: const char* rangeS ( void );
   public: const char* attributeS ( void );
   public: const char* nb_handS ( void );*/

   /*--- Methods ---*/

   /*--- Private Methods ---*/

   /*--- Virtual Methods ---*/

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );
};

/*-------------------------------------------------------------------------*/
/*-                          Global Variables                             -*/
/*-------------------------------------------------------------------------*/

extern const char STR_WPN_CATEGORY [][12];
extern const char STR_WPN_RANGE [][7];
extern const char STR_WPN_ATTRIBUTE [][4];
extern const char STR_WPN_DMGTYPE [][16];


