/***************************************************************************/
/*                                                                         */
/*                              S Y S T E M . H                            */
/*                             Module Definition                           */
/*                                                                         */
/*     Content : Module System                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 3rd, 2002                                  */
/*                                                                         */
/*          Primordial definition for system functionality                 */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                     Global Constant Parameters                        -*/
/*-------------------------------------------------------------------------*/

#define Allegro_NB_OPERATING_SYSTEM 18
#define Allegro_NB_CPU_FAMILY       5
#define System_NB_MUSIC             39
#define System_NB_FONT              14


/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

// music track identifier

#define System_MUSIC_w1camp      0
#define System_MUSIC_w1city      1
#define System_MUSIC_w1fight     2
#define System_MUSIC_w1credit    3
#define System_MUSIC_w1dungon    4
#define System_MUSIC_w1edge      5
#define System_MUSIC_w1ending    6
#define System_MUSIC_w1inn       7
#define System_MUSIC_w1intro     8
#define System_MUSIC_w1lvl10     9
#define System_MUSIC_w1shop      10
#define System_MUSIC_w1tavern    11
#define System_MUSIC_w1temple    12
#define System_MUSIC_w1victor    13
#define System_MUSIC_w2camp      14
#define System_MUSIC_w2city      15
#define System_MUSIC_w2death     16
#define System_MUSIC_w2dungon    17
#define System_MUSIC_w2edge      18
#define System_MUSIC_w2ending    19
#define System_MUSIC_w2fight     20
#define System_MUSIC_w2inn       21
#define System_MUSIC_w2intro     22
#define System_MUSIC_w2shop      23
#define System_MUSIC_w2tavern    24
#define System_MUSIC_w2temple    25
#define System_MUSIC_w3boss      26
#define System_MUSIC_w3camp      27
#define System_MUSIC_w3city      28
#define System_MUSIC_w3death     29
#define System_MUSIC_w3dungon    30
#define System_MUSIC_w3edge      31
#define System_MUSIC_w3ending    32
#define System_MUSIC_w3fight     33
#define System_MUSIC_w3inn       34
#define System_MUSIC_w3intro     35
#define System_MUSIC_w3shop      36
#define System_MUSIC_w3tavern    37
#define System_MUSIC_w3temple    38

/*-------------------------------------------------------------------------*/
/*-                           Type Definition                             -*/
/*-------------------------------------------------------------------------*/

typedef struct s_OS_Identification
{
   int ID;
   char name [ 16 ];
}s_OS_Identification;

typedef struct s_CPU_family
{
   short ID;
   char name [ 13 ];
}s_CPU_family;

typedef struct s_music_track
{
   char name [ 36 ];
   MIDI* music;
}s_music_track;

typedef struct s_font_list
{
   char name [ 21 ];
   short dataID;
}s_font_list;

/*-------------------------------------------------------------------------*/
/*-                    Global Variables                                   -*/
/*-------------------------------------------------------------------------*/

extern DATAFILE *datfaudio; // Audio datafile
extern DATAFILE *datfmaze; // Maze textures datafile
extern DATAFILE *datfimage; // Image datafile
extern DATAFILE *datfeditor; // Editor datafile
extern DATAFILE *datfennemy; // Ennemy Images
extern DATAFILE *datffont; // Ennemy Images
extern DATAFILE *adatf; // main datafile

// double buffer system

extern BITMAP *buffer; // create a double buffer
extern BITMAP *backup; // create screen backup buffer // should become obsolete

// Keyboard generic keys;

extern tiny SELECT_KEY;
extern tiny CANCEL_KEY;
extern tiny DISPLAY_KEY;

// System identification variables

extern s_OS_Identification OS_NAME [ Allegro_NB_OPERATING_SYSTEM ];
extern s_CPU_family CPU_FAMILY_NAME [ Allegro_NB_CPU_FAMILY ];

// System music list

extern s_music_track MUSIC_LIST [ System_NB_MUSIC ];

// other
extern s_font_list FONT_LIST [ System_NB_FONT ];

