/***************************************************************************/
/*                                                                         */
/*                           S H I E L D . H                               */
/*                           Class Definition                              */
/*                                                                         */
/*     Content : Class Shield                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : June 7th, 2002                                      */
/*                                                                         */
/*          This class contains the database class for shield equipment    */
/*     which can be equiped in a hand for defensive purpose                */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

//shield category

#define Shield_CATEGORY_NONE     0     // Can equip with 2 handed weapon
#define Shield_CATEGORY_LIGHT    1
#define Shield_CATEGORY_HEAVY    2

/*-------------------------------------------------------------------------*/
/*-                           Type Definitnion                            -*/
/*-------------------------------------------------------------------------*/


typedef struct dbs_Shield
{
   dbs_Item item_data a_packed;
   tiny category a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny MPD a_packed;
   tiny MAD a_packed;
}dbs_Shield a_packed;

/*-------------------------------------------------------------------------*/
/*                            Class Definition                            -*/
/*-------------------------------------------------------------------------*/

class Shield : public Item
{

   /*--- Properties ---*/

   private: tiny p_PD;
   private: tiny p_AD;
   private: tiny p_MPD;
   private: tiny p_MAD;
   private: tiny p_category;

   /*--- Constructor & Destructor ---*/

   public: Shield ( void );
//   public: Shield ( Shield &obj );
   public: Shield ( DBTag shdtag );
   public: ~Shield ( void );

   /*--- Property Methods ---*/

   public: tiny PD ( void );
   public: void PD ( tiny value );
   public: tiny AD ( void );
   public: void AD ( tiny value );
   public: tiny MPD ( void );
   public: void MPD ( tiny value );
   public: tiny MAD ( void );
   public: void MAD ( tiny value );
   public: tiny category ( void );
   public: void category ( tiny value );


   /*--- Methods ---*/

   /*--- Virtual Methods ---*/

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};

/*--------------------------------------------------------------------*/
/*-                       Global Variables                           -*/
/*--------------------------------------------------------------------*/

extern const char STR_SHL_CATEGORY [][9];


