/***************************************************************************/
/*                                                                         */
/*                             S C R E E N . H                             */
/*                                                                         */
/*     Content : Game screen management procedures                         */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting date : May 12nd, 2002                                      */
/*                                                                         */
/*          This module contains many HIgh level procedures called by the  */
/*     main programm to manage the various screen of the games which are   */
/*     not a part of any class engine.                                     */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                             Constants                                 -*/
/*-------------------------------------------------------------------------*/

// title menu selection

#define SCREEN_TITLE_START        0
#define SCREEN_TITLE_CONTINUE     1
#define SCREEN_TITLE_GALLERY      2
#define SCREEN_TITLE_OPTION       3
#define SCREEN_TITLE_END_GAME     4

// art gallery menu selection

#define Screen_GALLERY_TEXTURE   0
#define Screen_GALLERY_MASKTEX   1
#define Screen_GALLERY_MONSTER   2
#define Screen_GALLERY_OBJECT    3
#define Screen_GALLERY_MUSIC     4
#define Screen_GALLERY_SOUND     5
#define Screen_GALLERY_FONT      6
#define Screen_GALLERY_EXIT      7

/*-------------------------------------------------------------------------*/
/*-                      Procedure Prototypes                             -*/
/*-------------------------------------------------------------------------*/

void show_copyright_screen ( void );
tiny show_title_screen ( void );
void show_loading_screen ( const char *title, short percentage );
void show_art_gallery ( void );
void show_transition_algo7 ( BITMAP *before, BITMAP *after, tiny delay );


