/***************************************************************************/
/*                                                                         */
/*                                R A C E . H                              */
/*                             Class Definition                            */
/*                                                                         */
/*     Content : Class Race                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 7th, 2004                                  */
/*     License : GNU General Public License                                */
/*                                                                         */
/*          This class encapsulate and manage the race information of the  */
/*     character.                                                          */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Constants                                    -*/
/*-------------------------------------------------------------------------*/

// aligment restriction

#define Race_ALIGRESTRICT_KIND         1  // life         kn
#define Race_ALIGRESTRICT_PEACEFULL    2  // water        pf
#define Race_ALIGRESTRICT_LIVELY       4  // Air          lv
#define Race_ALIGRESTRICT_SELLFISH     8  // Death        sf
#define Race_ALIGRESTRICT_AGGRESSIVE   16 // Fire         ag
#define Race_ALIGRESTRICT_STOICAL      32 // Earth        st

// health resistance

//  race size
// race abilities

#define Race_ABILITY_NONE           0
#define Race_ABILITY_AMPHIBIOUS     1 // -wil
#define Race_ABILITY_FLYING         2 // -end
#define Race_ABILITY_DARKVISION     3 // -cun
#define Race_ABILITY_ARMOR_SKIN     4 // -dex
#define Race_ABILITY_BREATH         5 // -dex
#define Race_ABILITY_NATURAL_MAGIC  6 // -int
#define Race_ABILITY_RESIST_MAGIC   7 // -str
#define Race_ABILITY_LUCKY          8 // -end

/*-------------------------------------------------------------------------*/
/*-                        Type Definition                                -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Race
{
   char name [ 13 ] a_packed;
   char plural [ 13 ] a_packed;
   tiny attribute [ 6 ] a_packed;
   byte aligment_restriction a_packed;
   short lifespan a_packed;
   word health_resist a_packed;
   tiny size a_packed;
   tiny HPdice a_packed;
   tiny MPdice a_packed;
   tiny DMGdice a_packed;
   tiny MDMGdice a_packed;
   tiny ability [ 3 ] a_packed;
}dbs_Race a_packed;

typedef struct s_Race_stat_modifier
{
   char name [ 16 ];
   char sname [ 5 ];
}s_Race_stat_modifier;

/*-------------------------------------------------------------------------*/
/*-                       Class Definition                                -*/
/*-------------------------------------------------------------------------*/

class Race : public DBObject
{
   // Properties

   private: char p_name [ 13 ];
   private: char p_plural [ 13 ];
   private: tiny p_attribute [ 6 ];
   private: byte p_aligment_restriction;
   private: short p_lifespan;
   private: word p_health_resist;
   private: tiny p_size;
   private: tiny p_HPdice;
   private: tiny p_MPdice;
   private: tiny p_DMGdice;
   private: tiny p_MDMGdice;
   
   private: tiny p_ability [ 3 ];

   // Constructor & Destructor

   public: Race ( void );
   public: ~Race ( void );

   // Property Method

   public: const char* name ( void );
   public: const char* plural ( void );
   public: tiny attribute ( tiny attributeID );
   public: short lifespan ( void );
   public: word health_resist ( void );
   public: byte aligment_restriction ( void );
   public: tiny size ( void );
   public: tiny HPdice ( void );
   public: tiny MPdice ( void );
   public: tiny DMGdice ( void );
   public: tiny MDMGdice ( void );
   public: tiny ability ( tiny index );

   // Method

   public: void edit ( void ); // race editor

   // Virtual Methods
   
   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );


};

/*-------------------------------------------------------------------------*/
/*-                      Global Variables                                 -*/
/*-------------------------------------------------------------------------*/

extern short LIFE_SPAN [ 5 ];
extern s_Race_stat_modifier STAT_MODIFIER [ 6 ];
