/***************************************************************************/
/*                                                                         */
/*                            P L A Y E R . H                              */
/*                           Class Definition                              */
/*                                                                         */
/*     Content : Class Player                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 30th, 2002                                    */
/*                                                                         */
/*          This is the object containing all the data related to the      */
/*     player.                                                             */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                      Constant Class Parameter                         -*/
/*-------------------------------------------------------------------------*/

#define Player_NB_MAX_CHARACTER  18


/*-------------------------------------------------------------------------*/
/*-                             Constant                                  -*/
/*-------------------------------------------------------------------------*/
/*
// player status

#define Player_STATUS_LOGGEDOFF     1
#define Player_STATUS_LOGGEDON      2
#define Player_STATUS_PLAYING       3

// player account

#define Player_ACCOUNT_ACTIVE       1
#define Player_ACCOUNT_SUSPENDED    2
*/

// define player screen selection

#define Player_CREATE_CHARACTER     0
#define Player_INSPECT_CHARACTER    1
#define Player_DELETE_CHARACTER     2
#define Player_RENAME_CHARACTER     3
#define Player_CREATE_PARTY         4
#define Player_DISBAND_PARTY        5
#define Player_SELECT_PARTY         6
#define Player_LOGOUT               7

// start return code
#define Player_CONTINUE    0
#define Player_EXIT        1
#define Player_START_GAME  2

/*-------------------------------------------------------------------------*/
/*-                         type definition                               -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Player
{
   dword character [ Player_NB_MAX_CHARACTER ] a_packed;
   dword party [ 3 ] a_packed;
   tiny nb_character a_packed;
   tiny selected_party a_packed;
   tiny nb_party a_packed;
   dword account a_packed;
   dword game a_packed;
   dword default_city a_packed;
}dbs_Player a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Player : public DBObject
{

   //--- Properties ---

   // these are used onlywhen the character is logged is is not saved in the database
   private: DBTag p_character [ Player_NB_MAX_CHARACTER ]; // copy characters owned by the player
   private: DBTag p_party [ 3 ]; // parties made by the character.
   private: tiny p_nb_character; // nb of character owned by the player
   private: tiny p_selected_party; // currently playing party.
   private: tiny p_nb_party; // number of party created by the player
   private: DBTag p_account; // tag on the account of the player
   private: DBTag p_game; // tag of the game
   private: DBTag p_default_city; // tag of the city to start a new party.

   //--- Constructor & Destructor ---

   public: Player ( void );
   public: ~Player ( void );

   //--- Property Method ---



   // these are used when the character is logged
   public: tiny nb_character ( void );
   public: tiny nb_party ( void );
   public: DBTag character ( tiny ID );
   public: DBTag selected_party ( void );
   public: tiny selected_partyID ( void );
   public: DBTag party ( tiny partyID );
   public: DBTag account ( void );
   public: void account ( DBTag value );
   public: DBTag game ( void );
   public: void game ( DBTag value );
   public: DBTag default_city ( void );
   public: void default_city ( DBTag value );

   //--- Method ---

   public: tiny start ( void );

   public: void delete_character ( tiny characterID );
   public: void disband_party ( tiny partyID );
   public: void destroy_party ( tiny partyID );
   public: void select_default_city ( void );

   //--- Private Methods ---

   private: void show_create_character ( void );
   private: void show_inspect_character ( void );
   private: void show_delete_character ( void );
   private: void show_rename_character ( void );
   private: void show_create_party ( void );
   private: void show_disband_party ( void );
   private: tiny show_select_party ( void );
//   private: void compact_characters ( void );

   private: void new_character_name ( Character &character );
   private: void new_character_family ( Character &character );
   private: void new_character_reputation ( Character &character );
   private: void new_character_sex ( Character &character );
   private: void new_character_race ( Character &character );
   private: void new_character_aligment ( Character &character );
   private: void new_character_attribute ( Character &character );
   private: void new_character_class ( Character &character );
//   private: void new_character_element ( Character &character );

   // --- virtual Functions ---
//   public: virtual DBTag DBinsert ( void );
//   public: virtual void DBupdate ( void );
//   public: virtual void DBselect ( DBTag value, bool readonly = false );
//   public: virtual void DBselect ( dword index, bool readonly = false );
//   public: virtual void DBremove ( void );

//   public: void exDBselect ( Database &datb, dword index, bool readonly = false );
//   public: void exDBremove ( Database &datb );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};

/*-------------------------------------------------------------------------*/
/*-                   Global Variable Definition                          -*/
/*-------------------------------------------------------------------------*/

//extern Player player; // player logged on the client

