/***************************************************************************/
/*                                                                         */
/*                             P A R T Y . H                               */
/*                           Class definition                              */
/*                                                                         */
/*     Content : Class Party                                               */
/*     Programmer : Eric Pietrocupo                                        */
/*     Stating date : May 1st, 2002                                        */
/*                                                                         */
/*         This class contains a regroupment of characters that will be    */
/*     used by most engine ( like maze and city ) to keep track of who is  */
/*     traveling in those engine.                                          */
/*                                                                         */
/***************************************************************************/

// note : since this class use tag to identify party members, it will also be
// possible to make parties of ennemies.

/*-------------------------------------------------------------------------*/
/*-                             Constants                                 -*/
/*-------------------------------------------------------------------------*/

// party spell index
#define Party_NB_SPELL        12

#define Party_SPELL_LIGHT           0
#define Party_SPELL_PROTECT         1
#define Party_SPELL_LEVITATE        2
#define Party_SPELL_IDENTIFY        3
#define Party_SPELL_FEAR            4
#define Party_SPELL_WATER_BREATH    5
#define Party_SPELL_IMMOLATE        6
#define Party_SPELL_GASEOUS_FORM    7
#define Party_SPELL_ETHEREAL_FORM   8
#define Party_SPELL_RESERVED1       9
#define Party_SPELL_RESERVED2       10
#define Party_SPELL_RESERVED3       11

// party facing

// ?? same as : Maze_FACE_?????
#define Party_FACE_NORTH 0
#define Party_FACE_EAST  1
#define Party_FACE_SOUTH 2
#define Party_FACE_WEST  3

// party status
#define Party_STATUS_RESERVE    0
#define Party_STATUS_CITY       1
#define Party_STATUS_MAZE       2

// combat attack side

/*#define Party_CMBTSIDE_FRONT     0
#define Party_CMBTSIDE_RIGHT     1
#define Party_CMBTSIDE_LEFT      2
#define Party_CMBTSIDE_BACK      3*/

/*-------------------------------------------------------------------------*/
/*-                           Type definition                             -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Party_position
{
   tiny x;
   tiny y;
   tiny z;
   tiny facing;
}s_Party_position;

typedef struct dbs_Party_position
{
   tiny x a_packed;
   tiny y a_packed;
   tiny z a_packed;
   tiny facing a_packed;
}dbs_Party_position a_packed;

typedef struct dbs_Party
{
   char name [ 31 ] a_packed;
   dword character [ 6 ] a_packed;
//   tiny combat_pos [ 6 ] a_packed;
   dbs_Party_position pos a_packed;
   short spell_duration [ Party_NB_SPELL ] a_packed;
   tiny nb_character a_packed;
   dword location a_packed;
   tiny status a_packed;
//   dword player a_packed;
//   dword game a_packed;
}dbs_Party a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Party : public DBObject
{

   /*--- Properties ---*/

   private: char p_name [ 31 ]; // name of the party
   private: DBTag p_character [ 6 ]; // character list
   private: tiny p_combat_pos [ 6 ]; // location in combat rank of each character.
   private: s_Party_position p_pos; // location in the maze
   private: short p_spell_duration [ Party_NB_SPELL ]; // duration of the spell in seconds cast on the party
   private: tiny p_nb_character; // keep track of the number of characters
   private: DBTag p_location; // tag on city when saved game
   private: tiny p_status; // status of the party ( in/out )
//   private: DBTag p_player; // tag of the player who own the party
//   private: DBTag p_game; // tag of the game where it belong

   /*--- Constructor & Destructor ---*/

   public: Party ( void );
//   public: Party ( const Party &tmpobj );
   public: ~Party ( void );

   /*--- Property Methods ---*/

//   public: string& name ( void );
   public: const char* name ( void );
   public: void name ( const char *str );
   public: DBTag character ( tiny number );
   public: tiny rank ( tiny number );
   public: void rank ( tiny number, tiny rankID );
   public: s_Party_position position ( void );
   public: void position ( s_Party_position position );
   public: void position ( tiny x, tiny y, tiny z, tiny facing );
   public: void position ( tiny x, tiny y, tiny z );
   public: tiny facing ( void );
   public: void facing ( tiny side );
   public: tiny nb_character ( void );
   public: short spell_duration ( tiny spellID );
   public: DBTag location ( void );
   public: void location ( DBTag value );
   public: tiny status ( void );
   public: void status ( tiny value );
   
//   public: DBTag player ( void );
//   public: void player ( DBTag value );
//   public: DBTag game ( void );
//   public: void game ( DBTag value );
   

   /*--- Methods ---*/

   public: void add_character ( DBTag character );
   public: void remove_character ( tiny number );
   public: void remove_all_character ( void );
   public: void turn_left ( void );
   public: void turn_right ( void );
   public: void walk_forward ( void );
   public: void walk_backward ( void );
   public: void move_down ( void );
   public: void move_up ( void );
   public: bool test_front_wall ( byte solid );
   public: bool test_front_door ( byte solid );
   public: void decrement_duration ( short seconds );
   public: void destroy_spell ( tiny spell_index );
   public: void destroy_all_spell ( void );
   public: void reset_position ( void );
   public: void rest ( tiny nb_days, tiny room_type );
   public: bool is_functional ( void );

   public: void autoability ( void );
   public: void activesort_characters ( void );
   public: void ennemy_rankprioritysort ( void ); //sort ennemies according to rank priority
//   public: void activesort_ennemies ( void );

   public: tiny combat_rank ( tiny characterID, tiny side );

   /*--- Private Methods ---*/

   public: void compact_characters ( void );


   /*--- Virtual Methods ---*/

//   public: virtual DBTag DBinsert ( void );
//   public: virtual void DBupdate ( void );
//   public: virtual void DBselect ( DBTag value, bool readonly = false );
//   public: virtual void DBselect ( dword index, bool readonly = false );
//   public: virtual void DBremove ( void );

//   public: void exDBselect ( Database &datb, dword index, bool readonly = false );
//   public: void exDBremove ( Database &datb );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );


};

extern const char STR_PAR_STATUS [] [ 12 ];
