/***************************************************************************/
/*                                                                         */
/*                             O P T I O N . H                             */
/*                            Class definition                             */
/*                                                                         */
/*     Content : Class Option                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : May 12nd, 2002                                      */
/*                                                                         */
/*          This is an option menu engine which looks close to menu but    */
/*     change the states of each inten instead of returning the selected   */
/*     choice.                                                             */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Constant Class Parameter                        -*/
/*-------------------------------------------------------------------------*/

#define Option_FONT           FNT_print

/*-------------------------------------------------------------------------*/
/*-                          Type definition                              -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Option_item
{
   char text [51]; // Text written for the menu item
   tiny nb_elem; // Contains the number of choice
   tiny selected; // curently selected choice
   char elem[ 5 ][ 31 ]; // Contains the text of the choice
   s_Option_item *ptr_next; // pointer on the nextitem in the list
}s_Option_item;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Option
{

   // Properties

   private: char p_title [81]; // Text written at the top of the menu
   private: char p_quit [51]; // text for last choice that exit option menu
   private: tiny  p_nb_item; // count number of add items
   private: s_Option_item *ptr_first; // Point on the 1st menu item
   private: s_Option_item *ptr_last; // Point on the last menu item

   // Constructor & Destructor

   public: Option ( void );
   public: Option ( const char* str );
//   public: Option ( string &str );
   public: ~Option ( void );

   // Property Methods

//   public: void title ( string &str );
   public: void title ( const char* str );
//   public: void quit ( string &str );
   public: void quit ( const char* str );
   public: tiny nb_item ();
   public: tiny nb_element ( tiny itemID );
   public: tiny selected ( tiny itemID );
   public: void selected ( tiny itemID, tiny value );

   // Methods

   //note : string size 20 Character, element size 8 character
//   public: void add_item ( string &str, string &elem1, string &elem2,
//             string &elem3, string &elem4, string &elem5, tiny selected = 0 );
   public: void add_item ( const char* str, const char* elem1, const char* elem2,
     const char* elem3, const char* elem4, const char* elem5, tiny selected = 0 );
   public: void show ( short x, short y );

   // Private Methods

   private: void select_right ( tiny itemID );
   private: void select_left ( tiny itemID );

};


