/***************************************************************************/
/*                                                                         */
/*                         O P P O N E N T . H                             */
/*                           Class Definition                              */
/*                                                                         */
/*     Content : Class Opponent                                            */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : June 9, 2002                                        */
/*                                                                         */
/*          This class is used to store the necessary information of each  */
/*     opponent who participate in a combat. Opponent objects are created  */
/*     from Characters and Monster which are converted. Which mean that    */
/*     character's and monsters class will no be used for combat           */
/*     operations. When comabt is finished, data is saved in the character */
/*     classes if they were generated from characters.                     */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                     Constant class Parameter                          -*/
/*-------------------------------------------------------------------------*/

#define Opponent_NB_MAX_HIT_LOCATION 10
#define Opponent_NB_MAX_ATTACK_STAT  5
#define Opponent_NB_HEALTH           16
#define Opponent_NB_ELEMENT          6
#define Opponent_NB_MAX_SABILITY     3
#define Opponent_NB_SIZE             5
#define Opponent_NB_ALIGMENT         6

/*-------------------------------------------------------------------------*/
/*-                         Constants                                     -*/
/*-------------------------------------------------------------------------*/

// hit location for humanoids

// Use Armor_LOCATION Instead
/*
#define Opponent_LOCATION_TORSO  0
#define Opponent_LOCATION_LLEG   1
#define Opponent_LOCATION_RLEG   2
#define Opponent_LOCATION_LARM   3
#define Opponent_LOCATION_RARM   4
#define Opponent_LOCATION_HEAD   5
*/

// Opponent Type

#define Opponent_TYPE_CHARACTER  1
#define Opponent_TYPE_ENNEMY     2

// Attribute identification

#define Character_STRENGTH       0
#define Character_DEXTERITY      1
#define Character_ENDURANCE      2
#define Character_INTELLIGENCE   3
#define Character_CUNNING        4
#define Character_WILLPOWER      5
#define Character_LUCK           6

#define Opponent_STRENGTH       0
#define Opponent_DEXTERITY      1
#define Opponent_ENDURANCE      2
#define Opponent_INTELLIGENCE   3
#define Opponent_CUNNING        4
#define Opponent_WILLPOWER      5
#define Opponent_LUCK           6

#define Opponent_ALIGMENT_KIND         0 // life         kn
#define Opponent_ALIGMENT_PEACEFULL    1 // water        pf
#define Opponent_ALIGMENT_LIVELY       2 // Air          lv
#define Opponent_ALIGMENT_SELLFISH     3 // Death        sf
#define Opponent_ALIGMENT_AGGRESSIVE   4 // Fire         ag
#define Opponent_ALIGMENT_STOICAL      5 // Earth        st

// Element identification

#define Opponent_ELEMENT_LIFE      0
#define Opponent_ELEMENT_WATER     1
#define Opponent_ELEMENT_AIR       2
#define Opponent_ELEMENT_DEATH     3
#define Opponent_ELEMENT_FIRE      4
#define Opponent_ELEMENT_EARTH     5

#define Opponent_ELEMENTBIT_LIFE      1
#define Opponent_ELEMENTBIT_WATER     2
#define Opponent_ELEMENTBIT_AIR       4
#define Opponent_ELEMENTBIT_DEATH     8
#define Opponent_ELEMENTBIT_FIRE      16
#define Opponent_ELEMENTBIT_EARTH     32

// Elemental Strength


// maze special resistance ID

//?? note sure how to implemement these, either race ability
/*
#define Opponent_SABILITY_AMPHIBIOUS         1
#define Opponent_SABILITY_NATURALMANA        2
#define Opponent_SABILITY_INFRAVISION        4
#define Opponent_SABILITY_POISON_BREATHING   8
#define Opponent_SABILITY_DARKVISION         16
#define Opponent_SABILITY_LEVITATE           32
#define Opponent_SABILITY_WEAPON_IMMUNITY    64
#define Opponent_SABILITY_MAGIC_IMMUNITY     128
#define Opponent_SABILITY_NATURAL_ARMOR      256
#define Opponent_SABILITY_HEAVY_ARMOR        512
#define Opponent_SABILITY_REGENERATION       1024
*/

// health identification value
// note : 8 first health are physical health status while
//        8 last health status are mental/magic status

#define Opponent_PHYSICAL_HEALTH_LIMIT   128 // define where the physcal
   // health status stop in the list in case the proportion is not 8/8

//?? idea : last physical health : Lycanthropy
//?? idea : Mental health : Confused

#define Opponent_HEALTH_ASLEEP     1       // cannot move, recover easy
#define Opponent_HEALTH_PARALYSED  2       // cannot move, recover hard
#define Opponent_HEALTH_PETRIFIED  4       // cannot move, no recover
#define Opponent_HEALTH_RESERVED   8       //
#define Opponent_HEALTH_POISONED   16      // lose HP gradualy
#define Opponent_HEALTH_BLINDED    32      // combat penalty
#define Opponent_HEALTH_CRIPPLED   64      // special injury, final penalty to combat
#define Opponent_HEALTH_RESERVED3  128
#define Opponent_HEALTH_AFFRAID    256     // combat penalty
#define Opponent_HEALTH_CURSED     512     // Luck rolls are allways failed
#define Opponent_HEALTH_SEALED     1024    // cannot cast spells
#define Opponent_HEALTH_DOOMED     2048    // Probability to die instantly
#define Opponent_HEALTH_FADING     4096    // lose soul continuously
#define Opponent_HEALTH_RESERVED5  8192
#define Opponent_HEALTH_RESERVED6  16384
#define Opponent_HEALTH_RESERVED7  32768

#define Opponent_HEALTHID_SLEEP      1       // cannot move, recover easy
#define Opponent_HEALTHID_PARALYZE   2       // cannot move, recover hard
#define Opponent_HEALTHID_PETRIFY    3       // cannot move, no recover
#define Opponent_HEALTHID_RESERVED   4       //
#define Opponent_HEALTHID_POISON     5       // LOSE HP
#define Opponent_HEALTHID_BLIND      6       // combat penalty
#define Opponent_HEALTHID_CRIPPLE    7
#define Opponent_HEALTHID_RESERVED3  8
#define Opponent_HEALTHID_FEAR       9       // combat penalty
#define Opponent_HEALTHID_CURSE      10      // Luck rolls are allways failed
#define Opponent_HEALTHID_SEAL       11      // cannot cast spells
#define Opponent_HEALTHID_DOOM       12      // Probability to die instantly
#define Opponent_HEALTHID_FADE       13    // lose soul continuously
#define Opponent_HEALTHID_RESERVED5  14
#define Opponent_HEALTHID_RESERVED6  15
#define Opponent_HEALTHID_RESERVED7  16

// character status values

#define Opponent_STATUS_ALIVE      0
#define Opponent_STATUS_DEAD       1
#define Opponent_STATUS_ASHES      2
#define Opponent_STATUS_DELETED    3
#define Opponent_STATUS_DISPELLED  4

#define Opponent_SIZE_TINY      0
#define Opponent_SIZE_SHORT     1
#define Opponent_SIZE_NORMAL    2
#define Opponent_SIZE_LARGE     3
#define Opponent_SIZE_HUGE      4

/*-------------------------------------------------------------------------*/
/*-                          Type Definition                              -*/
/*-------------------------------------------------------------------------*/

/*typedef struct s_Opponent_aligment
{
   tiny law;
   tiny good;
}s_Opponent_aligment;*/

typedef struct s_Opponent_healthC
{
   char letter;
   int color;
}s_Opponent_healthC;

typedef struct s_Opponent_hstr
{
   s_Opponent_healthC character [ 16 ];
}s_Opponent_hstr;

typedef struct s_Opponent_health_info
{
   word mask; // mask to apllay to check presence
   char adjective[ 17 ]; // string used for display
   char name [ 17 ]; // string used for display
   short red;  // color that must be used for display
   short green;
   short blue;
   tiny attribute; // attribute lost when raising this resistance
   tiny TN; // base TN + level modifier + difficulty modifier
}s_Opponent_health_info;

typedef struct s_Opponent_aligment_info
{
   char name [ 11 ]; // full name
   char initial [ 3 ]; // 2 letter code
}s_Opponent_aligment_info;


/*typedef struct s_Opponent_rollstat
{
   tiny min;
   tiny max;
   tiny modifier; // modify max but this stat can change compared to others
   tiny bonus;
//   short other;
}s_Opponent_rollstat;*/


typedef struct s_Opponent_stat
{
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny multihitmod a_packed;
   tiny hitbonus a_packed;
   tiny encmod a_packed;
   tiny dmg_x a_packed;
   tiny dmg_y a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny mdmg_x a_packed;
   tiny mdmg_y a_packed;   
   tiny mdmg_z a_packed;
   tiny range a_packed;
//   tiny hitroll a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
}s_Opponent_stat;

typedef struct dbs_Opponent
{
   char name [ 16 ] a_packed;
   tiny type a_packed;
   tiny size a_packed;
   short max_HP a_packed;
   short current_HP a_packed;
   short max_MP a_packed;
   short current_MP a_packed;
   tiny aligment a_packed;
   tiny attribute [ 7 ] a_packed;
   tiny level a_packed;
   tiny soul a_packed;
   word health a_packed;
   tiny status a_packed;
   word elm_weakness a_packed;
   short reward_exp a_packed;
   short gold a_packed;
   byte pictureID a_packed;
}dbs_Opponent a_packed;


/*-------------------------------------------------------------------------*/
/*-                        Global Variables                               -*/
/*-------------------------------------------------------------------------*/

//extern V3D ELEMENT_DIAGRAM [ Opponent_NB_ELEMENT ] [ Opponent_NB_ELEM_LEVEL ];

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Opponent : public DBObject
{

   /*--- Properties ---*/

   protected: char p_name [ 16 ]; // basic name of the opponent
   protected: tiny p_aligment; // struct containing the aligment
   protected: tiny p_size; // size of the opponent
   protected: short p_max_HP; // maximum Hit Point of the character
   protected: short p_current_HP; // current Hit Point value
   protected: short p_max_MP; // maxium spell point of the character
   protected: short p_current_MP; // curent spell point of the character
   protected: tiny p_attribute [ 7 ]; // Opponent_attribute
   protected: tiny p_level; // experience level of the character
   protected: tiny p_soul; // current soul level of the character
   protected: word p_health; // health status of the character
   protected: tiny p_status; // status of the character
   protected: word p_elm_weakness; // double dmg for these elements
   protected: short p_reward_exp; // exp received for destroying ennemy
   protected: short p_gold; // gold pieces hold by the opponent
   protected: byte p_pictureID; // Ennemy/Skin image ID number corresponding to the monster
   protected: tiny p_type; // opponent type
   protected: s_Opponent_stat p_stat; // compiled stats

   private: static byte p_maze_special; // contains maze special byte

   /*--- Constructor and Destructors ---*/

   public: Opponent ( void );
   public: ~Opponent ( void );

   /*--- Property Methods ---*/

   public: const char* name ( void );
   public: void name ( const char *str );
   public: void attribute ( tiny attribID, tiny value );
   public: tiny attribute ( tiny attribID );
   public: void strength ( tiny value );
   public: tiny strength ( void );
   public: tiny STRmodifier ( void );
   public: void dexterity ( tiny value );
   public: tiny dexterity ( void );
   public: tiny DEXmodifier ( void );
   public: void endurance ( tiny value );
   public: tiny endurance ( void );
   public: tiny ENDmodifier ( void );
   public: void intelligence ( tiny value );
   public: tiny intelligence ( void );
   public: tiny INTmodifier ( void );
   public: void cunning ( tiny value );
   public: tiny cunning ( void );
   public: tiny CUNmodifier ( void );
   public: void willpower ( tiny value );
   public: tiny willpower ( void );
   public: tiny WILmodifier ( void );
   public: void luck ( tiny value );
   public: tiny luck ( void );
   public: tiny LUCKmodifier ( void );
   public: tiny level ( void );
   public: tiny size ( void );
   public: void aligment ( tiny value );
   public: tiny aligment ( void );
   public: short max_HP ( void );
   public: short current_HP ( void );
   public: short max_MP ( void );
   public: short current_MP ( void );
   public: tiny soul ( void );
   public: bool health ( Word healthID );
   public: word health ( void );
   public: void status ( tiny statusID );
   public: tiny status ( void );
   public: short reward_exp ( void );
   public: void reward_exp ( short value );
   public: short gold ( void );
   public: void gold ( short value );
   public: byte pictureID ( void );
   public: void pictureID ( byte value );
//   public: void type ( tiny typeID );
   public: tiny type ( void );
   


   public: const char* aligmentC ( void ); // 3 character
   public: const char* aligmentS ( void );
   public: const char* statusS ( void ); // 9 character
   public: s_Opponent_hstr healthS ( void );

   public: s_Opponent_stat stat ( void );

   /*--- Methods ---*/

   public: void recover_HP ( short value );
   public: void recover_MP ( short value );
   public: void recover_soul ( tiny value );
   public: void lose_HP ( short value );
   public: void lose_MP ( short value );
   public: void lose_soul ( tiny value );
   public: void add_health ( Word healthID );
   public: void remove_health ( Word healthID );
   public: void gain_gold ( short value );
   public: void lose_gold ( short value );
   public: void save_vs ( word healthID, tiny level );

   public: void eval_stat_all ( void ); // call all the eval stat function
   public: void eval_stat_clear ( void );
   public: void eval_stat_base ( void );
   public: void eval_stat_wound ( void );
   public: void eval_stat_health ( void );
   public: void eval_stat_maze ( void );
   public: void eval_stat_enc_modifier ( void );
   public: void eval_stat_limit ( void );
//   public: void eval_stat_spell ( void );
   public: tiny initiative ( void );
   public: bool is_active ( void );

   public: void combat_action ( tiny action_type, tiny value,
                   char *result, Opponent &target);

   /*--- Private Methods ---*/
   
   private: void cmbact_zap ( tiny value, char *result, Opponent &target  );
   private: void cmbact_fight ( tiny value, char *result, Opponent &target );
   private: void cmbact_parry ( tiny value, char *result );
   private: void cmbact_use_item ( tiny value, char *result );
//   private: void cmbact_move ( tiny value, char *result );

/*#define Combat_COMMAND_HIDE               3
#d#define Combat_COMMAND_CAST_SPELL         7
#define Combat_COMMAND_DISPEL             8
#define Combat_COMMAND_WEILD_MAGIC        9
#define Combat_COMMAND_PREVIOUS           10*/

   /*--- Virtual Methods ---*/

   public: virtual void eval_stat_other ( void ) = 0;

//   public: virtual string& name_combat ( void ) =0;
   public: virtual void name_combat ( char *str ) = 0;
   
//   public: l void save_vs ( Word healthID, tiny modifier )= 0;


   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
//   public: virtual void child_DBremove ( void );

};

/*-------------------------------------------------------------------------*/
/*-                   Global Variable Definition                          -*/
/*-------------------------------------------------------------------------*/

extern s_Opponent_health_info HEALTH_INFO [ Opponent_NB_HEALTH ];
extern const char STR_OPP_SIZE [][7];
extern const char STR_OPP_STATUS [] [ 11 ];
extern const char STR_OPP_DEFENSE [] [ 11 ];
extern s_Opponent_aligment_info ALIGMENT_INFO [ Opponent_NB_ALIGMENT ];
//extern s_Opponent_limit_stat_info LIMIT_STAT [ Opponent_NB_STAT ];
//extern s_Opponent_life_template LIFE_TEMPLATE [ Opponent_NB_LIFE_TEMPLATE ];

