/***************************************************************************/
/*                                                                         */
/*                               M E N U . H                               */
/*                                                                         */
/*     Content : Class Menu                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 14th, 2002                                    */
/*                                                                         */
/*          This is the header of the menu class which is used to manage   */
/*     different menus used during the game. A class has been made to make */
/*     sure it is reused during the game.                                  */
/*                                                                         */
/*     Requirements : Allegro Video                                        */
/*                    Allegro Text                                         */
/*                    Allegro Keyboard                                     */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Constant Class Parameter                        -*/
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*-                       Constant Parameter                              -*/
/*-------------------------------------------------------------------------*/

#define Menu_FONT                FNT_print
#define Menu_COLOR_TEXT          makecol ( 225, 225, 225 )
#define Menu_COLOR_MASK          makecol ( 150, 150, 150 )

/*-------------------------------------------------------------------------*/
/*-                          Type definition                              -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Menu_item
{
   char text [ 51 ]; // Text written for the menu item
   bool mask;        // mask menuitem if TRUE.
   s_Menu_item *ptr_next; // pointer on the nextitem in the list
}s_Menu_item;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Menu
{

   // Properties

   private: char p_title [81]; // Text written at the top of the menu
   private: tiny  p_nb_item; // count number of add items
//   private: FONT *p_font;   // Font used to draw the menu
   private: s_Menu_item *ptr_first; // Point on the 1st menu item
   private: s_Menu_item *ptr_last; // Point on the last menu item

   // Constructor & Destructor

   public: Menu ( void );
   public: Menu ( const char* str );
//   public: Menu ( string &str /*, FONT *fnt */);
   public: ~Menu ( void );

   // Property Methods

//   public: void title ( string &str );
   public: void title ( const char* str );
   public: const char* title ( void );
   public: tiny nb_item ();
//   public: void textfont ( FONT *fnt );
   public: short char_width ( void );

   // Methods

//   public: void add_item ( string &str, bool mask = false );
   public: void add_item ( const char* str, bool mask = false );
   public: void mask_item ( tiny ID );
   public: void unmask_all_item ( void );
   public: short show ( short x, short y, tiny position = 0, bool nocancel = false );
   public: void draw ( short x, short y );

};


