/***************************************************************************/
/*                                                                         */
/*                         M A N A G E R . H                               */
/*                        Class Definition                                 */
/*                                                                         */
/*     Content : Calss Manager                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 24th, 2003                                     */
/*     License : GNU General Public LIcense                                */
/*                                                                         */
/*          This class is an engine that manage the Players account and    */
/*     the started games.                                                  */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Class Parameter                                 -*/
/*-------------------------------------------------------------------------*/

#define Manager_NB_MAX_ADVENTURE 32
#define Manager_NB_MAX_GAME      32
#define Manager_NB_MAX_ACCOUNT   64
#define Manager_NB_MAX_RACE      32
#define Manager_NB_MAX_CLASS     32

/*-------------------------------------------------------------------------*/
/*-                          Constants                                    -*/
/*-------------------------------------------------------------------------*/

// manager menu

#define Manager_MENU_LOGIN             0
#define Manager_MENU_ADVENTURE         1
#define Manager_MENU_GAME              2
#define Manager_MENU_ACCOUNT           3
#define Manager_MENU_RACE              4
#define Manager_MENU_CLASS             5
#define Manager_MENU_EXIT              6

// Manager Sub Menu

#define Manager_SUBMENU_CREATE         0
#define Manager_SUBMENU_INSPECT        1
#define Manager_SUBMENU_DELETE         2
#define Manager_SUBMENU_EXIT1          3
#define Manager_SUBMENU_IMPORT         3
#define Manager_SUBMENU_EXPORT         4
#define Manager_SUBMENU_EXIT2          5

// manager return code

#define Manager_CONTINUE   0
#define Manager_LOGIN      1
#define Manager_EXIT       2

/*-------------------------------------------------------------------------*/
/*-                       Class Definition                                -*/
/*-------------------------------------------------------------------------*/

class Manager
{
   //--- properties ---

   private: DBTag p_account_logged; // successfull account login number

   //--- Constructor & Destructor ---

   public: Manager ( void );
   public: ~Manager ( void );

   //--- Property Methods ---

   public: DBTag account_logged ( void );
   public: tiny nb_game ( void );
   public: tiny nb_account ( void );
   public: tiny nb_adventure ( void );
   public: tiny nb_race ( void );
   public: tiny nb_class ( void );

   //--- Methods ---

   public: tiny start ( void );

   public: tiny show_login ( void );

   public: void show_adventure ( void );
   public: void show_game ( void );
   public: void show_account ( void );
   public: void show_race ( void );
   public: void show_class ( void );
   
   public: void show_create_adventure ( void );
   public: void show_inspect_adventure ( void );
   public: void show_delete_adventure ( void );
   public: void show_create_game ( void );
   public: void show_inspect_game ( void );
   public: void show_delete_game ( void );
   public: void show_create_account ( void );
   public: void show_inspect_account ( void );
   public: void show_delete_account ( void );
   public: void show_create_race ( void );
   public: void show_inspect_race ( void );
   public: void show_delete_race ( void );
   public: void show_import_race ( void );
   public: void show_export_race ( void );
   public: void show_create_class ( void );
   public: void show_inspect_class ( void );
   public: void show_delete_class ( void );
   public: void show_import_class ( void );
   public: void show_export_class ( void );
   
   

};




