/***************************************************************************/
/*                                                                         */
/*                               L I S T . H                               */
/*                                                                         */
/*     Content : Class List                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : August 25th 2002                                    */
/*                                                                         */
/*          This is the header of the List class which is used to manage   */
/*     different List used during the game. A class has been made to make  */
/*     sure it is reused during the game.                                  */
/*                                                                         */
/*     Requirements : Allegro Video                                        */
/*                    Allegro Text                                         */
/*                    Allegro Keyboard                                     */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Constant Class Parameter                        -*/
/*-------------------------------------------------------------------------*/

#define List_FONT                FNT_print
#define List_COLOR_TEXT          makecol ( 225, 225, 225 )
#define List_COLOR_MASK          makecol ( 150, 150, 150 )
#define List_MAX_NB_ITEM         256


/*-------------------------------------------------------------------------*/
/*-                           Constants                                   -*/
/*-------------------------------------------------------------------------*/

// add item type

#define List_ADD_WEAPON_NAME  0
#define List_ADD_WEAPON_BUY   1
#define List_ADD_ARMOR_NAME   0
#define List_ADD_ARMOR_BUY    1

/*-------------------------------------------------------------------------*/
/*-                          Type Definition                              -*/
/*-------------------------------------------------------------------------*/

typedef struct s_List_item
{
   char text [ 81 ]; // Text written for the menu item
   bool mask;   // mask list item if TRUE.
}s_List_item;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class List
{
   // Properties

   private: char p_title [ 81 ]; // Text written at the top of the List
   private: short p_nb_item; // count number of add items
   private: tiny p_page_size; // number of lines to draw at the same time.
   private: short p_page_pos; // current location of the page
   private: bool p_sensible; // return selection each time cursor moved
   private: s_List_item p_item [ List_MAX_NB_ITEM ]; // strings to draw in the list.

   // Constructor & Destructor

   public: List ( void );
   public: List ( const char* str, tiny psize = 3, bool sensible = false );
//   public: List ( string &str, tiny psize = 3, bool sensible = false );
   public: ~List ( void );

   // Property Methods

//   public: void title ( string &str );
   public: void title ( const char* str );
   public: const char* title ( void );
   public: void page_size ( tiny value );
   public: tiny page_size ( void );
   public: void page_pos ( short value );
   public: short page_pos ( void );
   public: short nb_item ();
   public: short char_width ( void );
   public: void sensible ( bool value );
   public: bool sensible ( void );

   // Methods

//   public: void add_item ( string &str, bool mask = false );
   public: void add_item ( const char* str, bool mask = false );
//   public: void update_item ( string &str, short index, bool mask = false );
   public: void update_item ( const char *str, short index, bool mask = false );
//   public: void add_item ( Weapon &wdat, tiny style = List_ADD_WEAPON_NAME,
//                                                         bool mask = false );
//   public: void add_item ( Armor &adat, tiny style = List_ADD_ARMOR_NAME,
//                                                         bool mask = false );
   public: void mask_item ( short ID );
   public: void unmask_all_item ( void );
   public: void clear_all_item ( void );
   public: short show ( short x, short y, short cursor_pos = 0,
      bool reset_page = false, bool nocancel = false );
};



