/***************************************************************************/
/*                                                                         */
/*                                I T E M . H                              */
/*                                                                         */
/*                           Base Class Definition                         */
/*                                                                         */
/*   Content : Item class definition                                       */
/*   Programmer : Eric Pietrocupo                                          */
/*   Starting Date : April 29th, 2002                                      */
/*                                                                         */
/*        This is the base class from which most equipment objects are     */
/*   derived from.                                                         */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Class Parameter                              -*/
/*-------------------------------------------------------------------------*/

#define Item_NAME_SIZE        18 // excluding \0

/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

// Ability types of the objects

// most ability affect the user except for spells
// Ability use charges to use

#define Item_ABILITY_NONE              0
#define Item_ABILITY_SPELL             1
#define Item_ABILITY_RAISE_MAXHP       2 // raise max HP by value
#define Item_ABILITY_RAISE_MAXSP       3 // raise max SP by value
#define Item_ABILITY_GAIN_EXP          4 // gain value
#define Item_ABILITY_LOWER_AGE         5 // by value
#define Item_ABILITY_RAISE_SOUL        6 // by value
#define Item_ABILITY_RECOVER_HP        7 // random value
#define Item_ABILITY_RECOVER_MP        8 // random value
#define Item_ABILITY_RAISE_ATTRIBUTE   9 // value = attribute ID bitwise
#define Item_ABILITY_CURE_HEALTH       11 // value = healthID bitwise
#define Item_ABILITY_RAISE_STAT        12 // Raise Stat limited time ( considered spell )

//#define Item_ABILITY_RAISE_MAXLP        13 // RAise maxLP by value

// Auto abilities
// These abilities are executed for each step in the maze

#define Item_AUTOABILITY_NONE             0
#define Item_AUTOABILITY_REGEN_HP         1 // +1 HP
#define Item_AUTOABILITY_REGEN_MORE_HP    2 // +3 HP
#define Item_AUTOABILITY_DRAIN_HP         3 // -1 HP
#define Item_AUTOABILITY_DRAIN_MORE_HP    4 // -3 HP
#define Item_AUTOABILITY_REGEN_MP         5 // +1 SP
#define Item_AUTOABILITY_REGEN_MORE_MP    6 // +3 SP
#define Item_AUTOABILITY_DRAIN_MP         7 // -1 SP
#define Item_AUTOABILITY_DRAIN_MORE_MP    8 // -3 SP
#define Item_AUTOABILITY_RANDOM_HEALTH    9 // 10% cahnce receive random health
#define Item_AUTOABILITY_CURE_HEALTH      10 // 5% cure each health
#define Item_AUTOABILITY_REGEN_EXP        11 // + lvl exposant * 5
#define Item_AUTOABILITY_DRAIN_EXP        12 // - lvl exposant * 20
#define Item_AUTOABILITY_REGEN_SOUL       13 // 5% chance +1 soul
#define Item_AUTOABILITY_DRAIN_SOUL       14 // 10% chance -1 soul
#define Item_AUTOABILITY_RAISE_AGE        15 // 5% chance +1 age

// item charges exhausted effect
// The abilities are executed when no more charges left in the Item

#define Item_EXHAUST_BREAK              0
#define Item_EXHAUST_NOTHING            1 // nothing happen, charges are all used.
#define Item_EXHAUST_RECHARGE           2 // allow ITEM to be recharged
#define Item_EXHAUST_DEAD               3 // kill the character
#define Item_EXHAUST_ASHES              4 // send character in ashes
#define Item_EXHAUST_DELETED            5 // delete the character
#define Item_EXHAUST_RAISE_AGE          6 // Age the character from 3% to 8% lifespan
#define Item_EXHAUST_LOWER_MAXHP        7 // lower HP by random ( 2 * exp level )
#define Item_EXHAUST_LOWER_MAXSP        8 // lower SP by random ( 2 * exp level )
#define Item_EXHAUST_LOSE_EXP           9 // 25% next level
#define Item_EXHAUST_LOWER_STRENGTH     10
#define Item_EXHAUST_LOWER_DEXTERITY    11
#define Item_EXHAUST_LOWER_ENDURANCE    12
#define Item_EXHAUST_LOWER_INTELLIGENCE 13
#define Item_EXHAUST_LOWER_CUNNING      14
#define Item_EXHAUST_LOWER_WILLPOWER    15
#define Item_EXHAUST_LOWER_LUCK         16
#define Item_EXHAUST_LOSE_SOUL          17 // lose 5 to 25 soul point
#define Item_EXHAUST_RANDOM_HEALTH      18

// drawbacks

#define Item_DRAWBACK_NOTHING            0 // nothing happen, charges are all used.
#define Item_DRAWBACK_RAISE_AGE          1 // Age the character from 3% to 8% lifespan
#define Item_DRAWBACK_LOWER_MAXHP        2 // lower HP by random ( 2 * exp level )
#define Item_DRAWBACK_LOWER_MAXMP        3 // lower SP by random ( 2 * exp level )
#define Item_DRAWBACK_LOSE_EXP           4 // 25% next level
#define Item_DRAWBACK_LOWER_STRENGTH     5
#define Item_DRAWBACK_LOWER_DEXTERITY    6
#define Item_DRAWBACK_LOWER_ENDURANCE    7
#define Item_DRAWBACK_LOWER_INTELLIGENCE 8
#define Item_DRAWBACK_LOWER_CUNNING      9
#define Item_DRAWBACK_LOWER_WILLPOWER    10
#define Item_DRAWBACK_LOWER_LUCK         11
#define Item_DRAWBACK_LOSE_SOUL          12 // lose 5 to 25 soul point
#define Item_DRAWBACK_RANDOM_HEALTH      13


// effect types of the object

// these effect allows to protect character against something or
// to inflict ennemy with something.

//#define Item_ELMEFFECT_MASK_ELEMENT       // 0000000000111111
//#define Item_ELMEFFECT_MASK_MONSTER       // 1111111111000000

#define Item_HLTEFFECT_NONE            0
#define Item_ELMEFFECT_NONE            0

#define Item_HLTEFFECT_SLEEP          1     // 0000000000000001
#define Item_HLTEFFECT_PARALYZATION   1<<1  // 0000000000000010
#define Item_HLTEFFECT_PETRIFICATION  1<<2  // 0000000000000100
#define Item_HLTEFFECT_RESERVED       1<<3  // 0000000000001000
#define Item_HLTEFFECT_POISON         1<<4  // 0000000000010000
#define Item_HLTEFFECT_BLINDNESS      1<<5  // 0000000000100000
#define Item_HLTEFFECT_CRIPPLE        1<<6  // 0000000001000000 ?remove
#define Item_HLTEFFECT_RESERVE3       1<<7  // 0000000010000000
#define Item_HLTEFFECT_FEAR           1<<8  // 0000000100000000
#define Item_HLTEFFECT_CURSE          1<<9  // 0000001000000000
#define Item_HLTEFFECT_SEAL           1<<10 // 0000010000000000
#define Item_HLTEFFECT_DOOM           1<<11 // 0000100000000000
#define Item_HLTEFFECT_FADE           1<<12 // 0001000000000000
#define Item_HLTEFFECT_RESERVE5       1<<13 // 0010000000000000
#define Item_HLTEFFECT_RESERVE6       1<<14 // 0100000000000000
#define Item_HLTEFFECT_RESERVE7       1<<15 // 1000000000000000

#define Item_ELMEFFECT_LIFE       1     // 0000000000000001
#define Item_ELMEFFECT_WATER      1<<1  // 0000000000000010
#define Item_ELMEFFECT_AIR        1<<2  // 0000000000000100
#define Item_ELMEFFECT_DEATH      1<<3  // 0000000000001000
#define Item_ELMEFFECT_FIRE       1<<4  // 0000000000010000
#define Item_ELMEFFECT_EARTH      1<<5  // 0000000000100000
#define Item_ELMEFFECT_DRAGON     1<<6  // 0000000001000000
#define Item_ELMEFFECT_UNDEAD     1<<7  // 0000000010000000
#define Item_ELMEFFECT_MYTHICAL   1<<8  // 0000000100000000
#define Item_ELMEFFECT_DIVINE     1<<9  // 0000001000000000
#define Item_ELMEFFECT_DIRE       1<<10 // 0000010000000000
#define Item_ELMEFFECT_MAGIC      1<<11 // 0000100000000000
#define Item_ELMEFFECT_WERE       1<<12 // 0001000000000000
#define Item_ELMEFFECT_RESERVED1  1<<13 // 0010000000000000
#define Item_ELMEFFECT_RESERVED2  1<<14 // 0100000000000000
#define Item_ELMEFFECT_RESERVED3  1<<15 // 1000000000000000

// Identifications

// example :
// name-type, value-stat, effect, ability-autoability, charge, exhaust-drawback, status
#define Item_IDENTIFICATION_ALL        255
#define Item_IDENTIFICATION_NONE       0 //
#define Item_IDENTIFICATION_NAME       1 // name and type
#define Item_IDENTIFICATION_STAT       2 // Stats and Gold value
#define Item_IDENTIFICATION_STATUS     4 // Fine, echant, artifact, key item
#define Item_IDENTIFICATION_EFFECT     8 // Hlt & Elm effect + Mo + MD effect
#define Item_IDENTIFICATION_ABILITY    16 // Ability, autoability, charges
#define Item_IDENTIFICATION_DRAWBACK   32 // Exhaust, Drawback

// Item types

#define Item_TYPE_WEAPON      0
#define Item_TYPE_SHIELD      1
#define Item_TYPE_ARMOR       2
#define Item_TYPE_ACCESSORY   3 // helmet, gauntlet, boots and accessories
#define Item_TYPE_EXPANDABLE  4 // one use items
#define Item_TYPE_OTHER       5

// Status Id

#define Item_STATUS_NORMAL       0
//#define Item_STATUS_FINE         1
#define Item_STATUS_ENCHANTED    2
#define Item_STATUS_CURSED       4
#define Item_STATUS_ARTIFACT     8
//#define Item_STATUS_UNIQUE       16
#define Item_STATUS_FOUND        32 // not sold normaly

// Magical Properties

//?? idea : HOming to auto hit target ( currently in dmg type )

#define Item_MGKPROP_ELEMENTKILL       1     // 0000000000000001
#define Item_MGKPROP_DEATH             1<<1  // 0000000000000010
#define Item_MGKPROP_ASHES             1<<2  // 0000000000000100
#define Item_MGKPROP_DELETE            1<<3  // 0000000000001000
#define Item_MGKPROP_SOULDRAIN         1<<4  // 0000000000010000
#define Item_MGKPROP_LIFEDRAIN         1<<5  // 0000000000100000
#define Item_MGKPROP_RESERVED2         1<<6  // 0000000001000000
#define Item_MGKPROP_RESERVED3         1<<7  // 0000000010000000
#define Item_MGKPROP_RESERVED4         1<<8  // 0000000100000000
#define Item_MGKPROP_WEAPONIMMUNITY    1<<9  // 0000001000000000
#define Item_MGKPROP_MAGICIMMUNITY     1<<10 // 0000010000000000
#define Item_MGKPROP_RESERVED8         1<<11 // 0000100000000000
#define Item_MGKPROP_RESERVED9         1<<12 // 0001000000000000
#define Item_MGKPROP_RESERVED10        1<<13 // 0010000000000000
#define Item_MGKPROP_RESERVED11        1<<14 // 0100000000000000
#define Item_MGKPROP_RESERVED12        1<<15 // 1000000000000000

// Item Location

#define WEAPON     0
#define SHIELD     1
#define ARMOR      2
#define HEAD       3
#define HAND       4
#define FEET       5
#define OTHER      6
#define NOLOC      7

#define Item_LOCATION_WEAPON     0
#define Item_LOCATION_SHIELD     1
#define Item_LOCATION_ARMOR      2
#define Item_LOCATION_HEAD       3
#define Item_LOCATION_HAND       4
#define Item_LOCATION_FEET       5
#define Item_LOCATION_OTHER      6
#define Item_LOCATION_NOLOC      7


/*-------------------------------------------------------------------------*/
/*-                            Type definition                            -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Item_ability
{
   byte type a_packed;
   dword value a_packed;
   byte exhausted a_packed; // result when all charges used
   byte drawback a_packed; // result when using a charge beside the ability.
   tiny max_charge a_packed;   
   tiny nb_charge a_packed;   
}dbs_Item_ability a_packed;

typedef struct dbs_Item
{
   char name [ Item_NAME_SIZE + 1 ] a_packed;
   char fname [ Item_NAME_SIZE + 1 ] a_packed;
   tiny type a_packed;
   tiny location a_packed;
   dbs_Item_ability ability a_packed;
   byte autoability a_packed;
   word hlteffect a_packed;
   word elmeffect a_packed;
   word magikproperty a_packed;
   tiny key a_packed;
   byte identification a_packed;
   float weight a_packed;
   byte status a_packed;
   tiny rarity a_packed;
   short price a_packed;
}dbs_Item a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Item : public DBObject
{

   //----- Properties -----
   protected: char p_name [ Item_NAME_SIZE + 1 ]; // Real name of the Item
   protected: char p_fname [ Item_NAME_SIZE + 1 ]; // name of the unidentified object
   protected: tiny p_type; // Item type
   protected: tiny p_location; // Item equip location
   protected: dbs_Item_ability p_ability; // infor on the ability of the object
   protected: byte p_autoability; // ability executed for each step
   protected: word p_hlteffect; // special resistance and offensiive
   protected: word p_elmeffect; // special resistance and offensiive
   protected: word p_magikproperty; // magical offense ability
   protected: tiny p_key; // indicates that item is a key item for the lock with
   protected: byte p_identification; // indicates identified stuff
   protected: float p_weight; // weigth of the item
   protected: byte p_status; // Status  of the item
   protected: tiny p_rarity; // match monster level 1 to 25
   protected: short p_price; // value in gold of the item.

   //----- Constructor & destructor -----

   public: Item ( void );

   public: Item ( DBTag itemtag );
   public: virtual ~Item ( void );

   //----- Property methods -----

   public: const char* name ( void );
   public: const char* fname ( void );
   public: void name ( const char* real, const char* hidden );
   public: dbs_Item_ability ability ( void );
   public: void ability ( dbs_Item_ability data );
   public: void ability ( tiny type, tiny value, tiny max_charge,
      tiny exhausted, tiny drawback );
   public: byte autoability ( void );
   public: void autoability ( byte value );
   public: word hlteffect ( void );
   public: void hlteffect ( word value );
   public: word elmeffect ( void );
   public: void elmeffect ( word value );
   public: tiny nb_charge ( void );
   public: bool cursed ( void );
   public: tiny key ( void );
   public: byte identification ( void );
   public: void identification ( byte value );
   public: float weight ( void );
   public: void weight ( float value );
   public: byte status ( void );
   public: void status ( byte value );
   public: tiny rarity ( void );
   public: void rarity ( tiny value );
   public: short price ( void );
   public: void price ( short value );
   public: word magikproperty ( void );
   public: void magikproperty ( word value );
   public: tiny location ( void );
   public: void location ( tiny value );

   
   public: virtual tiny type ( void );

   // these methods draw different output according to identification
   public: const char* vname ( void );
   public: void statusS1 ( char* str );
   public: void statusS2 ( char* str );
   public: const char* typeS ( void );
   public: void abilityS ( char* str );
   public: const char* autoabilityS ( void );
   public: const char* exhaustedS( void );
   public: const char* drawbackS( void );

   //----- Methods -----

   public: void recharge ( void );

   public: bool is_key ( tiny lockID );
   // use item : abiliity and decharge
   // execute effect
   // identify : character perform an identify ( maybe placed in character )
   public: bool identified ( tiny type );
   
   //----- Private Methods -----

   //----- Virtual Methods -----

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );
};


/*-------------------------------------------------------------------------*/
/*-                         Global Variables                              -*/
/*-------------------------------------------------------------------------*/

extern const char STR_ITM_ABILITY [][21];
extern const char STR_ITM_AUTOABILITY [][21];
extern const char STR_ITM_EXHAUST [][21];
extern const char STR_ITM_HLTEFFECT [][21];
extern const char STR_ITM_ELMEFFECT [][21];
extern const char STR_ITM_DRAWBACK [][21];
extern const char STR_ITM_MAGIKPROPERTY [][21];
//extern s_Item_mdproperty_info MDPROPERTY_INFO [ Item_NB_MDPROPERTY ];
extern const char STR_ITM_TYPE [] [11];
extern const char STR_ITM_LOCATION [][11];
extern const char STR_ITM_RARITY [][11];
//extern const char *STR_ITM_STATUS1 [] [11];















