/***************************************************************************/
/*                                                                         */
/*                              I N I T . H                                */
/*                                                                         */
/*     Content : Initialisation procedures                                 */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : march 19, 2002                                      */
/*                                                                         */
/*          This module contains all the procedure used to initialise      */
/*     the system, objects and data of the game                            */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                             Constant                                  -*/
/*-------------------------------------------------------------------------*/

#define INIT_SUCCESS    1
#define INIT_FAILURE    2

#define Init_PARAM_NONE    0
#define Init_PARAM_SETUP   1
#define Init_PARAM_EDITOR  2

/*-------------------------------------------------------------------------*/
/*-                           Prototypes                                  -*/
/*-------------------------------------------------------------------------*/

tiny decode_parameter ( tiny nb_param, char *param[] );
tiny init_game ( void );
tiny init_setup ( void );
tiny init_editor ( void );
tiny init_keyboard ( void );
tiny init_timer ( void );
tiny init_sound ( void );
tiny init_other ( void );
tiny init_graphic ( void );
tiny init_data ( void );
void exit_game ( void );
void exit_setup ( void );
void exit_editor ( void );
void load_database ( void );

void InitProc_datafile_loading ( DATAFILE *f );
void InitProc_datafile_editor_loading ( DATAFILE *f );

