/***************************************************************************/
/*                                                                         */
/*                            G E N E R A L . H                            */
/*                                                                         */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 14th, 2002                                    */
/*                                                                         */
/*          This file contains general definitions and funtions for the    */
/*     whole wizardry project.                                             */
/*                                                                         */
/***************************************************************************/

#ifndef GENERAL_H
#define GENERAL_H 1

/*------------------------------------------------------------------------*/
/*-                          Exclusions                                  -*/
/*------------------------------------------------------------------------*/

#define  alleg_mouse_unused
#define  alleg_joystick_unused
#define  alleg_vidmem_unused
#define  alleg_flic_unused
#define  alleg_gui_unused

/*-------------------------------------------------------------------------*/
/*-                          Type definition                              -*/
/*-------------------------------------------------------------------------*/

typedef signed char tiny; // 8 bit signed
typedef unsigned char byte; // 8 bit : used for bitwise operation
typedef unsigned short word; // 16 bit : used for bitwise operation
typedef unsigned int dword; // 32 bit : used for bitwise operation

//#define string String  // alias
#define Byte byte      // alias
#define Word word      // alias
#define Dword dword    // alias

#ifndef NULL
#define NULL   0
#endif

//Placed here instead of opponent for compiling include purpose
/*typedef struct s_Opponent_rollstat
{
   byte min;
   byte max;
   byte modifier; // modify max but this stat can change compared to others
   byte bonus;
//   short other;
}s_Opponent_rollstat;*/


/*-------------------------------------------------------------------------*/
/*-                            Includes                                   -*/
/*-------------------------------------------------------------------------*/

//#include <strclass.h>
  /*
#include <stdio.h>
//#include <stdlib.h>
//#include <typeinfo>
//#include <time.h>
#include <allegro.h>
#include <random.h>
//#include <string.h>
#include <datafile.h>
#include <datmacro.h>
#include <strclass.h>
#include <init.h>
#include <menu.h>
#include <option.h>
#include <screen.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
#include <list.h>
#include <opponent.h>
#include <charactr.h>
#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <city.h>
#include <maze.h>
#include <adventur.h>
#include <camp.h>
#include <config.h>
#include <draw.h>
#include <global.h>
#include <dialog.h>
#include <combat.h>
*/


/*-------------------------------------------------------------------------*/
/*-                         Constants                                     -*/
/*-------------------------------------------------------------------------*/

// general constant

#define VERSION      "0.1.6"
#define YEAR         "2002-2004,2006"

// constant font definition
#define General_FONT_PARTY          FNT_print
#define General_FONT_INPUT          FNT_script
#define General_FONT_INSTRUCTION    FNT_small

// constant_color_definition
#define General_COLOR_TEXT          makecol ( 225, 225, 225 )
#define General_COLOR_INSTRUCTION   makecol ( 250, 250, 250 )
#define General_COLOR_DISABLE       makecol ( 150, 150, 150 )
#define General_COLOR_BORDER        makecol ( 250, 250, 250 )
#define General_COLOR_FILL          makecol ( 0, 0, 0 )

// Constants for general.h functions

#define General_INPUTSTR_SIZE    121
//#define General_FILELIST_SIZE    128

/*-------------------------------------------------------------------------*/
/*-                                Macros                                 -*/
/*-------------------------------------------------------------------------*/

//#if ALLEGRO_PLATFORM_STR == ALLEGRO_WINDOWS

#ifndef ALLEGRO_WINDOWS
   #define rnd(value) ( ( random()%((value)) ) + 1 )
#else   
   #define rnd(value) ( ( rand()%((value)) ) + 1 )
#endif

#define a_packed  __attribute__ ((packed))

/*------------------------------------------------------------------------*/
/*-                     Global Variables                                 -*/
/*------------------------------------------------------------------------*/

//extern char filelist [ General_FILELIST_SIZE ] [ 13 ];
//extern short flistindex;

/*-------------------------------------------------------------------------*/
/*-                        Prototype                                      -*/
/*-------------------------------------------------------------------------*/


void textinput ( short x, short y, char *str, tiny nb_char );

void save_backup_screen ( void ); // save screen to backup
void load_backup_screen ( void ); // load screen from backup
void save_backup_buffer ( void ); // save buffer to backup
void load_backup_buffer ( void ); // load buffer from backup
void copy_buffer ( void );

void make_screen_shot ( char *filename );
void play_music_track ( tiny track, bool loop = true );

word hdice ( word maxvalue ); // half-dice : N/2 to N
word dice ( word maxvalue ); // dice : 1 to N
word rngdice ( word minvalue, word maxvalue ); // range dice : N to M
//word statdice ( s_Opponent_rollstat rollstat );
//double exponent ( float x, float y );

void flist_proc ( const char *name, int attribute, int param );

void debug ( const char *str, int var1 = 0, int var2 = 0);

#endif
