/***************************************************************************/
/*                                                                         */
/*                            G A M E . H                                  */
/*                                                                         */
/*     Content : Class Game                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting date : April 30th, 2002                                    */
/*                                                                         */
/*          This class contains all the information related to a started   */
/*     game. It also make the link with the adventure and the savegame     */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Parameters                                   -*/
/*------------------------------------------------------------------------*/

#define Game_NB_MAX_RACE      32

/*-------------------------------------------------------------------------*/
/*-                           Constants                                   -*/
/*-------------------------------------------------------------------------*/

// difficulty level

#define Game_DIFFICULTY_EASY     0
#define Game_DIFFICULTY_NORMAL   1
#define Game_DIFFICULTY_HARD     2

// Levelup
#define Game_LEVELUP_FAST     0
#define Game_LEVELUP_NORMAL   1
#define Game_LEVELUP_SLOW     2

/*-------------------------------------------------------------------------*/
/*-                         Typedef definition                            -*/
/*-------------------------------------------------------------------------*/

/*typedef struct s_Game_time
{
   tiny hour;
   tiny minute;
   tiny second;
}s_time;

typedef struct s_Game_date
{
   short year;
   tiny month;
   tiny day;
}s_date;*/

typedef struct dbs_Game
{
//   char adventurefile [ 13 ] a_packed;
   char savegamefile [ 23 ] a_packed;
   char password [ 11 ] a_packed;
   tiny pass_protect a_packed;
   tiny difficulty a_packed;
   tiny levelup a_packed;
   dword adventure a_packed;
}dbs_Game a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class definition                              -*/
/*-------------------------------------------------------------------------*/

class Game : public DBObject
{

   //--- Properties ---

//   private: s_Game_time p_time;
//   private: s_Game_date p_date;
//   private: string p_admin_password/*10*/ ; // password required for admin operation
//   private: string p_adventurefile;
   private: char p_savegamefile [ 23 ];
   private: char p_password [ 11 ]; // password protected game
   private: bool p_pass_protect; // true if game is protected by password
   private: tiny p_difficulty; // difficulty level of the monsters
   private: tiny p_levelup; // level up speed in experience points
   private: DBTag p_adventure; // Adventure played by the game.

   //--- Constructor & Destructor ---

   public: Game ( void );
   public: ~Game ( void );

   //--- Property Methods ---

//   public: string& adventure ( void );
//   public: const char* cadventure ( void );
//   public: void adventure ( string &str );
//   public: string& savegame ( void );
   public: const char* savegame ( void );
   public: void savegame ( const char *str );
   public: void password ( const char *str );
   public: tiny difficulty ( void );
   public: void difficulty ( tiny value );
   public: tiny levelup ( void );
   public: void levelup ( tiny value );
   public: void protect ( void );
   public: void open ( void );
   public: bool pass_protect ( void );
   public: DBTag adventure ( void );
   public: void adventure ( DBTag value );

   //--- Method ---

   public: bool verify_password ( const char *str );

   //--- Private Methods ---

//   public: void adjust_overflow ( void );

   //--- Virtual Methods ---

//   public: virtual DBTag DBinsert ( void );
//   public: virtual void DBupdate ( void );
//   public: virtual void DBselect ( DBTag value, bool readonly = false );
//   public: virtual void DBselect ( dword index, bool readonly = false );
//   public: virtual void DBremove ( void );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};

/*-------------------------------------------------------------------------*/
/*-                         Global Variables                              -*/
/*-------------------------------------------------------------------------*/

extern const char STR_GAM_DIFFICULTY [] [ 6 ];
extern const char STR_GAM_LEVELUP [] [ 6 ];

