/***************************************************************************/
/*                                                                         */
/*                            E N N E M Y . H                              */
/*                            Class Definition                             */
/*                                                                         */
/*     Content : Class Monster                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : September 1st, 2002                                 */
/*                                                                         */
/*          This class contains all the necessary data to contain the      */
/*     data of a monster and all his AI actions.                           */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                           Class Parameter                             -*/
/*-------------------------------------------------------------------------*/

//#define Ennemy_NB_WEAPON         5
#define Ennemy_NB_SPELL            4
#define Ennemy_NB_ACTION           4
#define Ennemy_NUMBER            256 //?? not sure usage, used for art gallery
                                  // replace with real database information
//#define Ennemy_GAME_NUMBER       192
//#define Ennemy_ADV_NUMBER        64
/*#define Ennemy_NB_WEAPON         10
#define Ennemy_NB_ARMOR          7
#define Ennemy_NB_SHIELD         5*/

/*-------------------------------------------------------------------------*/
/*-                             Constants                                 -*/
/*-------------------------------------------------------------------------*/

// datatype ID

#define Ennemy_DATATYPE_MONSTER     1
#define Ennemy_DATATYPE_HUMANOID    2

// Action types

/*#define Ennemy_ACTION_RUN           1
#define Ennemy_ACTION_HELP          2
#define Ennemy_ACTION_INTELLIGIBLE  4
#define Ennemy_ACTION_BREATH        8  // splash damage to everybody : element
#define Ennemy_ACTION_HEALTH_BREATH 16 // inflict health to everybody*/

// Combat Action

#define Ennemy_ACTION_NONE                0
#define Ennemy_ACTION_RUN                 1
#define Ennemy_ACTION_HELP                2
#define Ennemy_ACTION_BREATH_FIRE         3
#define Ennemy_ACTION_BREATH_COLD         4
#define Ennemy_ACTION_BREATH_LIGHTNING    5
#define Ennemy_ACTION_BREATH_ACID         6
#define Ennemy_ACTION_BREATH_SLEEP        7  // sleep effect
#define Ennemy_ACTION_BREATH_PARALYSIS    8
#define Ennemy_ACTION_BREATH_POISON       9
#define Ennemy_ACTION_BREATH_PETRIFY      10
#define Ennemy_ACTION_STONE_GAZE          11
#define Ennemy_ACTION_EXPLODE             12 // sacrifice and front damage
#define Ennemy_ACTION_DUPLICATE           13
#define Ennemy_ACTION_DEATH_WAIL          14

// Ennemy size



/*-------------------------------------------------------------------------*/
/*-                           Type Definition                             -*/
/*-------------------------------------------------------------------------*/

/*typedef struct dbs_Ennemy_weapon
{
   tiny templateID a_packed; // teamplate of the natural weapon
   dword effect a_packed;
   byte addeffect a_packed;
}dbs_Ennemy_weapon;*/

//?? code to remove
typedef struct s_Ennemy_list
{
   char name [ 26 ]; // name of the monsters
}s_Ennemy_list;

typedef struct dbs_Ennemy
{
   dbs_Opponent opponent_data a_packed;
   char group_name [ 16 ] a_packed;
   byte action [ Ennemy_NB_ACTION ] a_packed;
   byte spell [ Ennemy_NB_SPELL ] a_packed;
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny hitbonus a_packed;
   tiny encmod a_packed;
   tiny dmg_x a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny eprob a_packed;
   tiny rankpriority a_packed;
   tiny mdmg_z a_packed;
   tiny range a_packed;
   tiny static_dmg a_packed;
   tiny hitattrib a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
   

// old info
//   char name [ 16 ] a_packed;   
//   tiny minion a_packed;
//   tiny size a_packed;
//   dbs_Ennemy_weapon weapon [ Ennemy_NB_WEAPON ] a_packed;
//   s_Ennemy_action action [ Ennemy_NB_ACTION ] a_packed;
//   short basestat [ Opponent_NB_STAT ] a_packed;
}dbs_Ennemy a_packed;
/*
typedef struct s_Enemmy_generic_weapon
{
   char name [ 19 ];
   byte dmg_type;
   byte category;
   tiny penetration;
   word wproperty;
}s_Ennemy_generic_weapon;

typedef struct s_Enemmy_generic_armor
{
   char name [ 19 ];
   tiny bulk;
   tiny passivedef;
   tiny protection;
}s_Ennemy_generic_armor;

typedef struct s_Enemmy_generic_shield
{
   char name [ 19 ];
   tiny bulk a_packed;
   tiny passivedef a_packed;
   tiny nb_block a_packed;
}s_Ennemy_generic_shield;
  */
typedef struct dbs_Ennemy_monster
{
   char name [ 16 ] a_packed;
   char group_name [ 16 ] a_packed;   
   tiny level a_packed;
   tiny size a_packed;
   tiny aligment a_packed;
   short reward_exp a_packed;
   short gold a_packed;
   byte pictureID a_packed;
   tiny eprob a_packed;
   tiny rankpriority a_packed;
//   tiny attribute [ 6 ] a_packed;
   word elm_weakness a_packed;
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   tiny hitbonus a_packed;
   tiny encmod a_packed;
   tiny dmg_x a_packed;
   tiny dmg_z a_packed;
   tiny dmg_type a_packed;
   tiny mdmg_z a_packed;
   tiny range a_packed;
   tiny static_dmg a_packed;
   tiny hitattrib a_packed;
   tiny nb_max_attack a_packed;
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MDR a_packed;   
   tiny MPD a_packed;
   tiny MAD a_packed;
   tiny PSAVE a_packed;
   tiny MSAVE a_packed;
   tiny init a_packed;
   tiny action [ Ennemy_NB_ACTION ] a_packed;
   tiny spell [ Ennemy_NB_SPELL ] a_packed;
}dbs_Ennemy_Monster a_packed;

/*-------------------------------------------------------------------------*/
/*-                       Global Variable Definition                      -*/
/*-------------------------------------------------------------------------*/

extern s_Ennemy_list ENNEMY_LIST [ Ennemy_NUMBER ];

/*-------------------------------------------------------------------------*/
/*-                          Class Definition                             -*/
/*-------------------------------------------------------------------------*/

class Ennemy : public Opponent
{
   // Properties

//   private: string p_name; // Name of the Monster
   private: char p_group_name [ 16 ]; // Monster Category
   private: tiny p_action [ Ennemy_NB_ACTION ];
   private: tiny p_spell [ Ennemy_NB_SPELL ];
   private: word p_elm_resist;
   private: word p_hlt_resist;
   private: word p_elm_effect;
   private: word p_hlt_effect;
   private: word p_magikproperty;
   private: tiny p_hitbonus;
   private: tiny p_encmod;
   private: tiny p_dmg_x;
   private: tiny p_dmg_z;
   private: tiny p_dmg_type;
   private: tiny p_mdmg_z;
   private: tiny p_range;
   private: tiny p_static_dmg;
   private: tiny p_hitattrib;
   private: tiny p_nb_max_attack;
   private: tiny p_PD;
   private: tiny p_AD;
   private: tiny p_DR;
   private: tiny p_MDR;
   private: tiny p_MPD;
   private: tiny p_MAD;
   private: tiny p_PSAVE;
   private: tiny p_MSAVE;
   private: tiny p_init;
   private: tiny p_eprob;
   private: tiny p_rankpriority;
   

   // Constructor & Destructor

   public: Ennemy ( void );
//   public: Ennemy ( const Ennemy &tmpobj );
   public: ~Ennemy ( void );

   // Property Methods

   public: const char* group_name ( void );
   public: tiny eprob ( void );
   public: tiny rankpriority ( void );
   
   // Virtual Methods

   public: virtual void eval_stat_other ( void );

   public: virtual void name_combat ( char* str );
   
//   public: virtual void save_vs ( Word healthID, tiny modifier );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
//   public: virtual void child_DBremove ( void );

   public: virtual void alternate_strdat_to_objdat ( tiny datatypeID, void *dataptr );

   public: void monster_strdat_to_objdat ( void *dataptr );

};


