/***************************************************************************/
/*                                                                         */
/*                          E N C O U N T R . H                            */
/*                            Class Definition                             */
/*                                                                         */
/*     Content : Class Encounter                                           */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 1st, 2003                                  */
/*     License : GNU General Public License                                */
/*                                                                         */
/*          This class create a list of selectable monster for encounter   */
/*     according to previously set parameter. It also contains the engine  */
/*     used before combat starts.                                          */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                           Class Parameters                            -*/
/*-------------------------------------------------------------------------*/

#define Encounter_ELIST_SIZE   256

/*-------------------------------------------------------------------------*/
/*-                              Constants                                -*/
/*-------------------------------------------------------------------------*/

// list building mask

#define Encounter_MASK_DRAGON     1
#define Encounter_MASK_UNDEAD     1<<1
#define Encounter_MASK_MYTHICAL   1<<2
#define Encounter_MASK_DIVINE     1<<3
#define Encounter_MASK_ANIMAL     1<<4
#define Encounter_MASK_MAGIC      1<<5
#define Encounter_MASK_FORMLESS   1<<6
#define Encounter_MASK_REPTILE    1<<7
#define Encounter_MASK_INSECT     1<<8
#define Encounter_MASK_HUMANOID   1<<9
#define Encounter_MASK_TINY       1<<10
#define Encounter_MASK_SMALL      1<<11
#define Encounter_MASK_MEDIUM     1<<12
#define Encounter_MASK_LARGE      1<<13
#define Encounter_MASK_HUGE       1<<14

// encounter engine return value

#define Encounter_END      0
#define Encounter_IGNORE   1
#define Encounter_ENGAGE   2

// Encounter probability in %
// consider that these probabilities are rolled for each side which is open.
// game difficulty also modifies this value

#define Encounter_PROBABILITY_NONE        0
#define Encounter_PROBABILITY_LOW         1
#define Encounter_PROBABILITY_NORMAL      2
#define Encounter_PROBABILITY_HIGH        3
#define Encounter_PROBABILITY_VERYHIGH    4

// Encounter Attack Side

#define Encounter_SIDE_FRONT 0
#define Encounter_SIDE_RIGHT 1
#define Encounter_SIDE_BACK  2
#define Encounter_SIDE_LEFT  3

/*-------------------------------------------------------------------------*/
/*-                           Type Definition                             -*/
/*-------------------------------------------------------------------------*/

/*
typedef struct s_Encounter_selection
{

} */

/*-------------------------------------------------------------------------*/
/*-                          Class Definition                             -*/
/*-------------------------------------------------------------------------*/

class Encounter
{
   //--- properties ---

   private: DBTag p_elist [ Encounter_ELIST_SIZE ]; // selection list of ennemy
   private: short p_nb_ennemy; // nb of opponent selected in the list.
   private: tiny p_probability; // % of chance to encounter en ennemy 0 to 4 % recommended,
      // value rolled for each side open.
   private: DBTag p_selection [ 6 ]; // Ennemy selected
//   private: tiny p_side; // ennemy attacking side.
   private: tiny p_nb_selected; // nb of ennemies selected
   private: tiny p_counter; // decrementing value for random.
   private: bool p_door; // encountered in door.
   private: DBTag p_party; // temporary party used for transfering ennemies

   //--- Constructor & Destructor ---

   public: Encounter ( void );
   public: ~Encounter ( void );

   //--- Property Methods ---

   public: short nb_ennemy ( void );
   public: void probability ( tiny value );
   public: tiny probability ( void );
   public: tiny counter ( void );

   //--- Methods ---

   public: void build_list ( tiny base, tiny range, word mask = 0);
   public: void clear_list ( void );
   public: bool check_encounter ( byte solid, bool door );
   public: tiny start ( DBTag party );
   public: void clear_selection ( void );
   public: void clear_objects ( void ); //Delete from db generated ennemies & party
   public: DBTag get_ennemy_party ( void ); // run in combat after start

   //--- Private Methods ---
   
   private: void select_encounter ( void );


};

/*-------------------------------------------------------------------------*/
/*-                        Global Variables                               -*/
/*-------------------------------------------------------------------------*/

extern Encounter encount;



