/***************************************************************************/
/*                                                                         */
/*                             E D I T O R . H                             */
/*                            Class Definition                             */
/*                                                                         */
/*     Content : Class Editor                                              */
/*     Starting Date :  February 21st, 2004                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     License : GNU General Public License                                */
/*                                                                         */
/*          This class is the editor main programm. It allows to edit maze */
/*     maps that will be loaded later in the adventure.                    */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                              Type Definition                          -*/
/*-------------------------------------------------------------------------*/

typedef struct fs_maz_header
{
   tiny f_width;
   tiny f_depth;
   tiny f_sky;
   tiny f_rclevel;
   tiny f_startx;
   tiny f_starty;
   tiny f_startz;
   tiny f_startface;
   dword f_reserved;
}fs_maz_header;

typedef struct s_Editor_maze_tile
{
   byte solid [4]; // 1 value for each direction
   byte special_tech; // 5 bit technical info ;
   byte special_fill; // 1 value
   word masktex; // 2 bit mask floor/ceiling :  4 bit mask wall,
   word object_position; //value
   word tilesetid; // value
   byte walltex; // masked wall texture ID
   byte floortex; // masked floor texture ID
   byte objectimg; // room object image ID
   byte event; // event ID for the maze ( or the floor ) ( 0 = no event )
}s_Editor_maze_tile;


/*-------------------------------------------------------------------------*/
/*-                         Class Declaration                             -*/
/*-------------------------------------------------------------------------*/

class Editor
{
   // Properties

   private: tiny p_width;
   private: tiny p_depth;
   private: tiny p_sky;
   private: tiny p_rclevel;
   private: s_Party_position p_startpos;
   private: s_Editor_maze_tile p_curtile;

   // internal global varaibles ( no need to save

//   private: BITMAP *p_map;
   private: tiny p_xcur;
   private: tiny p_ycur;
   private: tiny p_zcur;
   private: tiny p_xscroll;
   private: tiny p_yscroll;


   // Constructor and Destructor

   public: Editor ( void );
   public: ~Editor ( void );

   // Property Methods

   // Methods

   public: void start ( void );
   public: void load_maz_file ( char *filename );
   public: void save_maz_file ( char *filename );

   // Private Methods

   private: void copy_background ( void );
   private: void draw_map ( void );
   private: void draw_detailed_tile ( void );
   private: void read_curtile ( void /*s_Maze_tile mtile*/);
   private: void write_curtile ( void /*s_Maze_tile &mtile*/ );

   
};

/*-----------------------------------------------------------------------*/
/*-                        Global variables                             -*/
/*-----------------------------------------------------------------------*/

extern const char STR_EDT_SPECIAL_TECH [][16];
extern const char STR_EDT_SPECIAL_FILL [][16];


