/***************************************************************************/
/*                                                                         */
/*                             C O N F I G . H                             */
/*                            Class definition                             */
/*                                                                         */
/*     Content : Class Config                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Stating date : May 20th, 2002                                       */
/*                                                                         */
/*          This class contains the information, configuration procedures  */
/*     and the config screen engine to configure the parameters of the     */
/*     game.                                                               */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                              Class Parameter                          -*/
/*-------------------------------------------------------------------------*/

#define Config_NB_MAX_CONFIG  32
#define Config_NB_CONFIG      18

/*-------------------------------------------------------------------------*/
/*-                          Constants                                    -*/
/*-------------------------------------------------------------------------*/

// configuration identification values
#define Config_TEXTURE                0
#define Config_RENDERING              1
#define Config_SHADING                2
#define Config_TRANSPARENCY           3
#define Config_FLOOR_CEILING          4
#define Config_KEY_DISPLAY            5
#define Config_HELP_DISPLAY           6
#define Config_MUSIC_VOLUME           7
#define Config_SOUND_VOLUME           8
#define Config_BASIC_KEY              9
#define Config_DISPLAY_PARTY          10
#define Config_DISPLAY_SPELL          11
#define Config_DISPLAY_SPECIAL        12
#define Config_WINDOW_BORDER          13
#define Config_ANIMATION              14
#define Config_WINDOW_BACKGROUND      15
#define Config_WINDOW_TEXTURE         16
#define Config_WINDOW_COLOR           17

// configuaration values

#define Config_TEX_YES     0
#define Config_TEX_NO      1

#define Config_REN_PTEX    0
#define Config_REN_ATEX    1

#define Config_SHD_YES     0
#define Config_SHD_NO      1

#define Config_TRS_YES     0
#define Config_TRS_NO      1

#define Config_FAC_YES     0
#define Config_FAC_NO      1

#define Config_KEY_YES     0
#define Config_KEY_NO      1

#define Config_HLP_YES     0
#define Config_HLP_NO      1

#define Config_MUS_MUTE     0
#define Config_MUS_LOW      1
#define Config_MUS_MEDIUM   2
#define Config_MUS_HIGH     3
#define Config_MUS_MAX      4

#define Config_SND_MUTE     0
#define Config_SND_LOW      1
#define Config_SND_MEDIUM   2
#define Config_SND_HIGH     3
#define Config_SND_MAX      4

#define Config_BKY_AZ       0
#define Config_BKY_QW       1
#define Config_BKY_ZX       2

#define Config_PAR_YES      0
#define Config_PAR_NO       1

#define Config_SPL_YES      0
#define Config_SPL_NO       1

#define Config_SPC_YES      0
#define Config_SPC_NO       1

#define Config_WBD_THICK    0
#define Config_WBD_THIN     1
#define Config_WBD_DOUBLE   2
#define Config_WBD_FLAT     3
#define Config_WBD_NONE     4

#define Config_ANI_YES      0
#define Config_ANI_NO       1

#define Config_WBG_COLOR    0
#define Config_WBG_TEXTURE  1

#define Config_WTX_GRANITE  0
#define Config_WTX_FOREST   1
#define Config_WTX_WATER    2
#define Config_WTX_PURPLE   3
#define Config_WTX_EARTH    4

#define Config_WCO_BLACK    0
#define Config_WCO_GREEN    1
#define Config_WCO_BLUE     2
#define Config_WCO_PURPLE   3
#define Config_WCO_BROWN    4

/*-------------------------------------------------------------------------*/
/*-                    Structures and type definition                     -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Config_file
{
   tiny f_value [ Config_NB_MAX_CONFIG ];
}s_Config_file;

/*-------------------------------------------------------------------------*/
/*-                           Class Definition                            -*/
/*-------------------------------------------------------------------------*/

class Config
{
   /*--- Properties ---*/

   private: tiny p_value [ Config_NB_MAX_CONFIG ]; // contains the configuration values

   /*--- Constructor & Destructors ---*/

   public: Config ( void );
   public: ~Config ( void );

   /*--- Property methods ---*/

   public: void set ( tiny configID, tiny value );
   public: tiny get ( tiny configID );

   /*--- Methods ---*/

   public: void start ( void );
   public: void reset ( void );
   public: void initialise ( void );

   public: void load ( void );
   public: void save ( void );
   
   /*--- Private Methods ---*/

   private: void configure_volume ( void );
   private: void configure_key ( void );
   private: void configure_maze ( void );
   private: void configure_window ( void );

};



/*-------------------------------------------------------------------------*/
/*-                      Global Varaible Definition                       -*/
/*-------------------------------------------------------------------------*/

extern Config config;

