/***************************************************************************/
/*                                                                         */
/*                             C O M B A T . H                             */
/*                             Class Definition                            */
/*                                                                         */
/*     Content : Class Combat                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 2nd, 2002                                      */
/*                                                                         */
/*          This class contain exclusively the combat engine. It use       */
/*     opponent classes to make the battle between characters and monsters */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Class Parameter                              -*/
/*-------------------------------------------------------------------------*/

#define Combat_COMMAND_SIZE         12

/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

// combat return value

#define Combat_VICTORY     0
#define Combat_DEFEATED    1
#define Combat_RUN         2

// combat action type

//#define Combat_COMMAND_ZAP                0
#define Combat_COMMAND_FIGHT              0
#define Combat_COMMAND_PARRY              1
#define Combat_COMMAND_HIDE               2
#define Combat_COMMAND_USE_ITEM           3
#define Combat_COMMAND_CAST_SPELL         4
#define Combat_COMMAND_DISPEL             5
#define Combat_COMMAND_RUN                6
#define Combat_COMMAND_PREVIOUS           7

//?? add "run" on first, Prayer, Summon

// combat command requirements
//?? redifine these
//#define Combat_CMDREQ_SPELL        1 // is capable of casting spell
//#define Combat_CMDREQ_ITEM         2 // possess item or equipment
//#define Combat_CMDREQ_REACH        8 // can reach ennemy with weapon
#define Combat_CMDREQ_NOT_FIRST    1 // not the first character to play
#define Combat_CMDREQ_TARGET       2
#define Combat_CMDREQ_FIRST        3
#define Combat_CMDREQ_IGNORE       128 // ignore this command in the list

// combat actor_type

#define Combat_ACTOR_TYPE_NOBODY    0
#define Combat_ACTOR_TYPE_CHARACTER 1
#define Combat_ACTOR_TYPE_ENNEMY    2

/*-------------------------------------------------------------------------*/
/*-                       Type Definition                                 -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Combat_action
{
   tiny actor_type; // Character/ ennemy or nobody
   tiny actor_ID; // ID number of the person who made the action
   tiny command; // command ID
   tiny initiative; // initiative % value
   tiny target; // target ennemy ( -1 equal everybody )
   tiny value; // value used differently according to the command type
}s_Combat_action;

typedef struct s_Combat_command
{
   char name [ 21 ];
   byte requirement; // general requirement
   tiny skill; // skill required to use the command
};

/*-------------------------------------------------------------------------*/
/*-                     Global Variables Definitions                      -*/
/*-------------------------------------------------------------------------*/

extern s_Combat_command COMBAT_COMMAND [ Combat_COMMAND_SIZE ];

/*-------------------------------------------------------------------------*/
/*-                         Class Defintion                               -*/
/*-------------------------------------------------------------------------*/

class Combat
{

   //--- Properties ---

   private: Character p_character [ 6 ]; // list of player's characters
   private: tiny p_nb_character;
   private: Ennemy p_ennemy [ 6 ]; // list of ennemy opponents
   private: tiny p_nb_ennemy;

   private: DBTag p_char_party;
   private: DBTag p_enmy_party;
   // all list of character and ennemy. Save/update characters
   // but delete ennemies and their party.

   //--- Constructors & Destructors ---

   public: Combat ( void );
   public: ~Combat ( void );

   //--- Propetry Methods ---

//   public: tiny nb_character ( void );
//   public: tiny nb_ennemy ( void );

   //--- Methods ---

//   public: void add_character ( DBTag character );
   public: void add_character_party ( DBTag party );
//   public: void add_ennemy ( DBTag ennemy );
   public: void add_ennemy_party ( DBTag party );
//   public: void save_parties ( void );
   public: void reselect_opponents ( void );
   public: void clear ( void );
   public: void add_reward ( void );
   public: void show_cimetary ( void );
//   public: void activesort_characters ( void );
//   public: void activesort_ennemies ( void );
//   public: void remove_character ( tiny index );
//   public: void remove_ennemy ( tiny index );
   
   public: tiny start ( void );

   //--- Private Methods ---

//   private: void draw_combat_screen ( void );
   private: void draw_ennemy ( void );

};

extern const char STR_CMB_STATUS [] [ 16 ];
