/***************************************************************************/
/*                                                                         */
/*                              C I T Y . H                                */
/*                                                                         */
/*     Content : Class City                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 27th, 2002                                    */
/*                                                                         */
/*          This file contains the definition of the class city which is   */
/*     a used as a data object and as an engine.                           */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                     Constant Class Parameter                          -*/
/*-------------------------------------------------------------------------*/

#define City_FONT_NAME           FNT_helena24
#define City_FONT_INSTRUCTION    FNT_small
#define City_NB_MAX_LOCATION     8
#define City_NB_MAX_SERVICE      8
#define City_NB_SERVICE          16
#define City_NB_ADVSERVICE       16
#define City_NB_MAX_WARP         8
#define City_NB_MAX_ITEM         256

/*-------------------------------------------------------------------------*/
/*-                            Constant                                   -*/
/*-------------------------------------------------------------------------*/

// alternate loading

#define City_DATATYPE_ADVENTURE  1

// city location types
/*
#define City_PLACE_GAME_MENU           0
#define City_PLACE_INN                 1
#define City_PLACE_ADVENTURER_GUILD    2
#define City_PLACE_TAVERN              3
#define City_PLACE_MARKETPLACE         4
#define City_PLACE_BLACKSMITH          5
#define City_PLACE_ARMORER             6
#define City_PLACE_WIZARD_GUILD        7
#define City_PLACE_TEMPLE              8
#define City_PLACE_LIBRARY             9
#define City_PLACE_PORT                10
#define City_PLACE_MAZE                11
#define City_PLACE_EDGE_OF_TOWN        12
#define City_PLACE_THIEVES_GUILD       13
*/

// City services

#define City_SERVICE_REST        0
#define City_SERVICE_LEVELUP     1
#define City_SERVICE_HOME        2
#define City_SERVICE_HIRE        3
#define City_SERVICE_QUIT        4
#define City_SERVICE_BUY         5
#define City_SERVICE_SELL        6
#define City_SERVICE_FORGE       7
#define City_SERVICE_ENCHANT     8
#define City_SERVICE_IDENTIFY    9
#define City_SERVICE_HEAL        10
#define City_SERVICE_REVIVE      11
#define City_SERVICE_KNOWLEDGE   12
#define City_SERVICE_KEY         13
#define City_SERVICE_UNCURSE     14
#define City_SERVICE_RETIRE      15

//?? implement by default
//#define City_SERVICE_RETURN      4

//#define City_SERVICE_LANDWARP    13
//#define City_SERVICE_SEAWARP     14
//#define City_SERVICE_AIRWARP     15
//#define City_SERVICE_MAGIKWARP   16
//#define City_SERVICE_EXPLORE     17

// room types

#define City_ROOMTYPE_COMMON      0
#define City_ROOMTYPE_FINE        1

// exit city engine

#define City_CONTINUE         0
#define City_END_GAME         1
#define City_WARP_TO_MAZE     2
#define City_WARP_TO_CITY     3

// rest room_type constant ( mirror constant Character_ROOMTYPE )

#define City_ROOMTYPE_COMMON      0
#define City_ROOMTYPE_FINE        1

// City warping travel type

#define City_WARPTYPE_LAND    0
#define City_WARPTYPE_SEA     1
#define City_WARPTYPE_AIR     2
#define City_WARPTYPE_MAGIC   3
#define City_WARPTYPE_EXPLORE 4

// City Types

#define City_TYPE_VILLAGE     0
#define City_TYPE_CITY        1
#define City_TYPE_CASTLE      2

/*-------------------------------------------------------------------------*/
/*-                     Global variable Definition                        -*/
/*-------------------------------------------------------------------------*/

extern const char SERVICE_NAME [ City_NB_SERVICE ] [ 21 ];

/*-------------------------------------------------------------------------*/
/*-                       Type definition                                 -*/
/*-------------------------------------------------------------------------*/

typedef struct s_City_place
{
   char name [21]; // name drawned in the menu to identify the place
   tiny service [ City_NB_MAX_SERVICE ]; // Services available in the building
   tiny music_track; // Number ID of the music track to play
}s_City_place;

typedef struct s_City_warp
{
   tiny type; // travel type
//   short distance; // determine travel price according to type
   tiny target; // City tag of the target city
   DBTag tag a_packed;
}s_City_warp;

typedef struct s_City_item
{
   DBTag itemtag; // tag on the item for sale
   tiny type; // Item type ID
   byte quantity; // number of items of this type in stock
//   tiny modifier; // price modifier -25% to +25%, ( either random or according to sales/rarety )
}s_City_item;

//typedef struct s_City_data
//{
             /* nb char */
//   s_City_item item [ City_NB_MAX_ITEM ]; // item list of the city
//}s_City_data;

// database structure

typedef struct dbs_City_place
{
   char name [ 21 ] a_packed;
   tiny service [ City_NB_MAX_SERVICE ] a_packed;
   tiny music_track a_packed;
}dbs_City_place a_packed;

typedef struct dbs_City_warp
{
   tiny type a_packed;
//   short distance a_packed;
   tiny target a_packed;
   DBTag tag a_packed;
}dbs_City_warp a_packed;

typedef struct dbs_City
{
   char name [ 31 ] a_packed;
   char shortname [ 11 ] a_packed;
   tiny nb_place a_packed;
   short xpos a_packed;
   short ypos a_packed;
   tiny type a_packed;
   dbs_City_place place [ City_NB_MAX_LOCATION ] a_packed;
   dbs_City_warp warp [ City_NB_MAX_WARP ] a_packed;
}dbs_City a_packed;

// adventure entry structure

typedef struct dbs_ADV_City_place
{
   char name [ 21 ] a_packed; // name of the place
   tiny music_track a_packed; // music track to play
//   tiny service [ City_NB_MAX_SERVICE ] a_packed;
}dbs_ADV_City_place;

typedef struct dbs_ADV_City_warp
{
   tiny type a_packed; // travel type
//   short distance a_packed; // determine travel price according to type
   tiny target a_packed; // 0 - 15 city, 16 - 31 maze
}s_ADV_City_warp;

/*typedef struct dbs_ADV_City_service
{
   tiny type a_packed;
   tiny placeID a_packed;
}dbs_ADV_City_service;*/

typedef struct dbs_ADV_City_data
{
   char name [ 31 ] a_packed;
   char shortname [ 11 ] a_packed;
   tiny type a_packed;
   short xpos a_packed;
   short ypos a_packed;
   tiny nb_place a_packed;
   dbs_ADV_City_place place [ City_NB_MAX_LOCATION ] a_packed;
   tiny service_location [ City_NB_ADVSERVICE ] a_packed;
   dbs_ADV_City_warp warp [ City_NB_MAX_WARP ] a_packed;   
}dbs_ADV_City_data;




/*-------------------------------------------------------------------------*/
/*-                        Class Definition                               -*/
/*-------------------------------------------------------------------------*/

class City : public DBObject
{

   // Properties

   private: char p_name [ 31 ]; // title of the city
   private: char p_shortname [ 11 ];
   private: tiny p_nb_place; // number of places in the city
   private: short p_xpos; // xposition on the map
   private: short p_ypos; // yposition on the map
   private: tiny p_type; // city type
   private: s_City_place p_place [ City_NB_MAX_LOCATION ]; // list of places which can be visited
   private: s_City_warp p_warp [ City_NB_MAX_WARP ]; // city warping information

   private: Party p_party;
   private: s_City_item p_item [ City_NB_MAX_ITEM ];
//   private: Party p_party;

   // Constructor and destructor

   public: City ( void );
   public: ~City ( void );
   
   // Property Methods

//   public: void name ( string &str );
//   public: string& name ( void );
   public: void name ( const char* str );
   public: const char* name ( void );
   public: tiny nb_place ( void );
   public: short xpos ( void );
   public: short ypos ( void );
   public: tiny type ( void );
//   public: void party ( Party &party );

   // Methods

   public: tiny start ( DBTag party );
//   public: void generate ( dbs_ADV_City_data dat );

   public: void reference_target ( DBTag citytaglist [ 16 ], DBTag mazetaglist [ 16 ] );

   // Private Methods

   private: void generate_item ( void );

   private: void show_service_rest ( void );
   private: void show_service_levelup ( void );
   private: void show_service_buy ( void );
   private: void show_service_identify ( void );
   private: void show_service_heal ( void );
   private: void show_service_revive ( void );
   private: tiny show_edge_of_town ( void );

   // virtual Methods
   
   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

   public: virtual void alternate_strdat_to_objdat ( tiny datatypeID, void *dataptr );

};

/*-------------------------------------------------------------------------*/
/*-                         Global Variables                              -*/
/*-------------------------------------------------------------------------*/

extern const char STR_CTY_BUYTYPE [] [ 81 ];
extern const char STR_CTY_WARPACTION [] [ 11 ];

