/***************************************************************************/
/*                                                                         */
/*                         C H A R A C T R . H                             */
/*                                                                         */
/*                         Class Header Definition                         */
/*                                                                         */
/*     Content : Class Character                                           */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 26, 2002                                      */
/*                                                                         */
/*          This class is a database object that contains all the data     */
/*     and procedures that are relative to the character.                  */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                       Constant Parameter                              -*/
/*-------------------------------------------------------------------------*/

#define Character_NB_RACE           10
#define Character_INVENTORY_SIZE    10
#define Character_NB_ATTRIBUTE      7
#define Character_EQUIP_SIZE        7

/*-------------------------------------------------------------------------*/
/*                              Constants                                  */
/*-------------------------------------------------------------------------*/

// Race Identification
/*
#define Character_RACE_HIGH_MAN     0
#define Character_RACE_JINRUI       1
#define Character_RACE_HIGH_ELF     2
#define Character_RACE_DARK_ELF     3
#define Character_RACE_HALFLING     4
#define Character_RACE_DWARF        5
#define Character_RACE_DRACONIAN    6
#define Character_RACE_LIZARDMAN    7
#define Character_RACE_ORC          8
#define Character_RACE_GOBLIN       9
  */
// Valid aligemnt value bit definition
    /*
#define Character_VALID_ALIGMENT_LAWFULL  1
#define Character_VALID_ALIGMENT_BALANCED 2
#define Character_VALID_ALIGMENT_CHAOTIC  4
#define Character_VALID_ALIGMENT_GOOD     8
#define Character_VALID_ALIGMENT_NEUTRAL  16
#define Character_VALID_ALIGMENT_EVIL     32
      */
// sex value

#define Character_FEMALE   0
#define Character_MALE     1

// Availability of the character
#define Character_IN_PARTY1       0
#define Character_IN_PARTY2       1
#define Character_IN_PARTY3       2
#define Character_AVAILABLE       3
#define Character_TOBEDESTROYED   4

// Skill identifier
        /*
#define Character_SKILL_WEAPON_MASTERY    0
#define Character_SKILL_WEAPON_ART        1
#define Character_SKILL_WEAPON_MAGIC      2
#define Character_SKILL_FORGE             3
#define Character_SKILL_MECHANICS         4
#define Character_SKILL_STEALTH           5
#define Character_SKILL_ASSASIN           6
#define Character_SKILL_ACROBATICS        7
#define Character_SKILL_MAGIC_WEILDER     8
#define Character_SKILL_SPELL_FIRE        9
#define Character_SKILL_SPELL_WATER       10
#define Character_SKILL_SPELL_AIR         11
#define Character_SKILL_SPELL_EARTH       12
#define Character_SKILL_SPELL_LIFE        13
#define Character_SKILL_SPELL_DEATH       14
#define Character_SKILL_SUMMONING         15
#define Character_SKILL_ENCHANT_ITEM      16
#define Character_SKILL_IDENTIFY          17
#define Character_SKILL_DISPEL            18
#define Character_SKILL_HEALING           19
          */
// character hit location ID used by the opponent class

/*
#define Character_HIT_LOCATION_TORSO       0
#define Character_HIT_LOCATION_LARM        1
#define Character_HIT_LOCATION_RARM        2
#define Character_HIT_LOCATION_LLEG        3
#define Character_HIT_LOCATION_RLEG        4
#define Character_HIT_LOCATION_HEAD        5
  */
// equiping functions return values

#define Character_ITEM_SUCCESSFULL       0
#define Character_ITEM_INVENTORY_FULL    1
#define Character_ITEM_ALREADY_EQUIPED   2
#define Character_ITEM_ALREADY_UNEQUIPED 3
#define Character_ITEM_UNEQUIPABLE       4
#define Character_ITEM_CURSED            5
#define Character_ITEM_TWOHAND_NOSHIELD  6
#define Character_ITEM_CLASS_RESTRICTION 7
//#define Character_ITEM_HEAVY             6 // require STREND
//#define Character_ITEM_REQUIRE_DEXCUN    7
//#define Character_ITEM_REQUIRE_INTWIL    8

// Equipment location value

#define Character_EQUIP_WEAPON          0
#define Character_EQUIP_SHIELD          1
#define Character_EQUIP_ARMOR           2
#define Character_EQUIP_HEAD            3
#define Character_EQUIP_HAND            4
#define Character_EQUIP_FEET            5
#define Character_EQUIP_OTHER           6
#define Character_EQUIP_NOLOC           7

#define WEAPON          0
#define SHIELD          1
#define ARMOR           2
#define HEAD            3
#define HAND            4
#define FEET            5
#define OTHER           6
#define NOLOC           7


//#define Character_UNEQUIP_WEAPON_B        1
// attribute generation method identification

#define Character_ATTRIBGEN_AVERAGE   0  // 555555
#define Character_ATTRIBGEN_DECREMENT 1  // 876432
#define Character_ATTRIBGEN_OPPOSED   2  // 888222
#define Character_ATTRIBGEN_EXTREME   3  // 993333
#define Character_ATTRIBGEN_LIGHT     4  // 666444

// alligment restriction idestification

/*-------------------------------------------------------------------------*/
/*-                             Type Definition                           -*/
/*-------------------------------------------------------------------------*/

typedef struct s_Character_attribgen_info
{
   tiny minimum [ 6 ];
}s_Character_attribgen_info;

typedef struct dbs_Character
{
   dbs_Opponent opponent_data a_packed;
   char family[ 16 ] a_packed;
   char reputation [ 16 ] a_packed;
   tiny rank a_packed;
   tiny institution a_packed;
   dword race a_packed;
   dword cclass a_packed;
   tiny sex a_packed;
   fix age a_packed;
   int experience a_packed;
   tiny available a_packed;
   dword inventory [ Character_INVENTORY_SIZE ] a_packed;
   dword equiped [ Character_EQUIP_SIZE ] a_packed;
//   dword weapon a_packed;
//   dword shield a_packed;
//   dword armor a_packed;
//   dword feet a_packed;
//   dword hand a_packed;
//   dword head a_packed;
//   dword other a_packed;
   tiny nb_inventory a_packed;
   tiny nb_equiped a_packed;
   int encumbrance a_packed;
   fix weight a_packed;
   char combatstr [ 13 ] a_packed;
}dbs_Character a_packed;

/*-------------------------------------------------------------------------*/
/*-                        Global Variable                                -*/
/*-------------------------------------------------------------------------*/

extern s_Character_attribgen_info ATTRIBGEN_INFO [ 5 ];

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Character : public Opponent
{
   private: char p_family [ 16 ]; // character's family name
   private: char p_reputation [ 16 ]; // Reputation name of the character
   private: tiny p_rank; // Character's rank in an institution
   private: tiny p_institution; // Institution's ID where the rank is owned
   private: DBTag p_race; // value identifying the race of the character
   private: DBTag p_cclass;
   private: tiny p_sex; // value determining the sex of the character
   private: fix p_age; // age of the character
   private: int p_experience; // experience points accumulated
   private: tiny p_available; // indicate availability of the character
   private: DBTag p_inventory [ Character_INVENTORY_SIZE ]; // General items
   private: DBTag p_equiped [ Character_EQUIP_SIZE ];
//   private: DBTag p_weapon; // main weapon of the character
//   private: DBTag p_shield; // shield in off hand
//   private: DBTag p_armor; // item equiped as armor
//   private: DBTag p_feet; // accessory wear on feets
//   private: DBTag p_hand; // accessory wear in hands
//   private: DBTag p_head; // accessory wear on the head
//   private: DBTag p_other; // accessory wear somewhere else.
   private: int p_encumbrance;
   private: fix p_weight;
   private: tiny p_nb_inventory;
   private: tiny p_nb_equiped;
   private: char p_combatstr [ 13 ]; // combat action ID string

   private: static tiny p_levelup_speed; // exponent used for calculating next levels

   // Constructor and destructor

   public: Character ( void );
   public: virtual ~Character ( void );

   // Property methods

   public: const char* family ( void );
   public: void family ( const char *str );
   public: const char* reputation ( void );
   public: void reputation ( const char*str );
   public: void rank ( tiny rankID );
   public: tiny rank ( void );
   public: void institution ( tiny institutionID );
   public: tiny institution ( void );
   public: void race ( DBTag value );
   public: DBTag race ( void );
   public: void cclass ( DBTag value );
   public: DBTag cclass ( void );
   public: void sex ( tiny value );
   public: tiny sex ( void );
   public: float age ( void );
   public: void age ( float value );
   public: int exp ( void );
   public: tiny available ( void );
   public: void available ( tiny value );
   public: int encumbrance ( void );
   public: float weight ( void );
   public: short maxweight ( void );
   public: const char* combatstr ( void );
   public: void combatstr ( const char *str );
   

   public: static void levelup_speed ( byte value );

   // equipment related methods
   public: DBTag inventory ( tiny index );
   public: DBTag equiped ( tiny index );
/*   public: DBTag weapon ( void );
   public: DBTag armor ( void );
   public: DBTag shield ( void );
   public: DBTag feet ( void );
   public: DBTag hand ( void );
   public: DBTag head ( void );
   public: DBTag other ( void );*/
   public: tiny new_inventory ( DBTag itemtag );
   public: tiny delete_inventory ( tiny inventoryID );
   private: tiny remove_inventory ( tiny inventoryID );
   private: tiny add_inventory ( DBTag itemtag );
   public: tiny equip_item ( tiny inventoryID );
   public: tiny unequip_item ( tiny location );
   public: tiny nb_inventory ( void );
   public: tiny nb_equiped ( void );
   public: bool is_equipable ( DBTag itemtag );

   // data to string interpretation
   public: const char* sexC ( void );
   public: const char* sexS ( void );
   public: void raceS ( char* str );
   public: void cclassS ( char* str );
   public: const char* availableS ( void );

   //--- Methods ---

   public: void clean ( void );
   public: void create_new_stats ( void );
   public: void init_race_attribute ( void );

   public: void autoability ( void );
   public: dword use_ability ( tiny inventoryID );
   
   public: bool check_levelup ( void );
   public: int next_level_exp ( void );

   public: void raise_level ( void );
   public: void gain_exp ( int value );
   public: void lose_exp ( int value );
   public: void rest ( tiny nb_days, tiny room_type );
   public: void raise_days ( tiny nb_days );

   public: void eval_stat_race ( void );
   public: void eval_stat_class ( void );
   public: void eval_stat_equipment ( void );
   public: void eval_stat_encumbrance ( void );

   //--- Private Methods ---

   /*--- Virtual Methods ---*/

   public: virtual void eval_stat_other ( void );
   public: virtual void name_combat ( char *str );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );
   
};

/*-------------------------------------------------------------------------*/
/*-                           Global Variables                            -*/
/*-------------------------------------------------------------------------*/

extern const char STR_ITM_EQUIPERR [] [ 241 ];
extern const char STR_CHR_SEXC [] [ 2 ];
extern const char STR_CHR_SEX [] [ 7 ];
extern const char STR_CHR_AVAILABLE [] [ 11 ];
extern const int EXP_TABLE [ 50 ] [ 3 ];

/*-------------------------------------------------------------------------*/
/*-               Non-class procedure prototypes                          -*/
/*-------------------------------------------------------------------------*/



// stuff to add
// available spells, prayer, summon
