/**************************************************************************/
/*                                                                        */
/*                              C C L A S S . H                           */
/*                             Class Definition                           */
/*                                                                        */
/*     Content : CClass ( Character Class ) class definition              */
/*     Programmer : Eric PIetroucpo                                       */
/*     Starting Date : June 13th, 2004                                    */
/*     License : GNU General Public License                               */
/*                                                                        */
/**************************************************************************/

/*------------------------------------------------------------------------*/
/*-                           Class Parameter                            -*/
/*------------------------------------------------------------------------*/

#define CClass_NB_MAX_SKILL  3

/*------------------------------------------------------------------------*/
/*-                             Constants                                -*/
/*------------------------------------------------------------------------*/

// Skills Constant

#define CClass_SKILL_NONE              0
#define CClass_SKILL_MAGIC_WEILDING    1
#define CClass_SKILL_PRAYER            2
#define CClass_SKILL_STEALTH           3 // ( Hide, Scouting )
#define CClass_SKILL_SUMMON            4
#define CClass_SKILL_IDENTIFY          5
#define CClass_SKILL_FORGE_ITEM        6
#define CClass_SKILL_MECHANIC          7
#define CClass_SKILL_ENCHANT_ITEM      8 // ( also create expandables )
#define CClass_SKILL_DISPEL            9
#define CClass_SKILL_HEALING           10
#define CClass_SKILL_MARTIALART        11 // hand to hand combat fighting

// Aligment Constants

#define CClass_ALIGMENT_KIND         1 // life         kn
#define CClass_ALIGMENT_PEACEFULL    2 // water        pf
#define CClass_ALIGMENT_LIVELY       4 // Air          lv
#define CClass_ALIGMENT_SELLFISH     8 // Death        sf
#define CClass_ALIGMENT_AGGRESSIVE   16 // Fire         ag
#define CClass_ALIGMENT_STOICAL      32 // Earth        st

// Sex restriction

#define CClass_SEX_NONE       0
#define CClass_SEX_MALE       1
#define CClass_SEX_FEMALE     2

// Spell Casting Element Allowed

#define CClass_SPELLELEMENT_NONE        0
#define CClass_SPELLELEMENT_LIFE        1 // life         kn
#define CClass_SPELLELEMENT_WATER       2 // water        pf
#define CClass_SPELLELEMENT_AIR         4 // Air          lv
#define CClass_SPELLELEMENT_DEATH       8 // Death        sf
#define CClass_SPELLELEMENT_FIRE       16 // Fire         ag
#define CClass_SPELLELEMENT_EARTH      32 // Earth        st

#define CClass_ARMORPROF_NONE      0
#define CClass_ARMORPROF_LIGHT     1
#define CClass_ARMORPROF_MEDIUM    2
#define CClass_ARMORPROF_HEAVY     3

#define CClass_SHIELDPROF_NONE      0
#define CClass_SHIELDPROF_LIGHT     1
#define CClass_SHIELDPROF_HEAVY     2

#define CClass_AD_NONE     0
#define CClass_AD_LOW      4
#define CClass_AD_MEDIUM   8
#define CClass_AD_HIGH     12

#define CClass_MAD_NONE     0
#define CClass_MAD_LOW      4
#define CClass_MAD_MEDIUM   8
#define CClass_MAD_HIGH     12

#define CClass_MHITP_HIGH   2
#define CClass_MHITP_MEDIUM 3
#define CClass_MHITP_LOW    4

#define CClass_WEAPONPROF_NONE        0
#define CClass_WEAPONPROF_MELEE       1
#define CClass_WEAPONPROF_SWORD       2
#define CClass_WEAPONPROF_BOW         4
#define CClass_WEAPONPROF_MECHANIC    8
#define CClass_WEAPONPROF_UNBALANCED  16
#define CClass_WEAPONPROF_THROWN      32
#define CClass_WEAPONPROF_MAGICAL     64

#define CClass_SPELLPROGRESS_NONE     0
#define CClass_SPELLPROGRESS_SLOW     2
#define CClass_SPELLPROGRESS_MEDIUM   3
#define CClass_SPELLPROGRESS_FAST     4

// Weapon Restriction

/*official new stat

- Aligment allowed
- Weapon range Restriction
- Weapon attrib Restriction
- Weapon nb_hand Restriction
- Armor Profiency
- Shield Profiency
- Element Resistance
- Element Effect
- Health Effect
- Magik Properties
- Spell Casting Element
- Magic Amplification 1 to 3
- Physical Damage y 4 to 12
- Magikal Damage y  4 to 12
- 3 Skill set
- Base multi hit penalty -10, -8, -6
- Active Defense level ( proportion of stat ) /50 , /5, /4, /3
- Magical Defense ( proportion of stat ) /50, /5, /4, /3

/*------------------------------------------------------------------------*/
/*-                          Structure Definition                        -*/
/*------------------------------------------------------------------------*/

typedef struct dbs_CClass
{
   char name [ 21 ] a_packed;
   char initial [ 4 ] a_packed;
   byte aligment_allowed a_packed;
   word elm_resist a_packed;
   word elm_effect a_packed;
   word hlt_resist a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;
   byte spell_element a_packed;
   tiny spell_amplification a_packed;
   tiny spell_progress a_packed;
   tiny skill [ CClass_NB_MAX_SKILL ] a_packed;
// byte wprof_range a_packed;
//   byte wprof_attrib a_packed;
//   byte wprof_nb_hand a_packed;
//   tiny wprof_size a_packed;
   byte weapon_profiency a_packed;
   tiny armor_profiency a_packed;
   tiny shield_profiency a_packed;
   tiny DMGdiv a_packed;
   tiny MDMGdiv a_packed;
   tiny mulhitdiv a_packed;
   tiny baseAD a_packed;
   tiny baseMAD a_packed;
   tiny HPdiv a_packed;
   tiny MPdiv a_packed;
}dbs_CClass  a_packed;

/*------------------------------------------------------------------------*/
/*-                         Class Declaration                            -*/
/*------------------------------------------------------------------------*/

class CClass : public DBObject
{
   //--- Properties ---

   private: char p_name [ 21 ]; // name of the class
   private: char p_initial [ 4 ];
   private: byte p_aligment_allowed; // Alligment allowed for the class
   private: word p_elm_resist;
   private: word p_elm_effect;
   private: word p_hlt_resist;
   private: word p_hlt_effect;
   private: word p_magikproperty;
   private: byte p_spell_element; // Element sphere able to cast/learn spells
   private: tiny p_spell_amplification; // maximum amplification level
   private: tiny p_spell_progress; // accumulated point required to learn spell
   private: tiny p_skill [ CClass_NB_MAX_SKILL ];
/*   private: byte p_wprof_range;
   private: byte p_wprof_attrib;
   private: byte p_wprof_nb_hand;
   private: tiny p_wprof_size;*/
   private: byte p_weapon_profiency;
   private: tiny p_armor_profiency;
   private: tiny p_shield_profiency;
   private: tiny p_DMGdiv;
   private: tiny p_MDMGdiv;
   private: tiny p_mulhitdiv;
   private: tiny p_baseAD;
   private: tiny p_baseMAD;
   private: tiny p_HPdiv;
   private: tiny p_MPdiv;
   
   
//   private: word p_statbonus;

   //--- Constructor & Destructor ---

   public: CClass ( void );
   public: ~CClass ( void );

   //--- Property Methods ---

   public: const char* name ( void );
   public: void name ( const char* value );
   public: const char* initial ( void );
   public: void initial ( const char* value );
   public: byte aligment_allowed ( void );
   public: void aligment_allowed ( tiny value );
   public: word elm_resist ( void );
   public: void elm_resist ( word value );
   public: word elm_effect ( void );
   public: void elm_effect ( word value );
   public: word hlt_resist ( void );
   public: void hlt_resist ( word value );
   public: word hlt_effect ( void );
   public: void hlt_effect ( word value );
   public: word magikproperty ( void );
   public: void magikproperty ( word value );
   public: byte spell_element ( void );
   public: void spell_element ( byte value );
   public: tiny spell_amplification ( void );
   public: void spell_amplification ( tiny value );
   public: tiny spell_progress ( void );
   public: void spell_progress ( tiny value );
   public: tiny skill  ( tiny index );
   public: void skill  ( tiny index, tiny value );
   public: bool have_skill ( tiny value );
/*   public: byte wprof_range ( void );
   public: void wprof_range ( byte value );
   public: byte wprof_attrib ( void );
   public: void wprof_attrib ( byte value );
   public: byte wprof_nb_hand ( void );
   public: void wprof_nb_hand ( byte value );
   public: tiny wprof_size ( void );
   public: void wprof_size ( tiny value );*/
   public: byte weapon_profiency ( void );
   public: void weapon_profiency ( byte value );
   public: tiny armor_profiency ( void );
   public: void armor_profiency ( tiny value );
   public: tiny shield_profiency ( void );
   public: void shield_profiency ( tiny value );
   public: tiny DMGdiv ( void );
   public: void DMGdiv ( tiny value );
   public: tiny MDMGdiv ( void );
   public: void MDMGdiv ( tiny value );
   public: tiny mulhitdiv ( void );
   public: void mulhitdiv ( tiny value );
   public: tiny baseAD ( void );
   public: void baseAD ( tiny value );
   public: tiny baseMAD ( void );
   public: void baseMAD ( tiny value );
   public: tiny HPdiv ( void );
   public: void HPdiv ( tiny value );
   public: tiny MPdiv ( void );
   public: void MPdiv ( tiny value );


   //--- Methods ---

   //--- Virtual Methods ---

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};
