/***************************************************************************/
/*                                                                         */
/*                              C A M P . H                                */
/*                            Class definition                             */
/*                                                                         */
/*     Content : Class Camp                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Stating Date : May 10th, 2002                                       */
/*                                                                         */
/*          The camp class is a engine for managing the camp menu, display */
/*     character stats and executer their commands, etc.                   */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                      Constant Class Parameter                         -*/
/*-------------------------------------------------------------------------*/

#define Camp_FONT_CHARACTER   FNT_print
#define Camp_FONT_INSTRUCTION FNT_small

/*-------------------------------------------------------------------------*/
/*-                             Constants                                 -*/
/*-------------------------------------------------------------------------*/

// camp return value

#define Camp_BACKTOMAZE    0
#define Camp_QUITPARTY     1

// camp menu selection

#define Camp_MENU_CHARACTER    0
#define Camp_MENU_SEARCH       1
#define Camp_MENU_REORDER      2
#define Camp_MENU_DIARY        3
#define Camp_MENU_OPTION       4
#define Camp_MENU_QUIT         5
#define Camp_MENU_CANCEL       6

/*#define Camp_MENU_SPELL        2
#define Camp_MENU_MECHANICS    3
#define Camp_MENU_HEAL         4*/
//#define Camp_MENU_USE_ITEM     5
//#define Camp_MENU_TRADE_ITEM   6

// character Menu selection

#define Camp_CHARMENU_EQUIP   0
#define Camp_CHARMENU_UNEQUIP 1
#define Camp_CHARMENU_INSPECT 2
#define Camp_CHARMENU_DROP    3
#define Camp_CHARMENU_READ    4
//#define Camp_CHARMENU_STAT    5
#define Camp_CHARMENU_CANCEL  5

/*-------------------------------------------------------------------------*/
/*-                        Class Definition                               -*/
/*-------------------------------------------------------------------------*/

class Camp
{
   /*--- Properties ---*/

   private: Party p_party;

   /*--- Constructors & Destructors ---*/

   public: Camp ( void );
   public: ~Camp ( void );

   /*--- Property Methods ---*/


   /*--- Methods ---*/

   public: tiny start ( DBTag party );

   /*--- Private Methods ---*/

   private: void show_character ( void );
   private: tiny show_select_inventory ( Character &tmpchar );
   private: tiny show_select_equipment ( Character &tmpchar );
   private: void show_inspect_item ( Character &tmpchar, tiny inventoryID );
//   private: void show_use_item ( Character &tmpchar, tiny inventoryID );
//   private: void show_fighting_style ( Character &tmpchar );
   private: void show_read_spell ( Character &tmpchar );
   private: void show_combat_stat ( Character &tmpchar );

};

