/***************************************************************************/
/*                                                                         */
/*                              A R M O R . H                              */
/*                             Class Definition                            */
/*                                                                         */
/*     Content : Class Armor                                               */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : June 5th, 2002                                      */
/*                                                                         */
/*          This database class is used for the protection equipment       */
/*     that can be placed on any part of the body.                         */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                      Class Constant Parameter                         -*/
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

// armor category

#define Armor_CATEGORY_NONE      0  // some armor can have this status
#define Armor_CATEGORY_LIGHT     1
#define Armor_CATEGORY_MEDIUM    2
#define Armor_CATEGORY_HEAVY     3

/*-------------------------------------------------------------------------*/
/*-                         Type Definition                               -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Armor
{
   dbs_Item item_data a_packed;
   tiny category a_packed;   
   tiny PD a_packed;
   tiny AD a_packed;
   tiny DR a_packed;
   tiny MPD a_packed;
   tiny MDR a_packed;
}dbs_Armor a_packed;

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Armor : public Item
{

   /*--- Properties ---*/

   private: tiny p_category; // armor category for armor profiency
   private: tiny p_PD; // base value replacing unarmored
   private: tiny p_AD; // Active Defense penalty.
   private: tiny p_DR; // Damage reduction per dice roled
   private: tiny p_MPD; // Mafical Passive defense Bonus
   private: tiny p_MDR; // magic Damage Resistance


   /*--- Constructors and destructors ---*/

   public: Armor ( void );
//   public: Armor ( Armor &obj );
   public: Armor ( DBTag armtag );
   public: ~Armor ( void );
//   public: virtual Item* copy ( void );

   /*--- Property Methods ---*/

   public: tiny PD ( void );
   public: void PD ( tiny value );
   public: tiny AD ( void );
   public: void AD ( tiny value );
   public: tiny DR ( void );
   public: void DR ( tiny value );
   public: tiny MPD ( void );
   public: void MPD ( tiny value );
   public: tiny MDR ( void );
   public: void MDR ( tiny value );
   public: tiny category ( void );
   public: void category ( tiny value );

   /*--- Methods ---*/

   /*--- Private Methods ---*/

   /*--- Virtual Method ---*/

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );
   
};

/*-------------------------------------------------------------------------*/
/*-                    Global Variable Definition                         -*/
/*-------------------------------------------------------------------------*/

extern const char STR_ARM_CATEGORY [] [9];

