/***************************************************************************/
/*                                                                         */
/*                        A D V E N T U R . H                              */
/*                          Class definition                               */
/*                                                                         */
/*     Content : Class Adventure                                           */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : January 17th, 2004                                     */
/*     License : GNU General Public License                                */
/*                                                                         */
/*          This class manage the adventure data file and transfer the     */
/*     data to the appropriate classes of the game.                        */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                    Type and structure definition                      -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Adventure
{
   char saganame [ 31 ] a_packed;
   char adventurename [ 31 ] a_packed;
   tiny episode a_packed;
   char authorname [ 21 ] a_packed;
   char version [ 11 ] a_packed;
   char date [ 26 ] a_packed;
   char impassword [ 9 ] a_packed;
   char expassword [ 9 ] a_packed;
   char filename [ 23 ] a_packed;
}dbs_Adventure;

/*-------------------------------------------------------------------------*/
/*-                          Class Definition                             -*/
/*-------------------------------------------------------------------------*/

class Adventure : public DBObject
{

   //----- Properties -----

   private: char p_saganame [ 31 ]; // full name of the campaing
   private: char p_adventurename [ 31 ]; // name of the current adventure
   private: tiny p_episode; // Number of the episode in the series
   private: char p_authorname [ 21 ]; // Name of the author
   private: char p_version [ 11 ]; // version identification of the adventure
   private: char p_date [ 26 ]; // Release date of the adventure
   private: char p_import_password [ 9 ]; // password required by imported party
   private: char p_export_password [ 9 ]; // password given when exporting party
   private: char p_filename [ 23 ]; // filename of the adventure

   //----- Constructor & destructor -----

   public: Adventure ( void );
   public: ~Adventure ( void );

   //----- Property methods -----

//   public: string& saganame ( void );
   public: const char* saganame ( void );
//   public: string& adventurename ( void );
   public: const char* adventurename ( void );
   public: tiny episode ( void );
//   public: string& authorname ( void );
   public: const char* authorname ( void );
//   public: string& version ( void );
   public: const char* version ( void );
//   public: string& date ( void );
   public: const char* date ( void );
//   public: string& importpasswd ( void );
   public: const char* importpasswd ( void );
//   public: string& exportpasswd ( void );
   public: const char* exportpasswd ( void );
//   public: string& filename ( void );
   public: const char* filename ( void );
//   public: void filename ( string &str );
   public: void filename ( const char* str );
   
   

   //----- Methods -----

   public: void show_intro ( void );
   public: void show_ending ( void );

   //----- Private Methods -----

   //----- Virtual Methods -----

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};

/*-------------------------------------------------------------------------*/
/*-                           Global Variables                            -*/
/*-------------------------------------------------------------------------*/

extern char wizcredits [ 1501 ];

//---------------------------- Very Old Code below ------------------------



/*-------------------------------------------------------------------------*/
/*-                      Constant parameter                               -*/
/*-------------------------------------------------------------------------*/

//#define Adventure_NB_MAX_CITY    32
//#define Adventure_NB_MAX_MAZE    32

/*-------------------------------------------------------------------------*/
/*-                           Constants                                   -*/
/*-------------------------------------------------------------------------*/

// travel destination type ID

//#define Adventure_DESTTYPE_CITY   0
//#define Adventure_DESTTYPE_MAZE   1

/*-------------------------------------------------------------------------*/
/*-                    Type and structure definition                      -*/
/*-------------------------------------------------------------------------*/
/*
typedef struct s_Adventure_travel
{
   tiny type; // destination type ( city or maze )
   tiny destinationID; // identification number of the location
}s_Adventure_travel;

typedef struct s_Adventure_file_header
{
   unsigned char f_name [ 31 ]; // Adventure name
   tiny f_nb_city; // Number of cities in the game
   tiny f_nb_maze; // Number of maze in the game
   tiny f_nb_maze_string; // Number of string used for maze events
   tiny f_nb_maze_texture; // Number of extra textures for the maze ( max 128 )
   tiny f_nb_accessory; // Number of new accessories ( max 32 )
   tiny f_nb_weapon; // Number of new weapons ( max 24 )
   tiny f_nb_armor; // Number of new armors ( max 24 )
   tiny f_nb_shield; // Number of new shield ( max 16 )
   tiny f_nb_item; // Number of new items ( max 32 ) ( generaly key items );
}s_Adventure_file_header;

typedef struct s_Adventure_Maze_file
{
   unsigned char f_title [ 31 ]; // name of the maze
   s_Maze_tile f_tile [ Maze_WIDTH ] [ Maze_WIDTH ] [ Maze_DEPTH ];
   s_Maze_special_space f_space [ Maze_WIDTH ] [ Maze_WIDTH ] [ Maze_DEPTH ];
   // to add : special wall
   s_Adventure_travel f_mazewarp;
}s_Adventure_Maze_file;

//?? maybe use s_Item_file
typedef struct s_Adventure_Item_file
{
   unsigned char f_name [ 16 ]; // Real name of the Item
   unsigned char f_fname [ 16 ]; // name of the unidentified object
   s_Item_ability f_ability; // infor on the ability of the object
   s_Item_effect f_effect; // permanent effect of the item
   tiny f_nb_charge; // nb of charages left in the object
   bool f_cursed; // true if object cannot be unequiped
   tiny f_key; // indicates that item is a key item for the lock with
   byte f_identification; // indicates identified stuff
   fix f_weight; // weigth of the item
}s_Aventure_Item_file;

//todo : weapon, shield, armor, acessory : also add item struct to it.

//todo : Adventure indroduction and ending story text and images
//todo : add world map
  */
/*-------------------------------------------------------------------------*/
/*-                          Class Definition                             -*/
/*-------------------------------------------------------------------------*/

/*
class Adventure
{

   //--- Properties ---

   private: string p_name;  // Adventure name
   private: tiny p_nb_city; // Number of cities in the game
   private: tiny p_nb_maze; // Number of maze in the game
   private: tiny p_nb_maze_string; // Number of string used for maze events
   private: tiny p_nb_maze_texture; // Number of extra textures for the maze
   private: tiny p_nb_accessory; // Number of new accessories ( max 32 )
   private: tiny p_nb_weapon; // Number of new weapons ( max 24 )
   private: tiny p_nb_armor; // Number of new armors ( max 24 )
   private: tiny p_nb_shield; // Number of new shield ( max 16 )
   private: tiny p_nb_item; // Number of new items

   //--- Constructors and Destructors ---

   public: Adventure ( void );
   public: ~Adventure ( void );

   //--- Property Methods ---

   //--- Methods ---

   //--- Private methods ---

};
*/


