/***************************************************************************/
/*                                                                         */
/*                           A C C O U N T . H                             */
/*                           Class Definition                              */
/*                                                                         */
/*     Content : Class Account                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 24th, 2003                                     */
/*     License : GNU General Public License                                */
/*                                                                         */
/*          This class allows to manage the players account. Player's      */
/*     login information is contained in the Account class instead of the  */
/*     Player class. The player exist for each game in the account played  */
/*     while the account exist only once.                                  */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Constants                                    -*/
/*-------------------------------------------------------------------------*/

// Account menu

#define Account_MENU_JOIN        0
#define Account_MENU_RETIRE      1
#define Account_MENU_LOGOUT      2

// Account return value

#define Account_CONTINUE      0
#define Account_JOIN          1
#define Account_EXIT          2

/*-------------------------------------------------------------------------*/
/*-                         TYpe definition                               -*/
/*-------------------------------------------------------------------------*/

typedef struct dbs_Account
{
   char name [ 16 ] a_packed;
   char family [ 16 ] a_packed;
   char nickname [ 16 ] a_packed;
   char loginame [ 11 ] a_packed;
   char password [ 11 ] a_packed;
   short nb_login a_packed;
}dbs_account a_packed;

/*-------------------------------------------------------------------------*/
/*-                             Class Definition                          -*/
/*-------------------------------------------------------------------------*/

class Account : public DBObject
{
   //--- properties ---

   private: char p_name [ 16 ]; // name of the player
   private: char p_family [ 16 ]; // family name of the player
   private: char p_nickname [ 16 ]; // nickname of the player
   private: char p_loginame [ 11 ]; // loginame of the player ( must be unique in the database )
   private: char p_password [ 11 ]; // password to log in the account
   private: short p_nb_login; // number of thimes the player has been logged on this account
   private: DBTag p_selected_player; // joining player

   //--- Constructor & Destructor ---

   public: Account ( void );
   public: ~Account ( void );

   //--- Property methods ---

//   public: string& name ( void );
   public: const char* name ( void );
   public: void name ( const char* str );
//   public: string& family ( void );
   public: const char* family ( void );
   public: void family ( const char *str );
//   public: string& nickname ( void );
   public: const char* nickname ( void );
   public: void nickname ( const char *str );
//   public: string& loginame ( void );
   public: const char* loginame ( void );
   public: void loginame ( const char *str );
   public: void password ( const char *str );
   public: DBTag selected_player ( void );
   
   //--- methods ---

   public: tiny start ( void );
   public: bool verify_password ( const char *pass );

   //--- Private Methods ---

   private: tiny show_join_game ( void );
//   private: void show_continue_game ( void );
   private: void show_retire_game ( void );

   //--- virtual methods ---

//   public: virtual DBTag DBinsert ( void );
//   public: virtual void DBupdate ( void );
//   public: virtual void DBselect ( DBTag value, bool readonly = false );
//   public: virtual void DBselect ( dword index, bool readonly = false );
//   public: virtual void DBremove ( void );

   public: virtual void objdat_to_strdat ( void *dataptr );
   public: virtual void strdat_to_objdat ( void *dataptr );
   public: virtual void child_DBremove ( void );

};










