/***************************************************************************/
/*                                                                         */
/*                        W D A T P R O C . C P P                          */
/*                                                                         */
/*     Content : Module WinData Procedures                                 */
/*     Programmer : Eirc Pietrocupo                                        */
/*     Starting Date : November 15th, 2002                                 */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
//#include <list.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <race.h>
#include <cclass.h>
#include <party.h>
#include <player.h>
#include <account.h>
#include <game.h>
#include <city.h>
//#include <maze.h> // ?? to be removed
//#include <adventur.h>
#include <camp.h>
//#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
//#include <winempty.h>
//#include <wintitle.h>
//#include <winmenu.h>
#include <windata.h>
#include <wdatproc.h>

/*-------------------------------------------------------------------------*/
/*-                      Procedures                                       -*/
/*-------------------------------------------------------------------------*/

void WDatProc_party_bar ( Party &party, short x, short y )
{
//   Party &player_party = party;
//   short height = 25;
   tiny font_height = text_height ( General_FONT_PARTY );
   tiny font_width = text_length ( General_FONT_PARTY, "a" );
   short ystart;
//   Character tmpcharacter;
   tiny i;
   tiny nb_character;
//   string tmpstr;
   char tmpstr [ 16 ];
   int color;
   Character tmpcharacter;
   CClass tmpclass;
   char tmpchar;

   nb_character = party.nb_character();
//   height = height + ( nb_character * font_height );
//   draw_border_fill ( 0, 480 - height , 639 , 479,
//      General_COLOR_BORDER, General_COLOR_FILL );

   ystart = y + 14 + 6;/*480 - height + 6 + 14*/;

   textout ( buffer, General_FONT_INSTRUCTION,
      "      Name               Sex Alig Level Class     HP       MP       Status                  Action",
      x + 7, ystart - 14, General_COLOR_TEXT );

   for ( i = 0 ; i < nb_character ; i++ )
   {
      tmpcharacter.DBselect ( party.character ( i ) );

      strcpy ( tmpstr, tmpcharacter.statusS() );
      color = General_COLOR_DISABLE;

      if ( tmpcharacter.status() == Opponent_STATUS_ALIVE )
      {
         strcpy ( tmpstr, "" );
         color = General_COLOR_TEXT;
      }
      if ( tmpcharacter.check_levelup() == true )
         tmpchar = '@';
      else
         tmpchar = ' ';

         tmpclass.DBselect ( tmpcharacter.cclass() );
//      tmpcharacter.combatstr ("Allo");

/*      DBTag tmptag = party.character ( i );
      textprintf ( buffer, font,  0, 32, General_COLOR_TEXT,
         "Char.Party Tag : T:%d S:%d K:%d", tmptag.table(),
         tmptag.source(), tmptag.key() );

      copy_buffer();
      while ( ( readkey() >> 8 ) != KEY_ENTER );*/

      textprintf ( buffer, General_FONT_PARTY, x + 7, ystart
         , color, "    %-15s %1s %2s %2d%c  %3s %3d/%3d %3d/%3d %-16s %s",
          tmpcharacter.name(), tmpcharacter.sexC(),
          tmpcharacter.aligmentC(), tmpcharacter.level(), tmpchar,
          tmpclass.initial (),
          tmpcharacter.current_HP (), tmpcharacter.max_HP(),
          tmpcharacter.current_MP(), tmpcharacter.max_MP(),
          /*( const char* )*/ tmpstr,  tmpcharacter.combatstr() );
          
      if ( tmpcharacter.status() == Opponent_STATUS_ALIVE )
      {
         draw_health_status ( tmpcharacter.healthS()
                                     , x + ( font_width * 46 ) + 6, ystart );
      }

      ystart = ystart + font_height;
   }

}

void WDatProc_ennemy_bar ( Party &party , short x, short y )
{
   tiny font_height = text_height ( General_FONT_PARTY );
   tiny font_width = text_length ( General_FONT_PARTY, "a" );
   short ystart;
   tiny i;
   tiny nb_character;
//   string tmpstr;
   char tmpstr [ 16 ];
   char tmpname [16];
   int color;
   
   Ennemy tmpe;
//   Opponent &tmpennemy = tmpe;

   nb_character = party.nb_character();

   ystart = y + 6;

//   textout ( buffer, General_FONT_INSTRUCTION,
//      "      Name               Status",
//      x + 7, ystart - 14, General_COLOR_TEXT );

   for ( i = 0 ; i < nb_character ; i++ )
   {
      tmpe.DBselect ( party.character ( i ) );


      strcpy ( tmpstr, tmpe.statusS() );
      color = General_COLOR_DISABLE;

      if ( tmpe.status() == Opponent_STATUS_ALIVE )
      {
         strcpy ( tmpstr, "" );
         color = General_COLOR_TEXT;
      }

//      strncpy ( tmpname, tmpe.cname(), 15 );
//      tmpname [ 15 ] = '\0';
      textprintf ( buffer, General_FONT_PARTY, x + 7, ystart
         , color, "    %s  %s", tmpe.name(), tmpstr );
          
      if ( tmpe.status() == Opponent_STATUS_ALIVE )
      {
         draw_health_status ( tmpe.healthS()
                                     , x + ( font_width * 20 ) + 6, ystart );
      }

      ystart = ystart + font_height;
   }

}


void WDatProc_gallery_bitmap ( BITMAP &bmp, short x, short y )
{
   stretch_sprite( buffer, &bmp, x + 6, y + 6, 256, 256 );
}

void WDatProc_worldmap ( BITMAP &bmp, short x, short y )
{
   draw_sprite ( buffer, &bmp, x + 6, y + 6 );
}

void WDatProc_character ( Character &character, short x, short y )
{
   tiny i;
   tiny j;
//   Weapon tmpw;
//   Shield tmps;
//   Armor tmpm;
//   Accessory tmpa;
   Item tmpitem;
   Race tmprace;
   int point [ 12 ];
   char tmpstr [ 21 ];
   word mask;
   
   character.eval_stat_all();

//--------------------------  Column 1    ---------------------------------

   textprintf ( buffer, FNT_blackchancery16, 34, 10, General_COLOR_TEXT,
      "%s the %s of %s", character.name(), character.reputation(),
      character.family() );

   character.raceS ( tmpstr );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 26, General_COLOR_TEXT,
      "%s %s %s", character.aligmentS(), character.sexS(), tmpstr );

   //to do add rank to the right


//   textprintf ( buffer, Camp_FONT_CHARACTER, 320, 26, General_COLOR_TEXT,
//      "%s, of ", tmpstr );


   textout ( buffer, Camp_FONT_INSTRUCTION, "Attribute               Modifier", 34, 42, General_COLOR_TEXT );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 58, General_COLOR_TEXT,
      "STRength     %2d   (%2d)", character.attribute ( 0 ), character.STRmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 74, General_COLOR_TEXT,
      "DEXterity    %2d   (%2d)", character.attribute ( 1 ), character.DEXmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 90, General_COLOR_TEXT,
      "ENDurance    %2d   (%2d)", character.attribute ( 2 ), character.ENDmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 106, General_COLOR_TEXT,
      "INTelligence %2d   (%2d)", character.attribute ( 3 ), character.INTmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 124, General_COLOR_TEXT,
      "CUNning      %2d   (%2d)", character.attribute ( 4 ), character.CUNmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 140, General_COLOR_TEXT,
      "WILlpower    %2d   (%2d)", character.attribute ( 5 ), character.WILmodifier() );

   textout ( buffer, Camp_FONT_INSTRUCTION, "Health", 34, 172, General_COLOR_TEXT );
   draw_health_status ( character.healthS(), 34, 188 );

   tmprace.DBselect ( character.race() );

   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 204, General_COLOR_TEXT,
      "Hit Point   %d/%d", character.current_HP(), character.max_HP() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 220, General_COLOR_TEXT,
      "Magik Point %d/%d", character.current_MP(), character.max_MP() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 236, General_COLOR_TEXT,
      "HP Dice  %d + %d", tmprace.HPdice(), character.ENDmodifier() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 252, General_COLOR_TEXT,
      "MP Dice  %d + %d", tmprace.MPdice(), character.WILmodifier() );
      

   textout ( buffer, Camp_FONT_INSTRUCTION, "Character", 34, 284, General_COLOR_TEXT );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 300, General_COLOR_TEXT,
      "Level       %d", character.level() );
   character.cclassS ( tmpstr );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 316, General_COLOR_TEXT,
      "Class       %s", tmpstr );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 332, General_COLOR_TEXT,
      "Age         %-3.0f", character.age() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 348, General_COLOR_TEXT,
      "Soul        %d%%", character.soul() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 364, General_COLOR_TEXT,
      "Status      %s", character.statusS() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 380, General_COLOR_TEXT,
      "Exp Point   %d", character.exp() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 396, General_COLOR_TEXT,
      "Next Level  %d", character.next_level_exp() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 412, General_COLOR_TEXT,
      "Gold        %d", character.gold() );

//-----------------------------  column 2 ------------------------------


   textout ( buffer, General_FONT_INSTRUCTION,
      "Inventory                Weight",
      242, 42, General_COLOR_TEXT );


//   ritem = NULL;

   tiny nb_item = character.nb_inventory();
   char tmpc;

   for ( i = 0 ; i < nb_item ; i++ )
   {
      tmpc = ' ';
      tmpitem.DBselect ( character.inventory ( i ) );
      if ( character.is_equipable ( tmpitem.tag() ) == false &&
         tmpitem.type() != Item_TYPE_EXPANDABLE )
         tmpc = '#';
      textprintf ( buffer, Camp_FONT_CHARACTER, 236, 58 + ( i * 16 )
            , General_COLOR_TEXT, "%c%-18s %4.2f", tmpc, tmpitem.vname(),
            tmpitem.weight() );
   }
  
   textout ( buffer, General_FONT_INSTRUCTION, "Equipment",
      242, 234, General_COLOR_TEXT );

   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 250, General_COLOR_TEXT,
      "Weapon " );
//   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 314, General_COLOR_TEXT,
//      "Weapon B" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 266, General_COLOR_TEXT,
      "Shield" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 282, General_COLOR_TEXT,
      "Armor" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 298, General_COLOR_TEXT,
      "Head" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 314, General_COLOR_TEXT,
      "Hands" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 330, General_COLOR_TEXT,
      "Feets" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 346, General_COLOR_TEXT,
      "Other" );

   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 378, General_COLOR_TEXT,
      "Weight %5.2f / %3d Kg", character.weight(), character.maxweight() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 394, General_COLOR_TEXT,
      "Encumbrance %d\%%", character.encumbrance() );

   short tmpy = 346; // used for column 3

   for ( i = 0 ; i < Character_EQUIP_SIZE ; i++ )
   {
      if ( character.equiped ( i ) != 0 )
      {
         tmpitem.DBselect ( character.equiped ( i ) );
         textprintf ( buffer, Camp_FONT_CHARACTER, 314, 250 + ( i * 16 ),
            General_COLOR_TEXT, "%-15s", tmpitem.vname() );
         if ( tmpitem.autoability() != Item_AUTOABILITY_NONE )
         {
            textprintf ( buffer, Camp_FONT_CHARACTER, 466, tmpy, General_COLOR_TEXT,
               "%s", STR_ITM_AUTOABILITY [ tmpitem.autoability() ] );
            tmpy += 16;
         }
      }
   }



//-------------------------------- column 3 -------------------------------

   s_Opponent_stat stat;

   character.eval_stat_all();   
   stat= character.stat();

   textout ( buffer, Camp_FONT_INSTRUCTION, "Combat Stat", 466, 42, General_COLOR_TEXT );

   textprintf ( buffer, General_FONT_PARTY, x+466, y + 58, General_COLOR_TEXT,
      "Attack Bonus      %2d", stat.hitbonus );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 74, General_COLOR_TEXT,
      "Initiative        %2d", stat.init );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 90, General_COLOR_TEXT,
      "PD/AD          %2d/%2d", stat.PD, stat.AD );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 106, General_COLOR_TEXT,
      "Magik PD/AD    %2d/%2d", stat.MPD, stat.MAD );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 122, General_COLOR_TEXT,
      "Dmg Reduce        %2d", stat.DR );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 138, General_COLOR_TEXT,
      "Magik Dmg reduce  %2d", stat.MDR );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 154, General_COLOR_TEXT,
      "Phys. Dmg  %2d d%2d+%2d", stat.dmg_x, stat.dmg_y, stat.dmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 170, General_COLOR_TEXT,
      "Magik Dmg  %2d d%2d+%2d", stat.mdmg_x, stat.mdmg_y, stat.mdmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 186, General_COLOR_TEXT,
      "Phys. Saves       %2d", stat.PSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 202, General_COLOR_TEXT,
      "Magik Saves       %2d", stat.MSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 218, General_COLOR_TEXT,
      "Encmbrance Pnlty  %2d", stat.encmod );
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 234, General_COLOR_TEXT,
      "Extra Att Penlty  %2d", stat.multihitmod );

   textprintf ( buffer, General_FONT_PARTY, x+466, y + 250, General_COLOR_TEXT,
      "HtEf");
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 266, General_COLOR_TEXT,
      "HtRs");
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 282, General_COLOR_TEXT,
      "ElEf");
   textprintf ( buffer, General_FONT_PARTY, x+466, y + 298, General_COLOR_TEXT,
      "ElRs");

   mask = 1;
   for ( i = 0 ; i < 16 ; i++ )
   {
      //--------------------
      if ( ( stat.hlt_effect & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 250,
            General_COLOR_TEXT, "%c", HEALTH_INFO [ i ]. name [ 0 ]);
      else
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 250,
            General_COLOR_TEXT, "." );
      //--------------------
      if ( ( stat.hlt_resist & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 266,
            General_COLOR_TEXT, "%c", HEALTH_INFO [ i ]. name [ 0 ]);
      else
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 266,
            General_COLOR_TEXT, "." );
      //-------------------
      if ( ( stat.elm_effect & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 282,
            General_COLOR_TEXT, "%c", STR_ITM_ELMEFFECT [ i ][ 0 ]);
      else
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 282,
            General_COLOR_TEXT, "." );
      //------------------
      if ( ( stat.elm_resist & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 298,
            General_COLOR_TEXT, "%c", STR_ITM_ELMEFFECT [ i ][ 0 ]);
      else
         textprintf ( buffer, General_FONT_PARTY, x+506 +( i * 8 ), y + 298,
            General_COLOR_TEXT, "." );
      mask = mask << 1;
   }


   textout ( buffer, Camp_FONT_INSTRUCTION, "Effect", 466, 330, General_COLOR_TEXT );

// NOTE: Item autoability Are drawn from column 2 code ( Equipment )

//   draw_instruction ( Draw_INSTRUCTION_SELECT, 550, 460 );




}

void WDatProc_character_gold ( Party &party, short x, short y )
{
   Character tmpcharacter;
   tiny nb_character = party.nb_character();
   tiny height = text_height ( General_FONT_PARTY );
   short tmpgold;
   tiny i;

   x = x + 6;
   y = y + 6;

   for ( i = 0 ; i < nb_character ; i++ )
   {
      tmpcharacter.DBselect ( party.character ( i ) );
      tmpgold = tmpcharacter.gold ();
      textprintf ( buffer, General_FONT_PARTY, x, y, General_COLOR_TEXT,
         "%-15s  %d Gp", tmpcharacter.name(), tmpgold );
      y = y + height;
   }

}

void WDatProc_new_character ( Character &character, short x, short y )
{
//   draw_border ( 0, 0, 639, 479, General_COLOR_BORDER );
   Race tmprace;
   DBTag racetag = character.race();
   x = x + 6;
   char tmpstr [ 21 ];   


   textprintf ( buffer, General_FONT_PARTY, x, y + 6, General_COLOR_TEXT,
      "Name :       %s", character.name() );
   textprintf ( buffer, General_FONT_PARTY, x, y + 22, General_COLOR_TEXT,
      "Family :     %s", character.family() );
   textprintf ( buffer, General_FONT_PARTY, x, y + 38, General_COLOR_TEXT,
      "Reputation : %s", character.reputation() );
      
   textprintf ( buffer, General_FONT_PARTY, x, y + 70, General_COLOR_TEXT,
      "Sex :        %s", character.sexS() );
   character.raceS ( tmpstr );      
   textprintf ( buffer, General_FONT_PARTY, x, y + 86, General_COLOR_TEXT,
      "Race :       %s", tmpstr );
   textprintf ( buffer, General_FONT_PARTY, x, y + 102, General_COLOR_TEXT,
      "Aligment :   %s", character.aligmentS() );
   character.cclassS ( tmpstr );
   textprintf ( buffer, General_FONT_PARTY, x, y + 118, General_COLOR_TEXT,
      "Class :      %s", tmpstr );
      

   if ( racetag.number() != 0 )
   {
      tmprace.DBselect ( racetag );
      textprintf ( buffer, General_FONT_PARTY, x, y + 150, General_COLOR_TEXT,
         "Strength      %d ( max %d )", character.strength(),
         ( tmprace.attribute ( Character_STRENGTH ) )+ 10 );
      textprintf ( buffer, General_FONT_PARTY, x, y + 166, General_COLOR_TEXT,
         "Dexterity     %d ( max %d )", character.dexterity(),
         ( tmprace.attribute ( Character_DEXTERITY ) )+ 10);
      textprintf ( buffer, General_FONT_PARTY, x, y + 182, General_COLOR_TEXT,
         "Endurance     %d ( max %d )", character.endurance(),
         ( tmprace.attribute ( Character_ENDURANCE ) )+ 10);
      textprintf ( buffer, General_FONT_PARTY, x, y + 198, General_COLOR_TEXT,
      "Intelligence  %d ( max %d )", character.intelligence(),
         ( tmprace.attribute ( Character_INTELLIGENCE ) )+ 10);
      textprintf ( buffer, General_FONT_PARTY, x, y + 214, General_COLOR_TEXT,
         "Cunning       %d ( max %d )", character.cunning(),
         ( tmprace.attribute ( Character_CUNNING ) )+ 10);
      textprintf ( buffer, General_FONT_PARTY, x, y + 230, General_COLOR_TEXT,
         "Willpower     %d ( max %d )", character.willpower(),
         ( tmprace.attribute ( Character_WILLPOWER ) ) + 10 );
   }


}

void WDatProc_character_list ( Player &player, short x, short y )
{
   draw_character_list ( player, x , y , false );
}

void WDatProc_character_list_masked ( Player &player, short x, short y )
{
   draw_character_list ( player, x , y , true );
}

void WDatProc_party_list ( Player &player, short x, short y )
{
   tiny nb_party = player.nb_party ();
   tiny nb_character;
   tiny i;
   tiny j;
   short xstart;
   short ystart;
//   Party tmpparty;
   short height = text_height ( General_FONT_PARTY );
   Party tmparty;
   Character tmpcharacter;
   City tmpcity;
   CClass tmpclass;
   char tmpstr [ 21 ];   
//   Race tmprace;

//   tmprace.DBselect ( character.race() );



//   Character tmpcharacter;

//   draw_border ( 0 , 0 , 639, 479, General_COLOR_BORDER );
   xstart = x + 6;

   for ( j = 0 ; j < nb_party ; j++ )
   {
      tmparty.DBselect ( player.party ( j ) );
      tmpcity.DBselect ( tmparty.location() );

      ystart = y + ( ( ( height * 7 ) + 16 ) * j ) + 6;

      textprintf ( buffer, General_FONT_PARTY, xstart, ystart, General_COLOR_TEXT,
          "%-30s %<<%-30s >> %s", tmparty.name(), tmpcity.name(),
          STR_PAR_STATUS [ tmparty.status() ] );

      textout ( buffer, General_FONT_INSTRUCTION,
         "Name                Family               Sex Alig Class Level  Status    ",
         xstart + 16, ystart + height, General_COLOR_TEXT );

      ystart = ystart + 14;

      nb_character = tmparty.nb_character ();
      for ( i = 0 ; i < nb_character ; i++ )
      {
         tmpcharacter.DBselect ( tmparty.character ( i ) );

         ystart = ystart + height;
         tmpclass.DBselect ( tmpcharacter.cclass () );
         textprintf ( buffer, General_FONT_PARTY, xstart + 16, ystart,
            General_COLOR_TEXT, "%-15s %-15s %1s %2s  %-3s Lv%d %-7s",
            tmpcharacter.name(), tmpcharacter.family(),
            tmpcharacter.sexC(), tmpcharacter.aligmentC(),
            tmpclass.initial(), tmpcharacter.level(),
            tmpcharacter.statusS() );
      }
   }

   Window::instruction ( 480, 40, Window_INSTRUCTION_SELECT
      + Window_INSTRUCTION_CANCEL + Window_INSTRUCTION_MENU );
//   p_inst_center_x = 320;
//   p_inst_y = 460;
//   draw_instruction (Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT +
//      Draw_INSTRUCTION_CANCEL, 320, 460 );

}

void WDatProc_new_account ( Account &account , short x, short y )
{
   x = x + 6;

//   account.DBselect

   textprintf ( buffer, General_FONT_PARTY, x, y + 6, General_COLOR_TEXT,
      "Loginame : %s", account.loginame() );
   textprintf ( buffer, General_FONT_PARTY, x, y + 22, General_COLOR_TEXT,
      "Name     : %s", account.name() );
   textprintf ( buffer, General_FONT_PARTY, x, y + 38, General_COLOR_TEXT,
      "Family   : %s", account.family() );
   textprintf ( buffer, General_FONT_PARTY, x, y + 54, General_COLOR_TEXT,
      "Nickname : %s", account.nickname() );
      
}

void WDatProc_inspect_item ( Item &item, short x, short y )
{
   dbs_Item_ability tmpability;
   char tmpstr [ 81 ];
   char tmpstr2 [ 81 ];
   char tmpstr3 [ 81 ];
   char tmpstr4 [ 81 ];
   Weapon tmpw;
   Armor tmpm;
   Shield tmps;
   Accessory tmpa;
   Expandable tmpe;
   tiny i;
   tiny j;
   tiny tmpval;
   short tmpy;

   x = x + 6;
   y = y + 6;
   tmpability = item.ability();   
   

//#define Item_IDENTIFICATION_EFFECT     8 // Hlt & Elm effect + Mo + MD effect
//#define Item_IDENTIFICATION_ABILITY    16 // Ability, autoability, charges
//#define Item_IDENTIFICATION_DRAWBACK   32 // Exhaust, Drawback

// weigth
   textprintf ( buffer, General_FONT_PARTY, x, y + 48, General_COLOR_TEXT,
      "Weight :  %4.2f Kg", item.weight() );


   //--------------- IDENTIFICATION_NAME --------------------------

   textprintf ( buffer, General_FONT_PARTY, x, y, General_COLOR_TEXT,
      "%s", item.vname() );
      
   if ( item.identified ( Item_IDENTIFICATION_NAME ) == true )
   {
      if ( item.identified ( Item_IDENTIFICATION_STATUS ) == true )
         item.statusS1( tmpstr);
      else
         strcpy ( tmpstr ,"Unknown" );
      strcpy ( tmpstr2 ,item.typeS() );
   }
   else
   {
      strcpy ( tmpstr ,"Unknown" );
      strcpy ( tmpstr2 , "Item" );
   }
   textprintf ( buffer, General_FONT_PARTY, x, y + 16, General_COLOR_TEXT,
      "%s %s", tmpstr, tmpstr2 );
   
   //--------------- IDENTIFICATION_STAT --------------------------

   if ( item.identified ( Item_IDENTIFICATION_STAT ) == true )
   {
      sprintf ( tmpstr, "%d", item.price() );

      switch ( item.type() )
      {
         case Item_TYPE_WEAPON :
            tmpw.DBselect ( item.tag() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y, General_COLOR_TEXT,
               "%d handed %s weapon", tmpw.nb_hand(), STR_WPN_CATEGORY [ tmpw.category() ] );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+16, General_COLOR_TEXT,
               "%s range W. using %s", STR_WPN_RANGE [ tmpw.range() ],
               STR_WPN_ATTRIBUTE [ tmpw.attribute() ]);
               
            tmpval = tmpw.static_dmg();
            if ( tmpval == 0 )
            {
               textprintf ( buffer, General_FONT_PARTY, x+240, y+32, General_COLOR_TEXT,
               "Damage : %d dY + %d", tmpw.dmg_x(), tmpw.dmg_z() );
            }
            else
            {
               textprintf ( buffer, General_FONT_PARTY, x+240, y+32, General_COLOR_TEXT,
               "Damage : %d d%d + %d", tmpw.dmg_x(), tmpw.static_dmg(), tmpw.dmg_z() );
            }

            textprintf ( buffer, General_FONT_PARTY, x+240, y+48, General_COLOR_TEXT,
            "Damage Type :     %s",  STR_WPN_DMGTYPE [ tmpw.dmg_type() ] );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+64, General_COLOR_TEXT,
            "#max of Attacks : %d",  tmpw.nb_max_attack());
            textprintf ( buffer, General_FONT_PARTY, x+240, y+80, General_COLOR_TEXT,
            "Active Defense :  %d",  tmpw.AD());
            textprintf ( buffer, General_FONT_PARTY, x+240, y+96, General_COLOR_TEXT,
            "Hit Bonus :       %d",  tmpw.hitbonus());
         break;

         case Item_TYPE_ARMOR :
            tmpm.DBselect ( item.tag() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y, General_COLOR_TEXT,
               "%s Armor", STR_ARM_CATEGORY [ tmpm.category() ] );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+16, General_COLOR_TEXT,
               "Passive Defense  %d", tmpm.PD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+32, General_COLOR_TEXT,
               "Active Defense   %d", tmpm.AD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+48, General_COLOR_TEXT,
               "Damage Resist    %d", tmpm.DR() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+64, General_COLOR_TEXT,
               "Magik Pasv Def.  %d", tmpm.MPD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+80, General_COLOR_TEXT,
               "Magik Dmg Resist %d", tmpm.MDR() );
         break;
         case Item_TYPE_SHIELD :
            tmps.DBselect ( item.tag() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y, General_COLOR_TEXT,
               "%s Shield", STR_SHL_CATEGORY [ tmps.category() ] );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+16, General_COLOR_TEXT,
               "Passive Defense  %d", tmps.PD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+32, General_COLOR_TEXT,
               "Active Defense   %d", tmps.AD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+48, General_COLOR_TEXT,
               "Magic Pasv def.  %d", tmps.MPD() );
            textprintf ( buffer, General_FONT_PARTY, x+240, y+64, General_COLOR_TEXT,
               "Magik Actv Def.  %d", tmps.MAD() );
               
         break;
         case Item_TYPE_ACCESSORY :
            tmpa.DBselect ( item.tag() );
            if ( item.identified ( Item_IDENTIFICATION_STATUS ) == true )
            {
               if ( tmpa.bonus() != 0 )
               {
                  textprintf ( buffer, General_FONT_PARTY, x+240, y, General_COLOR_TEXT,
                  "%d bonus applied to", tmpa.bonus() );

                  tmpy = y + 16;
               
                  for ( i = 0 ; i < 3 ; i++ )
                  {
                     if ( tmpa.statID ( i ) != Accessory_STAT_NONE )
                     {
                        textprintf ( buffer, General_FONT_PARTY, x+240, tmpy, General_COLOR_TEXT,
                           "%s", STR_ACC_STAT [ tmpa.statID ( i ) ]  );
                        tmpy += 16;
                     }
                  }
               }
               textprintf ( buffer, General_FONT_PARTY, x+240, y, General_COLOR_TEXT,
                  "No Modifiers" );
               
            }
         break;
      }
   }
   else
   {
      textprintf ( buffer, General_FONT_PARTY, x+240, y + 80, General_COLOR_TEXT,
        "< Unknown Stats >" );
   }

   
   textprintf ( buffer, General_FONT_PARTY, x, y + 64, General_COLOR_TEXT,
      "Value :   %s Gp", tmpstr );
   

   //--------------- IDENTIFICATION_STATUS --------------------------
   if ( item.identified ( Item_IDENTIFICATION_STATUS ) == true )
      item.statusS2( tmpstr );
   else
      strcpy ( tmpstr ,"" );

   textprintf ( buffer, General_FONT_PARTY, x, y + 32, General_COLOR_TEXT,
      "%s", tmpstr );
   
   //--------------- IDENTIFICATION_EFFECT --------------------------
   if ( item.type () == Item_TYPE_WEAPON )
      textprintf ( buffer, General_FONT_PARTY, x, y + 192, General_COLOR_TEXT,
         "Effect : " );
   else
      textprintf ( buffer, General_FONT_PARTY, x, y + 192, General_COLOR_TEXT,
         "Resist : " );

   if ( item.identified ( Item_IDENTIFICATION_EFFECT ) == true )
   {
   //?? note : need to add MD and MO properties
      word mask = 1;
      byte nb_shift = 0;

      for ( i = 0 ; i < 2 ; i++ )
         for ( j = 0 ; j < 8 ; j++ )
         {
            mask = mask << 1;
            nb_shift++;
            if ( ( item.hlteffect() & mask ) > 0 )
               textprintf ( buffer, General_FONT_PARTY, x + ( j * 56 ), y + ( i * 16 ),
                  General_COLOR_TEXT, "%7s",  STR_ITM_HLTEFFECT [ nb_shift ] );
         }

      mask = 1;
      nb_shift = 0;

      for ( i = 0 ; i < 2 ; i++ )
         for ( j = 0 ; j < 8 ; j++ )
         {
            mask = mask << 1;
            nb_shift++;
            if ( ( item.elmeffect() & mask ) > 0 )
               textprintf ( buffer, General_FONT_PARTY, x + ( j * 56 ), y + ( i * 16 ) + 64,
                  General_COLOR_TEXT, "%7s",  STR_ITM_ELMEFFECT [ nb_shift ] );
         }


   }
   //--------------- IDENTIFICATION_ABILITY --------------------------
   if ( item.identified ( Item_IDENTIFICATION_ABILITY ) == true )
   {
      item.abilityS( tmpstr );
      strcpy ( tmpstr2, STR_ITM_AUTOABILITY [ item.autoability() ] );
      if ( tmpability.type != Item_ABILITY_NONE )
      {
         sprintf ( tmpstr3, "%d", item.nb_charge() );
         sprintf ( tmpstr4, "%d", tmpability.max_charge );
      }
      else
      {
         strcpy ( tmpstr3, "-" );
         strcpy ( tmpstr4, "-" );
      }
   }
   else
   {
      strcpy ( tmpstr, "?" );
      strcpy ( tmpstr2, "?" );
      strcpy ( tmpstr3, "?" );
      strcpy ( tmpstr4, "?" );
   }

   textprintf ( buffer, General_FONT_PARTY, x, y + 80, General_COLOR_TEXT,
      "Autoablty %s", tmpstr2 );

   textprintf ( buffer, General_FONT_PARTY, x, y + 96, General_COLOR_TEXT,
      "Ability   %s", tmpstr );

   textprintf ( buffer, General_FONT_PARTY, x, y + 112, General_COLOR_TEXT,
      "Charges   %s / %s", tmpstr3, tmpstr4 );

   //--------------- IDENTIFICATION_DRAWBACK --------------------------
   if ( item.identified ( Item_IDENTIFICATION_DRAWBACK ) == true )
   {
      strcpy ( tmpstr, item.exhaustedS() );
      strcpy ( tmpstr2, item.drawbackS() );
   }
   else
   {
      strcpy ( tmpstr, "?" );
      strcpy ( tmpstr2, "?" );
   }

   textprintf ( buffer, General_FONT_PARTY, x, y + 128, General_COLOR_TEXT,
      "Exhausted %s", tmpstr );
      
   textprintf ( buffer, General_FONT_PARTY, x, y + 144, General_COLOR_TEXT,
      "Drawback  %s", tmpstr2 );

}


void WDatProc_character_stat ( Character &character, short x, short y )
{
   s_Opponent_stat stat;

   character.eval_stat_all();   
   stat= character.stat();

   textprintf ( buffer, General_FONT_PARTY, x+320, y, General_COLOR_TEXT,
      "Multi hit Modifier : %d", stat.multihitmod );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 16, General_COLOR_TEXT,
      "hitbonus : %d", stat.hitbonus );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 32, General_COLOR_TEXT,
      "encmod : %d", stat.encmod );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 48, General_COLOR_TEXT,
      "dmg_x : %d", stat.dmg_x );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 64, General_COLOR_TEXT,
      "dmg_y : %d", stat.dmg_y );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 80, General_COLOR_TEXT,
      "dmg_z : %d", stat.dmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 96, General_COLOR_TEXT,
      "dmg_type : %d", stat.dmg_type );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 112, General_COLOR_TEXT,
      "mdmg_x : %d", stat.mdmg_x );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 128, General_COLOR_TEXT,
      "mdmg_y : %d", stat.mdmg_y );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 144, General_COLOR_TEXT,
      "mdmg_z : %d", stat.mdmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 160, General_COLOR_TEXT,
      "range : %d", stat.range );
//   textprintf ( buffer, General_FONT_PARTY, x+320, y + 176, General_COLOR_TEXT,
//      "hitroll : %d", stat.hitroll );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 192, General_COLOR_TEXT,
      "nb_max_attack : %d", stat.nb_max_attack );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 208, General_COLOR_TEXT,
      "PD : %d", stat.PD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 224, General_COLOR_TEXT,
      "AD : %d", stat.AD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 240, General_COLOR_TEXT,
      "DR : %d", stat.DR );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 256, General_COLOR_TEXT,
      "MDR : %d", stat.MDR );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 272, General_COLOR_TEXT,
      "MPD : %d", stat.MPD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 288, General_COLOR_TEXT,
      "MAD : %d", stat.MAD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 304, General_COLOR_TEXT,
      "PSAVE : %d", stat.PSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 320, General_COLOR_TEXT,
      "MSAVE : %d", stat.MSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 336, General_COLOR_TEXT,
      "init : %d", stat.init );

/*   tiny i;
   char tmpstr [ 51 ];
   tiny tmpval;
   s_Opponent_stat tmpstat;

   character.eval_stat_all();   
   tmpstat = character.allstat();

   for ( i = 0 ; i < 8 ; i++ )
   {
      tmpval = tmpstat.roll [ i ].max + tmpstat.roll [ i ].modifier;
      if ( tmpval < tmpstat.roll [ i ].min )
         tmpval = tmpstat.roll [ i ].max;
   
      sprintf ( tmpstr, "%2d to %2d(%2d) + %2d", tmpstat.roll [ i ].min,
      tmpstat.roll [ i ].max,
      tmpval,
      tmpstat.roll [ i ].bonus );
      textout ( buffer, General_FONT_PARTY, tmpstr, 134, 6 + ( 16 * i ), General_COLOR_TEXT );
   }

   textout ( buffer, General_FONT_PARTY, "Evade     ", 6, 6, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Absorb    ", 6, 24, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Initiative", 6, 40, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Block     ", 6, 56, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Parry     ", 6, 72, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Hit       ", 6, 88, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Shock     ", 6, 104, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Passive Defense", 6, 120, General_COLOR_TEXT );

   textprintf ( buffer, General_FONT_PARTY, 6, 152, General_COLOR_TEXT,
      "Protection  %d", tmpstat.protection );
   textprintf ( buffer, General_FONT_PARTY, 6, 168, General_COLOR_TEXT,
      "Penetration DMG  %d", tmpstat.penetration );
   textprintf ( buffer, General_FONT_PARTY, 6, 184, General_COLOR_TEXT,
      "Multi-hit        %d", tmpstat.multihit );
   textprintf ( buffer, General_FONT_PARTY, 6, 200, General_COLOR_TEXT,
      "# of Parry       %d", tmpstat.nb_parry );
   textprintf ( buffer, General_FONT_PARTY, 6, 216, General_COLOR_TEXT,
      "# of Block       %d", tmpstat.nb_block );
   textprintf ( buffer, General_FONT_PARTY, 6, 232, General_COLOR_TEXT,
      "Bulk             %d", tmpstat.bulk );
   textprintf ( buffer, General_FONT_PARTY, 6, 248, General_COLOR_TEXT,
      "Encumbrance      %d", tmpstat.encumbrance );
  */

/*

/*
//   word elm_resist;
//   word hlt_resist;
//   word elm_effect;
//   word hlt_effect;
//   word moproperty;
//   word mdproperty;
//   byte dmg_type;
//   byte category;
//   word wproperty;
*/






/*   short xpos [ Opponent_NB_STAT ];
   short ypos [ Opponent_NB_STAT ];
   tiny i;
   tiny j;
   short tmpvar;
   short highestx;
   char tmpcstr [ 4 ];*/
/*

   character.eval_stat_all();   

   for ( i = 0 ; i < Opponent_NB_STAT ; i++ )
   {
      xpos [ i ] = 0;
      ypos [ i ] = 0;
   }

   x = x + 6;
   y = y + 6;
   character.eval_stat_all();

   // building general stat
   textout ( buffer, General_FONT_PARTY, "Evade", x, y, General_COLOR_TEXT );
   xpos [ Opponent_STAT_EVADE ] = x + 88;
   ypos [ Opponent_STAT_EVADE ] = y + 0;
   textout ( buffer, General_FONT_PARTY, "Bulk", x, y + 16, General_COLOR_TEXT );
   xpos [ Opponent_STAT_BULK ] = x + 88;
   ypos [ Opponent_STAT_BULK ] = y + 16;
   textout ( buffer, General_FONT_PARTY, "Cover", x, y + 32, General_COLOR_TEXT );
   xpos [ Opponent_STAT_COVER ] = x + 88;
   ypos [ Opponent_STAT_COVER ] = y + 32;
   textout ( buffer, General_FONT_PARTY, "Resist", x, y + 48, General_COLOR_TEXT );
   xpos [ Opponent_STAT_RESIST ] = x + 88;
   ypos [ Opponent_STAT_RESIST ] = y + 48;
   textout ( buffer, General_FONT_PARTY, "Dissipate", x, y + 64, General_COLOR_TEXT );
   xpos [ Opponent_STAT_DISSIPATE ] = x + 88;
   ypos [ Opponent_STAT_DISSIPATE ] = y + 64;


   // building armor protection stat
   textout ( buffer, General_FONT_PARTY, "Armor     Durability     Absorb", x + 314, y , General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Torso    ", x + 314, y + 16, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Left Arm ", x + 314, y + 32, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Right Arm", x + 314, y + 48, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Left Leg ", x + 314, y + 64, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Right Leg", x + 314, y + 80, General_COLOR_TEXT );
   textout ( buffer, General_FONT_PARTY, "Head     ", x + 314, y + 96, General_COLOR_TEXT );

   for ( i = 0 ; i < 6 ; i++ )
   {
      xpos [ Opponent_STAT_DURABILITY00 + i ] = x + 394;
      ypos [ Opponent_STAT_DURABILITY00 + i ] = y + 16 + ( i * 16 );
      xpos [ Opponent_STAT_ABSORB00 + i ] = x + 514;
      ypos [ Opponent_STAT_ABSORB00 + i ] = y + 16 + ( i * 16 );
   }
  */
   // building weapon stat
/*
   textout ( buffer, General_FONT_INSTRUCTION, "Fighting Style A", x, y + 150, General_COLOR_TEXT );

   if ( character.fstyle ( 0 ) != Character_FSTYLE_NONE
      || character.fstyle ( 0 ) != Character_FSTYLE_SHIELD )
   {
      textout ( buffer, General_FONT_PARTY, "Hit", x, y+162, General_COLOR_TEXT );
      xpos [ Opponent_STAT_HIT00 ] = x + 100;
      ypos [ Opponent_STAT_HIT00 ] = y + 162;

      textout ( buffer, General_FONT_PARTY, "Parry", x, y+178, General_COLOR_TEXT );
      xpos [ Opponent_STAT_PARRY00 ] = x + 100;
      ypos [ Opponent_STAT_PARRY00 ] = y + 178;

      textout ( buffer, General_FONT_PARTY, "Unparry", x, y+194, General_COLOR_TEXT );
      xpos [ Opponent_STAT_UNPARRY00 ] = x + 100;
      ypos [ Opponent_STAT_UNPARRY00 ] = y + 194;

      textout ( buffer, General_FONT_PARTY, "Combo", x, y+210, General_COLOR_TEXT );
      xpos [ Opponent_STAT_COMBO00 ] = x + 100;
      ypos [ Opponent_STAT_COMBO00 ] = y + 210;

      textout ( buffer, General_FONT_PARTY, "Multi-hit", x,y+226, General_COLOR_TEXT );
      xpos [ Opponent_STAT_MULTI00 ] = x + 100;
      ypos [ Opponent_STAT_MULTI00 ] = y + 226;

      textout ( buffer, General_FONT_PARTY, "Penetrate", x, y+242, General_COLOR_TEXT );
      xpos [ Opponent_STAT_PENETRATION00 ] = x + 100;
      ypos [ Opponent_STAT_PENETRATION00 ] = y + 242;

      textout ( buffer, General_FONT_PARTY, "Damage", x, y+258, General_COLOR_TEXT );
      xpos [ Opponent_STAT_DAMAGE00 ] = x + 100;
      ypos [ Opponent_STAT_DAMAGE00 ] = y + 258;

//      textout ( buffer, General_FONT_PARTY, "Shock", x, y+166, General_COLOR_TEXT );
//      xpos [ Opponent_STAT_SHOCK00 ] = x + 100;
//      ypos [ Opponent_STAT_SHOCK00 ] = y + 166;

      textout ( buffer, General_FONT_PARTY, "Cripple", x, y+274, General_COLOR_TEXT );
      xpos [ Opponent_STAT_CRIPPLE00 ] = x + 100;
      ypos [ Opponent_STAT_CRIPPLE00 ] = y + 274;

      textout ( buffer, General_FONT_PARTY, "Nb Parry", x, y+290, General_COLOR_TEXT );
      xpos [ Opponent_STAT_NB_PARRY00 ] = x + 100;
      ypos [ Opponent_STAT_NB_PARRY00 ] = y + 290;
   }

   if ( character.fstyle ( 0 ) != Character_FSTYLE_NONE
      || character.fstyle ( 0 ) != Character_FSTYLE_SHIELD )
   {
      textout ( buffer, General_FONT_PARTY, "Hit", x, y+306, General_COLOR_TEXT );
      xpos [ Opponent_STAT_HIT01 ] = x + 100;
      ypos [ Opponent_STAT_HIT01 ] = y + 306;

      textout ( buffer, General_FONT_PARTY, "Parry", x, y+322, General_COLOR_TEXT );
      xpos [ Opponent_STAT_PARRY01 ] = x + 100;
      ypos [ Opponent_STAT_PARRY01 ] = y + 322;

      textout ( buffer, General_FONT_PARTY, "Unparry", x, y+338, General_COLOR_TEXT );
      xpos [ Opponent_STAT_UNPARRY01 ] = x + 100;
      ypos [ Opponent_STAT_UNPARRY01 ] = y + 338;

      textout ( buffer, General_FONT_PARTY, "Combo", x, y+354, General_COLOR_TEXT );
      xpos [ Opponent_STAT_COMBO01 ] = x + 100;
      ypos [ Opponent_STAT_COMBO01 ] = y + 354;

      textout ( buffer, General_FONT_PARTY, "Multi-hit", x, y+370, General_COLOR_TEXT );
      xpos [ Opponent_STAT_MULTI01 ] = x + 100;
      ypos [ Opponent_STAT_MULTI01 ] = y + 370;

      textout ( buffer, General_FONT_PARTY, "Penetrate", x,386166, General_COLOR_TEXT );
      xpos [ Opponent_STAT_PENETRATION01 ] = x + 100;
      ypos [ Opponent_STAT_PENETRATION01 ] = y + 386;

      textout ( buffer, General_FONT_PARTY, "Damage", x, y+402, General_COLOR_TEXT );
      xpos [ Opponent_STAT_DAMAGE01 ] = x + 100;
      ypos [ Opponent_STAT_DAMAGE01 ] = y + 402;

      textout ( buffer, General_FONT_PARTY, "Shock", x, y+418, General_COLOR_TEXT );
      xpos [ Opponent_STAT_SHOCK01 ] = x + 100;
      ypos [ Opponent_STAT_SHOCK01 ] = y + 418;

      textout ( buffer, General_FONT_PARTY, "Cripple", x, y+434, General_COLOR_TEXT );
      xpos [ Opponent_STAT_CRIPPLE01 ] = x + 100;
      ypos [ Opponent_STAT_CRIPPLE01 ] = y + 434;

      textout ( buffer, General_FONT_PARTY, "Nb Parry", x, y+450, General_COLOR_TEXT );
      xpos [ Opponent_STAT_NB_PARRY01 ] = x + 100;
      ypos [ Opponent_STAT_NB_PARRY01 ] = y + 450;
   }
*/

   /*   string name; // name of the manuver used for display in combat
   tiny probability; // value used for % roll to determine manuver selected
   tiny hit; // propability to hit ennemy target
   tiny unparry; // Determine how hard is the weapon to parry
   tiny multi; // probablility to make additional attacks
   tiny type; // type of damage : Piercing or cutting
   tiny penetration; // Penetration %bonus
   tiny damage; // piercing or cutting damage
   tiny shock; // shock damage
}s_Weapon_manuver;

   dbs_Item item_data a_packed;   
   tiny parry a_packed;
   tiny combo a_packed;
   tiny templateID a_packed;
   tiny hit_bonus a_packed;
   tiny unparry_bonus a_packed;
   tiny multi_bonus a_packed;
   tiny penetration_bonus a_packed;
   tiny damage_bonus a_packed;
   tiny shock_bonus a_packed;
   tiny cripple_bonus a_packed;
*/

/*
   for ( i = 0 ; i < Opponent_NB_STATYPE ; i++ )
   {
      for ( j = 0 ; j < 25 ; j++ )
      {
         tmpvar = character.stat ( i, j );
         if ( tmpvar != 0 || i == 0 )
         {
            if ( i > 0 && tmpvar > 0 )
            {
               textprintf ( buffer, General_FONT_PARTY, xpos [ j ], ypos [ j ],
                  WDatProc_stat_color ( i ), "+" );
               xpos [ j ] = xpos [ j ] + 8;
            }
            if ( xpos [ j ] != 0 || ypos [ j ] != 0 )
            {
               sprintf ( tmpcstr, "%d", tmpvar );
               textprintf ( buffer, General_FONT_PARTY, xpos [ j ], ypos [ j ],
                  WDatProc_stat_color ( i ), "%d", tmpvar );
               xpos [ j ] = xpos [ j ] + ( strlen ( tmpcstr ) * 8 );
            }
         }
      }
   }

   highestx = 0;
   for ( i = 0 ; i < 5 ; i++ )
      if ( highestx < xpos [ i ] )
         highestx = xpos [ i ];
   for ( i = 0 ; i < 5 ; i++ )
      xpos [ i ] = highestx;

   highestx = 0;
   for ( i = Opponent_STAT_DURABILITY00 ; i < Opponent_STAT_DURABILITY05 ; i++ )
      if ( highestx < xpos [ i ] )
         highestx = xpos [ i ];
   for ( i = Opponent_STAT_DURABILITY00 ; i < Opponent_STAT_DURABILITY05 ; i++ )
      xpos [ i ] = highestx;

   highestx = 0;
   for ( i = Opponent_STAT_ABSORB00 ; i < Opponent_STAT_ABSORB05 ; i++ )
      if ( highestx < xpos [ i ] )
         highestx = xpos [ i ];
   for ( i = Opponent_STAT_ABSORB00 ; i < Opponent_STAT_ABSORB05 ; i++ )         
      xpos [ i ] = highestx;


   for ( j = 0 ; j < 25 ; j++ )
   {
      if ( xpos [ j ] != 0 || ypos [ j ] != 0 )
      {
   
      tmpvar = character.sum_stat ( j );
      textprintf ( buffer, General_FONT_PARTY, xpos [ j ], ypos [ j ],
         General_COLOR_TEXT, "=%d", tmpvar );
      }
   }

   // color legend

   textout ( buffer, FNT_print, "Attribute", x + 22, y + 440, WDatProc_COLOR_BASE );
   textout ( buffer, FNT_print, "Health", x + 102, y + 440, WDatProc_COLOR_HEALTH );
   textout ( buffer, FNT_print, "Wound", x + 158, y + 440, WDatProc_COLOR_WOUND );
   textout ( buffer, FNT_print, "Maze", x + 206, y + 440, WDatProc_COLOR_MAZE );
   textout ( buffer, FNT_print, "Spell", x + 246, y + 440, WDatProc_COLOR_SPELL );
   textout ( buffer, FNT_print, "Race", x + 294, y + 440, WDatProc_COLOR_RACE );
   textout ( buffer, FNT_print, "Skill", x + 334, y + 440, WDatProc_COLOR_SKILL );
   textout ( buffer, FNT_print, "Equipment", x + 382, y + 440, WDatProc_COLOR_EQUIPMENT );
   textout ( buffer, FNT_print, "Other", x + 462, y + 440, WDatProc_COLOR_OTHER );
   textout ( buffer, FNT_print, "Bulk", x + 510, y + 440, WDatProc_COLOR_BULK );
*/
}

void WDatProc_character_levelup ( Character &character, short x, short y )
{
   x = x + 10;
   y = y + 10;
   s_Opponent_stat stat;

   textprintf ( buffer, Camp_FONT_CHARACTER, x, y, General_COLOR_TEXT,
      "%s the %s of %s", character.name(), character.reputation(),
      character.family() );

   character.eval_stat_all ();

   stat = character.stat();

   textprintf ( buffer, General_FONT_PARTY, x, y + 16, General_COLOR_TEXT,
      "Level :       %d", character.level () );
//   textprintf ( buffer, General_FONT_PARTY, x, y + 32, General_COLOR_TEXT,
//      "Age :         %3.0f", character.age () );
      
   textprintf ( buffer, General_FONT_PARTY, x, y + 48, General_COLOR_TEXT,
      "Hit Point :   %d", character.max_HP () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 64, General_COLOR_TEXT,
      "Magik Point : %d", character.max_MP () );

   textprintf ( buffer, General_FONT_PARTY, x, y + 96, General_COLOR_TEXT,
      "Phisical DMG Dice : %d", stat.dmg_y );
   textprintf ( buffer, General_FONT_PARTY, x, y + 112, General_COLOR_TEXT,
      "Magik DMG Dice :    %d", stat.mdmg_y );
   textprintf ( buffer, General_FONT_PARTY, x, y + 128, General_COLOR_TEXT,
      "Multi Attack Mod. : %d", stat.multihitmod );
   textprintf ( buffer, General_FONT_PARTY, x, y + 144, General_COLOR_TEXT,
      "Skill Bonus :       %d", ( character.level() / 5 ) );

   textprintf ( buffer, General_FONT_PARTY, x, y + 176, General_COLOR_TEXT,
      "Exp :        %d", character.exp () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 192, General_COLOR_TEXT,
      "Next Level : %d", character.next_level_exp () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 208, General_COLOR_TEXT,
      "Soul :       %d", character.soul () );
      
}

void WDatProc_new_race ( Race &race, short x, short y )
{
   x = x + 6;
   y = y + 6;
   byte tmpvar;
   byte mask;
   word wmask;
   word wtmpvar;
   tiny i;

   textprintf ( buffer, General_FONT_PARTY, x, y, General_COLOR_TEXT,
      "Name :        %s", race.name() );
      
   textprintf ( buffer, General_FONT_PARTY, x, y+16, General_COLOR_TEXT,
      "Plural Name : %s", race.plural() );

   textprintf ( buffer, General_FONT_PARTY, x, y + 32, General_COLOR_TEXT,
      "STRength      %d", race.attribute ( Character_STRENGTH ) );
   textprintf ( buffer, General_FONT_PARTY, x, y + 48, General_COLOR_TEXT,
      "DEXterity     %d", race.attribute ( Character_DEXTERITY ) );
   textprintf ( buffer, General_FONT_PARTY, x, y + 64, General_COLOR_TEXT,
      "ENDurance     %d", race.attribute ( Character_ENDURANCE ) );
   textprintf ( buffer, General_FONT_PARTY, x, y + 80, General_COLOR_TEXT,
      "INTelligence  %d", race.attribute ( Character_INTELLIGENCE ) );
   textprintf ( buffer, General_FONT_PARTY, x, y + 96, General_COLOR_TEXT,
      "CUNning       %d", race.attribute ( Character_CUNNING ) );
   textprintf ( buffer, General_FONT_PARTY, x, y + 112, General_COLOR_TEXT,
      "WILpower      %d", race.attribute ( Character_WILLPOWER ) );

   textout ( buffer, General_FONT_PARTY, "Aligment Restriction",
      x, y + 128, General_COLOR_TEXT );

   tmpvar = race.aligment_restriction();
   mask = 1;

   for ( i = 0 ; i < Opponent_NB_ALIGMENT ; i++ )
   {
      if ( ( tmpvar & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x + ( i * 24), y + 144,
         General_COLOR_TEXT, "%2s ", ALIGMENT_INFO [ i ] . initial );
      mask = mask << 1;
   }
   
   textprintf ( buffer, General_FONT_PARTY, x, y + 160, General_COLOR_TEXT,
      "Life Span    %d Years", race.lifespan () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 176, General_COLOR_TEXT,
      "Size         %s", STR_OPP_SIZE [ race.size () ] );

/*   textout ( buffer, General_FONT_PARTY, "Stat Modifier",
      x, y + 192, General_COLOR_TEXT );

   tmpvar = race.stat_bonus();
   mask = 1;

   for ( i = 0 ; i < 6 ; i++ )
   {
      if ( ( tmpvar & mask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, x + ( i * 24 ), y + 208,
         General_COLOR_TEXT, "%3s ", STAT_MODIFIER [ i ].sname );
      mask = mask << 1;
   }*/

   textout ( buffer, General_FONT_PARTY, "Health Resistance",
      x, y + 224, General_COLOR_TEXT );

   wtmpvar = race.health_resist();
   wmask = 1;
   short tmpx = x;
   short tmpy = y + 240;

   for ( i = 0 ; i < Opponent_NB_HEALTH ; i++ )
   {
      if ( ( wtmpvar & wmask ) > 0 )
         textprintf ( buffer, General_FONT_PARTY, tmpx, tmpy ,
         General_COLOR_TEXT, "%s", HEALTH_INFO [ i ].name );
      wmask = wmask << 1;
      tmpy += 16;
      if ( i == 7 )
      {
         tmpy = y + 240;
         tmpx = x + 112;
      }
   }

   //    private: word p_health_resist; // 240
   // 2 column, 1st physical, 2nd Psychic

   // set resistance with letters

   //?? add HP, MP, DMG, MDMG dices.

   textout ( buffer, General_FONT_PARTY, "Abilities",
      x, y + 368, General_COLOR_TEXT );

   /* private: tiny p_ability [ 3 ]; */
}

void WDatProc_opponent_stat ( Opponent &opponent, short x, short y )
{
   x = x + 6;
   y = y + 6;
   s_Opponent_stat stat;
   Ennemy tmpennemy;

   opponent.eval_stat_all();
   stat = opponent.stat();

   textprintf ( buffer, General_FONT_PARTY, x, y, General_COLOR_TEXT,
      "Name :    %s", opponent.name () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 16, General_COLOR_TEXT,
      "STRength :     %d", opponent.strength () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 32, General_COLOR_TEXT,
      "DEXterity :    %d", opponent.dexterity () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 48, General_COLOR_TEXT,
      "ENDurance :    %d", opponent.endurance () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 64, General_COLOR_TEXT,
      "INTelligence : %d", opponent.intelligence () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 80, General_COLOR_TEXT,
      "CUNning :      %d", opponent.cunning () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 96, General_COLOR_TEXT,
      "WILlpower :    %d", opponent.willpower () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 112, General_COLOR_TEXT,
      "LUCk :    %d", opponent.luck () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 128, General_COLOR_TEXT,
      "Level :   %d", opponent.level () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 142, General_COLOR_TEXT,
      "Size :    %s", STR_OPP_SIZE [ opponent.size () ] );
   textprintf ( buffer, General_FONT_PARTY, x, y + 158, General_COLOR_TEXT,
      "HP :      %d", opponent.max_HP () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 174, General_COLOR_TEXT,
      "MP :      %d", opponent.max_MP () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 206, General_COLOR_TEXT,
      "Soul :     %d", opponent.soul () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 222, General_COLOR_TEXT,
      "EXP :      %d", opponent.reward_exp () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 238, General_COLOR_TEXT,
      "Gold :     %d", opponent.gold () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 252, General_COLOR_TEXT,
      "Aligment : %s", opponent.aligmentS () );
   textprintf ( buffer, General_FONT_PARTY, x, y + 268, General_COLOR_TEXT,
      "Status :   %s", opponent.statusS () );


   if ( opponent.type() == Opponent_TYPE_ENNEMY )
   {
      tmpennemy.DBselect ( opponent.tag() );
         textprintf ( buffer, General_FONT_PARTY, x, y + 284, General_COLOR_TEXT,
         "Encounter Probability : %d", tmpennemy.eprob () );
         textprintf ( buffer, General_FONT_PARTY, x, y + 300, General_COLOR_TEXT,
         "Rank Priority :         %d", tmpennemy.rankpriority () );
      
   }

   // add 2nd column combat stat

   textprintf ( buffer, General_FONT_PARTY, x+320, y, General_COLOR_TEXT,
      "Multi hit Modifier : %d", stat.multihitmod );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 16, General_COLOR_TEXT,
      "hitbonus : %d", stat.hitbonus );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 32, General_COLOR_TEXT,
      "encmod : %d", stat.encmod );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 48, General_COLOR_TEXT,
      "dmg_x : %d", stat.dmg_x );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 64, General_COLOR_TEXT,
      "dmg_y : %d", stat.dmg_y );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 80, General_COLOR_TEXT,
      "dmg_z : %d", stat.dmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 96, General_COLOR_TEXT,
      "dmg_type : %d", stat.dmg_type );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 112, General_COLOR_TEXT,
      "mdmg_x : %d", stat.mdmg_x );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 128, General_COLOR_TEXT,
      "mdmg_y : %d", stat.mdmg_y );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 144, General_COLOR_TEXT,
      "mdmg_z : %d", stat.mdmg_z );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 160, General_COLOR_TEXT,
      "range : %d", stat.range );
//   textprintf ( buffer, General_FONT_PARTY, x+320, y + 176, General_COLOR_TEXT,
//      "hitroll : %d", stat.hitroll );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 192, General_COLOR_TEXT,
      "nb_max_attack : %d", stat.nb_max_attack );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 208, General_COLOR_TEXT,
      "PD : %d", stat.PD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 224, General_COLOR_TEXT,
      "AD : %d", stat.AD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 240, General_COLOR_TEXT,
      "DR : %d", stat.DR );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 256, General_COLOR_TEXT,
      "MDR : %d", stat.MDR );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 272, General_COLOR_TEXT,
      "MPD : %d", stat.MPD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 288, General_COLOR_TEXT,
      "MAD : %d", stat.MAD );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 304, General_COLOR_TEXT,
      "PSAVE : %d", stat.PSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 320, General_COLOR_TEXT,
      "MSAVE : %d", stat.MSAVE );
   textprintf ( buffer, General_FONT_PARTY, x+320, y + 336, General_COLOR_TEXT,
      "init : %d", stat.init );
/*
   word elm_resist a_packed;
   word hlt_resist a_packed;
   word elm_effect a_packed;
   word hlt_effect a_packed;
   word magikproperty a_packed;*/
   
      
}
/*
void WDatProc_ennemy_picture ( Party &party, short x, short y )
{
}
*/
/*-------------------------------------------------------------------------*/
/*-                     Private module usage procedures                   -*/
/*-------------------------------------------------------------------------*/

void draw_character_list ( Player &player, short x, short y, bool mask )
{
//   short height = 24;
   tiny font_height = text_height ( General_FONT_PARTY );
   short ystart;
   tiny nb_character;
   tiny i;
   Character tmpcharacter;
   CClass tmpclass;
   char tmpstr [ 21 ];

//   Character tmpcharacter;
   int clr;

   nb_character = player.nb_character();
//   height = height + ( ( nb_character + 1 ) * font_height )
//   + ( font_height / 2 );
//   draw_border_fill ( 0, 0 , 639 , height,
//      General_COLOR_BORDER, General_COLOR_FILL );

   Window::instruction ( 320, 340, Window_INSTRUCTION_SELECT +
      Window_INSTRUCTION_CANCEL + Window_INSTRUCTION_MENU );
//   p_inst_center_x = 320;
//   p_inst_y = 355;

//   draw_instruction (Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT +
//      Draw_INSTRUCTION_CANCEL, 320, 355 );

   textout ( buffer, General_FONT_INSTRUCTION,
      "     Name                 Family              Sex Alig Class Level  Status    Location",
      x + 10, y + 6 + font_height, General_COLOR_TEXT );

   ystart = y + 6 + 12 + font_height + ( font_height / 2 );

   for ( i = 0 ; i < nb_character ; i++ )
   {
      tmpcharacter.DBselect ( player.character ( i ) );
//      DBTag tmptag = player.character ( 0 );

//      textprintf ( buffer, font, 100, 100, General_COLOR_TEXT,
//         "[%3d|%3d|%5d]", tmptag.table(), tmptag.source(), tmptag.key() );

      clr = General_COLOR_TEXT;
      if ( mask == true &&
         tmpcharacter.available() != Character_AVAILABLE )
         clr = General_COLOR_DISABLE;

      tmpclass.DBselect ( tmpcharacter.cclass() );
      textprintf ( buffer, General_FONT_PARTY, x + 7, ystart
         , clr, "    %-15s %-15s %1s %2s  %3s Lv%2d %-7s %-13s",
         tmpcharacter.name(), tmpcharacter.family(),
         tmpcharacter.sexC(), tmpcharacter.aligmentC(),
            tmpclass.initial(), tmpcharacter.level(),
         tmpcharacter.statusS(), tmpcharacter.availableS() );

      ystart = ystart + font_height;
   }


}




