/***************************************************************************/
/*                                                                         */
/*                          S C R E E N . C P P                            */
/*                                                                         */
/*     Content : Game screen Management procedures                         */
/*     Programmer : Eric PIetrocupo                                        */
/*     Stating Date : May 12nd, 2002                                       */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                               Includes                                -*/
/*-------------------------------------------------------------------------*/

#include <allegro.h>
#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>

//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
#include <screen.h>
//#include <dbdata.h> //??-- to remove start
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h> //?? to remove end
#include <adventur.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winempty.h>
#include <wintitle.h>
#include <winmenu.h>
#include <winlist.h>
#include <wdatproc.h>
#include <windata.h>
#include <winmessa.h>
//#include <sinterfc.h>
//#include <siproc.h>

/*-------------------------------------------------------------------------*/
/*-                        Procedures                                     -*/
/*-------------------------------------------------------------------------*/

void show_copyright_screen ( void )
{
   BITMAP *tmpbuf = create_bitmap ( 640, 480 );

   clear_bitmap ( tmpbuf );

   blit ( screen, buffer, 0, 0, 0, 0, 640, 480 );

// Show Allegro

   blit ( BMP_allegro, tmpbuf, 0, 0, 0, 0, 640, 480 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 3000 );
   clear_bitmap ( tmpbuf );

// show company screen

   textout_centre ( tmpbuf, FNT_print,
      "Contains copyrighted material from", 320, 0, General_COLOR_TEXT );

   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1000 );

   blit ( BMP_company000, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );

   blit ( BMP_company001, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );

   blit ( BMP_company002, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );

   blit ( BMP_company003, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );

   blit ( BMP_company004, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );

   blit ( BMP_company005, tmpbuf, 0, 0, 220, 140, 200, 200 );
   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 1500 );



/*   stretch_sprite ( buffer, BMP_company, 0, 0, 640, 480 );
   textout_centre ( buffer, FNT_print,
      "This game contains copyrighted material from these companies",
      320, 0, General_COLOR_TEXT );
   copy_buffer ();
   rest (  500 );*/

// show copyright screen
   clear_bitmap ( tmpbuf );

   textout_centre ( tmpbuf, FNT_print, "Wizardry",
      320, 100, General_COLOR_TEXT );
   textout_centre ( tmpbuf, FNT_print,
      "is a copyright of Andrew Greenberg, Robert Woodhead and",
          320, 116, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "Sir-Tech Software. Most of ideas, concept and",
         320, 132, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "images in this game are their copyrighted material",
      320, 148, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "Additional images and sound has been extracted from" ,
      320, 180, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "the Hexen and Heretic computer game",
      320, 196, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "Wizardry Legacy",
      320, 228, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "is a free software, inspired from the original Wizardry games,",
      320, 244, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "which can be redistributed and/or modified under the terms of the",
      320, 260, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "GNU General Public Licence as published by the Free Software Foundation.",
      320, 276, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "Wizardry Legacy",
      320, 308, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "exist only for the fun of making and playing the game,",
      320, 324, General_COLOR_TEXT );

   textout_centre ( tmpbuf, FNT_print,
      "this is why it should never be used for any kind of profit",
      320, 340, General_COLOR_TEXT );

   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest ( 8000 );

   clear_bitmap ( tmpbuf );

   show_transition_algo7 ( buffer, tmpbuf, 10 );
   rest( 500 );
   destroy_bitmap ( tmpbuf );


//-------------------------------- Code Testing ---------------------
        /*
   short i;
   Item tmpitem;
   DBTag tmptag;

   dword index = db.search_table_entry ( DBTABLE_ITEM );
   char tmpstr [ 100 ];

   // random value for eachitem types : Weap, shld, armr, accs, exp, other
   tiny rndval [ 6 ] = { 4, 5, 2, 8, 20, 1 };
   tiny min [ 6 ] = { 2, 3, 1, 4, 5, 1 };
   tiny tmptype;
   short tmpvar;
   
   i = 0;
 //  j = 0;

   // the list of items will regenerate itself at each call.
   // make a sub function to generate
   while ( db.entry_table_tag ( index ) == DBTABLE_ITEM )
   {
      tmpitem.DBselect ( index );
      tmptag = tmpitem.tag();
      if ( ( tmpitem.type() == Item_TYPE_EXPANDABLE )
         && tmptag.source() != DBSOURCE_SAVEGAME )
      {
//         p_item [ i ] . itemtag = tmpitem.tag();
//         p_item [ i ] . type = tmpitem.type();
         tmptype = tmpitem.type();
//         p_item [ i ] . quantity = 5;
         sprintf ( tmpstr, "%s W:%f S:%d R:%d P:%d", tmpitem.name(), tmpitem.weight(),
             tmpitem.status(), tmpitem.rarity(), tmpitem.price() );
         debug ( tmpstr );
         tmpvar = min [ tmptype ]+rnd( rndval [ tmptype ] );
         i++;
      }
      index++;
   }
      */

   //?? testing Super Interfaces

/*   SICommand ( "This is a test menu", SICMDITEM_TEST, 50, 50 );*/

   //?? testing adventure

//   clear_bitmap ( screen );
//   Adventure testadv;

//   testadv.show_intro  ();
//   testadv.show_ending ();

   //?? db tes ---

//   textout_centre( buffer, FNT_print,
//      "This is a database test", 320, 0, General_COLOR_TEXT );

/*   Ennemy tmpenn;
   dword index = db.search_table_entry ( DBTABLE_MONSTER );
   short i = 0;
   bool accept_ennemy;
   short y = 0;
   

   short nb_ennemy = 0;
   
   do
   {
      tmpenn.alDBselect ( Ennemy_DATATYPE_MONSTER, index );
      accept_ennemy = false;

      if ( ( tmpenn.level() >= 1 )
         && ( tmpenn.level() <= 3 ) )
         accept_ennemy = true;

      //?? use mask to block additional monsters

      if ( accept_ennemy == true )
      {
         textprintf ( buffer, FNT_print, 20, y, General_COLOR_TEXT,
            "- %s | %s | level %2d | size %d |",
         tmpenn.cname(), tmpenn.cgroup_name(), tmpenn.level(), tmpenn.size() );
         i++;
         y+=16;
         nb_ennemy++;
      }
      index++;
   }
   while ( db.entry_table_tag ( index ) == DBTABLE_MONSTER );

   copy_buffer();
   while ( ( readkey()>>8) != KEY_ENTER );*/


}

tiny show_title_screen ( void )
{
   Menu menu_title ("");
   short answer = 0;
   tiny tmpvar;

   menu_title.add_item ("Start Game");
   menu_title.add_item ("Continue Game", true );
   menu_title.add_item ("Art Gallery", false );
   menu_title.add_item ("Game Option");
   menu_title.add_item ("Exit Wizardry" );

   WinMenu wmnu_title ( menu_title, 240, 350, true, true );

   tmpvar = BMP_TITLE000 - 1;
   tmpvar += rnd ( 5 );

   blit ( ( BITMAP* ) datfimage [ tmpvar ] . dat, buffer, 0, 0, 0, 0, 640, 480 );
//   draw_sprite ( buffer, ( BITMAP* ) datfimage [ tmpvar ] . dat
//      , 110, 30 );
//   draw_sprite ( buffer, BMP_title, 80, 100 );
//   draw_border ( 0, 0, 639 , 479, makecol ( 255, 180, 180 ) );
   Window::instruction ( 320, 455 );

   text_mode ( -1 );
   textout_centre ( buffer, FNT_elgar32,
   "Welcome in the world of Wizardry", 320, 10, makecol ( 100, 200, 255 ) );

   textprintf ( buffer, FNT_elgar32, 10, 425, General_COLOR_TEXT,
      "Version %s", VERSION );
   textprintf ( buffer, FNT_elgar32, 10, 451, General_COLOR_TEXT,
      "%s", YEAR );
   text_mode ( -1 );

//   copy_buffer ();

//   draw_border_fill ( 234, 344, 396, 436, General_COLOR_BORDER,
//                                                        General_COLOR_FILL );
//   menu_title.show ( 240, 250 );
     answer = Window::show_all();
//   answer = menu_title.show ( 240, 350, answer, true );

//   make_screen_shot ( "titlshot.bmp" );


//   copy_buffer ();

//   stop_midi ();

//   copy_buffer ();
//   while ( (readkey() >> 8 ) != KEY_ENTER );


   if ( answer == -1 )
      return ( SCREEN_TITLE_END_GAME );
   else
      return ( answer );

}

void show_loading_screen ( const char* title, short percentage )
{
   //?? note percentage is now 500%
   tiny height = text_height ( FNT_blackchancery24 );
   short y;

   y = ( height * 3 ) + 12 + 16;
   //?? replace by WinData
//   WinEmpty wemp_border ( 19, 200, 610, y );
//   draw_border_fill ( 19 , 200, 629 , y , General_COLOR_BORDER,
//      General_COLOR_FILL );

   y = 200 + 6;
   textout_centre ( screen, FNT_blackchancery24, "Entering", 320, y,
                                                        General_COLOR_TEXT );

   y = y + height;
   textout_centre ( screen, FNT_ambrosia24, title, 320, y, General_COLOR_TEXT );

   y = y + height;

   if ( percentage == 0 )
      percentage = 1;

   y = y + 2;
   rectfill ( screen, 69, y, 69 + ( percentage /** 5*/ ), y + 10,
                                                 makecol ( 150, 150, 255 ) );
   rect ( screen, 69, y, 569, y + 10, makecol ( 200, 200, 255 ) );

   y = y + 14;
   textout_centre ( screen, FNT_freehand16, "Loading", 320, y, General_COLOR_TEXT );

//   copy_buffer ();
}

void show_art_gallery ( void )
{
   List lst_monster ("Ennemy List", 20, true );
   List lst_music ("Music List", 20 );
   List lst_texset ("Texture Set", 20, true );
   List lst_masktex ("Masked Textures", 20, true );
   List lst_object ("Object Image", 20, true );
   List lst_sound ("Sound List", 20 );
   List lst_font ("Font List", 20, true );
   Menu mnu_gallery ("Galerry Room" );
   WinList* ptr_wlst;
   WinData<BITMAP> *ptr_wdat;
   BITMAP *ptr_bmp;
   BITMAP *ptr_bmp2;
   short answer1 = 0;
   short answer2 = 0;
   short i;
//   string tmpstr;
   char tmpstr [ 81 ];

   stop_midi ();

   ptr_bmp = create_bitmap ( 256, 256 );
   ptr_bmp2 = create_bitmap ( 128, 128 );

   // list and menu initialisation

   mnu_gallery.add_item ("Texture Sets   ", false );
   mnu_gallery.add_item ("Masked Textures", false );
   mnu_gallery.add_item ("Enemies        ", false );
   mnu_gallery.add_item ("Objects        ", false );
   mnu_gallery.add_item ("Musics         ", false );
   mnu_gallery.add_item ("Sounds         ", false );
   mnu_gallery.add_item ("Font           ", false );
   mnu_gallery.add_item ("Exit           ", false );

   for ( i = 0 ; i < 192  ; i++ )
      lst_monster.add_item ( ENNEMY_LIST [ i ].name );

   for ( i = 0 ; i < Maze_NB_GAME_TEXSET ; i++ )
   {
      sprintf ( tmpstr, "Texture Set %3d", i );
      lst_texset.add_item ( tmpstr );
   }

   for ( i = 0 ; i < Maze_NB_GAME_MASKTEX ; i++ )
   {
      sprintf ( tmpstr, "Texture %3d", i );
      lst_masktex.add_item ( tmpstr );
   }

   for ( i = 0 ; i < Maze_NB_GAME_OBJIMG ; i++ )
   {
      sprintf ( tmpstr, "Object %3d", i );
      lst_object.add_item ( tmpstr );
   }

   for ( i = 0 ; i < System_NB_MUSIC ; i++ )
      lst_music.add_item ( MUSIC_LIST [ i ] . name );

   for ( i = 0 ; i < 37 ; i++ )
   {
      sprintf ( tmpstr, "Sound %3d", i );
      lst_sound.add_item ( tmpstr );
   }

   for ( i = 0 ; i < System_NB_FONT ; i++ )
   {
      lst_font.add_item ( FONT_LIST [ i ].name );
   }

   WinEmpty wemp_background;
//   wemp_background.preshow ();
   WinTitle wttl_title ( "Art Gallery" );
//   wttl_title.preshow ();
   WinMenu wmnu_gallery ( mnu_gallery, 20, 40, true );

   Window::instruction ( 320, 460 );

   while ( answer1 != Screen_GALLERY_EXIT )
   {
      wmnu_gallery.unhide();
      answer1 = Window::show_all();
      wmnu_gallery.hide();

      switch ( answer1 )
      {
         case Screen_GALLERY_TEXTURE :
            ptr_wdat = new WinData<BITMAP> ( WDatProc_gallery_bitmap,
               *ptr_bmp, WDatProc_POSITION_GALLERY_BITMAP );
            ptr_wlst = new WinList ( lst_texset, 20, 40/* true*/ );
            answer2 = 0;

            while ( answer2 != -1 )
            {

               clear_bitmap ( ptr_bmp );
               draw_sprite ( ptr_bmp,
                  ( BITMAP* ) datfmaze [ BMP_TEXSET000 + ( answer2 * 4 ) ] . dat
                  , 0, 0 );
               draw_sprite ( ptr_bmp,
                  ( BITMAP* ) datfmaze [ BMP_TEXSET000 + ( answer2 * 4 ) + 1 ] . dat
                  , 128, 0 );
               draw_sprite ( ptr_bmp,
                  ( BITMAP* ) datfmaze [ BMP_TEXSET000 + ( answer2 * 4 ) + 2 ] . dat
                  , 0, 128 );
               draw_sprite ( ptr_bmp,
                  ( BITMAP* ) datfmaze [ BMP_TEXSET000 + ( answer2 * 4 ) + 3 ] . dat
                  , 128, 128 );
               Window::refresh_all();
               answer2 = Window::show_all();
//               make_screen_shot ( "gallshot.bmp");
//               ptr_wdat->parameter (
//                  *(( BITMAP* ) datf [ BMP_MASKTEX000 + answer2 ] . dat ));
            }
            delete ptr_wlst;
            delete ptr_wdat;
         break;

         case Screen_GALLERY_MASKTEX :
//            ptr_bmp2 = create_bitmap ( 128, 128 );
            clear_bitmap ( ptr_bmp2 );
            draw_sprite ( ptr_bmp2, ( BITMAP* ) datfmaze [ BMP_MASKTEX000 ] . dat, 0, 0 );
            ptr_wdat = new WinData<BITMAP> ( WDatProc_gallery_bitmap, *ptr_bmp2
               /**(( BITMAP* ) datfmaze [ BMP_MASKTEX000 ] . dat )*/
               , WDatProc_POSITION_GALLERY_BITMAP );
            ptr_wlst = new WinList ( lst_masktex, 20, 40/* true*/ );
            answer2 = 0;
            while ( answer2 != -1 )
            {
               answer2 = Window::show_all();
               if ( answer2 != -1 )
               {
                  clear_bitmap ( ptr_bmp2 );
                  draw_sprite ( ptr_bmp2,
                     ( BITMAP* ) datfmaze [ BMP_MASKTEX000 + answer2 ] . dat, 0, 0 );
//               ptr_wdat->parameter (
//                  *(( BITMAP* ) datfmaze [ BMP_MASKTEX000 + answer2 ] . dat ));
//               make_screen_shot ( "gallshot.bmp");
                  ptr_wdat->parameter ( *ptr_bmp2
                  /**(( BITMAP* ) datf [ BMP_MASKTEX000 + answer2 ] . dat )*/);
                  Window::refresh_all();
               }
            }
            delete ptr_wlst;
            delete ptr_wdat;
         break;


         case Screen_GALLERY_MONSTER :
            ptr_wdat = new WinData<BITMAP> ( WDatProc_gallery_bitmap ,
               *(( BITMAP* ) datfennemy [ BMP_ENNEMY000 ] . dat ),
               WDatProc_POSITION_GALLERY_BITMAP );
            ptr_wlst = new WinList ( lst_monster, 20, 40/* true*/ );
            answer2 = 0;
            while ( answer2 != -1 )
            {
               answer2 = Window::show_all();
//               make_screen_shot ( "gallshot.bmp");
               if ( answer2 != -1 )
               {
                  ptr_wdat->parameter (
                     *(( BITMAP* ) datfennemy [ BMP_ENNEMY000 + answer2 ] . dat ));
                  Window::refresh_all();
               }
            }
            delete ptr_wlst;
            delete ptr_wdat;
         break;

         case Screen_GALLERY_OBJECT :
            ptr_wdat = new WinData<BITMAP> ( WDatProc_gallery_bitmap,
               *(( BITMAP* ) datfmaze [ BMP_MAZEOBJ000 ] . dat ),
               WDatProc_POSITION_GALLERY_BITMAP );
            ptr_wlst = new WinList ( lst_object, 20, 40/* true*/ );
            answer2 = 0;
            while ( answer2 != -1 )
            {
               answer2 = Window::show_all();
//               make_screen_shot ( "gallshot.bmp");
               if ( answer2 != -1 )
               {
                  ptr_wdat->parameter (
                     *(( BITMAP* ) datfmaze [ BMP_MAZEOBJ000 + answer2 ] . dat ));
                  Window::refresh_all();
               }
            }
            delete ptr_wlst;
            delete ptr_wdat;
         break;

         case Screen_GALLERY_MUSIC :
            ptr_wlst = new WinList ( lst_music, 20, 40 );
            answer2 = 0;
            while ( answer2 != -1 )
            {
//               draw_border_fill ( 0, 0, 256, 356, General_COLOR_BORDER,
//                  General_COLOR_FILL );
//               draw_instruction ( Draw_INSTRUCTION_SELECT +
//                            Draw_INSTRUCTION_CANCEL +
//                            Draw_INSTRUCTION_MENU , 320, 460 );
               answer2 = Window::show_all();
//               answer2 = lst_music.show ( 6, 6, answer2, false );
               if ( answer2 >= 0 )
                  play_music_track ( answer2 );
            }
            delete ptr_wlst;
         break;

         case Screen_GALLERY_SOUND :
            ptr_wlst = new WinList ( lst_sound, 20, 40 );
            answer2 = 0;                  \
            while ( answer2 != -1 )
            {
               answer2 = Window::show_all();
               if ( answer2 >= 0 )
                  play_sample ( ( SAMPLE* ) datfaudio [ SMP_SOUND000 + answer2 ] . dat
                     , 128, 128, 1000, 0 );
            }
            delete ptr_wlst;
         break;

         case Screen_GALLERY_FONT :
            ptr_wlst = new WinList ( lst_font, 20, 40/* true*/ );
            answer2 = 0;
            while ( answer2 != -1 )
            {
               Window::draw_all();
               textout_centre ( buffer, ( FONT* ) datffont [ FONT_LIST [ answer2 ] . dataID ] . dat,
                "Prepare your self for", 450, 200, General_COLOR_TEXT );
               textout_centre ( buffer, ( FONT* ) datffont [ FONT_LIST [ answer2 ] . dataID ] . dat,
                "the ultimate fantasy Game", 450, 232, General_COLOR_TEXT );
               answer2 = ptr_wlst->show();
               if ( answer2 != -1 )
                  Window::refresh_all();
            }
            delete ptr_wlst;
         break;
         
      }
   }

   destroy_bitmap ( ptr_bmp );
   destroy_bitmap ( ptr_bmp2 );
}


void show_transition_algo7 ( BITMAP *before, BITMAP *after, tiny delay )
{

   short i;
   short j;
   short tmpj;
   short x;
   short y;
   short xrel;
   short yrel;

   j = 0;
   for ( i = 0 ; i < 16 ; i++ )
   {
      // calculating correct j value;

      if ( j > 15 )
         j = j - 16;
      
      // interpretation of relative pixel
      tmpj = j;
      xrel = 0;
      yrel = 0;
      while ( tmpj > 3 )
      {
         yrel++;
         tmpj = tmpj - 4;
      }
      xrel = tmpj;
         
      // draw the pixel
      for ( y = 0 ; y < 480 ; y = y + 4 )
         for ( x = 0 ; x < 640 ; x = x + 4 )
            putpixel ( before, x + xrel, y + yrel, getpixel ( after, x + xrel, y+ yrel ) );
      blit ( before, screen, 0, 0, 0, 0, 640, 480 );

      // incrementing j;
      j = j + 7;
      rest(delay);
   }
}
