/***************************************************************************/
/*                                                                         */
/*                        M A Z E P R O C . C P P                          */
/*                         Module Source code                              */
/*                                                                         */
/*     Content : Module MazeProc procedures                                */
/*     Programmer : Eric PIetrocupo                                        */
/*     Starting Date : January 2nd, 2003                                   */
/*     License : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>

//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
#include <maze.h>
#include <mazeproc.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winquest.h>
#include <winmessa.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>


/*-------------------------------------------------------------------------*/
/*-                           Procedures                                  -*/
/*-------------------------------------------------------------------------*/

tiny MazeProc_event_exit ( s_Maze_event &event, Party &party )
{

   tiny retval = Maze_CONTINUE;
   tiny answer;

   WinTitle *wttl_title = new WinTitle ( event.title );
   WinQuestion *wqst_confirm = new WinQuestion ( event.message );
   load_backup_screen ();
   answer = Window::show_all();
   if ( answer == 0 )
      retval = Maze_BASE_EXIT + event.var [ Maze_EVEXIT_ID ];
   delete wqst_confirm;
   delete wttl_title;

   return ( retval );
}

tiny MazeProc_event_moveup ( s_Maze_event &event, Party &party )
{
   tiny answer;
   
   WinTitle *wttl_title = new WinTitle ( event.title );
   WinQuestion *wqst_confirm = new WinQuestion ( event.message );
   load_backup_screen ();
   answer = Window::show_all();
   if ( answer == 0 )
      party.move_up();
   delete wqst_confirm;
   delete wttl_title;
   return ( Maze_CONTINUE );
}

tiny MazeProc_event_movedown ( s_Maze_event &event, Party &party )
{
   tiny answer;

   WinTitle *wttl_title = new WinTitle ( event.title );
   WinQuestion *wqst_confirm = new WinQuestion ( event.message );
   load_backup_screen ();
   answer = Window::show_all();
   if ( answer == 0 )
       party.move_down();
   delete wqst_confirm;
   delete wttl_title;
   return ( Maze_CONTINUE );
}

tiny MazeProc_event_teleport ( s_Maze_event &event, Party &party )
{
   s_Party_position tpos;
   tpos = party.position ();
   BITMAP *tmpbuf;

   save_backup_screen();
   tmpbuf = create_bitmap ( 640, 480 );
   play_sample ( SMP_sound000, 128, 128, 1000, 0 );
   tpos.x = event.var [ Maze_EVTPORT_XPOS ];
   tpos.y = event.var [ Maze_EVTPORT_YPOS ];
   tpos.z = event.var [ Maze_EVTPORT_ZPOS ];
   tpos.facing = event.var [ Maze_EVTPORT_FACE ];
   party.position ( tpos );

   // animation
   if ( config.get ( Config_ANIMATION ) == Config_ANI_YES )
   {
      maze.draw_maze();
      blit ( buffer, tmpbuf, 0, 0, 0, 0, 640, 480 );
      blit ( backup, buffer, 0, 0, 0, 0, 640, 480 );

      short i;
      short j;
      short tmpj;
      short x;
      short y;
      short xrel;
      short yrel;

      j = 0;
      for ( i = 0 ; i < 16 ; i++ )
      {
         // calculating correct j value;

         if ( j > 15 )
            j = j - 16;
      
         // interpretation of relative pixel
         tmpj = j;
         xrel = 0;
         yrel = 0;
         while ( tmpj > 3 )
         {
            yrel++;
            tmpj = tmpj - 4;
         }
         xrel = tmpj;
         
         // draw the pixel
         for ( y = 0 ; y < 480 ; y = y + 4 )
            for ( x = 0 ; x < 640 ; x = x + 4 )
               putpixel ( buffer, x + xrel, y + yrel, getpixel ( tmpbuf, x + xrel, y+ yrel ) );
         blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );

         // incrementing j;
         j = j + 7;
         rest(10);
      }
   }

   destroy_bitmap ( tmpbuf );

   return ( Maze_CONTINUE );   
}

tiny MazeProc_event_rotator ( s_Maze_event &event, Party &party )
{
   s_Party_position tpos;
   tpos = party.position ();
   tiny i;

   // ?? try to make a parmanent rotating device and walking
   // ?? foward to escape is possible

   for ( i = rnd ( 3 ) ; i > 0 ; i-- )
      party.turn_right ();

   return ( Maze_CONTINUE );
}

tiny MazeProc_event_message ( s_Maze_event &event, Party &party )
{
//   Party &player_party = player.selected_party ();
   tiny answer;
   
   WinTitle *wttl_title = new WinTitle ( event.title );
   WinMessage *wqst_message = new WinMessage ( event.message );
   load_backup_screen ();
   answer = Window::show_all();
   delete wqst_message;
   delete wttl_title;
   return ( Maze_CONTINUE );
}

tiny MazeProc_event_special_combat ( s_Maze_event &event, Party &party )
{
   return ( Maze_COMBAT );
}

