/***************************************************************************/
/*                                                                         */
/*               T H E    W I Z A R D R Y    P R O J E C T                 */
/*                                                                         */
/*     Content : Main Programm                                             */
/*     Starting Date : March 14th, 2002                                    */
/*     Programmer : Eric Pietrocupo                                        */
/*     License : GNU General Public License                                */
/*                                                                         */
/*                                                                         */
/*          This game project consist to make a game which is close to     */
/*     the original game called Wizardry. The game will not look           */
/*     exactly as the original, but it will have the same look and feel.   */
/*                                                                         */
/***************************************************************************/

// Included headers

#include <allegro.h>
#include <general.h>
#include <stdio.h>
#include <stdlib.h>
//#include <time.h>

//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
#include <init.h>
//#include <menu.h>
//#include <option.h>
#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <city.h>
#include <encountr.h>
#include <maze.h>
#include <editor.h>
//#include <adventur.h>
#include <camp.h>
#include <config.h>
//#include <draw.h>
//#include <dialog.h>
#include <combat.h>
#include <setup.h>
#include <manager.h>
#include <account.h>


// driver selection

   BEGIN_COLOR_DEPTH_LIST
      COLOR_DEPTH_8
      COLOR_DEPTH_15
      COLOR_DEPTH_16
   END_COLOR_DEPTH_LIST

// Main programm
int main ( int nb_param, char *param[] )
{
   tiny init_status;
   tiny title_value = SCREEN_TITLE_START;
   tiny city_value;
   tiny maze_value;
   tiny player_value;
   tiny account_value;
   tiny manager_value;
   tiny encount_value;
   tiny combat_value;
   tiny camp_value;
   City city; // city engine
   Camp camp; // camp engine
   Party party;
   Manager manager;
   Combat combat; // combat engine
   Editor editor;
   short i;
   tiny param_code;
   tiny music_selected;
   Account tmpacc;
   Player tmplayer;
//   DBTag partytag;

//   sbrk ( 1400000 );
//   s_Maze_tile test [ 100 ] [ 100 ] [ 10 ];
//   BITMAP *test = create_bitmap ( 640, 480 );

   param_code = decode_parameter ( nb_param, param );

/*   __dpmi_free_mem_info meminfo;
   __dpmi_get_free_memory_information( &meminfo );

   printf("Largest Block       : %12d Bytes\n", meminfo.largest_available_free_block_in_bytes );
   printf("Max Unlock Pages    : %10d Pages\n", meminfo.maximum_unlocked_page_allocation_in_pages );
   printf("Max Locked Pages    : %10d Pages\n", meminfo.maximum_locked_page_allocation_in_pages );
   printf("Linear Add. Space   : %10d Pages\n", meminfo.linear_address_space_size_in_pages );
   printf("Nb Unlocked Pages   : %10d Pages\n", meminfo.total_number_of_unlocked_pages );
   printf("Nb Free Pages       : %10d Pages\n", meminfo.total_number_of_free_pages );
   printf("Nb Physical Pages   : %10d Pages\n", meminfo.total_number_of_physical_pages );
   printf("Free Lin.add. space : %10d Pages\n", meminfo.free_linear_address_space_in_pages );
   printf("Paging File size    : %10d Pages\n", meminfo.size_of_paging_file_partition_in_pages );

   printf("Physical Memory    : %10d Bytes\n",
      _go32_dpmi_remaining_physical_memory()  );
   printf("Virtual Memory     : %12d Bytes\n",
      _go32_dpmi_remaining_virtual_memory()  );
   printf("sbrk(0)            : %10d ??\n",
      sbrk(0) );
      

   while ( kbhit() == 0 );*/

   if ( param_code == Init_PARAM_SETUP )
   {
      init_status = init_setup ();
      if ( init_status == INIT_SUCCESS )
         setup_main();
      exit_setup();
   }
   else
     if ( param_code == Init_PARAM_EDITOR )
     {
//        Editor *edit = new Editor;
        init_status = init_editor ();
        if ( init_status == INIT_SUCCESS );
        {
//           editor.load_maz_file ("map000.maz");
           editor.start();
//           editor.save_maz_file ( "map000.maz" );
      //?? to do , more complex logic for maze testing
        }

        exit_editor();
//        delete edit;
     }
   else
   {
//      maze = new Maze;
      init_status = init_game ();

      music_selected = rnd ( 2 );

      if ( init_status == INIT_SUCCESS )
      {
         show_copyright_screen ();

         while ( title_value != SCREEN_TITLE_END_GAME )
         {
            if ( title_value != SCREEN_TITLE_OPTION )
               if ( music_selected == 1 )
                  play_music_track ( System_MUSIC_w1intro );
               else
                  play_music_track ( System_MUSIC_w3intro );

            title_value = show_title_screen ();

            switch ( title_value )
            {
               case SCREEN_TITLE_OPTION :
                  config.start();
               break;

               case SCREEN_TITLE_GALLERY :
                  show_art_gallery ();
               break;

               case SCREEN_TITLE_START :

                  manager_value = Manager_CONTINUE;

                  while ( manager_value != Manager_EXIT )
                  {
                     manager_value = manager.start();
                     
                     if ( manager_value == Manager_LOGIN )
                     {
                        account_value = Account_CONTINUE;

                        while ( account_value != Account_EXIT )
                        {
                           tmpacc.DBselect ( manager.account_logged() );
                           account_value = tmpacc.start();

                           if ( account_value == Account_JOIN )
                           {
                              player_value = Player_CONTINUE;

                              while ( player_value != Player_EXIT )
                              {
                                 tmplayer.DBselect ( tmpacc.selected_player() );
                                 player_value = tmplayer.start();

                                 if ( player_value == Player_START_GAME )
                                 {
//                                    party.DBselect ( tmplayer.selected_party() );
                                    city_value = City_CONTINUE;

                                    while ( city_value != City_END_GAME )
                                    {
                                       party.DBselect ( tmplayer.selected_party() );                                    
                                       if ( party.status() == Party_STATUS_CITY )
                                       {
                                          city.DBselect ( party.location() );
                                          city_value = city.start ( party.tag() );
//                                          debug ( "Exit city if");
                                       }
                                       party.DBselect ( tmplayer.selected_party() );

/*                                       // warp to another City
                                       if ( party.status() == Party_STATUS_CITY
                                          && city_value == City_WARP_TO_CITY )
                                       {
                                          debug ( "Enter Warp to city if");
                                          party.DBselect ( tmplayer.selected_party() );
                                          city_value = City_CONTINUE;
                                       }*/

                                       // warp to maze
                                       if ( party.status() == Party_STATUS_MAZE )
                                       {
//                                          party.status ( Party_STATUS_MAZE );
//                                          party.DBupdate();
//                                          debug ( "Enter warp to maze if" );
                                          maze.DBselect ( party.location() );
                                          maze_value = Maze_CONTINUE;
                                          maze.load();
                                          if ( city_value == City_WARP_TO_MAZE )
                                             party.position ( maze.start_position() );
                                          s_Party_position tmpos = party.position ();

                                          encount.clear_list();
                                          encount.build_list ( maze.ebase(), maze.erange() );
                                          encount.probability ( maze.eprob() );

                                          while ( maze_value != Maze_EXIT )
                                          {
                                             maze_value = maze.start( party.tag() );

                                             if ( maze_value == Maze_CAMP )
                                             {
                                                camp_value = camp.start( party.tag() );
                                                if ( camp_value == Camp_QUITPARTY )
                                                {
                                                   maze_value = Maze_EXIT;
                                                   city_value = City_END_GAME;
                                                }
                                             }
                                             if ( maze_value >= Maze_1ST_EXIT &&
                                                maze_value <= Maze_8TH_EXIT )
                                             {
                                                party.location ( maze.exitwarptag ( maze_value ) );
                                                party.status ( Party_STATUS_CITY );
                                                party.DBupdate();
                                                city_value = City_WARP_TO_CITY;
                                                maze_value = Maze_EXIT;
                                             }
                                             if ( maze_value == Maze_COMBAT )
                                             {
                                                encount_value = encount.start( party.tag() );

                                                if ( encount_value == Encounter_ENGAGE )
                                                {
                                                   combat.add_character_party ( party.tag() );
                                                   combat.add_ennemy_party ( encount.get_ennemy_party() );

                                                   combat_value = combat.start();

                                                   if ( combat_value == Combat_DEFEATED )
                                                   {
                                                      maze_value = Maze_EXIT;
                                                      city_value = City_END_GAME;
//                                                      tmplayer.disband_party ( tmplayer.selected_partyID() );

                                                   }

                                                   encount.clear_objects();
                                                   encount.clear_selection();
                                                }

                                                //?? combat add parties and call start
                                                
                                                // to change = set value according to encounter
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               break;
            }
         }
      }
      exit_game ();
//      delete maze;
   }

   return ( 0 );
}
END_OF_MAIN()


// conversion note to do :
// - backup video memory for windows ( maybe copy buffer create a backup )
//   or create a copy backuped buffer function
