/***************************************************************************/
/*                                                                         */
/*                            I N I T . C P P                              */
/*                                                                         */
/*     Content : Initialisation procedures                                 */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : march 19, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <allegro.h>
#include <stdio.h>
//#include <stdlib.h>
#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
#include <init.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>


/*-------------------------------------------------------------------------*/
/*-                             Procedures                                -*/
/*-------------------------------------------------------------------------*/

tiny decode_parameter ( tiny nb_param, char *param[] )
{
   if ( nb_param > 1 )
      if ( strcmp ( param [ 1 ] , "-setup" ) == 0 )
         return ( Init_PARAM_SETUP );
      else
         if ( strcmp ( param [ 1 ] , "-editor" ) == 0 )
            return ( Init_PARAM_EDITOR );

   return ( Init_PARAM_NONE );
}

tiny init_setup ( void )
{
   tiny status = INIT_SUCCESS;
   tiny value;

   printf ("|--------------------------------------|\r\n");
   printf ("|        Wizardry legacy %s         |\r\n", VERSION );
   printf ("|            Setup Utility             |\r\n" );
   printf ("|--------------------------------------|\r\n\r\n");

   printf ("Initialising %s ", allegro_id);
   set_uformat ( U_ASCII );   
   value = allegro_init ();
   if ( value != 0 )
   {
      status = INIT_FAILURE;
      printf ("[ Failure ]\r\n");
   }
   else
      printf ("[ Success ]\r\n");

   if ( status == INIT_SUCCESS )
      printf ("- Running Platform : %s \r\n", ALLEGRO_PLATFORM_STR );

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Keyboard      ");
      value = init_keyboard ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Timer         ");
      value = init_timer ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Mouse         ");
      value = install_mouse ();
      if ( value == -1 )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }



   if ( status == INIT_SUCCESS )
   {
      printf ("Initialising Graphic Mode");
      set_color_depth ( 8 );
      value = set_gfx_mode(GFX_SAFE, 640, 480, 0, 0);
      if ( value == -1 )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   return ( status );
}

tiny init_game ( void )
{
   tiny status = INIT_SUCCESS;
   tiny value;
//   tiny i;

   printf ("|--------------------------------------|\r\n");
   printf ("|        Wizardry legacy %s         |\r\n", VERSION );
   printf ("|--------------------------------------|\r\n\r\n");

   printf ("Initialising %s ", allegro_id);
   set_uformat ( U_ASCII );
   value = allegro_init ();
   if ( value != 0 )
   {
      status = INIT_FAILURE;
      printf ("[ Failure ]\r\n");
   }
   else
      printf ("[ Success ]\r\n");

   if ( status == INIT_SUCCESS )
   {

      printf ("- Running Platform : %s \r\n", ALLEGRO_PLATFORM_STR );
/*      for ( i = 0 ; i < Allegro_NB_OPERATING_SYSTEM ; i++ )
         if ( os_type == OS_NAME [ i ].ID )
            value = i;
      printf ("- Detected Operating System : %s %d.%d\r\n",
         OS_NAME [ i ].name, os_version, os_revision );

      value = -1;
      for ( i = 0 ; i < Allegro_NB_CPU_FAMILY ; i++ )
         if ( cpu_family == CPU_FAMILY [ i ].ID )
            value = i;
      if ( value == -1 )
         value = Allegro_NB_CPU_FAMILY; // unknown type : last one
      printf ("- Detected CPU : %s\r\n",
         CPU_FAMILY [ i ].name  );*/
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Keyboard      ");
      value = init_keyboard ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Timer         ");
      value = init_timer ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }


   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Sound Driver  ");
      value = init_sound ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
/*         for ( i = 0 ; i < 120; i++ )
            if ( strcmp ( &allegro_error [ i ], "" ) != 0 )
               printf ("- %s\r\n",allegro_error [ i ] );*/
      }
      else
         printf ("[ Success ]\r\n");
   }

   init_other ();

   if ( status == INIT_SUCCESS )
   {
      printf ("Initialising Graphic Mode");
      value = init_graphic ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
/*         for ( i = 0 ; i < 120; i++ )
            if ( strcmp ( &allegro_error [ i ], "" ) != 0 )
               printf ("- %s\r\n",allegro_error [ i ] );*/
      }
      else
         printf ("[ Success ]\r\n");
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Loading Data             ");
      value = init_data ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   return ( status );
}

tiny init_editor ( void )
{
   tiny status = INIT_SUCCESS;
   tiny value;
//   tiny i;

   printf ("|--------------------------------------|\r\n");
   printf ("|        Wizardry legacy %s         |\r\n", VERSION );
   printf ("|             Maze Editor              |\r\n" );
   printf ("|--------------------------------------|\r\n\r\n");

   printf ("Initialising %s ", allegro_id);
   set_uformat ( U_ASCII );
   value = allegro_init ();
   if ( value != 0 )
   {
      status = INIT_FAILURE;
      printf ("[ Failure ]\r\n");
   }
   else
      printf ("[ Success ]\r\n");

   if ( status == INIT_SUCCESS )
   {

      printf ("- Running Platform : %s \r\n", ALLEGRO_PLATFORM_STR );
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Installing Keyboard      ");
      value = init_keyboard ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

   if ( status == INIT_SUCCESS )
   {
      printf ("Initialising Graphic Mode");
      value = init_graphic ();
      if ( value != INIT_SUCCESS )
      {
         status = INIT_FAILURE;
         printf ("[ Failure ]\r\n");
      }
      else
         printf ("[ Success ]\r\n");
   }

      printf ("Loading Data             ");

   clear ( screen );

   textout_centre ( screen, font,
      "Welcome to the Wizardry Maze Editor",
      320, 230, General_COLOR_TEXT );
   textout_centre ( screen, font,
      "This editor will make .maz file that can be imported into the adventure file",
      320, 250, General_COLOR_TEXT );

   textprintf_centre ( screen, font, 320, 360, General_COLOR_TEXT,
      "Wizardry Legacy  v%s  %s", VERSION, YEAR );

   rect ( screen, 218, 398, 421, 416, General_COLOR_TEXT );

   text_mode ( 0 );

   textout_centre ( screen, font,
      "  Loading Maze Textures  ", 320, 460, General_COLOR_TEXT );
   datfmaze = load_datafile_callback ("datafile//mazetex.dat", 
InitProc_datafile_editor_loading);

   textout_centre ( screen, font,
      "      Loading fonts      ", 320, 460, General_COLOR_TEXT );
   datffont = load_datafile_callback ("datafile//font.dat", 
InitProc_datafile_editor_loading);

   textout_centre ( screen, font,
      "  Loading Editor Images  ", 320, 460, General_COLOR_TEXT );
   datfeditor = load_datafile_callback ("datafile//editor.dat", 
InitProc_datafile_editor_loading);

   text_mode ( -1 );
   if ( datfmaze == NULL || datfimage == NULL || datfaudio == NULL )
      return ( INIT_FAILURE );


   clear ( buffer );

//   maze.reference_bitmap ();

   config.load();
   config.initialise ();

//   load_database ();

//   return ( INIT_SUCCESS );


   return ( status );
}


tiny init_keyboard ( void )
{
   tiny value;

   value = install_keyboard ();
   if ( value != 0 )
      return ( INIT_FAILURE );
   else
      return ( INIT_SUCCESS );
}

tiny init_timer ( void )
{
   tiny value;

   value = install_timer ();
   if ( value != 0 )
      return ( INIT_FAILURE );
   else
      return ( INIT_SUCCESS );
}


tiny init_sound ( void )
{
   tiny value;
   
   value = install_sound ( DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

   if ( value != 0 )
      return ( INIT_FAILURE );
   else
      return ( INIT_SUCCESS );

}

tiny init_other ( void )
{

   #ifndef ALLEGRO_WINDOWS
      srandom ( time(NULL) );   
   #else
      srand ( time(NULL) );
   #endif
      
//   #if ALLEGRO_PLATFORM_STR == ALLEGRO_WINDOWS
//   #if VAR == ALLO
//   #endif   


   return ( INIT_SUCCESS );
}

tiny init_graphic ( void )
{
   tiny value;

   set_color_depth ( 16 );
   set_projection_viewport ( 0 , 0 , 640 , 480 );
   set_trans_blender( 0, 0, 0, 255 );
   text_mode ( -1 );

   buffer = create_bitmap ( 640,480 );
   backup = create_bitmap ( 640,480 );
   if ( buffer == NULL )
      return ( INIT_FAILURE );
   clear ( buffer );
   
   value = set_gfx_mode ( GFX_AUTODETECT, 640, 480, 0, 0 );
   if ( value != 0 )
      return ( INIT_FAILURE );
   else
      return ( INIT_SUCCESS );
}

tiny init_data ( void )
{

//   DATAFILE *tmpfnt2;
//   DATAFILE *tmpfnt;

//   tmpfnt2 = load_datafile_object ("wizardry.dat", "FNT_SCRIPT" );
//   tmpfnt = load_datafile_object ("wizardry.dat", "FNT_STYLE" );

//   if ( tmpfnt2 == NULL || tmpfnt == NULL )
//      return ( INIT_FAILURE );

      
//   textout_centre ( buffer, (FONT*) tmpfnt->dat, "Loading", 320, 250,
//                                                   General_COLOR_TEXT );

   clear ( screen );

   textout_centre ( screen, font,
      "Prepare yourself for the ultimate fantasy game!",
      320, 230, General_COLOR_TEXT );

   textprintf_centre ( screen, font, 320, 360, General_COLOR_TEXT,
      "Wizardry Legacy  v%s  %s", VERSION, YEAR );



   rect ( screen, 218, 398, 421, 416, General_COLOR_TEXT );

   text_mode ( 0 );

   textout_centre ( screen, font,
      "  Loading Maze Textures  ", 320, 460, General_COLOR_TEXT );
   datfmaze = load_datafile_callback ("datafile//mazetex.dat", 
InitProc_datafile_loading);

   textout_centre ( screen, font,
      " Loading Ennemy Pictures ", 320, 460, General_COLOR_TEXT );
   datfennemy = load_datafile_callback ("datafile//ennemy.dat", 
InitProc_datafile_loading);

   textout_centre ( screen, font,
      "  Loading Various Images ", 320, 460, General_COLOR_TEXT );
   datfimage = load_datafile_callback ("datafile//image.dat", 
InitProc_datafile_loading);

   textout_centre ( screen, font,
      "      Loading Fonts      ", 320, 460, General_COLOR_TEXT );
   datffont = load_datafile_callback ("datafile//font.dat", 
InitProc_datafile_loading);

   textout_centre ( screen, font,
      "   Loading Audio Files   ", 320, 460, General_COLOR_TEXT );
   datfaudio = load_datafile_callback ("datafile//audio.dat", 
InitProc_datafile_loading);

   textout_centre ( screen, font,
      "  Loading Editor Images  ", 320, 460, General_COLOR_TEXT );
   datfeditor = load_datafile_callback ("datafile//editor.dat", 
InitProc_datafile_editor_loading);

   text_mode ( -1 );
   if ( datfmaze == NULL || datfimage == NULL || datfaudio == NULL )
      return ( INIT_FAILURE );

   clear ( buffer );

//   textout_centre ( buffer, font, "Loading adventure : newadv.wza", 320, 200, General_COLOR_TEXT );

//   copy_buffer();
   
//   adatf = load_datafile ( "newadv.wza" );

   maze.reference_bitmap ();

   config.load();
   config.initialise ();

   load_database ();

   return ( INIT_SUCCESS );
}

void exit_game ( void )
{
   set_gfx_mode ( GFX_TEXT, 80, 25, 0, 0 );
   printf ("Shutting down Wizardry\r\n");
   printf ("- Saving Game Configuration\r\n");
   config.save();
   printf ("- Saving System Database\r\n");
   db.save_dba_file ( "system.dba", DBSOURCE_SYSTEM );
   printf ("- Unloading Datafiles\r\n");
   unload_datafile ( datfmaze );
   unload_datafile ( datfimage );
   unload_datafile ( datfaudio );
   printf ("- Shutting down Allegro\r\n");
   allegro_exit ();
}

void exit_setup ( void )
{
   set_gfx_mode ( GFX_TEXT, 80, 25, 0, 0 );
   printf ("Shutting down Wizardry Setup\r\n");
   printf ("- Shutting down Allegro\r\n");
   allegro_exit ();
}

void exit_editor ( void )
{
   set_gfx_mode ( GFX_TEXT, 80, 25, 0, 0 );
   printf ("Shutting down Wizardry Editor\r\n");
   printf ("- Shutting down Allegro\r\n");
   printf ("- Unloading Datafile\r\n");
//   unload_datafile ( datf );
   allegro_exit ();
}


void load_database ( void )
{
//   s_Weapon_file* tmpw;
//   s_Armor_file* tmpa;
   tiny i;

   DBObject::set_database ( db );

   for ( i = 0 ; i < System_NB_MUSIC ; i++ )
   {
      MUSIC_LIST [ i ] . music = ( MIDI* ) datfaudio [ MID_MUSIC000 + i ] . dat;
   }

   db.load_dba_file ("datafile//wizardry.dba", DBSOURCE_GAME );

   if ( exists ( "system.dba" ) != 0 )
      db.load_dba_file ( "system.dba", DBSOURCE_SYSTEM );
      
   db.default_source ( DBSOURCE_SYSTEM );

}

void InitProc_datafile_loading ( DATAFILE *f )
{
   static dword progress = 0;
   static word drawval = 0;
   static dword eval = 0;
   short max = ZZZ_END_OF_AUDIO + ZZZ_END_OF_MAZETEX + ZZZ_END_OF_IMAGE
      + ZZZ_END_OF_FONT + ZZZ_END_OF_ENNEMY + ZZZ_END_OF_EDITOR;

   progress++;
   eval = ( progress * 200 ) / max;
   if ( eval > drawval )
   {
      drawval = eval;
      rectfill ( screen, 219, 399, 219 + drawval, 415, makecol ( 225, 175, 0 ) );
   }

  
}

void InitProc_datafile_editor_loading ( DATAFILE *f )
{
   static dword progress = 0;
   static word drawval = 0;
   static dword eval = 0;
   short max = ZZZ_END_OF_MAZETEX + ZZZ_END_OF_FONT + ZZZ_END_OF_EDITOR;

   //?? note: image is loaded because it contains fonts
   progress++;
   eval = ( progress * 200 ) / max;
   if ( eval > drawval )
   {
      drawval = eval;
      rectfill ( screen, 219, 399, 219 + drawval, 415, makecol ( 225, 175, 0 ) );
   }

  
}


/*
Done! extern char allegro_id[];

Done! extern char allegro_error[ALLEGRO_ERROR_SIZE];

Done! extern int os_type;

Done! extern int os_version;
Done! extern int os_revision;

Done! extern int cpu_family;

??? not sure
void allegro_message(char *msg, ...);
   Outputs a message, using a printf() format string. This function must 
   only be used when you aren't in graphics mode, eg. before calling 
   set_gfx_mode(), or after a set_gfx_mode(GFX_TEXT). On platforms that have 
   a text mode console (DOS, Unix and BeOS) it will print the string to the 
   console, attempting to work around codepage differences by reducing any 
   accented characters to 7 bit ASCII approximations, or under Windows it 
   will bring up a GUI message box.

??? not sure
extern int cpu_model;
   Contains the Intel CPU submodel, where applicable. On a 486 
   (cpu_family=4), zero or one indicates a DX chip, 2 an SX, 3 a 487 (SX) or 
   486 DX, 4 an SL, 5 an SX2, 7 a DX2 write-back enhanced, 8 a DX4 or DX4 
   overdrive, 14 a Cyrix, and 15 is unknown. On a Pentium chip 
   (cpu_family=5), 1 indicates a Pentium (510\66, 567\66), 2 is a Pentium 
   P54C, 3 is a Pentium overdrive processor, 5 is a Pentium overdrive for 
   IntelDX4, 14 is a Cyrix, and 15 is unknown.

ALLEGRO_PLATFORM_STR
   text string
*/



