/***************************************************************************/
/*                                                                         */
/*                        G E N E R A L . C P P                            */
/*                                                                         */
/*     Content : Unclassified procedures                                   */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 19, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>

#include <string.h>
#include <datafile.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                       General Procedures                              -*/
/*-------------------------------------------------------------------------*/

void textinput ( short x, short y, char *str, tiny nb_char )

{
   char *input_string;
   tiny i = 0;
   int tmpkey;
   int tmpcode = KEY_ESC;
   int tmpascii;

   text_mode ( 0 );

   input_string = (char*) malloc ( nb_char + 3 );

   strncpy( input_string, "                                                                                                                                ",
      nb_char + 1 );
   input_string [ nb_char + 1 ] = '\0';
   textout ( buffer, General_FONT_INPUT, input_string, x, y,
      General_COLOR_TEXT );

   strcpy ( input_string, "_ \0" );

   textout ( buffer, General_FONT_INPUT, input_string, x, y,
      General_COLOR_TEXT );

   vsync();
   blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );

   while ( tmpcode != KEY_ENTER )
   {
      tmpkey = readkey();
      tmpcode = tmpkey >> 8;
      tmpascii = tmpkey & 0xff;

      if ( tmpcode != KEY_ENTER )
      {
      
         if ( tmpcode == KEY_BACKSPACE && i > 0 )
            i--;
         else
            if ( i < nb_char && tmpcode != KEY_BACKSPACE )
            {
               if ( tmpascii != 0/* && tmpcode != KEY_BACKSPACE*/ )
               {
                  input_string [ i ] = tmpascii;
                  i++;
               }
               else
                  clear_keybuf();
            }
         
         if ( i >= nb_char )
         {
            input_string [ i ] = ' ';
            input_string [ i + 1 ] = '\0';
         }
         else
         {
            input_string [ i ] = '_';
            input_string [ i + 1 ] = ' ';
            input_string [ i + 2 ] = '\0';
         }

      textout ( buffer, General_FONT_INPUT, input_string, x, y,
         General_COLOR_TEXT );

      vsync();
      blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );
      
      }
   }

   input_string [ i ] = '\0';

   clear ( buffer );

   strcpy ( str,input_string );
   text_mode ( -1 );
   free ( input_string );
//   return ( input_string );
}

void save_backup_screen ( void )
{
   blit ( screen, backup, 0, 0, 0, 0, 640, 480 );
}

void load_backup_screen ( void )
{
   blit ( backup, buffer, 0, 0, 0, 0, 640, 480 );
}

void save_backup_buffer ( void )
{
   blit ( buffer, backup, 0, 0, 0, 0, 640, 480 );
}

void load_backup_buffer ( void )
{
   blit ( backup, buffer, 0, 0, 0, 0, 640, 480 );
}

void copy_buffer ( void )
{
   vsync ();
   blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );
   clear( buffer );
}

void make_screen_shot ( char *filename )
{

   BITMAP *scrnshot;
   PALETTE pal;

   scrnshot = create_bitmap ( 640, 480 );

   blit ( screen, scrnshot, 0, 0, 0, 0, 640, 480 );
   get_palette ( pal );
   
   
   save_bitmap (filename, scrnshot, pal );

   destroy_bitmap ( scrnshot );
}


void play_music_track ( tiny track, bool loop )
{
   if ( loop == true )
      play_midi ( MUSIC_LIST [ track ] . music, 1 );
   else
      play_midi ( MUSIC_LIST [ track ] . music, 0 );
}

word hdice ( word maxvalue )
{
   word rest;
   word roll;

   rest = maxvalue - ( maxvalue / 2 );
   roll = rnd ( maxvalue / 2 );

   return ( rest + roll );
}

word dice ( word maxvalue )
{
   if ( maxvalue > 0 )
      return ( rnd ( maxvalue ) );
   else
      return ( 0 );
}

word rngdice ( word minvalue, word maxvalue )
{
   word range;

   range = maxvalue - minvalue;

   return ( rnd ( range ) + minvalue );
}

void debug ( const char *str, int var1, int var2 )
{
   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT, str, var1, var2 );
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );
}
/*
word statdice ( s_Opponent_rollstat rollstat )
{
   word min = rollstat.min;
   word max = rollstat.max + rollstat.modifier;
   word value = 1;

   if ( max < min )
      max = min;

   if ( max > min )
      value = rnd ( max - min );

   return ( min + value + rollstat.bonus );
      
} */


/*
void flist_proc ( const char *name, int attribute, int param )
{
   strncpy ( filelist [ flistindex ], name, 12 );
   flistindex++;

   textprintf ( buffer, font, 10, 10, General_COLOR_TEXT,
      "name : %s | attribute : %d | param : %d",
      name, attribute, param );

   textprintf ( buffer, font, 10, 30, General_COLOR_TEXT,
      "%d : %s", flistindex - 1, filelist [ flistindex - 1 ] );
      
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );
} */

/*
double exponent ( float x, float y )
{
   double result;

   
} */




