/***************************************************************************/
/*                                                                         */
/*                            D R A W . C P P                              */
/*                           Module Source code                            */
/*                                                                         */
/*     Content : common drawing procedures                                 */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting date : May 21st, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
//#include <string.h>
#include <datafile.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
//#include <list.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
#include <camp.h>
#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                        Drawing procedures                             -*/
/*-------------------------------------------------------------------------*/
/*
void draw_border ( short x1, short y1, short x2, short y2, int color )
{
   int tmpcol [ 5 ];
   tiny i;
   tiny j;
   tiny k;
   tiny diff;
   short basex [ 4 ];
   short basey [ 4 ];

   tmpcol [ 0 ] = color - ( 5285 * 2 );
   tmpcol [ 1 ] = color - 5285;
   tmpcol [ 2 ] = color;
   tmpcol [ 3 ] = color - 5285;
   tmpcol [ 4 ] = color - ( 5285 * 2 );

   basex [ 0 ] = x1;
   basey [ 0 ] = y1;
   basex [ 1 ] = x2 - 4;
   basey [ 1 ] = y1;
   basex [ 2 ] = x1;
   basey [ 2 ] = y2 - 4;
   basex [ 3 ] = x2 - 4;
   basey [ 3 ] = y2 - 4;

   for ( k = 0 ; k < 4 ; k++ )
      for ( j = 0 ; j < 5 ; j++ )
         for ( i = 0 ; i < 5 ; i++ )
         {
            if ( BORDER_CORNER [ k ] [ j ] [ i ] != 5 )
               putpixel ( buffer, basex [ k ] + i , basey [ k ] + j,
                  tmpcol [ BORDER_CORNER [ k ] [ j ] [ i ] ] );
         }

   putpixel ( buffer, basex [ 0 ] + 5 , basey [ 0 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 1 ] - 1, basey [ 1 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 2 ] + 5 , basey [ 2 ] - 1, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 3 ] - 1, basey [ 3 ] - 1, tmpcol [ 4 ] );

   diff = 5;
   for ( i = 0 ; i < 5 ; i++ )
   {
//      rect( buffer, x1, y1, x2, y2, tmpcol [ i ] );
      vline ( buffer, x1 , y1 + diff, y2 - diff, tmpcol [ i ] );
      vline ( buffer, x2 , y1 + diff, y2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y1, x2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y2, x2 - diff, tmpcol [ i ] );
      x1++;
      y1++;
      x2--;
      y2--;
      diff--;
   }

} */
/*
void draw_border_fill ( short x1, short y1, short x2, short y2, int color, int fill )

{
   int tmpcol [ 5 ];
   tiny i;
   tiny j;
   tiny k;
   tiny diff;
   short basex [ 4 ];
   short basey [ 4 ];

   tmpcol [ 0 ] = color - ( 5285 * 2 );
   tmpcol [ 1 ] = color - 5285;
   tmpcol [ 2 ] = color;
   tmpcol [ 3 ] = color - 5285;
   tmpcol [ 4 ] = color - ( 5285 * 2 );

   basex [ 0 ] = x1;
   basey [ 0 ] = y1;
   basex [ 1 ] = x2 - 4;
   basey [ 1 ] = y1;
   basex [ 2 ] = x1;
   basey [ 2 ] = y2 - 4;
   basex [ 3 ] = x2 - 4;
   basey [ 3 ] = y2 - 4;

   rectfill ( buffer, x1 + 5, y1 + 5, x2 - 5, y2 - 5, fill );

   for ( k = 0 ; k < 4 ; k++ )
      for ( j = 0 ; j < 5 ; j++ )
         for ( i = 0 ; i < 5 ; i++ )
         {
            if ( BORDER_CORNER [ k ] [ j ] [ i ] != 5 )
               putpixel ( buffer, basex [ k ] + i , basey [ k ] + j,
                  tmpcol [ BORDER_CORNER [ k ] [ j ] [ i ] ] );
         }

   putpixel ( buffer, basex [ 0 ] + 5 , basey [ 0 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 1 ] - 1, basey [ 1 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 2 ] + 5 , basey [ 2 ] - 1, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 3 ] - 1, basey [ 3 ] - 1, tmpcol [ 4 ] );

   diff = 5;
   for ( i = 0 ; i < 5 ; i++ )
   {
      vline ( buffer, x1 , y1 + diff, y2 - diff, tmpcol [ i ] );
      vline ( buffer, x2 , y1 + diff, y2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y1, x2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y2, x2 - diff, tmpcol [ i ] );
      x1++;
      y1++;
      x2--;
      y2--;
      diff--;
   }

} */
/*
void draw_instruction ( const char *str, short x, short y )
{
   if ( config.get ( Config_KEY_DISPLAY ) == Config_KEY_YES )
   {
      text_mode ( -1 );
      textout_centre ( buffer, General_FONT_INSTRUCTION, str, x, y
                                               , General_COLOR_INSTRUCTION );
      text_mode ( 0 );
   }
} */
/*
void draw_instruction ( byte instID, short x, short y )
{
   string str;

   if ( config.get ( Config_KEY_DISPLAY ) == Config_KEY_YES )
   {
      text_mode ( -1 );

      if ( ( instID & Draw_INSTRUCTION_SELECT ) > 0 )
      {
         str += "[ ";
         switch ( SELECT_KEY )
         {
            case KEY_Z :
               str += "Z";
            break;
            case KEY_W :
               str += "W";
            break;
            case KEY_X :
               str += "X";
            break;
         }
         str += " : Select ]";
      }
      if ( ( instID & Draw_INSTRUCTION_CANCEL ) > 0 )
      {
         str += "[ ";
         switch ( CANCEL_KEY )
         {
            case KEY_A :
               str += "A";
            break;
            case KEY_Q :
               str += "Q";
            break;
            case KEY_Z :
               str += "Z";
            break;
         }
         str += " : Cancel ]";
      }
      if ( ( instID & Draw_INSTRUCTION_DISPLAY ) > 0 )
         str += "[ Enter : Display ]";
      if ( ( instID & Draw_INSTRUCTION_MENU ) > 0 )
         str += "[ Up/Dn : Cursor ]";
      if ( ( instID & Draw_INSTRUCTION_SWITCH ) > 0 )
         str += "[ Lft/Rgt : Switch ]";
      if ( ( instID & Draw_INSTRUCTION_MOVE ) > 0 )
         str += "[ Up/Lft/Rgt : Move ]";
      if ( ( instID & Draw_INSTRUCTION_INPUT ) > 0 )
         str += "[ Enter : Accept ]";
      if ( ( instID & Draw_INSTRUCTION_CAMP ) > 0 )
      {
         str += "[ ";
         switch ( CANCEL_KEY )
         {
            case KEY_A :
               str += "A";
            break;
            case KEY_Q :
               str += "Q";
            break;
            case KEY_Z :
               str += "Z";
            break;
         }
         str += " : Camp ]";
      }
         

      textout_centre ( buffer, General_FONT_INSTRUCTION, str.data(), x, y
                                               , General_COLOR_INSTRUCTION );
      text_mode ( 0 );      
   }
} */

/*
void draw_party_bar ( Party &party )
{
   Party &player_party = party;
   short height = 25;
   tiny font_height = text_height ( General_FONT_PARTY );
   tiny font_width = text_length ( General_FONT_PARTY, "a" );
   short ystart;
//   Character tmpcharacter;
   tiny i;
   tiny nb_character;
   string tmpstr;

   nb_character = player_party.nb_character();
   height = height + ( nb_character * font_height );
   draw_border_fill ( 0, 480 - height , 639 , 479,
      General_COLOR_BORDER, General_COLOR_FILL );

   ystart = 480 - height + 6 + 14;

   textout ( buffer, General_FONT_INSTRUCTION,
      "      Name               Sex Alig Level Hit Point Spell Point Status",
      7, ystart - 14, General_COLOR_TEXT );

   for ( i = 0 ; i < nb_character ; i++ )
   {
      Character &tmpcharacter = player_party.character ( i );

      tmpstr = tmpcharacter.statusS();

      if ( tmpcharacter.status() == Character_STATUS_ALIVE )
         tmpstr = "";

      textprintf ( buffer, General_FONT_PARTY, 7, ystart
         , General_COLOR_TEXT, "    %-15s %1s %2s  %2d  %3d/%3d %3d/%3d %s",
          tmpcharacter.cname(), tmpcharacter.csexC(),
          tmpcharacter.caligmentC(), tmpcharacter.level(),
          tmpcharacter.current_HP (), tmpcharacter.max_HP(),
          tmpcharacter.current_SP(), tmpcharacter.max_SP(),
          //( const char* )
          tmpstr.data() );
          
      if ( tmpcharacter.status() == Character_STATUS_ALIVE )
      {
         draw_health_status ( tmpcharacter.healthS()
                                          , ( font_width * 47 ) + 6, ystart );
      }

      ystart = ystart + font_height;
   }
}                        */

void draw_party_spell ( Party &party )
{
  short y = 0;

  if ( party.spell_duration ( Party_SPELL_LIGHT ) > 0 )
  {
     draw_sprite( buffer, BMP_icn_light , 0, y);
     y = y + 32;
  }

  if ( party.spell_duration ( Party_SPELL_PROTECT ) > 0 )
  {
     draw_sprite( buffer, BMP_icn_protect , 0, y);
     y = y + 32;
  }
  
  if ( party.spell_duration ( Party_SPELL_LEVITATE ) > 0 )
  {
     draw_sprite( buffer, BMP_icn_levitate , 0, y);
     y = y + 32;
  }

  if ( party.spell_duration ( Party_SPELL_IDENTIFY ) > 0 )
  {
     draw_sprite( buffer, BMP_icn_identify , 0, y);
     y = y + 32;
  }

  if ( party.spell_duration ( Party_SPELL_FEAR ) > 0 )
  {
     textout( buffer, FNT_print, "Fear", 0, y, General_COLOR_TEXT);
     y = y + 32;
  }

  if ( party.spell_duration ( Party_SPELL_WATER_BREATH ) > 0 )
  {
     draw_sprite( buffer, BMP_icn_water_breath , 0, y);
     y = y + 32;
  }

}

/*
void draw_party_list ( void )
{
   tiny nb_party = player.nb_party ();
   tiny nb_character;
   tiny i;
   tiny j;
   short x = 30;
   short y = 100;
   Party tmpparty;
   short height = text_height ( General_FONT_PARTY );

//   Character tmpcharacter;

   draw_border ( 0 , 0 , 639, 479, General_COLOR_BORDER );

   for ( j = 0 ; j < nb_party ; j++ )
   {
      tmpparty = player.party ( j );

      y = 88 + ( ( ( height * 7 ) + 16 ) * j );

      textout ( buffer, General_FONT_PARTY, "<<Party Location>>", x, y,
         General_COLOR_TEXT );


      textout ( buffer, General_FONT_INSTRUCTION,
         "Name                Family               Sex Alig Race          Level  Status    ",
         x + 16, y + height, General_COLOR_TEXT );

      y = y + 14;

      nb_character = tmpparty.nb_character ();
      for ( i = 0 ; i < nb_character ; i++ )
      {
         Character &tmpcharacter = tmpparty.character ( i );

         y = y + height;
         textprintf ( buffer, General_FONT_PARTY, x + 16, y,
            General_COLOR_TEXT, "%-15s %-15s %1s %2s %-10s Lv%d %-7s",
            tmpcharacter.cname(), tmpcharacter.cfamily(),
            tmpcharacter.csexC(), tmpcharacter.caligmentC(),
            tmpcharacter.craceS(), tmpcharacter.level(),
            tmpcharacter.cstatusS() );
      }
   }

   draw_instruction (Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT +
      Draw_INSTRUCTION_CANCEL, 320, 460 );
} */

void draw_health_status ( s_Opponent_hstr hstr, short x, short y )
{
   char tmpstr[2] = {' ','\0'};
   tiny i;
   short tmpx = x;
   short width = text_length ( General_FONT_PARTY, "a" );

   for ( i = 0 ; i < 16 ; i++ )
   {
      tmpstr[0] = hstr.character [ i ] .letter;
      textout ( buffer, General_FONT_PARTY, tmpstr, tmpx, y,
         hstr.character [ i ] .color );
      tmpx = tmpx + width;
   }

}
/*
void draw_character ( Character &character )
{
   tiny i;
   Weapon* tmpw;
   Shield* tmps;
   Armor* tmpm;
   Accessory* tmpa;
   Item* ritem;

   draw_border ( 0 , 0 , 639 , 479, General_COLOR_BORDER );

   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 10, General_COLOR_TEXT,
      "%s of %s from %s", character.cname(), character.cfamily(),
         character.chomeland() );

   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 26, General_COLOR_TEXT,
      "%s %s %s", character.caligmentS(), character.csexS(), character.craceS() );

   //to do add rank to the right

   textout ( buffer, Camp_FONT_INSTRUCTION, "Attribute", 58, 42, General_COLOR_TEXT );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 58, General_COLOR_TEXT,
      "Strength     %d", character.attribute ( 0 ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 74, General_COLOR_TEXT,
      "Dexterity    %d", character.attribute ( 1 ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 90, General_COLOR_TEXT,
      "Endurance    %d", character.attribute ( 2 ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 106, General_COLOR_TEXT,
      "Intelligence %d", character.attribute ( 3 ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 124, General_COLOR_TEXT,
      "Cunning      %d", character.attribute ( 4 ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 140, General_COLOR_TEXT,
      "Willpower    %d", character.attribute ( 5 ) );

   textout ( buffer, General_FONT_INSTRUCTION,
      "Inventory                Weight",
      34, 172, General_COLOR_TEXT );


   ritem = NULL;
   for ( i = 0 ; i < 10 ; i++ )
   {
      ritem = NULL;
      ritem = character.inventory ( i );
      if ( ritem != NULL )
         textprintf ( buffer, Camp_FONT_CHARACTER, 34, 188 + ( i * 16 )
            , General_COLOR_TEXT, "%-15s %2.2f Kg", ritem->cvname(),
            static_cast<float>( ritem->weight() ) );
   }

   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 432, General_COLOR_TEXT,
      "Weight      %3.2f Kg", ( float ) character.weight() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 34, 448, General_COLOR_TEXT,
      "Encumbrance %d\%%", character.encumbrance() );

// column 2

   textout ( buffer, Camp_FONT_INSTRUCTION, "Character", 242, 42, General_COLOR_TEXT );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 58, General_COLOR_TEXT,
      "Level       %d", character.level() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 74, General_COLOR_TEXT,
      "Soul        %d%%", character.soul() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 90, General_COLOR_TEXT,
      "Status      %s", character.cstatusS() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 106, General_COLOR_TEXT,
      "Exp Point   %d", character.exp() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 122, General_COLOR_TEXT,
      "Gold        %d", character.gold() );

   textout ( buffer, General_FONT_INSTRUCTION, "Skills                     Level",
      242, 154, General_COLOR_TEXT );

   textprintf ( buffer, General_FONT_PARTY, 242, 170, General_COLOR_TEXT,
      "*%-20s %d", (const char*)SKILL_INFO [ character.skillID(0) ] .name.data(),
      character.skill_level (0) );
   textprintf ( buffer, General_FONT_PARTY, 242, 186, General_COLOR_TEXT,
      " %-20s %d", (const char*)SKILL_INFO [ character.skillID(1) ] . name.data(),
      character.skill_level (1) );
   textprintf ( buffer, General_FONT_PARTY, 242, 202, General_COLOR_TEXT,
      " %-20s %d", (const char*)SKILL_INFO [ character.skillID(2) ] . name.data(),
      character.skill_level (2) );

   textout ( buffer, General_FONT_INSTRUCTION, "Equipment",
      242, 282, General_COLOR_TEXT );

   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 298, General_COLOR_TEXT,
      "Weapon A" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 314, General_COLOR_TEXT,
      "Weapon B" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 330, General_COLOR_TEXT,
      "Shield" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 346, General_COLOR_TEXT,
      "Armor" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 362, General_COLOR_TEXT,
      "Head" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 378, General_COLOR_TEXT,
      "Hands" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 394, General_COLOR_TEXT,
      "Feets" );
   textprintf ( buffer, Camp_FONT_CHARACTER, 242, 410, General_COLOR_TEXT,
      "Other" );

//   tmpw = character.weaponA();
//   if ( tmpw != NULL )
//      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 298, General_COLOR_TEXT,
//         "%-15s", tmpw->cvname() );
   tmpw = character.weaponB();
   if ( tmpw != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 314, General_COLOR_TEXT,
         "%-15s", tmpw->cvname() );
   tmps = character.shield() ;
   if ( tmps != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 330, General_COLOR_TEXT,
         "%-15s", tmps->cvname() );
   tmpm = character.armor();
   if ( tmpm != NULL )
   {
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 346, General_COLOR_TEXT,
         "%-15s", tmpm->cvname() );
//      textprintf ( buffer, Camp_FONT_CHARACTER, 450, 346, General_COLOR_TEXT,
//         "price : %d", tmpm->price() );
//      textprintf ( buffer, Camp_FONT_CHARACTER, 450, 330, General_COLOR_TEXT,
//         "cover : %d", tmpm->cover() );
   }
   tmpa = character.head();
   if ( tmpa != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 362, General_COLOR_TEXT,
         "%-15s", tmpa->cvname() );
   tmpa = character.hand();
   if ( tmpa != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 378, General_COLOR_TEXT,
         "%-15s", tmpa->cvname() );
   tmpa = character.feet();
   if ( tmpa != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 394, General_COLOR_TEXT,
         "%-15s", tmpa->cvname() );
   tmpa = character.other();
   if ( tmpa != NULL )
      textprintf ( buffer, Camp_FONT_CHARACTER, 314, 410, General_COLOR_TEXT,
         "%-15s", tmpa->cvname() );

// column 3

   textout ( buffer, Camp_FONT_INSTRUCTION, "Health", 450, 42, General_COLOR_TEXT );
   draw_health_status ( character.healthS(), 450, 58 );


   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 74, General_COLOR_TEXT,
      "Hit Point   %d/%d", character.current_HP(), character.max_HP() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 90, General_COLOR_TEXT,
      "Spell Point %d/%d", character.current_SP(), character.max_SP() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 106, General_COLOR_TEXT,
      "Life Point  %d\%%", character.life() );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 122, General_COLOR_TEXT,
      "Torso LP    %d/%d", character.current_LP ( Opponent_LOCATION_TORSO ),
                          character.max_LP ( Opponent_LOCATION_TORSO ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 138, General_COLOR_TEXT,
      "Head LP     %d/%d", character.current_LP ( Opponent_LOCATION_HEAD ),
                          character.max_LP ( Opponent_LOCATION_HEAD ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 154, General_COLOR_TEXT,
      "L. Arm LP   %d/%d", character.current_LP ( Opponent_LOCATION_LARM ),
                          character.max_LP ( Opponent_LOCATION_LARM ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 170, General_COLOR_TEXT,
      "R. Arm LP   %d/%d", character.current_LP ( Opponent_LOCATION_RARM ),
                          character.max_LP ( Opponent_LOCATION_RARM ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 186, General_COLOR_TEXT,
      "L. Leg LP   %d/%d", character.current_LP ( Opponent_LOCATION_LLEG ),
                          character.max_LP ( Opponent_LOCATION_LLEG ) );
   textprintf ( buffer, Camp_FONT_CHARACTER, 450, 202, General_COLOR_TEXT,
      "R. Leg LP   %d/%d", character.current_LP ( Opponent_LOCATION_RLEG ),
                          character.max_LP ( Opponent_LOCATION_RLEG ) );

   draw_instruction ( Draw_INSTRUCTION_SELECT, 550, 460 );

}
*/
/*
void draw_character_list ( bool mask_unavailable = false )
{
   short height = 24;
   tiny font_height = text_height ( General_FONT_PARTY );
   short ystart;
   tiny nb_character;
   tiny i;

//   Character tmpcharacter;
   int clr;

   nb_character = player.nb_character();
   height = height + ( ( nb_character + 1 ) * font_height )
   + ( font_height / 2 );
   draw_border_fill ( 0, 0 , 639 , height,
      General_COLOR_BORDER, General_COLOR_FILL );

   draw_instruction (Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT +
      Draw_INSTRUCTION_CANCEL, 320, 355 );

   textout ( buffer, General_FONT_INSTRUCTION,
      "     Name                 Family              Sex Alig Race          Level  Status    Location",
      10, 6 + font_height, General_COLOR_TEXT );

   ystart = 6 + 12 + font_height + ( font_height / 2 );

   for ( i = 0 ; i < nb_character ; i++ )
   {
      Character &tmpcharacter = player.character ( i );

      clr = General_COLOR_TEXT;
      if ( mask_unavailable == true &&
         tmpcharacter.available() != Character_AVAILABLE )
         clr = General_COLOR_DISABLE;

      textprintf ( buffer, General_FONT_PARTY, 7, ystart
         , clr, "    %-15s %-15s %1s %2s %-10s Lv%2d %-7s %-13s",
         tmpcharacter.cname(), tmpcharacter.cfamily(),
         tmpcharacter.csexC(), tmpcharacter.caligmentC(),
         tmpcharacter.craceS(), tmpcharacter.level(),
         tmpcharacter.cstatusS(), tmpcharacter.cavailableS() );

      ystart = ystart + font_height;
   }

} */

/*
void draw_new_character ( Character &character )
{
   draw_border ( 0, 0, 639, 479, General_COLOR_BORDER );

   textprintf ( buffer, General_FONT_PARTY, 400, 26, General_COLOR_TEXT,
      "Name :      %s", character.cname() );
   textprintf ( buffer, General_FONT_PARTY, 400, 42, General_COLOR_TEXT,
      "Family :    %s", character.cfamily() );
   textprintf ( buffer, General_FONT_PARTY, 400, 58, General_COLOR_TEXT,
      "Home land : %s", character.chomeland() );
   textprintf ( buffer, General_FONT_PARTY, 400, 74, General_COLOR_TEXT,
      "Sex :       %s", character.csexS() );
   textprintf ( buffer, General_FONT_PARTY, 400, 90, General_COLOR_TEXT,
      "Race :      %s", character.craceS() );
   textprintf ( buffer, General_FONT_PARTY, 400, 106, General_COLOR_TEXT,
      "Aligment :  %s", character.caligmentS() );

   textprintf ( buffer, General_FONT_PARTY, 400, 138, General_COLOR_TEXT,
      "Strength      %d", character.strength() );
   textprintf ( buffer, General_FONT_PARTY, 400, 154, General_COLOR_TEXT,
      "Dexterity     %d", character.dexterity() );
   textprintf ( buffer, General_FONT_PARTY, 400, 170, General_COLOR_TEXT,
      "Endurance     %d", character.endurance() );
   textprintf ( buffer, General_FONT_PARTY, 400, 186, General_COLOR_TEXT,
      "Intelligence  %d", character.intelligence() );
   textprintf ( buffer, General_FONT_PARTY, 400, 202, General_COLOR_TEXT,
      "Cunning       %d", character.cunning() );
   textprintf ( buffer, General_FONT_PARTY, 400, 218, General_COLOR_TEXT,
      "Willpower     %d", character.willpower() );

   textout ( buffer, General_FONT_INSTRUCTION, "Skills", 400, 250, General_COLOR_TEXT );

   if ( character.skillID(0) != -1 )
      textprintf ( buffer, General_FONT_PARTY, 400, 266, General_COLOR_TEXT,
         "*%-20s", (const char*)SKILL_INFO [ character.skillID(0) ] . name.data() );

   if ( character.skillID(1) != -1 )
      textprintf ( buffer, General_FONT_PARTY, 400, 282, General_COLOR_TEXT,
         " %-20s", (const char*)SKILL_INFO [ character.skillID(1) ] . name.data() );
      
   if ( character.skillID(2) != -1 )
      textprintf ( buffer, General_FONT_PARTY, 400, 298, General_COLOR_TEXT,
         " %-20s", (const char*)SKILL_INFO [ character.skillID(2) ] . name.data() );


//   textprintf ( buffer, General_FONT_PARTY, 400, 234, General_COLOR_TEXT,
//      "Luck          %d", character.luck() );



}
*/



