/***************************************************************************/
/*                                                                         */
/*                        W I N T I T L E . C P P                          */
/*                           Class Source Code                             */
/*                                                                         */
/*     Content : Class WinTitle                                            */
/*     Programer : Eric Pietrocupo                                         */
/*     Starting Date : NOvember 10th, 2002                                 */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
//#include <winempty.h>
#include <wintitle.h>


/*-------------------------------------------------------------------------*/
/*-                    Constructor & Destructor                           -*/
/*-------------------------------------------------------------------------*/

/*WinTitle::WinTitle ( string &title, short center_x , short y_pos )
{
   short font_height = text_height ( WinTitle_FONT );
   short text_width = text_length ( WinTitle_FONT, title.data() ) + 8;

   p_title = title;
   p_center_x = center_x;

   p_x_pos = center_x - ( ( text_width / 2 ) + 6 );
   p_y_pos = y_pos;
   p_width = 6 + text_width + 6 + 1;
   p_height = 6 + font_height + 6 + 1;
   p_backup = create_bitmap ( p_width, p_height );
   preshow();
} */

WinTitle::WinTitle ( const char *title, short center_x, short y_pos )
{
   short font_height = text_height ( WinTitle_FONT );
   short text_width = text_length ( WinTitle_FONT, title ) + 8;


   strncpy ( p_title, title, 81 );
   p_center_x = center_x;

   p_x_pos = center_x - ( ( text_width / 2 ) + 6 );
   p_y_pos = y_pos;
   p_width = 6 + text_width + 6 + 1;
   p_height = 6 + font_height + 6 + 1;
   p_backup = create_bitmap ( p_width, p_height );
   preshow();
}

/*
WinTitle::~WinTitle ( void )
{

}
*/

/*-------------------------------------------------------------------------*/
/*-                           Virtual Method                              -*/
/*-------------------------------------------------------------------------*/

void WinTitle::preshow ( void )
{
   WinTitle::show();
   clear ( buffer );
}

void WinTitle::refresh ( void )
{
   // this function does nothing
}

short WinTitle::show ( void )
{
   border_fill ();
   textout_centre ( buffer, WinTitle_FONT, p_title, p_center_x, p_y_pos + 6,
      WinTitle_COLOR );
   blit ( buffer, p_backup, p_x_pos, p_y_pos, 0, 0, p_width, p_height );
   draw_instruction();         
   return ( 0 );
}

tiny WinTitle::type ( void )
{
   return ( Window_TYPE_TITLE );
}
