/***************************************************************************/
/*                                                                         */
/*                        W I N I N P U T . C P P                          */
/*                         Class Source COde                               */
/*                                                                         */
/*     Content : Class WinInput source code                                */
/*     Programmer : Eric PIetrocupo                                        */
/*     Starting DAte : July 23rd, 2003                                     */
/*     License : GNU General Public LIcense                                */
/*     Engine : Wizardry window engine                                     */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
//#include <winempty.h>
//#include <wintitle.h>
//#include <winmessa.h>
#include <wininput.h>


/*-------------------------------------------------------------------------*/
/*-                    Constructor and Destructor                         -*/
/*-------------------------------------------------------------------------*/

/*WinInput::WinInput ( string &text, tiny nb_char, short x_pos, short y_pos )
{
   construct ( text, nb_char, x_pos, y_pos );
} */

WinInput::WinInput ( const char *text, tiny nb_char, short x_pos, short y_pos )
{
//   string *tmpstr = new string;
//   *tmpstr = text;

   construct ( text, nb_char, x_pos, y_pos );

//   delete tmpstr;
}

/*
WinInput::~WinInput ( void )
{

} */

/*-------------------------------------------------------------------------*/
/*-                          Methods                                      -*/
/*-------------------------------------------------------------------------*/

void WinInput::get_string ( char *copystr )
{
   strcpy ( copystr, p_inputstr );
}

/*-------------------------------------------------------------------------*/
/*-                          Virtual Methods                              -*/
/*-------------------------------------------------------------------------*/

void WinInput::preshow ( void )
{
   // This function does nothing
}

void WinInput::refresh ( void )
{
   // This function does nothing
}

short WinInput::show ( void )
{
   short tmpx = p_x_pos + 6;
   short tmpy = p_y_pos + 6;
   short font_height = text_height ( WinInput_FONT );

   p_inst_order = Window_INSTRUCTION_INPUT;
   border_fill ();

   draw_instruction();
   textout ( buffer, WinInput_FONT, p_textstring, tmpx, tmpy,
      WinInput_COLOR );

   textinput ( tmpx, tmpy + font_height, p_inputstr, p_nb_character );

   blit ( screen, p_backup, p_x_pos, p_y_pos, 0, 0, p_width, p_height );

   return ( 0 );

}

tiny WinInput::type ( void )
{
   return ( Window_TYPE_INPUT );
}

/*-------------------------------------------------------------------------*/
/*-                          Private Mehtods                              -*/
/*-------------------------------------------------------------------------*/

void WinInput::construct ( const char *text, tiny nb_char, short x_pos, short y_pos )
{
   tiny textsize;
   short font_height = text_height ( WinInput_FONT );
   short font_input_height = text_height ( WinInput_INPUTFONT );
   short font_width = text_length ( WinInput_FONT, "a" );

   strncpy ( p_textstring, text, 81 );
   strcpy ( p_inputstr,"" );
   textsize = strlen ( p_textstring );
   p_nb_character = nb_char;

   if ( nb_char > textsize )
      textsize = nb_char;

   p_x_pos = x_pos;
   p_y_pos = y_pos;
   p_width = 6 + ( font_width * textsize ) + 6 + 1 + 8;
   p_height = 6 + ( font_height + font_input_height ) + 6 + 1;
   p_backup = create_bitmap ( p_width, p_height );
}

