/***************************************************************************/
/*                                                                         */
/*                        W I N D O W . C P P                              */
/*                          Class Source code                              */
/*                                                                         */
/*     Content : Class Window                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 4th, 2002                                  */
/*                                                                         */
/***************************************************************************/

#include <general.h>

//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>


/*-------------------------------------------------------------------------*/
/*-                         Class Variable                                -*/
/*-------------------------------------------------------------------------*/

Window *Window::p_ptr_last = NULL;
Window *Window::p_ptr_first = NULL;
tiny Window::p_nb_open = 0;
tiny Window::p_border_type = Window_BORDER_THICK;
tiny Window::p_bg_mode = Window_BACKGROUND_TEXTURE;
tiny Window::p_bg_color = Window_COLOR_BLACK;
tiny Window::p_bg_texture = Window_TEXTURE_SLATE;

tiny Window::p_inst_order = -1;
short Window::p_inst_center_x = 320;
short Window::p_inst_y = 460;
const char *Window::p_inst_string = "";



/*-------------------------------------------------------------------------*/
/*-                     Constructor & Destructor                          -*/
/*-------------------------------------------------------------------------*/

Window::Window ( void )
{
/*   p_width = 0;
   p_height = 0;
   p_x_pos = 0;
   p_y_pos = 0;
   p_backup = NULL;*/
   p_hidden = false;

   if ( p_nb_open == 0 )
   {
      p_ptr_first = this;
      p_ptr_last = this;
      p_ptr_next = NULL;
      p_ptr_previous = NULL;
   }
   else
   {
      p_ptr_last->p_ptr_next = this;
      p_ptr_previous = p_ptr_last;
      p_ptr_last = this;
      p_ptr_next = NULL;
   }

   p_nb_open++;
}

Window::~Window ( void )
{
   destroy_bitmap ( p_backup );

   if ( p_nb_open <= 1 )
   {
      p_ptr_previous = NULL;
      p_ptr_next = NULL;
      p_ptr_first = NULL;
      p_ptr_last = NULL;
   }
   else
   {
      if ( p_ptr_previous != NULL )
         p_ptr_previous->p_ptr_next = p_ptr_next;
      if ( p_ptr_next != NULL )
         p_ptr_next->p_ptr_previous = p_ptr_previous;
      if ( p_ptr_first == this )
         p_ptr_first = p_ptr_next;
      if ( p_ptr_last == this )
         p_ptr_last = p_ptr_previous;
      p_ptr_previous = NULL;
      p_ptr_next = NULL;
      
   }
   
   p_nb_open--;
}

/*-------------------------------------------------------------------------*/
/*-                      Property Methods                                 -*/
/*-------------------------------------------------------------------------*/

short Window::width ( void )
{
   return ( p_width );
}

short Window::height ( void )
{
   return ( p_height );
}

short Window::x_pos ( void )
{
   return ( p_x_pos );
}

short Window::y_pos ( void )
{
   return ( p_y_pos );
}

Window* Window::next ( void )
{
   return ( p_ptr_next );
}

Window* Window::previous ( void )
{
   return ( p_ptr_previous );
}

tiny Window::nb_open ( void )
{
   return ( p_nb_open );
}

tiny Window::border_type ( void )
{
   return ( p_border_type );
}

void Window::border_type ( tiny type )
{
   p_border_type = type;
}

tiny Window::background_color ( void )
{
   return ( p_bg_color );
}
void Window::background_color ( tiny color )
{
   p_bg_color = color;
}
tiny Window::background_texture ( void )
{
   return ( p_bg_texture );
}
void Window::background_texture ( tiny texture )
{
   p_bg_texture = texture;
}

tiny Window::background_mode ( void )
{
   return ( p_bg_mode );
}
void Window::background_mode ( tiny mode )
{
   p_bg_mode = mode;
}



/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

void Window::hide ( void )
{
   p_hidden = true;
}

void Window::unhide ( void )
{
   p_hidden = false;
}


short Window::show_all ( void )
{
   tiny i;
   Window *tmptr;
   short retval = 0;

   if ( p_nb_open > 0 )
   {
      i = 1;
      tmptr = p_ptr_first;
      while ( i != p_nb_open )
      {
         if ( tmptr->p_hidden == false )
            tmptr->draw();
         tmptr = tmptr->next();
         i++;
      }
      retval = tmptr->show();
      
   }

   return ( retval );

}

void Window::draw_all ( void )
{
   tiny i;
   Window *tmptr;

   if ( p_nb_open > 0 )
   {
      i = 1;
      tmptr = p_ptr_first;
      while ( i != p_nb_open )
      {
         if ( tmptr->p_hidden == false )
            tmptr->draw();
         tmptr = tmptr->next();
         i++;
      }
      if ( tmptr->p_hidden == false )
         tmptr->draw();
      draw_instruction();
   }
}

void Window::refresh_all ( void )
{
   tiny i;
   Window *tmptr;

   if ( p_nb_open > 0 )
   {
      i = 1;
      tmptr = p_ptr_first;
      while ( i != p_nb_open )
      {
         if ( tmptr->p_hidden == false )
            tmptr->refresh();
         tmptr = tmptr->next();
         i++;
      }
      tmptr->refresh();
      
   }

}

void Window::instruction ( short center_x, short y )
{
   p_inst_center_x = center_x;
   p_inst_y = y;
}

void Window::instruction ( short center_x, short y, tiny order )
{
   p_inst_center_x = center_x;
   p_inst_y = y;
   p_inst_order = order;
}

void Window::instruction ( short center_x, short y, const char *str )
{
   p_inst_center_x = center_x;
   p_inst_y = y;
   p_inst_order = -1;
   p_inst_string = str;
}

/*-------------------------------------------------------------------------*/
/*-                           Private  Methods                            -*/
/*-------------------------------------------------------------------------*/

/*void Window::draw_border ( void )
{
   int tmpcol [ 5 ];
   tiny i;
   tiny j;
   tiny k;
   tiny diff;
   short basex [ 4 ];
   short basey [ 4 ];

   tmpcol [ 0 ] = Window_COLOR_BORDER - ( 5285 * 2 );
   tmpcol [ 1 ] = Window_COLOR_BORDER - 5285;
   tmpcol [ 2 ] = Window_COLOR_BORDER;
   tmpcol [ 3 ] = Window_COLOR_BORDER - 5285;
   tmpcol [ 4 ] = Window_COLOR_BORDER - ( 5285 * 2 );

   basex [ 0 ] = p_x_pos;
   basey [ 0 ] = p_y_pos;
   basex [ 1 ] = ( p_x_pos + p_width ) - 4;
   basey [ 1 ] = p_y_pos;
   basex [ 2 ] = p_x_pos;
   basey [ 2 ] = ( p_y_pos + p_height ) - 4;
   basex [ 3 ] = ( p_x_pos + p_width ) - 4;
   basey [ 3 ] = ( p_y_pos + p_height ) - 4;

   for ( k = 0 ; k < 4 ; k++ )
      for ( j = 0 ; j < 5 ; j++ )
         for ( i = 0 ; i < 5 ; i++ )
         {
            if ( BORDER_CORNER [ k ] [ j ] [ i ] != 5 )
               putpixel ( buffer, basex [ k ] + i , basey [ k ] + j,
                  tmpcol [ BORDER_CORNER [ k ] [ j ] [ i ] ] );
         }

   putpixel ( buffer, basex [ 0 ] + 5 , basey [ 0 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 1 ] - 1, basey [ 1 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 2 ] + 5 , basey [ 2 ] - 1, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 3 ] - 1, basey [ 3 ] - 1, tmpcol [ 4 ] );

   diff = 5;
   for ( i = 0 ; i < 5 ; i++ )
   {
//      rect( buffer, x1, y1, x2, y2, tmpcol [ i ] );
      vline ( buffer, x1 , y1 + diff, y2 - diff, tmpcol [ i ] );
      vline ( buffer, x2 , y1 + diff, y2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y1, x2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y2, x2 - diff, tmpcol [ i ] );
      x1++;
      y1++;
      x2--;
      y2--;
      diff--;
   }


} */

void Window::draw_instruction ( void )
{
//   string str;
   char str [ 121 ] = "";
//   char str2 [ 81 ] = "";

   if ( config.get ( Config_KEY_DISPLAY ) == Config_KEY_YES )
   {
//      text_mode ( -1 );

      if ( p_inst_order == -1 )
         textout_centre ( buffer, General_FONT_INSTRUCTION, str,
            p_inst_center_x, p_inst_y, General_COLOR_INSTRUCTION );
      else
      {
         if ( ( p_inst_order & Window_INSTRUCTION_SELECT ) > 0 )
         {
            strcat ( str, "[ " );
            switch ( SELECT_KEY )
            {
               case KEY_Z :
                  strcat ( str, "Z" );
               break;
               case KEY_W :
                  strcat ( str, "W" );
               break;
               case KEY_X :
                  strcat ( str, "X" );
               break;
            }
            strcat ( str, " : Select ]" );
         }
         if ( ( p_inst_order & Window_INSTRUCTION_CANCEL ) > 0 )
         {
            strcat ( str, "[ " );
            switch ( CANCEL_KEY )
            {
               case KEY_A :
                  strcat ( str, "A" );
               break;
               case KEY_Q :
                  strcat ( str, "Q" );
               break;
               case KEY_Z :
                  strcat ( str, "Z" );
               break;
            }
            strcat ( str, " : Cancel ]" );
         }
         if ( ( p_inst_order & Window_INSTRUCTION_DISPLAY ) > 0 )
            strcat ( str, "[ Enter : Display ]" );
         if ( ( p_inst_order & Window_INSTRUCTION_MENU ) > 0 )
            strcat ( str, "[ Up/Dn : Cursor ]" );
         if ( ( p_inst_order & Window_INSTRUCTION_SWITCH ) > 0 )
            strcat ( str, "[ Lft/Rgt : Switch ]" );
         if ( ( p_inst_order & Window_INSTRUCTION_MOVE ) > 0 )
            strcat ( str, "[ Up/Lft/Rgt : Move ]" );
         if ( ( p_inst_order & Window_INSTRUCTION_INPUT ) > 0 )
            strcat ( str, "[ Enter : Accept ]" );
         if ( ( p_inst_order & Window_INSTRUCTION_CAMP ) > 0 )
         {
            strcat ( str, "[ " );
            switch ( CANCEL_KEY )
            {
               case KEY_A :
                  strcat ( str, "A" );
               break;
               case KEY_Q :
                  strcat ( str, "Q" );
               break;
               case KEY_Z :
                  strcat ( str, "Z" );
               break;
            }
            strcat ( str, " : Camp ]" );
         }

         textout_centre ( buffer, General_FONT_INSTRUCTION, str,
                      p_inst_center_x, p_inst_y, General_COLOR_INSTRUCTION );
      }                                               

//      text_mode ( 0 );
   }

}

void Window::border_fill ( void )
{
   int tmpcol [ 5 ];
   tiny i;
   tiny j;
   tiny k;
   tiny diff;
   short basex [ 4 ];
   short basey [ 4 ];
   short x1 = p_x_pos;
   short y1 = p_y_pos;
   short x2 = ( p_x_pos + p_width ) - 1;
   short y2 = ( p_y_pos + p_height ) - 1;
   tiny z;
   int color;

   for ( z = 0 ; z < 5 ; z++ )
   {
      if ( BORDER_COLOR [ p_border_type ] [ z ] != 1 )
         tmpcol [ z ] = makecol ( 250 - BORDER_COLOR [ p_border_type ] [ z ],
                        250 - BORDER_COLOR [ p_border_type ] [ z ],
                        250 - BORDER_COLOR [ p_border_type ] [ z ] );
      else
         tmpcol [ z ] = 0;
   }

   basex [ 0 ] = x1;
   basey [ 0 ] = y1;
   basex [ 1 ] = x2 - 4;
   basey [ 1 ] = y1;
   basex [ 2 ] = x1;
   basey [ 2 ] = y2 - 4;
   basex [ 3 ] = x2 - 4;
   basey [ 3 ] = y2 - 4;


   color = makecol ( Window_BACKGROUND [ p_bg_color ] . red,
                     Window_BACKGROUND [ p_bg_color ] . green,
                     Window_BACKGROUND [ p_bg_color ] . blue );

   if ( p_bg_mode == Window_BACKGROUND_TEXTURE )
   {
      drawing_mode ( DRAW_MODE_COPY_PATTERN,
         (BITMAP*) datfimage [ Window_BACKGROUND [ p_bg_texture ] . texturedatID  ]
         . dat , 0, 0 );
   }

   rectfill ( buffer, x1 + 5, y1 + 5 , x2 - 5, y2 - 5, color );

   drawing_mode ( DRAW_MODE_SOLID, NULL, 0, 0 );

   for ( k = 0 ; k < 4 ; k++ )
      for ( j = 0 ; j < 5 ; j++ )
         for ( i = 0 ; i < 5 ; i++ )
         {
            if ( BORDER_CORNER [ k ] [ j ] [ i ] != 5 )
               putpixel ( buffer, basex [ k ] + i , basey [ k ] + j,
                  tmpcol [ BORDER_CORNER [ k ] [ j ] [ i ] ] );
         }

   putpixel ( buffer, basex [ 0 ] + 5 , basey [ 0 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 1 ] - 1, basey [ 1 ] + 5, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 2 ] + 5 , basey [ 2 ] - 1, tmpcol [ 4 ] );
   putpixel ( buffer, basex [ 3 ] - 1, basey [ 3 ] - 1, tmpcol [ 4 ] );

   diff = 5;
   for ( i = 0 ; i < 5 ; i++ )
   {
      vline ( buffer, x1 , y1 + diff, y2 - diff, tmpcol [ i ] );
      vline ( buffer, x2 , y1 + diff, y2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y1, x2 - diff, tmpcol [ i ] );
      hline ( buffer, x1 + diff, y2, x2 - diff, tmpcol [ i ] );
      x1++;
      y1++;
      x2--;
      y2--;
      diff--;
   }

}

void Window::draw ( void )
{
   if ( p_backup != NULL )
      blit ( p_backup, buffer, 0, 0, p_x_pos, p_y_pos, p_width, p_height );
}


