/***************************************************************************/
/*                                                                         */
/*                        W I N D A T A . C P P                            */
/*                          Class Definition                               */
/*                                                                         */
/*     Engine : Window                                                     */
/*     Content : Class WinData                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : November 13th, 2002                                 */
/*                                                                         */
/***************************************************************************/

/*-------------------------------------------------------------------------*/
/*-                          Includes                                     -*/
/*-------------------------------------------------------------------------*/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
//#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
//#include <winempty.h>
//#include <wintitle.h>
//#include <winmenu.h>
#include <windata.h>

/*-------------------------------------------------------------------------*/
/*-                            Templates                                  -*/
/*-------------------------------------------------------------------------*/

template WinData<Character>;
template WinData<Party>;
template WinData<Item>;
template WinData<BITMAP>;
//template WinData<DBTag>;
template WinData<Player>;
template WinData<Account>;
template WinData<Game>;
template WinData<Race>;
template WinData<Opponent>;

/*-------------------------------------------------------------------------*/
/*-                    Constructor & Destructor                           -*/
/*-------------------------------------------------------------------------*/

template<class t_datatype>WinData<t_datatype>::
WinData ( void (*proc)( t_datatype&, short, short ), t_datatype &param,
                     short x_pos, short y_pos, short width, short height )
{
   p_parameter = &param;
   p_procedure = proc;
   p_x_pos = x_pos;
   p_y_pos = y_pos;
   p_height = height;
   p_width = width;
   p_backup = create_bitmap ( p_width, p_height );
   preshow();
}
/*
template<class t_datatype>WinData<t_datatype>::
~WinData ( void )
{

} */

/*-------------------------------------------------------------------------*/
/*-                       Property Methods                                -*/
/*-------------------------------------------------------------------------*/

template<class t_datatype> void WinData<t_datatype>::parameter ( t_datatype &param )
{
   p_parameter = &param;
}

/*-------------------------------------------------------------------------*/
/*-                        Virtual Functions                              -*/
/*-------------------------------------------------------------------------*/

template<class t_datatype> void WinData<t_datatype>::preshow ( void )
{
   WinData::show();
   clear( buffer );
}

template<class t_datatype> void WinData<t_datatype>::refresh ( void )
{
   WinData::show();
   clear( buffer );
}

template<class t_datatype> short WinData<t_datatype>::show ( void )
{
   border_fill ();
   p_procedure ( *p_parameter, p_x_pos, p_y_pos );
   blit ( buffer, p_backup, p_x_pos, p_y_pos, 0, 0, p_width, p_height );
   draw_instruction();
   return (0);
}

template<class t_datatype> tiny WinData<t_datatype>::type ( void )
{
   return ( Window_TYPE_DATA );
}

