/***************************************************************************/
/*                                                                         */
/*                          W E A P O N . C P P                            */
/*                           Class Source Code                             */
/*                                                                         */
/*     Content : Class Weapon                                              */
/*     Programmer : Eric PIetrocupo                                        */
/*     Starting Date : June 7th, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
//#include <allegro.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
//#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                    Constructors and Destructors                       -*/
/*-------------------------------------------------------------------------*/

Weapon::Weapon ( void )
{
   p_dmg_x = 0;
   p_dmg_z = 0;
   p_dmg_type = 0;
   p_category = 0;
   p_range = 0;
   p_static_dmg = 0;
   p_nb_hand = 0;
   p_attribute = 0;
   p_nb_max_attack = 0;
   p_AD = 0;
   p_hitbonus = 0;
   

   p_type = Item_TYPE_WEAPON;
   p_dblength = sizeof ( dbs_Weapon );
   p_dbtableID = DBTABLE_ITEM;
}

Weapon::~Weapon ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                         Property Methods                              -*/
/*-------------------------------------------------------------------------*/

tiny Weapon::dmg_x ( void )
{
   return ( p_dmg_x );
}

void Weapon::dmg_x ( tiny value )
{
   p_dmg_x = value;
}

tiny Weapon::dmg_z ( void )
{
   return ( p_dmg_z );
}

void Weapon::dmg_z ( tiny value )
{
   p_dmg_z = value;
}

tiny Weapon::dmg_type ( void )
{
   return ( p_dmg_type );
}

void Weapon::dmg_type ( tiny value )
{
   p_dmg_type = value;
}

byte Weapon::category ( void )
{
   return ( p_category );
}

void Weapon::category ( byte value )
{
   p_category = value;
}

tiny Weapon::range ( void )
{
   return ( p_range );
}

void Weapon::range ( tiny value )
{
   p_range = value;
}

tiny Weapon::static_dmg ( void )
{
   return ( p_static_dmg );
}

void Weapon::static_dmg ( tiny value )
{
   p_static_dmg = value;
}

tiny Weapon::nb_hand ( void )
{
   return ( p_nb_hand );
}

void Weapon::nb_hand ( tiny value )
{
   p_nb_hand = value;
}

tiny Weapon::attribute ( void )
{
   return ( p_attribute );
}

void Weapon::attribute ( tiny value )
{
   p_attribute = value;
}

tiny Weapon::nb_max_attack ( void )
{
   return ( p_nb_max_attack );
}

void Weapon::nb_max_attack ( tiny value )
{
   p_nb_max_attack = value;
}

tiny Weapon::AD ( void )
{
   return ( p_AD );
}

void Weapon::AD ( tiny value )
{
   p_AD = value;
}

tiny Weapon::hitbonus ( void )
{
   return ( p_hitbonus );
}

void Weapon::hitbonus ( tiny value )
{
   p_hitbonus = value;
}


/*-------------------------------------------------------------------------*/
/*-                             Methods                                   -*/
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*-                           Virtual Methods                             -*/
/*-------------------------------------------------------------------------*/


void Weapon::objdat_to_strdat ( void *dataptr )
{
   dbs_Weapon &tmpdat = *(static_cast<dbs_Weapon*> ( dataptr ));

   Item::objdat_to_strdat ( dataptr );

   tmpdat.dmg_x = p_dmg_x;
   tmpdat.dmg_z = p_dmg_z;
   tmpdat.dmg_type = p_dmg_type;
   tmpdat.category = p_category;
   tmpdat.range = p_range;
   tmpdat.static_dmg = p_static_dmg;
   tmpdat.nb_hand = p_nb_hand;
   tmpdat.attribute = p_attribute;
   tmpdat.nb_max_attack = p_nb_max_attack;
   tmpdat.AD = p_AD;
   tmpdat.hitbonus = p_hitbonus;

}

void Weapon::strdat_to_objdat ( void *dataptr )
{
   dbs_Weapon &tmpdat = *(static_cast<dbs_Weapon*> ( dataptr ));

   Item::strdat_to_objdat ( dataptr );
   p_dmg_x = tmpdat.dmg_x;
   p_dmg_z = tmpdat.dmg_z;
   p_dmg_type = tmpdat.dmg_type;
   p_category = tmpdat.category;
   p_range = tmpdat.range;
   p_static_dmg = tmpdat.static_dmg;
   p_nb_hand = tmpdat.nb_hand;
   p_attribute = tmpdat.attribute;
   p_nb_max_attack = tmpdat.nb_max_attack;
   p_AD = tmpdat.AD;
   p_hitbonus = tmpdat.hitbonus;
}

void Weapon::child_DBremove ( void )
{
   // no child to remove
}










