/***************************************************************************/
/*                                                                         */
/*                          P L A Y E R . C P P                            */
/*                                                                         */
/*     Content : Class Player Source code                                  */
/*     Programmer : Eric Pietrocupo                                        */
/*     Stating Date : May 1st, 2002                                        */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>

#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <cclass.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winlist.h>
#include <winempty.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>
#include <winmessa.h>
#include <winquest.h>
#include <wininput.h>


/*-------------------------------------------------------------------------*/
/*-                      Constructor & Destructor                         -*/
/*-------------------------------------------------------------------------*/

Player::Player ( void )
{
//   p_nb_login = 0;
   p_nb_character = 0; //?? to modifiy
//   p_status = Player_STATUS_LOGGEDOFF;
//   p_account = Player_ACCOUNT_ACTIVE;
   p_selected_party = -1;
   p_nb_party = 0;
   p_account.number (0);
   p_game.number ( 0 );

   p_dblength = sizeof ( dbs_Player );
   p_dbtableID = DBTABLE_PLAYER;
}

Player::~Player ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                           Property Method                             -*/
/*-------------------------------------------------------------------------*/

tiny Player::nb_character ( void )
{
   return ( p_nb_character );
}

tiny Player::nb_party ( void )
{
   return ( p_nb_party );
}

DBTag Player::character ( tiny ID )
{
   return ( p_character [ ID ] );
}

DBTag Player::selected_party ( void )
{
   if ( p_selected_party >= 0 && p_selected_party < 3 )
      return ( p_party [ p_selected_party ] );
   else
      return ( p_party [ 0 ] );
}

tiny Player::selected_partyID ( void )
{
   return ( p_selected_party );
}

DBTag Player::party ( tiny partyID )
{
   return ( p_party [ partyID ] );
}

DBTag Player::account ( void )
{
   return ( p_account );
}

void Player::account ( DBTag value )
{
   p_account = value;
}

DBTag Player::game ( void )
{
   return ( p_game );
}

void Player::game ( DBTag value )
{
   p_game = value;
}

DBTag Player::default_city ( void )
{
   return ( p_default_city );
}

void Player::default_city ( DBTag value )
{
   p_default_city = value;
}



/*-------------------------------------------------------------------------*/
/*-                               Method                                  -*/
/*-------------------------------------------------------------------------*/

tiny Player::start ( /*DBTag gametag*/ )
{
   Menu player_menu;
   Game tmpgame;

   player_menu.title ("Player's Commands");

   player_menu.add_item ("Create Character" );
   player_menu.add_item ("Inspect Character" );
   player_menu.add_item ("Delete Character" );
   player_menu.add_item ("Rename Character" );
   player_menu.add_item ("Create Party" );
   player_menu.add_item ("Disband/Destroy Party");
   player_menu.add_item ("Select Party" );
   player_menu.add_item ("Exit Game" );

   tiny answer = 0;
   tiny ret_value;
   tiny tmpval;

   play_music_track ( System_MUSIC_w2edge );
   ret_value = Player_CONTINUE;

   WinEmpty wemp_background;
   WinTitle wttl_player ("Player's Domain");

   while ( ret_value == Player_CONTINUE )
   {
      player_menu.unmask_all_item ();

      if ( p_nb_character == Player_NB_MAX_CHARACTER )
         player_menu.mask_item ( Player_CREATE_CHARACTER );

      if ( p_nb_character == 0 )
      {
         player_menu.mask_item ( Player_INSPECT_CHARACTER );
         player_menu.mask_item ( Player_DELETE_CHARACTER );
         player_menu.mask_item ( Player_RENAME_CHARACTER );
         player_menu.mask_item ( Player_CREATE_PARTY );
         player_menu.mask_item ( Player_SELECT_PARTY );
      }

      if ( p_nb_party == 3 )
         player_menu.mask_item ( Player_CREATE_PARTY );
      
      if ( p_nb_party == 0 )
      {
         player_menu.mask_item ( Player_DISBAND_PARTY );
         player_menu.mask_item ( Player_SELECT_PARTY );
      }

      Window::instruction ( 320, 460 );

      WinMenu wmnu_player ( player_menu, 20, 40, true );
      answer = Window::show_all();

      wmnu_player.hide();
      switch ( answer )
      {
         case Player_CREATE_CHARACTER :
            show_create_character( /*gametag*/ );
         break;

         case Player_INSPECT_CHARACTER :
            show_inspect_character ();
         break;

         case Player_DELETE_CHARACTER :
            show_delete_character ();
         break;

         case Player_RENAME_CHARACTER :
            show_rename_character ();
         break;

         case Player_CREATE_PARTY :
            show_create_party ( /*gametag*/ );
         break;

         case Player_DISBAND_PARTY :
            show_disband_party ();
         break;

         case Player_SELECT_PARTY :
            tmpval = show_select_party ();
            if ( tmpval != -1 )
            {
               ret_value = Player_START_GAME;
               DBupdate();
            }
         break;

         case Player_LOGOUT :
            DBupdate();
            tmpgame.DBselect ( p_game );
            db.save_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
            db.remove_source ( DBSOURCE_SAVEGAME );
            unload_datafile ( adatf );
            db.remove_source ( DBSOURCE_ADVENTURE );
            maze.reference_bitmap();
            ret_value = Player_EXIT;
         break;
      }
   }

   return ( ret_value );

}

/*

void Player::login ( DBTag gametag )
{
   // load character and party tag into player
} */

void Player::delete_character ( tiny characterID )
{
   tiny i;

   db.remove ( p_character [ characterID ] );

   for ( i = characterID ; i < Player_NB_MAX_CHARACTER - 1 ; i++ )      
      p_character [ i ] = p_character [ i + 1 ];

   p_character [ Player_NB_MAX_CHARACTER - 1 ].number (0);

   p_nb_character--;

}

void Player::disband_party ( tiny partyID )
{
   tiny i;
   Party tmparty;
   Character tmpchar;

   tmparty.DBselect ( p_party [ partyID ] );

   for ( i = 0 ; i < tmparty . nb_character () ; i++ )
   {
      tmpchar.DBselect ( tmparty.character ( i ) );
      tmpchar.available ( Character_AVAILABLE );
      tmpchar.DBupdate();
   }

//   p_party [ partyID ].remove_all_character();
//   p_party [ partyID ].destroy_all_spell();
//   p_party [ partyID ].reset_position();

   tmparty.DBremove();

   for ( i = partyID ; i < 2 ; i++ )
      p_party [ i ] = p_party [ i + 1 ];

   p_nb_party--;

}

void Player::destroy_party ( tiny partyID )
{
   tiny i;
   Party tmparty;
   Character tmpchar;

   tmparty.DBselect ( p_party [ partyID ] );

   for ( i = 0 ; i < tmparty . nb_character () ; i++ )
   {
      tmpchar.DBselect ( tmparty.character ( i ) );
      tmpchar.available ( Character_TOBEDESTROYED );
      tmpchar.DBupdate();
   }

//   p_party [ partyID ].remove_all_character();
//   p_party [ partyID ].destroy_all_spell();
//   p_party [ partyID ].reset_position();

   // destroy Party

   tmparty.DBremove();

   // sort PArty
   for ( i = partyID ; i < 2 ; i++ )
      p_party [ i ] = p_party [ i + 1 ];
   p_nb_party--;

   // destroy characters

   i = 0;
   while ( i < p_nb_character )
   {
      tmpchar.DBselect ( p_character [ i ] );
      if ( tmpchar.available() == Character_TOBEDESTROYED )
         delete_character ( i );
      else
         i++;
   }

}


void Player::select_default_city ( void )
{
   dword index;
   
   index = db.search_table_entry ( DBTABLE_CITY );
   while ( db.entry_table_tag ( index ) != DBTABLE_CITY )
      index++;

   p_default_city = db.get_tag ( index );

}

/*-------------------------------------------------------------------------*/
/*-                        Private Methods                                -*/
/*-------------------------------------------------------------------------*/

void Player::show_create_character ( /*DBTag gametag*/ void )
{
   char tmpstr [ 201 ];
   tiny answer;
   Character tmpchar;

   WinData<Character> wdat_newchar ( WDatProc_new_character,
      tmpchar, WDatProc_POSITION_NEW_CHARACTER );
   Window::instruction ( 200, 460, Window_INSTRUCTION_INPUT );
   new_character_name ( tmpchar );
   new_character_family ( tmpchar );
   new_character_reputation ( tmpchar );
   Window::instruction ( 200, 460, Window_INSTRUCTION_SELECT +
      Window_INSTRUCTION_MENU );
   new_character_sex ( tmpchar );
   new_character_race ( tmpchar );
   new_character_aligment( tmpchar);
   new_character_class( tmpchar);   
   new_character_attribute( tmpchar);

//   new_character_element( tmpchar);

   // --- set other automaticly ---

   tmpchar.create_new_stats ();
//   tmpchar.player ( p_reftag );
//   tmpchar.game ( gametag );

   WinQuestion wqst_confirmation
      ( "Character creation complete. Do you want to keep this character ?" );

   answer = Window::show_all();

   wqst_confirmation.hide();
   
   if ( answer == 0 )
   {
      sprintf ( tmpstr, "%s the %s Is now available",
         tmpchar . name(),
         tmpchar . reputation() );
         tmpchar . eval_stat_all();

      p_character [ p_nb_character ] = tmpchar.DBinsert();
      p_nb_character++;
   }
   else
   {
      sprintf ( tmpstr, "%s of %s\nhas been deleted",
         tmpchar . name(),
         tmpchar . family() );
   }

   WinMessage wmsg_result ( tmpstr );
   Window::show_all();

}

void Player::show_inspect_character ( void )
{
   Menu character_menu;
   Character tmpchar;
   tiny i;
   tiny answer = 0;

   for ( i = 0; i < p_nb_character ; i++ )
      character_menu.add_item ("");

   while ( answer != -1 )
   {
      WinData<Player> wdat_list ( WDatProc_character_list, *this, WDatProc_POSITION_CHARACTER_LIST );

//      draw_character_list ();

      Window::draw_all();
      textout( buffer, General_FONT_PARTY,
         "Select a character to INSPECT", 6, 6, General_COLOR_TEXT );
      // to do : unstatic menu drawing location
      answer = character_menu.show ( 6, 42 , answer );

      if ( answer >= 0 )
      {
         tmpchar.DBselect ( p_character [ answer ] );
         WinData<Character> wdat_character ( WDatProc_character,
                      tmpchar, WDatProc_POSITION_CHARACTER );
//         draw_character ( p_character [ answer ] );
//         copy_buffer ();
         Window::instruction ( 550, 460, Window_INSTRUCTION_CANCEL );
         Window::draw_all();
         copy_buffer();
//         make_screen_shot ("charshot.bmp");//@@
         while ((readkey() >> 8) != CANCEL_KEY );
      }
   }
}

void Player::show_delete_character ( void )
{
   tiny i;
   tiny answer = 0;
   tiny confirm;
//   char str;
   Character tmpchar;
//   Menu mnu_confirm ("Are you sure you want to delete this character?");
   
//   mnu_confirm.add_item ("Yes");
//   mnu_confirm.add_item ("No");

   while ( answer != -1 && p_nb_character > 0 )
   {
      WinData<Player> wdat_list ( WDatProc_character_list_masked, *this,
      WDatProc_POSITION_CHARACTER_LIST );
      Menu character_menu;
      wdat_list.unhide();
      for ( i = 0; i < p_nb_character ; i++ )
      {
         tmpchar.DBselect ( p_character [ i ] );
         if ( tmpchar . available () == Character_AVAILABLE )
            character_menu.add_item ("", false );
         else
            character_menu.add_item ("", true );
      }

//      draw_character_list ( true );
      Window::draw_all();
      textout( buffer, General_FONT_PARTY,
         "Select a character to DELETE", 6, 6, General_COLOR_TEXT );

      // to do : unstatic menu drawing location
      answer = character_menu.show ( 6, 42 , answer );
      
      if ( answer >= 0 )
      {
         tmpchar.DBselect ( p_character [ answer ] );
         WinData<Character> wdat_character ( WDatProc_new_character,
            tmpchar, WDatProc_POSITION_NEW_CHARACTER );
//         draw_new_character ( p_character [ answer ] );
         wdat_list.hide();
         WinQuestion wqst_confirm (
            "Are you sure you want to delete this character?", 196 );
//         confirm = mnu_confirm.show ( 10, 10 );
         confirm = Window::show_all();

         if ( confirm == 0 )
         {
            delete_character ( answer );
            Window::refresh_all();
            if ( answer > 0 )
               answer--;
         }
      }
   }
}

void Player::show_rename_character ( void )
{
//   string tmpstr;
   tiny i;
   tiny answer = 0;
//   tiny confirm;
   char tmpstr [ 26 ];
   Character tmpchar;
//   Menu mnu_confirm ("Are you sure you want to delete this character?");
   
//   mnu_confirm.add_item ("Yes");
//   mnu_confirm.add_item ("No");

   while ( answer != -1 && p_nb_character > 0 )
   {
      WinData<Player> wdat_list ( WDatProc_character_list_masked, *this,
      WDatProc_POSITION_CHARACTER_LIST );
      Menu character_menu;
      wdat_list.unhide();
      for ( i = 0; i < p_nb_character ; i++ )
      {
         tmpchar.DBselect ( p_character [ i ] );
//         if ( tmpchar . available () == Character_AVAILABLE )
//            character_menu.add_item ("", false );
//         else
            character_menu.add_item ("" );
      }

//      draw_character_list ( true );
      Window::draw_all();
      textout( buffer, General_FONT_PARTY,
         "Select a character to RENAME", 6, 6, General_COLOR_TEXT );

      // to do : unstatic menu drawing location
      answer = character_menu.show ( 6, 42 , answer );

      wdat_list.hide();
      if ( answer >= 0 )
      {
         tmpchar.DBselect ( p_character [ answer ] );

         WinInput winp_name ("Enter your character's name", 15, 20, 50 );
         Window::show_all();

         WinInput winp_family ("Enter your character's family name", 15, 20, 100 );
         Window::show_all();

         WinInput winp_reputation ("Enter your character's reputation name", 15, 20, 150 );
         Window::show_all();
         
         winp_name.get_string ( tmpstr );
         tmpchar.name ( tmpstr );
         winp_family.get_string ( tmpstr );
         tmpchar.family ( tmpstr );
         winp_reputation.get_string ( tmpstr );
         tmpchar.reputation ( tmpstr );

         tmpchar.DBupdate();
         Window::refresh_all();
         
      }
   }






}

void Player::show_create_party ( /*DBTag gametag*/ void )
{
   Menu character_menu;
   tiny i;
   tiny answer = 0;
   bool char_added = false;
   tiny aligselected [ 6 ];
   bool addcharacter;
//   bool opposition = false;
   tiny tmpalig;
   char strname [ 31 ];
//   char tmpinput [ General_INPUTSTR_SIZE ];
   Character tmpchar;
   Party tmparty;
   dword index;
   City tmpcity;
   bool onecharalive;

   for ( i = 0 ; i < 6 ; i++ )
      aligselected [ i ] = 0;

   for ( i = 0; i < p_nb_character ; i++ )
   {
      tmpchar.DBselect ( p_character [ i ] );
      if ( tmpchar . available () == Character_AVAILABLE )
         character_menu.add_item ("", false );
      else
         character_menu.add_item ("", true );
   }

   while ( answer != -1 && tmparty.nb_character() < 6 )
   {
      WinData<Player> wdat_list ( WDatProc_character_list_masked, *this,
         WDatProc_POSITION_CHARACTER_LIST );
//      draw_character_list ( true );
      WinData<Party> wdat_party ( WDatProc_party_bar, tmparty,
         WDatProc_POSITION_PARTY_BAR );
      
//      draw_party_bar ( p_party [ p_nb_party ] );

      // to do : unstatic menu drawing location
      Window::draw_all();
      textout( buffer, General_FONT_PARTY,
         "ADD characters to your party", 6, 6, General_COLOR_TEXT );
      
      answer = character_menu.show ( 6, 42 , answer );

      if ( answer >= 0 )
      {
         tmpchar.DBselect ( p_character [ answer ] );
         addcharacter = false;
         tmpalig = tmpchar. aligment();
         
            /*
         if ( opposition == false )
         {
            aligselected [ tmpalig ] = true;
            if ( tmpalig < 3 )
            {
               if ( aligselected [ tmpalig + 3 ] == true )
                  opposition = true;
            }
            else
               if ( aligselected [ tmpalig - 3 ] == true )
                  opposition = true;
         }
         else
         {*/
//         for ( i = 0 ; i < 6 ; i++ )
//            textprintf ( buffer, font, 0, i * 16, General_COLOR_TEXT,
//               "%d : %d", i, aligselected [ i ] );

/*         textprintf ( buffer, font, 0, i * 16 + 16 , General_COLOR_TEXT,
            "tmpalig : %d", tmpalig );
         if ( tmpalig < 3 )
            if ( aligselected [ tmpalig + 3 ] == true )
               textout ( buffer, font, "Opposing True", 0, i * 16 + 32, General_COLOR_TEXT );
            else
               textout ( buffer, font, "Opposing False", 0, i * 16 + 32, General_COLOR_TEXT );
         else
            if ( aligselected [ tmpalig - 3 ] == true )
               textout ( buffer, font, "Opposing True", 0, i * 16 + 32, General_COLOR_TEXT );
            else
               textout ( buffer, font, "Opposing False", 0, i * 16 + 32, General_COLOR_TEXT );*/
            
//         copy_buffer();
//         while ( ( readkey() >> 8) != KEY_ENTER );

         switch ( tmpalig )
         {
            case Opponent_ALIGMENT_KIND :
               if ( aligselected [ Opponent_ALIGMENT_SELLFISH ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_KIND ]++;
                  addcharacter = true;
               }
            break;
            case Opponent_ALIGMENT_PEACEFULL :
               if ( aligselected [ Opponent_ALIGMENT_AGGRESSIVE ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_PEACEFULL ]++;
                  addcharacter = true;
               }
            break;
            case Opponent_ALIGMENT_LIVELY :
               if ( aligselected [ Opponent_ALIGMENT_STOICAL ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_LIVELY ]++;
                  addcharacter = true;
               }
            break;
            case Opponent_ALIGMENT_SELLFISH :
               if ( aligselected [ Opponent_ALIGMENT_KIND ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_SELLFISH ]++;
                  addcharacter = true;
               }
            break;
            case Opponent_ALIGMENT_AGGRESSIVE :
               if ( aligselected [ Opponent_ALIGMENT_PEACEFULL ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_AGGRESSIVE ]++;
                  addcharacter = true;
               }
            break;
            case Opponent_ALIGMENT_STOICAL :
               if ( aligselected [ Opponent_ALIGMENT_LIVELY ] == 0 )
               {
                  aligselected [ Opponent_ALIGMENT_STOICAL ]++;
                  addcharacter = true;
               }
            break;

         }
         
/*         if ( tmpalig < 3 )
         {

            if ( aligselected [ tmpalig + 3 ] == false )
            {
               aligselected [ tmpalig ] = true;
               addcharacter = true;
            }
         }
         else
         {
            if ( aligselected [ tmpalig - 3 ] == false )
            {
               aligselected [ tmpalig ] = true;
               addcharacter = true;
            }
         }*/
         
         if ( addcharacter == true )
         {
            tmparty. add_character ( p_character [ answer ] );
            tmpchar . available ( p_nb_party );
            tmpchar.DBupdate();
            character_menu.mask_item ( answer );
            char_added = true;
            Window::refresh_all();
            if ( answer < p_nb_character - 1 )
               answer++;
         }
         else
         {
            WinMessage wmsg_aligment ( "No aligment opposition allowed !\nKind<->Sellfish | Peaceful<->Agresive | Lively<->Stoical" );
            Window::show_all();
         }
      }
   }

   if ( char_added == true )
   {
      onecharalive = false;
      
      for ( i = 0 ; i < tmparty.nb_character() ; i++ )
      {
         tmpchar.DBselect ( tmparty.character ( i ) );
         if ( tmpchar.status() == Opponent_STATUS_ALIVE );
            onecharalive = true;
      }

      if ( onecharalive == true )
      {
         WinInput winp_name ( "Write the name of your Party", 30, 200, 100 );
         Window::show_all();
         winp_name.get_string ( strname );
         tmparty.name ( strname );

         tmparty.status ( Party_STATUS_RESERVE );
         tmparty.location ( p_default_city );
         p_party [ p_nb_party ] = tmparty.DBinsert();
         p_nb_party++;
      }
      else
      {
         WinMessage wmsg_aligment ( "Sorry, at least 1 character in your party \n must be alive to hold the bodies" );
         Window::show_all();
      }
   }
}

void Player::show_disband_party ( void )
{
   tiny i;
//   string str;
//   char str;
   tiny answer = -2;
   tiny answer2 = -2;
   Party tmparty;

   while ( answer != -1 && p_nb_party > 0 )
   {

   WinData<Player> wdat_list ( WDatProc_party_list, *this, WDatProc_POSITION_PARTY_LIST );

      Menu menu_select ("Select a party to DISBAND");

      for ( i = 0 ; i < p_nb_party ; i++ )
      {
         tmparty.DBselect ( p_party [ i ] );
//         if ( tmparty.status() == Party_STATUS_RESERVE )
            menu_select.add_item ( tmparty.name() );
//         else
//            menu_select.add_item ( tmparty.name(), true );
      }

      WinMenu wmnu_party ( menu_select, 10, 0, false, true );
      answer = Window::show_all();

//      draw_party_list ();

//      answer = menu_select.show ( 10, 10, answer - 1 );

      if ( answer >= 0 )
      {
         tmparty.DBselect ( p_party [ answer ] );
         if ( tmparty.status() == Party_STATUS_RESERVE )
         {
            disband_party ( answer );
            Window::refresh_all();
         }
         else
         {
            WinQuestion wqst_destroy ( "This party is not in reserve so you cannot disband it\nBut if you cannot play with this party you can DESTROY it\ndoing so will destroy all character. Do you want to destroy the party?");
            answer2 = Window::show_all();

            if ( answer2 == WinQuestion_ANSWER_YES )
            {
               destroy_party ( answer );
               Window::refresh_all();
            }
         }
      }

   }

}

tiny Player::show_select_party ( void )
{
   Menu menu_select ("Select your Party");
   tiny i;
//   string str;
   tiny answer;
   Party tmparty;

   for ( i = 0 ; i < p_nb_party ; i++ )
   {
      tmparty.DBselect ( p_party [ i ] );
      menu_select.add_item ( tmparty.name() );
   }

   WinData<Player> wdat_list ( WDatProc_party_list, *this, WDatProc_POSITION_PARTY_LIST );
//   draw_party_list ();

   WinMenu wmnu_party ( menu_select, 10, 0 );
//   answer = menu_select.show (  10, 10 );
   answer = Window::show_all();

   if ( answer >= 0 )
   {
      tmparty.DBselect ( p_party [ answer ] );
      if ( tmparty.is_functional() == false )
      {
         WinMessage wmsg_error ("Party is not functional\nno characters are alive");
         Window::show_all();
         answer = -1;
      }
      else
      {
         p_selected_party = answer;
         if ( tmparty.status() == Party_STATUS_RESERVE )
         {
            tmparty.status( Party_STATUS_CITY );
            tmparty.DBupdate();
         }
      }
   }

   return ( answer );
}

/*void Player::compact_characters ( void )
{

} */

void Player::new_character_name ( Character &character )
{
//   string tmpstr;
   char tmpstr [ 16 ];
//   tiny new_charID = p_nb_character;

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_INPUT, 200, 460 );
   textout ( buffer, General_FONT_PARTY, "Enter the Name of your character",
      10, 40, General_COLOR_TEXT );
   textinput ( 10, 56, tmpstr, 15 );
   character . name ( tmpstr );
   Window::refresh_all();
}

void Player::new_character_family ( Character &character )
{
//   string tmpstr;
   char tmpstr [ 16 ];   
//   tiny new_charID = p_nb_character;

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_INPUT, 200, 460 );
   textout ( buffer, General_FONT_PARTY, "Enter the Family name",
      10, 40, General_COLOR_TEXT );
   textinput ( 10, 56, tmpstr, 15 );
   character . family ( tmpstr );
   Window::refresh_all();
}

void Player::new_character_reputation ( Character &character )
{
//   string tmpstr;
   char tmpstr [ 16 ];   
//   tiny new_charID = p_nb_character;

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_INPUT, 200, 460 );
   textout ( buffer, General_FONT_PARTY, "Enter the character's reputation name",
      10, 40, General_COLOR_TEXT );
   textinput ( 10, 56, tmpstr, 15 );
   character . reputation ( tmpstr );
   Window::refresh_all();
}

void Player::new_character_sex ( Character &character )
{
   tiny answer;
   Menu mnu_sex ("Select the Sex of your character");
//   tiny new_charID = p_nb_character;

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
   mnu_sex.add_item ("Female ( CUN+1 )");
   mnu_sex.add_item ("Male ( STR+1 )");
   answer = mnu_sex.show (  10, 40, 0, true );
   character . sex ( answer );
   Window::refresh_all();

}

void Player::new_character_race ( Character &character )
{
   tiny answer;
   Menu mnu_race ("Select the race of your character");
//   tiny new_charID = p_nb_character;
   tiny i;
   char tmp [ 81 ];
   Race tmprace;
   DBTag racelist [ Game_NB_MAX_RACE ];
   tiny racei;
   dword index;
   DBTag tmptag;

//   draw_new_character ( p_character [ new_charID ] );
   Window::show_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );

   index = db.search_table_entry ( DBTABLE_RACE );
   racei = 0;
   while ( db.entry_table_tag ( index ) == DBTABLE_RACE )
   {
      tmprace.DBselect ( index );
      tmptag = tmprace.tag();
      if ( tmptag.source() != DBSOURCE_SYSTEM )
      {
         mnu_race.add_item ( tmprace.name() );
         racelist [ racei ] = tmptag;
         racei++;
      }
      index++;
   }
   
   answer = mnu_race.show ( 10, 40, 0, true );
   character . race ( racelist [ answer ] );
   character . init_race_attribute ();
   Window::refresh_all();
}

void Player::new_character_aligment ( Character &character )
{
   tiny answer;
//   tiny answer2;
   Menu mnu_aligment ("Select the aligment");
//   tiny new_charID = p_nb_character;
   bool mask [ 6 ];
   tiny bincount;
   byte aligrestriction;
   tiny i;
   Race tmprace;

   tmprace.DBselect ( character.race() );
   aligrestriction = tmprace.aligment_restriction();
   bincount = 1;
   for ( i = 0 ; i < 6 ; i++ )
   {
      if ( ( bincount & aligrestriction ) > 0 )
         mask [ i ] = true;
      else
         mask [ i ] = false;
      bincount = bincount << 1;
   }
   
//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
   mnu_aligment.add_item ("Kind", mask [ 0 ] );
   mnu_aligment.add_item ("Peacefull", mask [ 1 ] );
   mnu_aligment.add_item ("Lively", mask [ 2 ] );
   mnu_aligment.add_item ("Sellfish", mask [ 3 ] );
   mnu_aligment.add_item ("Agressive", mask [ 4 ] );
   mnu_aligment.add_item ("Stoical", mask [ 5 ] );

   answer = mnu_aligment.show ( 10, 40, 0, true );

   character . aligment ( answer );
   Window::refresh_all();

}

void Player::new_character_attribute ( Character &character )
{
   Menu mnu_generator ("Select the generation type of attributes");
   Menu mnu_attribute;
   Menu mnu_extra;
   Menu mnu_yesno ("Do you want to remove some luck points and add them to your attributes ?");
   Menu mnu_nbpoint ("How many points to remove ?" );
   tiny generation_type;
   tiny attribonus [ 7 ];
   tiny extrapoints;
//   tiny new_charID = p_nb_character;
//   string tmpstr;
   char tmpstr [ 81 ];
   char tmpstr2 [ 15 ];
   tiny i;
   tiny j;
   tiny swap;
   tiny sumbonus;
   tiny answer;
   tiny tmpattrib;
   Race tmprace;
   
   // generation
   tmprace.DBselect ( character.race() );

//   draw_new_character ( p_character [ new_charID ] );
   Window::show_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 320, 460 );
   mnu_generator.add_item ("Average   [ 555555 ]");
   mnu_generator.add_item ("Decrement [ 876432 ]");
   mnu_generator.add_item ("Opposed   [ 888222 ]");
   mnu_generator.add_item ("Extreme   [ 993333 ]");
   mnu_generator.add_item ("Light     [ 666444 ]");
   generation_type = mnu_generator.show ( 10, 40, 0, true );
   

//   draw_new_character ( p_character [ new_charID ] );
   Window::refresh_all();
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );

   sumbonus = 0;
   for ( i = 0 ; i < 6 ; i++ )
   {
      attribonus [ i ] = rnd ( 3 )
                        + ATTRIBGEN_INFO [ generation_type ] . minimum [ i ];
      sumbonus = sumbonus + attribonus [ i ];
   }


   attribonus [ 6 ] = 4 - ( ( sumbonus - 24 ) / 3 );
   if ( attribonus [ 6 ] == 0 )
      attribonus [ 6 ] = 1;

   // sort values

   for ( i = 0 ; i < 5 ; i++ )
      for ( j = i + 1 ; j < 6 ; j++ )
         if ( attribonus [ i ] < attribonus [ j ] )
         {
            swap = attribonus [ i ];
            attribonus [ i ] = attribonus [ j ];
            attribonus [ j ] = swap;
         }


   // location

   mnu_attribute.add_item ("Strength");
   mnu_attribute.add_item ("Dexterity");
   mnu_attribute.add_item ("Endurance");
   mnu_attribute.add_item ("Intelligence");
   mnu_attribute.add_item ("Cunning");
   mnu_attribute.add_item ("Willpower");
   answer = 0;
   
   for ( i = 0 ; i < 6 ; i++ )
   {
      strcpy ( tmpstr, "Rolled values : " );

      for ( j = i ; j < 6 ; j++ )
      {
         sprintf ( tmpstr2, "%d", attribonus [ j ] );
         strcat ( tmpstr, tmpstr2 );
         strcat ( tmpstr, ", " );
      }
      
      strcat ( tmpstr, "extra " );
      sprintf ( tmpstr2, "%d", attribonus [ 6 ] );
      strcat ( tmpstr, tmpstr2 );

      Window::draw_all();

      textout ( buffer, General_FONT_PARTY, tmpstr, 10, 200,
                                                        General_COLOR_TEXT );

      sprintf ( tmpstr,"Where do you want to place value %d", attribonus [ i ] );

      mnu_attribute.title ( tmpstr );
//      draw_new_character ( p_character [ new_charID ] );

//      draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
      answer = mnu_attribute.show ( 10, 40, answer, true );
      
      mnu_attribute.mask_item ( answer );
      tmpattrib = character . attribute ( answer );
      tmpattrib = tmpattrib + attribonus [ i ];
      if ( tmpattrib > ( tmprace.attribute ( answer ) + 10 ) )
         tmpattrib = tmprace.attribute ( answer ) + 10;
      character . attribute ( answer, tmpattrib );
      Window::refresh_all();      
   }


   // extra points

   mnu_attribute.unmask_all_item ();
   sprintf ( tmpstr, "You have %d extra points. Where to place them?",
      attribonus [ 6 ] );

   mnu_extra.title ( tmpstr );
   mnu_extra.add_item ("Add it to an attribute");
   mnu_extra.add_item ("Add it to luck");

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
   answer = mnu_extra.show ( 10, 40, 0, true );

   if ( answer == 0 )
   {
      sprintf ( tmpstr, "Place a %d in which attribute ? ( Maximum is : race attribute + 10 ) ",
         attribonus [ 6 ] );

      mnu_attribute.title ( tmpstr );
//      draw_new_character ( p_character [ new_charID ] );
      Window::show_all();
//      draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
      answer = mnu_attribute.show ( 10, 40, 0, true );

      tmpattrib = character .attribute ( answer );
      tmpattrib = tmpattrib + attribonus [ 6 ];

      if ( tmpattrib > ( tmprace.attribute ( answer ) + 10 ) )
         tmpattrib = tmprace.attribute ( answer ) + 10;
      character . attribute ( answer, tmpattrib );
      Window::refresh_all();
   }
   else
   {
      tmpattrib = character .luck();
      tmpattrib = tmpattrib + attribonus [ 6 ];
      character . luck ( tmpattrib );
      Window::refresh_all();
   }

   // Pool luck

   mnu_yesno.add_item ("No");
   mnu_yesno.add_item ("Yes");

//   draw_new_character ( p_character [ new_charID ] );
   Window::draw_all();
//   draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
   answer = mnu_yesno.show (  10, 40, 0, true );

   if ( answer == 1 )
   {
      mnu_nbpoint.add_item ("1");
      mnu_nbpoint.add_item ("2");
      mnu_nbpoint.add_item ("3");
      mnu_nbpoint.add_item ("4");

//      draw_new_character ( p_character [ new_charID ] );
      Window::draw_all();
//      draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
      answer = mnu_nbpoint.show (  10, 40, 0, true );

      extrapoints = answer + 1;

      tmpattrib = character .luck();
      tmpattrib = tmpattrib - extrapoints;
      character . luck ( tmpattrib );
      Window::refresh_all();

      sprintf ( tmpstr, "Where do you want to place %d Points ?", extrapoints );

      mnu_attribute.title ( tmpstr );
//      draw_new_character ( p_character [ new_charID ] );
      Window::draw_all();
//      draw_instruction ( Draw_INSTRUCTION_MENU + Draw_INSTRUCTION_SELECT, 200, 460 );
      answer = mnu_attribute.show (  10, 40, 0, true );

      tmpattrib = character .attribute ( answer );
      tmpattrib = tmpattrib + extrapoints;
      if ( tmpattrib > ( tmprace.attribute ( answer ) + 10 ) )
         tmpattrib = tmprace.attribute ( answer ) + 10;
      character . attribute ( answer, tmpattrib );
      Window::refresh_all();

   }

}

void Player::new_character_class ( Character &character )
{
   List lst_cclass ("Select a Class for your character", 15 );
   short i;
   tiny j;
   short answer;
   DBTag copytag [ 64 ];
   dword index;
   CClass tmpclass;
   bool mask_item;
   byte mask;

   index = db.search_table_entry ( DBTABLE_CCLASS );

   i = 0;
   while ( db.entry_table_tag ( index ) == DBTABLE_CCLASS )
   {
      mask_item = false;
      mask = 1;
      tmpclass.DBselect ( index );
      for ( j = 0 ; j < character.aligment() ; j++ )
         mask = mask << 1;
      if ( ( mask & tmpclass.aligment_allowed() ) == 0 )
         mask_item = true;
      lst_cclass.add_item ( tmpclass.name(), mask_item );
      copytag [ i ] = tmpclass.tag();
      i++;
      index++;
   }

   Window::draw_all();
   answer = lst_cclass.show (  10, 40, 0, true, true );

   character. cclass ( copytag [ answer ] );
   Window::refresh_all();
}
/*
void Player::new_character_element ( Character &character )
{

} */


/*-------------------------------------------------------------------------*/
/*-                        Virtual Functions                              -*/
/*-------------------------------------------------------------------------*/



void Player::objdat_to_strdat ( void *dataptr )
{
   dbs_Player &tmpdat = *(static_cast<dbs_Player*> ( dataptr ));

   tiny i;
   
   tmpdat.nb_character = p_nb_character;
   tmpdat.selected_party = p_selected_party;
   tmpdat.nb_party = p_nb_party;

   for ( i = 0 ; i < Player_NB_MAX_CHARACTER ; i++ )
      tmpdat.character [ i ] = p_character [ i ].number();
      
   for ( i = 0 ; i < 3 ; i++ )
      tmpdat.party [ i ] = p_party [ i ].number();
      
   tmpdat.account = p_account.number();
   tmpdat.game = p_game.number();
   tmpdat.default_city = p_default_city.number ();
   
}

void Player::strdat_to_objdat ( void *dataptr )
{
   dbs_Player &tmpdat = *(static_cast<dbs_Player*> ( dataptr ));
   
      tiny i;
   
      p_nb_character = tmpdat.nb_character;
      p_selected_party = tmpdat.selected_party;
      p_nb_party = tmpdat.nb_party;

      for ( i = 0 ; i < Player_NB_MAX_CHARACTER ; i++ )
         p_character [ i ].number( tmpdat.character [ i ] );
      
      for ( i = 0 ; i < 3 ; i++ )
         p_party [ i ].number( tmpdat.party [ i ] );
      
      p_account.number( tmpdat.account );
      p_game.number( tmpdat.game );
      p_default_city.number ( tmpdat.default_city );

}

void Player::child_DBremove ( void )
{
   tiny i;
   Character tmpchar;
   Party tmparty;

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      tmpchar.DBselect ( p_character [ i ] );
      tmpchar.DBremove();
   }

   for ( i = 0 ; i < p_nb_party ; i++ )
   {
      tmparty.DBselect ( p_party [ i ] );
      tmparty.DBremove();
   }

}







