/***************************************************************************/
/*                                                                         */
/*                            P A R T Y . C P P                            */
/*                            Class Source code                            */
/*                                                                         */
/*     Content : Class PArty source code                                   */
/*     Programmer : Eric Pietrocupo                                        */
/*     Stating Date : May 1st, 2002                                        */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <opponent.h>
#include <charactr.h>
#include <ennemy.h>
#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                    Constructor & Destructor                           -*/
/*-------------------------------------------------------------------------*/

Party::Party ( void )
{
   tiny i;

   reset_position ();
   destroy_all_spell ();

   p_nb_character = 0;
   for ( i = 0 ; i < 6 ; i++ )
   {
      p_character [ i ].number(0);
      p_combat_pos [ i ] = 0;
   }
   p_location.number ( 0 );
   p_status = Party_STATUS_RESERVE;

   p_dblength = sizeof ( dbs_Party );
   p_dbtableID = DBTABLE_PARTY;
//   p_player.number (0 );
//   p_game.number ( 0 );

/*   // to remove, spell icon testing
   for ( i = 0 ; i < Party_NB_SPELL ; i ++ )
      p_spell_duration [ i ] = 500;

   p_spell_duration [ Party_SPELL_FEAR ] = 0;
   p_spell_duration [ Party_SPELL_LIGHT ] = 0;*/

}

/*Party::Party ( const Party &tmpobj )
{
   tiny i;
   DBObject ( dynamic_cast<DBObject*>(tmpobj) );

   for ( i = 0 ; i < 6 ; i++ )
   {
      p_character [ i ] = tmpobj.p_character [ i ];
      p_combat_pos [ i ] = tmpobj.p_combat_pos [ i ];
   }
   
   p_pos = tmpobj.p_pos;
   for ( i = 0 ; i < Party_NB_SPELL ; i ++ )
      p_spell_duration [ i ] = tmpobj.p_spell_duration [ i ];

   p_nb_character = tmpobj.p_nb_character;
//   p_player = tmpobj.p_player;
//   p_game = tmpobj.p_game;

} */

Party::~Party ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                        Property Methods                               -*/
/*-------------------------------------------------------------------------*/

/*string& Party::name ( void )
{
   return ( p_name );
} */

const char* Party::name ( void )
{
   return ( p_name );
}

void Party::name ( const char *str )
{
   strncpy ( p_name, str, 31 );
}

DBTag Party::character ( tiny number )
{
   return ( p_character [ number ] );
}

tiny Party::rank ( tiny number )
{
   return ( p_combat_pos [ number ] );
}

void Party::rank ( tiny number, tiny rankID )
{
   p_combat_pos [ number ] = rankID;
}

s_Party_position Party::position ( void )
{
   return ( p_pos );
}

void Party::position ( s_Party_position position )
{
   p_pos = position;
}

void Party::position ( tiny x, tiny y, tiny z, tiny facing )
{
   p_pos.x = x;
   p_pos.y = y;
   p_pos.z = z;
   p_pos.facing = facing;
}

void Party::position ( tiny x, tiny y, tiny z )
{
   p_pos.x = x;
   p_pos.y = y;
   p_pos.z = z;
}

tiny Party::facing ( void )
{
   return ( p_pos.facing );
}

void Party::facing ( tiny side )
{
   p_pos.facing = side;
}

tiny Party::status ( void )
{
   return ( p_status );
}

void Party::status ( tiny value )
{
   p_status = value;
}

tiny Party::nb_character ( void )
{
   return ( p_nb_character );
}

short Party::spell_duration ( tiny spellID )
{
   return ( p_spell_duration [ spellID ] );
}

DBTag Party::location ( void )
{
   return ( p_location );
}

void Party::location ( DBTag value )
{
   p_location = value;
}


/*DBTag Party::player ( void )
{
   return ( p_player );
}
void Party::player ( DBTag value )
{
   p_player = value;
}
DBTag Party::game ( void )
{
   return ( p_game );
}
void Party::game ( DBTag value )
{
   p_game = value;
}

  */
/*-------------------------------------------------------------------------*/
/*-                             Methods                                   -*/
/*-------------------------------------------------------------------------*/

void Party::add_character ( DBTag character )
{
   if ( p_nb_character < 6 )
   {
      p_character [ p_nb_character ] = character;
      p_nb_character++;
   }
}

void Party::remove_character ( tiny number )
{
   p_character [ number ].number(0);
   compact_characters ();
   p_nb_character--;
}

void Party::remove_all_character ( void )
{
   tiny i;

   for ( i = 0 ; i < 6 ; i++ )
      p_character [ i ].number(0);
   
   p_nb_character = 0;
   
}

void Party::turn_left ( void )
{
   p_pos.facing--;
   
   if ( p_pos.facing < 0 )
      p_pos.facing = 3;

}

void Party::turn_right ( void )
{
   p_pos.facing++;

   if ( p_pos.facing > 3 )
      p_pos.facing = 0;

}

void Party::walk_forward ( void )
{
   switch ( p_pos.facing )
   {
      case Maze_FACE_NORTH :
         p_pos.y++;
      break;
               
      case Maze_FACE_EAST :
         p_pos.x++;
      break;
               
      case Maze_FACE_SOUTH :
         p_pos.y--;
      break;
               
      case Maze_FACE_WEST :
         p_pos.x--;
      break;
   }
}

void Party::walk_backward ( void )
{
   switch ( p_pos.facing )
   {
      case Maze_FACE_NORTH :
         p_pos.y--;
      break;
               
      case Maze_FACE_EAST :
         p_pos.x--;
      break;
               
      case Maze_FACE_SOUTH :
         p_pos.y++;
      break;
               
      case Maze_FACE_WEST :
         p_pos.x++;
      break;
   }
}

void Party::move_down ( void )
{
   p_pos.z++;
}

void Party::move_up ( void )
{
   p_pos.z--;
}

bool Party::test_front_wall ( byte solid )
{
   byte mask = Maze_SOLID_NORTH_MASK;

   switch ( p_pos.facing )
   {
      case Maze_FACE_NORTH :
         mask = Maze_SOLID_NORTH_MASK;
      break;
               
      case Maze_FACE_EAST :
         mask = Maze_SOLID_EAST_MASK;
      break;
               
      case Maze_FACE_SOUTH :
         mask = Maze_SOLID_SOUTH_MASK;
      break;
               
      case Maze_FACE_WEST :
         mask = Maze_SOLID_WEST_MASK;
      break;
   }

  if ( ( solid & mask ) > 0 )
     return ( true );
  else
     return ( false );

}

bool Party::test_front_door ( byte solid )
{
   byte mask = Maze_SOLID_NORTH_DOOR;

   switch ( p_pos.facing )
   {
      case Maze_FACE_NORTH :
         mask = Maze_SOLID_NORTH_DOOR;
      break;
               
      case Maze_FACE_EAST :
         mask = Maze_SOLID_EAST_DOOR;
      break;
               
      case Maze_FACE_SOUTH :
         mask = Maze_SOLID_SOUTH_DOOR;
      break;
               
      case Maze_FACE_WEST :
         mask = Maze_SOLID_WEST_DOOR;
      break;
   }

  if ( ( solid & mask ) == mask )
     return ( true );
  else
     return ( false );
}


void Party::decrement_duration ( short seconds )
{
   tiny i;

   for ( i = 0 ; i < Party_NB_SPELL ; i++ )
   {
      p_spell_duration [ i ] = p_spell_duration [ i ] - seconds;
      if ( p_spell_duration [ i ] < 0 )
         p_spell_duration [ i ] = 0;
   }
   
}

void Party::destroy_spell ( tiny spell_index )
{
   p_spell_duration [ spell_index ] = 0;
}

void Party::destroy_all_spell ( void )
{
   tiny i;

   for ( i = 0 ; i < Party_NB_SPELL ; i++ )
      p_spell_duration [ i ] = 0;

}

void Party::reset_position ( void )
{
   p_pos.x = 0;
   p_pos.y = 0;
   p_pos.z = 0;
   p_pos.facing = Party_FACE_NORTH;
}

void Party::rest ( tiny nb_days, tiny room_type )
{
   Character tmpchar;
   tiny i;

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      tmpchar.DBselect ( p_character [ i ] );
      tmpchar.rest ( nb_days, room_type );
      tmpchar.DBupdate();
   }
}

void Party::autoability ( void )
{
   Character tmpchar;
   tiny i;

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      tmpchar.DBselect ( p_character [ i ] );
      tmpchar.autoability ();
      tmpchar.DBupdate();
   }
}

tiny Party::combat_rank ( tiny characterID, tiny side )
{
   return ( 0 );
}

void Party::activesort_characters ( void )
{
   int i;
   int j;
   DBTag tmptag;
   Character tmpopp1; // sort also ennemies
   Character tmpopp2; // using opponent instead does not work
   tiny maxi = p_nb_character - 1;
   tiny maxj = p_nb_character;

   for ( i = 0 ; i < maxi ; i++ )
   {
      for ( j = i + 1 ; j < maxj ; j++ )
      {
//      if ( p_character [ i ] != 0 )
//      {

         tmpopp1.DBselect ( p_character [ i ] );
         tmpopp2.DBselect ( p_character [ j ] );

/*         textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
            "Character I:%d J:%d Ia:%d Ja:%d", i, j , tmpopp1.is_active(),
            tmpopp2.is_active() );
         textprintf ( buffer, font, 0, 16, General_COLOR_TEXT,
            "#:%d maxJ:%d maxJ:%d Is:%d Js:%d", p_nb_character, maxi, maxj ,tmpopp1.status(),
               tmpopp2.status() );
         textprintf ( buffer, font, 0, 32, General_COLOR_TEXT,
            "I : %s  %d  %s", tmpopp1.name(), tmpopp1.level(),
               STR_OPP_STATUS [ tmpopp1.status() ] );
         textprintf ( buffer, font, 0, 48, General_COLOR_TEXT,
            "J : %s  %d  %s", tmpopp2.name(), tmpopp2.level(),
               STR_OPP_STATUS [ tmpopp2.status() ] );

               
         copy_buffer();
         while ( ( readkey() >> 8 ) != KEY_ENTER );*/
         
         if ( tmpopp1.is_active() == false && tmpopp2.is_active() == true )
         {
//            debug ( "swap" );
            tmptag = p_character [ i ];
            p_character [ i ] = p_character [ j ];
            p_character [ j ] = tmptag;
         }
      }
   }
}


void Party::ennemy_rankprioritysort ( void )
{
   int i;
   int j;
   DBTag tmptag;
   Ennemy tmpopp1;
   Ennemy tmpopp2;
   tiny maxi = p_nb_character - 1;
   tiny maxj = p_nb_character;

   for ( i = 0 ; i < maxi ; i++ )
   {
      for ( j = i + 1 ; j < maxj ; j++ )
      {
         tmpopp1.DBselect ( p_character [ i ] );
         tmpopp2.DBselect ( p_character [ j ] );

         if ( tmpopp1.rankpriority() > tmpopp2.rankpriority() )
         {
            tmptag = p_character [ i ];
            p_character [ i ] = p_character [ j ];
            p_character [ j ] = tmptag;
         }
      }
   }

}
   
/*-------------------------------------------------------------------------*/
/*-                        Private Methods                                -*/
/*-------------------------------------------------------------------------*/

void Party::compact_characters ( void )
{

   int i;
   int j;

   for ( i = 0 ; i < 5 ; i++ )
   {
      if ( p_character [ i ] == 0 )
      {
         j = i + 1;
         while ( p_character [ j ] == 0 && j < 6 )
            j++;

         if ( p_character [ j ] != 0 )
         {
            p_character [ i ] = p_character [ j ];
            p_character [ j ].number(0);
         }
      }
   }
}

bool Party::is_functional ( void )
{
   bool retval = false;
   tiny i;
   Character tmpchar;

   for ( i = 0 ; i < p_nb_character ; i++ )
   {
      tmpchar.DBselect ( p_character [ i ] );
      if ( tmpchar.status() == Opponent_STATUS_ALIVE )
         retval = true;
   }
   
   return ( retval );
}

/*-------------------------------------------------------------------------*/
/*-                        Virtual Methods                                -*/
/*-------------------------------------------------------------------------*/

/*
DBTag Party::DBinsert ( void )
{
   dbs_Party tmpdat;
   DBTag tmptag;
   tiny i;

   strncpy ( tmpdat.name, p_name.data(), 30 );
   tmpdat.pos.x = p_pos.x;
   tmpdat.pos.y = p_pos.y;
   tmpdat.pos.z = p_pos.z;
   tmpdat.pos.facing = p_pos.facing;
   tmpdat.nb_character = p_nb_character;
//   tmpdat.player = p_player.number();
//   tmpdat.game = p_game.number();

   for ( i = 0 ; i < 6 ; i++ )
   {
      tmpdat.character [ i ] = p_character [ i ].number();
      tmpdat.combat_pos [ i ] = p_combat_pos [ i ];
   }
   for ( i = 0 ; i < Party_NB_SPELL ; i++ )
      tmpdat.spell_duration [ i ]= p_spell_duration [ i ];

   tmptag = db.insert ( DBTABLE_PARTY,
      static_cast<void*>(&tmpdat), sizeof ( dbs_Party ) );
   end_insert ( tmptag );

   return ( tmptag );
}

void Party::DBupdate ( void )
{
   if ( p_readonly == false )
   {
      dbs_Party tmpdat;
      tiny i;

      strncpy ( tmpdat.name, p_name.data(), 30 );
      tmpdat.pos.x = p_pos.x;
      tmpdat.pos.y = p_pos.y;
      tmpdat.pos.z = p_pos.z;
      tmpdat.pos.facing = p_pos.facing;
      tmpdat.nb_character = p_nb_character;
//      tmpdat.player = p_player.number();
//      tmpdat.game = p_game.number();

      for ( i = 0 ; i < 6 ; i++ )
      {
         tmpdat.character [ i ] = p_character [ i ].number();
         tmpdat.combat_pos [ i ] = p_combat_pos [ i ];
      }
      for ( i = 0 ; i < Party_NB_SPELL ; i++ )
         tmpdat.spell_duration [ i ]= p_spell_duration [ i ];

      db.update ( p_reftag,
         static_cast<void*>(&tmpdat), sizeof ( dbs_Party ) );
      end_update();
   }

}

void Party::DBselect ( DBTag value, bool readonly )
{
   dbs_Party tmpdat;
   if ( db.select ( &tmpdat, value, sizeof ( dbs_Party ) ) == true )
   {
      tiny i;

      p_name = tmpdat.name;
      p_pos.x = tmpdat.pos.x;
      p_pos.y = tmpdat.pos.y;
      p_pos.z = tmpdat.pos.z;
      p_pos.facing = tmpdat.pos.facing;
      p_nb_character = tmpdat.nb_character;
//      p_player.number( tmpdat.player );
//      p_game.number( tmpdat.game );


      for ( i = 0 ; i < 6 ; i++ )
      {
         p_character [ i ].number(tmpdat.character [ i ]);
         p_combat_pos [ i ] = tmpdat.combat_pos [ i ];
      }
      for ( i = 0 ; i < Party_NB_SPELL ; i++ )
         p_spell_duration [ i ] = tmpdat.spell_duration [ i ];
   
      end_select ( value, readonly );
   }
}

void Party::DBselect ( dword index, bool readonly )
{
   dbs_Party tmpdat;
   if ( db.select ( &tmpdat, index, sizeof ( dbs_Party ) ) == true )
   {
      tiny i;

      p_name = tmpdat.name;
      p_pos.x = tmpdat.pos.x;
      p_pos.y = tmpdat.pos.y;
      p_pos.z = tmpdat.pos.z;
      p_pos.facing = tmpdat.pos.facing;
      p_nb_character = tmpdat.nb_character;
//      p_player.number( tmpdat.player );
//      p_game.number( tmpdat.game );

      for ( i = 0 ; i < 6 ; i++ )
      {
         p_character [ i ].number(tmpdat.character [ i ]);
         p_combat_pos [ i ] = tmpdat.combat_pos [ i ];
      }
      for ( i = 0 ; i < Party_NB_SPELL ; i++ )
         p_spell_duration [ i ] = tmpdat.spell_duration [ i ];
   
      end_select ( db.get_tag ( index ), readonly );
   }
}

void Party::DBremove ( void )
{
   db.remove ( p_reftag );
   end_remove();
}

void Party::exDBselect ( Database &datb, dword index, bool readonly = false )
{
   dbs_Party tmpdat;
   if ( datb.select ( &tmpdat, index, sizeof ( dbs_Party ) ) == true )
   {
      tiny i;

      p_name = tmpdat.name;
      p_pos.x = tmpdat.pos.x;
      p_pos.y = tmpdat.pos.y;
      p_pos.z = tmpdat.pos.z;
      p_pos.facing = tmpdat.pos.facing;
      p_nb_character = tmpdat.nb_character;
//      p_player.number( tmpdat.player );
//      p_game.number( tmpdat.game );

      for ( i = 0 ; i < 6 ; i++ )
      {
         p_character [ i ].number(tmpdat.character [ i ]);
         p_combat_pos [ i ] = tmpdat.combat_pos [ i ];
      }
      for ( i = 0 ; i < Party_NB_SPELL ; i++ )
         p_spell_duration [ i ] = tmpdat.spell_duration [ i ];
   
      end_select ( datb.get_tag ( index ), readonly );
   }

}

void Party::exDBremove ( Database &datb )
{
   datb.remove ( p_reftag );
   end_remove();
}
                                                            */

void Party::objdat_to_strdat ( void *dataptr )
{
   dbs_Party &tmpdat = *(static_cast<dbs_Party*> ( dataptr ));

   tiny i;

   strncpy ( tmpdat.name, p_name, 31 );
   tmpdat.pos.x = p_pos.x;
   tmpdat.pos.y = p_pos.y;
   tmpdat.pos.z = p_pos.z;
   tmpdat.pos.facing = p_pos.facing;
   tmpdat.nb_character = p_nb_character;
   tmpdat.location = p_location.number();
   tmpdat.status = p_status;
//   tmpdat.player = p_player.number();
//   tmpdat.game = p_game.number();

   for ( i = 0 ; i < 6 ; i++ )
   {
      tmpdat.character [ i ] = p_character [ i ].number();
//      tmpdat.combat_pos [ i ] = p_combat_pos [ i ];
   }
   for ( i = 0 ; i < Party_NB_SPELL ; i++ )
      tmpdat.spell_duration [ i ]= p_spell_duration [ i ];
   
}

void Party::strdat_to_objdat ( void *dataptr )
{
   dbs_Party &tmpdat = *(static_cast<dbs_Party*> ( dataptr ));

      tiny i;

      strcpy ( p_name, tmpdat.name );
      p_pos.x = tmpdat.pos.x;
      p_pos.y = tmpdat.pos.y;
      p_pos.z = tmpdat.pos.z;
      p_pos.facing = tmpdat.pos.facing;
      p_nb_character = tmpdat.nb_character;
      p_location.number ( tmpdat.location );
      p_status = tmpdat.status;
//      p_player.number( tmpdat.player );
//      p_game.number( tmpdat.game );

      for ( i = 0 ; i < 6 ; i++ )
      {
         p_character [ i ].number(tmpdat.character [ i ]);
//         p_combat_pos [ i ] = tmpdat.combat_pos [ i ];
      }
      for ( i = 0 ; i < Party_NB_SPELL ; i++ )
         p_spell_duration [ i ] = tmpdat.spell_duration [ i ];

}

void Party::child_DBremove ( void )
{
   // no child to remove
}



