/***************************************************************************/
/*                                                                         */
/*                         O P T I O N . C P P                             */
/*                                                                         */
/*     Content : Class Option                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : May 12nd, 2002                                      */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                  Constructor and Destructor                           -*/
/*-------------------------------------------------------------------------*/

Option::Option ( void )
{
   strcpy ( p_title, "" );
//   p_font = font;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;
}

Option::Option ( const char* str )
{
//   string *tmp = new string;

//   *tmp = dat;

   strncpy ( p_title, str, 81 );
//   p_font = fnt;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;

//   delete tmp;

}
/*Option::Option ( string &str )
{
   p_title = str;
//   p_font = fnt;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;
} */

Option::~Option ( void )
{
   s_Option_item *tmp_ptr;
   s_Option_item *del_ptr;

   tmp_ptr = ptr_first;

   while ( tmp_ptr != NULL )
   {
      del_ptr = tmp_ptr;
      tmp_ptr = tmp_ptr -> ptr_next;
      free ( del_ptr );
   }

}

/*-------------------------------------------------------------------------*/
/*-                         Property Methods                              -*/
/*-------------------------------------------------------------------------*/

/*void Option::title ( string &str )
{
   p_title = str;
} */

void Option::title ( const char* str )
{
//   string *tmp = new string;

//   *tmp= dat ;

   strncpy ( p_title, str, 81 );

//   delete tmp;
}

/*void Option::quit ( string &str )
{
   p_quit = str;
} */

void Option::quit ( const char* str )
{
//   string *tmp = new string;

//   *tmp= dat ;

   strncpy ( p_quit, str, 51 );

//   delete tmp;
}

tiny Option::nb_item ()
{
   return ( p_nb_item );
}

tiny Option::nb_element ( tiny itemID )
{
   s_Option_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != itemID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

    if ( tmp_ptr != NULL )
         return ( tmp_ptr->nb_elem );
    else
       return ( 0 );

}


tiny Option::selected ( tiny itemID )
{
   s_Option_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != itemID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

   if ( tmp_ptr != NULL )
      return ( tmp_ptr->selected );
   else
      return ( 0 );

}

void Option::selected ( tiny itemID, tiny value )
{
   s_Option_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != itemID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

   if ( tmp_ptr != NULL )
      tmp_ptr->selected = value;
}

/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

   // Methods

/*void Option::add_item ( string &str, string &elem1, string &elem2,
           string &elem3, string &elem4, string &elem5, tiny selected = 0 )*/
void Option::add_item ( const char* str, const char* elem1, const char* elem2,
   const char* elem3, const char* elem4, const char* elem5, tiny selected )
           
{

   s_Option_item *ptr_new_item;
   tiny nb_elem;

   ptr_new_item = new s_Option_item;

   nb_elem = 2;
   strncpy ( ptr_new_item -> text, str, 51 );
   strncpy ( ptr_new_item -> elem [ 0 ], elem1, 31 );
   strncpy ( ptr_new_item -> elem [ 1 ], elem2, 31 );
   strncpy ( ptr_new_item -> elem [ 2 ], elem3, 31 );
   strncpy ( ptr_new_item -> elem [ 3 ], elem4, 31 );
   strncpy ( ptr_new_item -> elem [ 4 ], elem5, 31 );
   ptr_new_item -> selected = selected;

   if ( strcmp ( elem3, "" ) != 0 )
   {
      nb_elem++;

      if ( strcmp ( elem4, "" ) != 0 )
      {
         nb_elem++;

         if ( strcmp ( elem5, "" ) != 0 )
            nb_elem++;
      }
   }

   ptr_new_item -> nb_elem = nb_elem;

   if ( p_nb_item == 0 )
   {
      // insert the first item
      ptr_first = ptr_new_item;
      ptr_last = ptr_new_item;
      ptr_new_item -> ptr_next = NULL;
   }
   else
   {
      // add item at the end of the list
      ptr_last -> ptr_next = ptr_new_item;
      ptr_last = ptr_new_item;
      ptr_new_item -> ptr_next = NULL;
   }

   p_nb_item++;

}

/*
void Option::add_item ( const char* dat, const char* elem1, const char* elem2,
   const char* elem3, const char* elem4, const char* elem5, tiny selected )
{
   string* tmpdat = new string;
   string* tmpelem1 = new string;
   string* tmpelem2 = new string;
   string* tmpelem3 = new string;
   string* tmpelem4 = new string;
   string* tmpelem5 = new string;

   *tmpdat = dat;
   *tmpelem1 = elem1;
   *tmpelem2 = elem2;
   *tmpelem3 = elem3;
   *tmpelem4 = elem4;
   *tmpelem5 = elem5;

   add_item ( *tmpdat, *tmpelem1, *tmpelem2, *tmpelem3, *tmpelem4
      , *tmpelem5, selected );
   
   delete tmpdat;
   delete tmpelem1;
   delete tmpelem2;
   delete tmpelem3;
   delete tmpelem4;
   delete tmpelem5;

} */

void Option::show (  short x, short y )
{

   tiny font_height = text_height ( Option_FONT );
   tiny space = font_height / 2;
   s_Option_item *tmp_ptr;
   tiny cursor = 0;
//   string tmp_str;
   char kbvalue;
   short base_y = y;
   short yinc;
   bool rereadkb = false;
   tiny i;
   char format [ 81 ];
   bool exit_option = false;
   tiny j;
   bool option_changed = true;
   BITMAP* backbuf = create_bitmap ( 640, 480 );

   while ( exit_option == false )
   {


      if ( option_changed == true )
      {
         blit ( buffer, backbuf, 0, 0, 0, 0, 640, 480 );
         option_changed = false;
         if ( strcmp ( p_title, "" ) != 0 )
         {
            textprintf ( backbuf , Option_FONT, x, y, General_COLOR_TEXT,
               "   %s", p_title );
            base_y = y + font_height + space;
         }
         else
            base_y = y;

         tmp_ptr = ptr_first;
         yinc = base_y;

         for ( j = 0 ; j < p_nb_item ; j++ )
         {
            strcpy ( format, "   %-20s " );
            
            for ( i = 0 ; i < 5 ; i++ )
            {
               if ( i == tmp_ptr -> selected )
                  strcat ( format, "[%8s]" );
               else
                  strcat ( format, " %8s " );
            }
         
            textprintf ( backbuf, Option_FONT, x, yinc, General_COLOR_TEXT,
               format, tmp_ptr -> text,
               tmp_ptr -> elem [ 0 ],
               tmp_ptr -> elem [ 1 ],
               tmp_ptr -> elem [ 2 ],
               tmp_ptr -> elem [ 3 ],
               tmp_ptr -> elem [ 4 ] );

            yinc = yinc + font_height;
            tmp_ptr = tmp_ptr -> ptr_next;
         }

         textprintf ( backbuf, Option_FONT, x, yinc, General_COLOR_TEXT,
            "   %-20s", p_quit );

      }

      tmp_ptr = ptr_first;
      yinc = base_y;

      vsync ();
      blit ( backbuf, screen , 0 , 0 , 0 , 0 , 640 , 480 );

      for ( j = 0 ; j < p_nb_item ; j++ )
      {
         if ( j == cursor )
            textprintf ( screen, Option_FONT, x, yinc, General_COLOR_TEXT,
               "->" );

         yinc = yinc + font_height;
         tmp_ptr = tmp_ptr -> ptr_next;
      }

      if ( cursor == p_nb_item )
         textprintf ( screen, Option_FONT, x, yinc, General_COLOR_TEXT,
            "->" );


      // Keyboard reading

      rereadkb = true;

      while ( rereadkb == true )
      {
         kbvalue = readkey() >> 8;

         rereadkb = true;
         
         if ( kbvalue == SELECT_KEY )
         {
            if ( cursor == p_nb_item )
            {
               rereadkb = false;
               exit_option = true;
            }
         }

         if ( kbvalue == CANCEL_KEY )
         {
            rereadkb = false;
            exit_option = true;
         }


         if ( kbvalue == KEY_UP )
         {
            if ( cursor > 0 )
            {
               cursor--;
               rereadkb = false;
            }
         }

         if ( kbvalue == KEY_DOWN )
         {
            if ( cursor < p_nb_item )
            {
               cursor++;
               rereadkb = false;
            }
         }

         if ( kbvalue == KEY_LEFT )
         {
            select_left ( cursor );
            option_changed = true;
            rereadkb = false;
         }

         if ( kbvalue == KEY_RIGHT )
         {
            select_right ( cursor );
            option_changed = true;
            rereadkb = false;
         }
      }
   }

   destroy_bitmap ( backbuf );
   clear ( buffer );
}

/*-------------------------------------------------------------------------*/
/*-                         Private Methods                               -*/
/*-------------------------------------------------------------------------*/

void Option::select_right ( tiny itemID )
{
   s_Option_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != itemID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

   if ( tmp_ptr != NULL )
      if ( tmp_ptr -> selected < ( tmp_ptr -> nb_elem -1 ) )
        tmp_ptr -> selected++;

}

   
void Option::select_left ( tiny itemID )
{
   s_Option_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != itemID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

   if ( tmp_ptr != NULL )
      if ( tmp_ptr -> selected > 0 )
        tmp_ptr -> selected--;

}

