/***************************************************************************/
/*                                                                         */
/*                         M E N U . C P P                                 */
/*                                                                         */
/*     Content : Class Menu                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : March 14th , 2002                                   */
/*                                                                         */
/***************************************************************************/

#include <general.h>

//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>


/*-------------------------------------------------------------------------*/
/*-                  Constructor and Destructor                           -*/
/*-------------------------------------------------------------------------*/

Menu::Menu ( void )
{
   strcpy ( p_title, "" );
//   p_font = font;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;
}

Menu::Menu ( const char* str )
{
//   string *tmp = new string;

//   *tmp = dat;

   strncpy ( p_title, str , 81 );
//   p_font = fnt;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;

//   delete tmp;

}
/*Menu::Menu ( string &str )
{
   p_title = str;
//   p_font = fnt;
   p_nb_item = 0;
   ptr_first = NULL;
   ptr_last = NULL;
} */

Menu::~Menu ( void )
{
   s_Menu_item *tmp_ptr;
   s_Menu_item *del_ptr;

   tmp_ptr = ptr_first;

   while ( tmp_ptr != NULL )
   {
      del_ptr = tmp_ptr;
      tmp_ptr = tmp_ptr -> ptr_next;
      free ( del_ptr );
   }

}

/*-------------------------------------------------------------------------*/
/*-                         Property Methods                              -*/
/*-------------------------------------------------------------------------*/


/*void Menu::title ( string &str )
{
   p_title = str;
} */

void Menu::title ( const char* str )
{
//   string *tmp = new string;

//   *tmp= dat ;

   strncpy ( p_title, str, 81 );

//   delete tmp;
}

const char* Menu::title ( void )
{
   return ( p_title );
}

tiny Menu::nb_item ()
{
   return ( p_nb_item );
}

/*void Menu::textfont ( FONT *fnt )
{
   p_font = fnt;
}*/

short Menu::char_width ( void )
{
   short max_width = strlen ( p_title );
   short tmp_width;
   s_Menu_item *tmp_ptr;

   tmp_ptr = ptr_first;

   while ( tmp_ptr != NULL )
   {
      tmp_width = strlen ( tmp_ptr->text );
      if ( tmp_width > max_width )
         max_width = tmp_width;
      
      tmp_ptr = tmp_ptr -> ptr_next;
   }

   max_width = max_width + 3;

   return ( max_width );

}

/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

void Menu::add_item ( const char* str, bool mask )
{

   s_Menu_item *ptr_new_item;

   ptr_new_item = new s_Menu_item;
//   ptr_new_item = (s_Menu_item*) malloc ( sizeof (s_Menu_item) );

   strncpy ( ptr_new_item -> text, str, 51 );
   ptr_new_item -> mask = mask;

   if ( p_nb_item == 0 )
   {
      // insert the first item
      ptr_first = ptr_new_item;
      ptr_last = ptr_new_item;
      ptr_new_item -> ptr_next = NULL;
   }
   else
   {
      // add item at the end of the list
      ptr_last -> ptr_next = ptr_new_item;
      ptr_last = ptr_new_item;
      ptr_new_item -> ptr_next = NULL;
   }

   p_nb_item++;

}

/*void Menu::add_item ( const char* dat, bool mask)
{
//   string* tmp = new string;

//   *tmp = dat;

   add_item ( dat, mask );
//   delete tmp;
} */

void Menu::mask_item ( tiny ID )
{

   s_Menu_item *tmp_ptr;
   tiny count = 0;

   tmp_ptr = ptr_first;

   while ( count != ID && tmp_ptr != NULL )
   {
      tmp_ptr = tmp_ptr -> ptr_next;
      count++;
   }

    if ( count == ID )
         tmp_ptr -> mask = true;

}

void Menu::unmask_all_item ( void )
{
   s_Menu_item *tmp_ptr;

   tmp_ptr = ptr_first;

   while ( tmp_ptr != NULL )
   {
      tmp_ptr -> mask = FALSE;
      
      tmp_ptr = tmp_ptr -> ptr_next;
   }
}

short Menu::show ( short x, short y, tiny position, bool nocancel )
{
   tiny font_height = text_height ( Menu_FONT );
   tiny space = font_height / 2;
   s_Menu_item *tmp_ptr;
   tiny cursor = position;
   tiny item_count = 0;
//   String tmp_str;
   char kbvalue;
   short base_y;
   short yinc;
   tiny answer = position;
   bool answer_found = false;
   bool rereadkb = false;
   bool selected_masked = false;
   int clr = Menu_COLOR_TEXT;
//   string tmpstr;

   if ( cursor < 0 )
      cursor = 0;

   char shotstr [ 8 ] [ 13 ]= { "mnushot1.bmp", "mnushot2.bmp", "mnushot3.bmp",
      "mnushot4.bmp", "mnushot5.bmp", "mnushot6.bmp", "mnushot7.bmp", "mnushot8.bmp" };
   static tiny shotID = 0;
      

   if ( strcmp ( p_title, "" ) != 0 )
   {
      textprintf ( buffer , Menu_FONT, x, y, Menu_COLOR_TEXT,
         "   %s", p_title );
      base_y = y + font_height + space;
   }
   else
      base_y = y;

   yinc = base_y;
   tmp_ptr = ptr_first;
   item_count = 0;
   selected_masked = false;

   while ( tmp_ptr != NULL )
   {
      if ( tmp_ptr -> mask == true )
         clr = Menu_COLOR_MASK;
      else
         clr = Menu_COLOR_TEXT;
      
//      if ( item_count == cursor )
//      {
//            textprintf ( screen, Menu_FONT, x, yinc, clr, "-> %s",
//               tmp_ptr -> text.data() );
//            selected_masked = tmp_ptr->mask;
//         }
//         else
//         {
      textprintf ( buffer, Menu_FONT, x, yinc, clr, "   %s",
         tmp_ptr -> text );
//         }

      yinc = yinc + font_height;
//         item_count++;
      tmp_ptr = tmp_ptr -> ptr_next;
   }

   clear_keybuf();

   clr = Menu_COLOR_TEXT;
   while ( answer_found == false )
   {
      yinc = base_y;
      tmp_ptr = ptr_first;
      item_count = 0;
      selected_masked = false;

      vsync ();
      blit ( buffer, screen , 0 , 0 , 0 , 0 , 640 , 480 );

      while ( tmp_ptr != NULL )
      {
//         if ( tmp_ptr -> mask == true )
//            clr = Menu_COLOR_MASK;
//         else
//            clr = Menu_COLOR_TEXT;
      
         if ( item_count == cursor )
         {
            textprintf ( screen, Menu_FONT, x, yinc, clr, "->" );
            selected_masked = tmp_ptr->mask;
         }
//         else
//         {
//            textprintf ( screen, Menu_FONT, x, yinc, clr, "   %s",
//               tmp_ptr -> text.data() );
//         }

         yinc = yinc + font_height;
         item_count++;
         tmp_ptr = tmp_ptr -> ptr_next;
      }

      // Keyboard reading

      rereadkb = true;

      while ( rereadkb == true )
      {
         kbvalue = readkey() >> 8;
         clear_keybuf();

         rereadkb = true;


         if ( kbvalue == SELECT_KEY )
         {
            if ( selected_masked == false )
            {
               answer = cursor;
               rereadkb = false;
               answer_found = true;
            }
         }
         
         if ( kbvalue == CANCEL_KEY )
         {
            if ( nocancel == true )
               rereadkb = true;
            else
            {
               answer = -1;
               rereadkb = false;
               answer_found = true;
            }
         }

         if ( kbvalue == KEY_UP )
         {
            if ( cursor > 0 )
            {
               cursor--;
               rereadkb = false;
            }
         }

         if ( kbvalue == KEY_DOWN )
         {
            if ( cursor < ( p_nb_item - 1) )
            {
               cursor++;
               rereadkb = false;
            }
         }

         if ( kbvalue == KEY_SPACE )
         {
            make_screen_shot ( shotstr [ shotID ] );
            shotID++;
         }
      }
   }
//?? implement masking

   clear ( buffer );
   return ( answer );
}


void Menu::draw ( short x, short y )
{
   tiny font_height = text_height ( Menu_FONT );
   tiny space = font_height / 2;
   s_Menu_item *tmp_ptr;
   short base_y;

   if ( strcmp ( p_title, "") != 0 )
   {
      textprintf ( buffer , Menu_FONT, x, y, Menu_COLOR_TEXT,
         "   %s", p_title );
      base_y = y + font_height + space;
   }
   else
      base_y = y;


   tmp_ptr = ptr_first;
   y = base_y;

   while ( tmp_ptr != NULL )
   {
      textprintf ( buffer, Menu_FONT, x, y, Menu_COLOR_TEXT, "   %s",
         tmp_ptr -> text );

      y = y + font_height;
      tmp_ptr = tmp_ptr -> ptr_next;
   }

   vsync ();
   blit ( buffer, screen , 0 , 0 , 0 , 0 , 640 , 480 );

}
