/***************************************************************************/
/*                                                                         */
/*                             M A Z E . C P P                             */
/*                                                                         */
/*     Content : Class Maze                                                */
/*     Programmer : Eric PIetrocupo                                        */
/*     Starting Date : March 18th, 2002                                    */
/*                                                                         */
/***************************************************************************/

#include <general.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <player.h>
#include <game.h>
#include <account.h>
//#include <city.h>
#include <maze.h>
#include <editor.h>
#include <encountr.h>
#include <mazeproc.h>
//#include <adventur.h>
//#include <camp.h>
#include <config.h>
#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winquest.h>
#include <winmessa.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>

/*-------------------------------------------------------------------------*/
/*-                      Constructor & Destructor                         -*/
/*-------------------------------------------------------------------------*/

Maze::Maze ( void /* maze data ( not file ) */ )
{
   s_Maze_tile tile;
   s_Maze_event event;
   short i;
   short j;
   short k;

   p_dblength = sizeof ( dbs_Maze_data );
   p_dbtableID = DBTABLE_MAZE;


   p_polytype = POLYTYPE_PTEX_LIT;
   p_mask_polytype = POLYTYPE_PTEX_LIT;
   p_display = Maze_DISPLAY_LAST_ITEM - 1;
   p_transparency = false;
   p_adjust_color = false;

   p_xpos = 0;
   p_ypos = 0;
   p_mapID = 0;

/*   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
      p_warp [ i ]. number ( 0 );*/

   for ( i = 0 ; i < Maze_NB_SAVEVALUE ; i++ )
      p_savevalue [ i ] = 0;

   s_Maze_alteration altempty;

   altempty.xpos = 0;
   altempty.ypos = 0;
   altempty.zpos = 0;
   altempty.savevalueID = 0;
   altempty.change = 0;
   altempty.info.solid = 0;
   altempty.info.walltex = 0;
   altempty.info.floortex = 0;
   altempty.info.objectimg = 0;
   altempty.info.event = 0;
   altempty.info.special = 0;
   altempty.info.texture = 0;

   for ( i = 0 ; i < Maze_NB_ALTERATION ; i++ )
      p_alteration [ i ] = altempty;

   p_width = 50;
   p_depth = 50;
   p_sky = -1;
   strcpy ( p_name, "" );
   strcpy ( p_shortname, "");

   p_rclevel = 0;
   p_startpos.x = 0;
   p_startpos.y = 0;
   p_startpos.z = 0;
   p_startpos.facing = Party_FACE_NORTH;

   p_music = System_MUSIC_w2dungon;
   p_eprob = Encounter_PROBABILITY_NORMAL;
   p_ebase = 1;
   p_erange = 2;
   p_einc = 2;

   // emptying all the data struct of the maze
   tile.walltex = 0;
   tile.floortex = 0;
   tile.objectimg = 0;
   tile.event = 0;
   tile.special = Maze_SPECIAL_SOLID;
   tile.texture = 0;
   tile.solid = 0;

   // maybe remove, set only when loading maze
   for ( k = 0 ; k < Maze_MAXDEPTH; k++ )
      for ( j = 0 ; j < Maze_MAXWIDTH; j++ )
         for ( i = 0 ; i < Maze_MAXWIDTH; i++ )
            mazetile [ k ] [ i ] [ j ] = tile;

   tile.special = 0;

/*   for ( i = 0 ; i < Maze_NB_TEXTURESET ; i++ )
      for ( j = 0 ; j < 4 ; j++ )
         p_texset [ i ] [ j ] = NULL;

   for ( i = 0 ; i < Maze_NB_MASKTEX ; i++ )
      p_masktex [ i ] = NULL;

   for ( i = 0 ; i < Maze_NB_OBJECTIMG ; i++ )
      p_objimg [ i ] = NULL;*/

   event.type = 0;
   strcpy ( event.title, "" );
   strcpy ( event.message, "" );
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = 0;

   for ( i = 0 ; i < Maze_NB_EVENT ; i++ )
//      for ( j = 0 ; j < Maze_DEPTH ; j++ )
      p_event [ i ] = event;

   // temporary hardcoded maze

//   p_name = "Wizardry Demo";
//   p_shortname = "Wiz Demo";

//   byte solid;   // 4bit door wall | 4 bit wall
//   byte walltex; // masked wall texture ID
//   byte floortex; // masked floor texture ID
//   byte objectimg; // room object image ID
//   byte event; // event ID for the maze ( or the floor ) ( 0 = no event )
//   byte special; // 5 bit technical info ; 3 bit filling info
//   word texture; // 2 bit mask floor/ceiling :  4 bit mask wall,


/*   tile.solid = WWEST + WSOUTH ;
   tile.floortex = 38;
   tile.objectimg = 63;
   tile.event = 1; // maze exit
   tile.texture = 0 + Maze_FLOOR_MTEX_UP +  Maze_OBJECT_CENTER;
   mazetile [ 0 ] [ 0 ] [ 0 ] = tile;
   tile.texture = 0;
   tile.event = 0;
   tile.floortex = 0;
   tile.objectimg = 0;

   tile.solid = WSOUTH;
   tile.event = 14;
   mazetile [ 0 ] [ 0 ] [ 1 ] = tile;
   tile.event = 0;

   tile.solid = WSOUTH + WNORTH + WEAST;
   mazetile [ 0 ] [ 0 ] [ 2 ] = tile;
   
   tile.solid = WWEST + WEAST;
   tile.event = 4;
   mazetile [ 0 ] [ 1 ] [ 0 ] = tile;
   tile.event = 0;

   tile.solid = WWEST + WEAST + WNORTH;
   tile.floortex = 5;
   tile.objectimg = 5;
   tile.walltex = 21;
   tile.texture = 0 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_4CORNER +
      Maze_WALL_MTEX_NORTH;
   mazetile [ 0 ] [ 1 ] [ 1 ] = tile;
   tile.floortex = 0;
   tile.objectimg = 0;
   tile.texture = 0;

   tile.solid = WWEST + WEAST;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.walltex = 3;
   tile.floortex = 34;
   tile.texture = 0 + Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_WEST
      + Maze_WALL_MTEX_EAST;
   mazetile [ 0 ] [ 2 ] [ 0 ] = tile;
   tile.special = 0;

   tile.solid = WWEST + WEAST + DNORTH;
   tile.objectimg = 0;
   tile.texture = 0 + Maze_OBJECT_TWINN;
   tile.event = 5;
   mazetile [ 0 ] [ 3 ] [ 0 ] = tile;
   tile.texture = 2;
   tile.event = 0;

   tile.solid = WWEST + WEAST + WSOUTH;
   tile.event = 6;
   mazetile [ 0 ] [ 4 ] [ 0 ] = tile;
   tile.event = 0;

   tile.solid = WWEST + WNORTH;
   tile.walltex = 19;
   tile.texture = 2 + Maze_WALL_MTEX_WEST;
   tile.event = 7;
   mazetile [ 0 ] [ 5 ] [ 0 ] = tile;
   tile.event = 0;
   tile.walltex = 0;
   tile.texture = 2;

   tile.solid = WNORTH + WSOUTH;
   tile.floortex = 35;
   tile.texture = 2 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_CENTER;
   tile.objectimg = 54;
   tile.special = Maze_SPECIAL_LIGHT;
   mazetile [ 0 ] [ 5 ] [ 1 ] = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 2;


   tile.solid = WNORTH + WSOUTH;
   mazetile [ 0 ] [ 5 ] [ 2 ] = tile;

   tile.solid = WNORTH + WSOUTH + WWEST;
   tile.event = 8;
   mazetile [ 0 ] [ 5 ] [ 3 ] = tile;
   tile.event = 0;

   tile.solid = WNORTH + WSOUTH;
   mazetile [ 0 ] [ 5 ] [ 4 ] = tile;

   tile.solid = WSOUTH + WEAST;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.objectimg = 6;
   tile.floortex = 34;
   tile.texture = 2 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_TWINN;
   mazetile [ 0 ] [ 5 ] [ 5 ] = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 2;

   tile.solid = WWEST + WEAST;
   tile.event = 9;   
   mazetile [ 0 ] [ 6 ] [ 5 ] = tile;
   tile.event = 0;   

      // rotator room
   tile.solid = WWEST + WSOUTH;
   tile.texture = 3;
   mazetile [ 0 ] [ 7 ] [ 4 ] = tile;
   
   tile.solid = WSOUTH;
   mazetile [ 0 ] [ 7 ] [ 5 ] = tile;


   tile.solid = WEAST + WSOUTH;
   mazetile [ 0 ] [ 7 ] [ 6 ] = tile;

   tile.solid = 0;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.floortex = 37;
   tile.objectimg = 8;
   tile.texture = 3 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_CENTER;
   mazetile [ 0 ] [ 8 ] [ 4 ] = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 3;

   tile.solid = 0;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.objectimg = 5;
   tile.event = 3;
   tile.texture = 3 + Maze_OBJECT_WEST;
   mazetile [ 0 ] [ 8 ] [ 5 ] = tile;
   tile.special = 0;
   tile.objectimg = 0;
   tile.texture = 3;
   tile.event = 0;

   tile.solid = WEAST;
   mazetile [ 0 ] [ 8 ] [ 6 ] = tile;

   tile.solid = WWEST + WNORTH;
   mazetile [ 0 ] [ 9 ] [ 4 ] = tile;
   
   tile.solid = GNORTH;
   tile.walltex = 42;
   mazetile [ 0 ] [ 9 ] [ 5 ] = tile;
   tile.walltex = 0;

   tile.solid = WEAST + WNORTH;
   mazetile [ 0 ] [ 9 ] [ 6 ] = tile;

   tile.solid = DNORTH + WWEST + WEAST + GSOUTH;
   tile.walltex = 42;
   mazetile [ 0 ] [ 10 ] [ 5 ] = tile;
   tile.walltex = 0;

      // end rotator room

   tile.texture = 5;
   tile.solid = WSOUTH + WNORTH;
   mazetile [ 0 ] [ 8 ] [ 3 ] = tile;

   tile.solid = WSOUTH + WNORTH;
   mazetile [ 0 ] [ 8 ] [ 2 ] = tile;

   tile.solid = WSOUTH + WWEST;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.floortex = 34;
   tile.walltex = 3;
   tile.texture = 5 + Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_SOUTH
      + Maze_WALL_MTEX_WEST;
   mazetile [ 0 ] [ 8 ] [ 1 ] = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 5;

   tile.solid = WWEST + WEAST;
   tile.event = 10;
   mazetile [ 0 ] [ 9 ] [ 1 ] = tile;
   tile.event = 0;
   
      // poison gas room

   tile.texture = 9;
   tile.solid = WWEST + WSOUTH;
   tile.special = Maze_SPECIAL_POISON_GAS;
   mazetile [ 0 ] [ 10 ] [ 0 ]  = tile;

   tile.solid = WSOUTH;
   mazetile [ 0 ] [ 10 ] [ 1 ]  = tile;

   tile.solid = WSOUTH + WEAST;
   mazetile [ 0 ] [ 10 ] [ 2 ]  = tile;
   
   tile.solid = WWEST;
   mazetile [ 0 ] [ 11 ] [ 0 ]  = tile;

   tile.solid = 0;
   mazetile [ 0 ] [ 11 ] [ 1 ]  = tile;

   tile.solid = WEAST;
   mazetile [ 0 ] [ 11 ] [ 2 ]  = tile;

   tile.solid = WWEST + WNORTH;
   mazetile [ 0 ] [ 12 ] [ 0 ]  = tile;

   tile.solid = 0;
   tile.special = Maze_SPECIAL_POISON_GAS + Maze_SPECIAL_LIGHT;
   tile.floortex = 34;
   tile.objectimg = 54;
   tile.texture = 9 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_CENTER;
   mazetile [ 0 ] [ 12 ] [ 1 ]  = tile;
   tile.special = Maze_SPECIAL_POISON_GAS;
   tile.floortex = 0;
   tile.texture = 9;

   tile.solid = WNORTH + WEAST;
   mazetile [ 0 ] [ 12 ] [ 2 ]  = tile;
   tile.special = 0;
      // end of poison gas room

   tile.texture = 7;
   tile.solid = WWEST + WEAST;
   mazetile [ 0 ] [ 13 ] [ 1 ]  = tile;

   tile.solid = WWEST + WNORTH;
   mazetile [ 0 ] [ 14 ] [ 1 ]  = tile;

   tile.solid = WNORTH + WSOUTH;
   mazetile [ 0 ] [ 14 ] [ 2 ]  = tile;

   tile.solid = WNORTH + WSOUTH;
   tile.event = 11;
   mazetile [ 0 ] [ 14 ] [ 3 ]  = tile;
   tile.event = 0;

      // dark corridor
   tile.solid = WNORTH + WSOUTH;
   tile.special = Maze_SPECIAL_DARKNESS;
   mazetile [ 0 ] [ 14 ] [ 4 ]  = tile;

   tile.solid = WNORTH + WSOUTH;
   mazetile [ 0 ] [ 14 ] [ 5 ]  = tile;

   tile.solid = WNORTH + WSOUTH;
   mazetile [ 0 ] [ 14 ] [ 6 ]  = tile;
   tile.special = 0;
      // end of dark corridor

   tile.solid = WNORTH + WSOUTH;
   tile.texture = 1;
   mazetile [ 0 ] [ 14 ] [ 7 ]  = tile;

   tile.solid = WNORTH + WEAST;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.floortex = 36;
   tile.objectimg = 53;
   tile.texture = 1 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_4CORNER;
   mazetile [ 0 ] [ 14 ] [ 8 ]  = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 1;
   
   
   tile.solid = WWEST + WEAST;
   tile.event = 12;
   mazetile [ 0 ] [ 13 ] [ 8 ]  = tile;
   tile.event = 0;

      // special xyz room

   tile.solid = WWEST + WNORTH;
   tile.floortex = 24;
   tile.walltex = 17;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_WEST;
   mazetile [ 0 ] [ 12 ] [ 7 ]  = tile;
   tile.texture = 1 + Maze_FLOOR_MTEX_DOWN;

   tile.solid = WNORTH;
   mazetile [ 0 ] [ 12 ] [ 8 ]  = tile;

   tile.solid = WEAST + WNORTH;
   tile.walltex = 33;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_NORTH;
   mazetile [ 0 ] [ 12 ] [ 9 ]  = tile;
   tile.floortex = 0;
   tile.texture = 1;

   tile.solid = DWEST;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.floortex = 37;
   tile.objectimg = 52;
   tile.texture = 1 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_TWINW;
   mazetile [ 0 ] [ 11 ] [ 7 ]  = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.texture = 1;
   

   tile.solid = 0;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.floortex = 10;
   tile.objectimg = 10;
   tile.texture = 1 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_CENTER;
   mazetile [ 0 ] [ 11 ] [ 8 ]  = tile;
   tile.special = 0;
   tile.floortex = 0;
   tile.objectimg = 0;
   tile.texture = 1;
   

   tile.solid = WEAST;
   tile.floortex = 24;
   tile.walltex = 17;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_EAST;
   mazetile [ 0 ] [ 11 ] [ 9 ]  = tile;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN;

   tile.solid = WWEST + WSOUTH;
   tile.walltex = 33;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_WEST;
   mazetile [ 0 ] [ 10 ] [ 7 ]  = tile;

   tile.solid = WSOUTH;
   tile.walltex = 17;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_SOUTH;
   mazetile [ 0 ] [ 10 ] [ 8 ]  = tile;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN;
   
   tile.solid = WEAST + WSOUTH;
   tile.walltex = 33;
   tile.texture = 1 +  Maze_FLOOR_MTEX_DOWN + Maze_WALL_MTEX_SOUTH
      + Maze_WALL_MTEX_EAST;

   mazetile [ 0 ] [ 10 ] [ 9 ]  = tile;
   tile.floortex = 0;
   tile.texture = 1;

      // end of special xyz room

   tile.texture = 8;
   tile.solid = WSOUTH + WNORTH + DEAST;
   mazetile [ 0 ] [ 11 ] [ 6 ]  = tile;

   tile.solid = WSOUTH + WNORTH;
   tile.event = 13;
   mazetile [ 0 ] [ 11 ] [ 5 ]  = tile;
   tile.event = 0;

   tile.solid = WSOUTH + WWEST + WNORTH;
   tile.floortex = 1;
   tile.special = Maze_SPECIAL_LIGHT;
   tile.objectimg = 45;
   tile.event = 2; // teleporter
   tile.walltex = 2;
   tile.texture = 8 + Maze_FLOOR_MTEX_DOWN + Maze_OBJECT_CENTER +
      Maze_WALL_MTEX_NORTH + Maze_WALL_MTEX_SOUTH + Maze_WALL_MTEX_WEST;
   mazetile [ 0 ] [ 11 ] [ 4 ]  = tile;
   tile.floortex = 0;
   tile.objectimg = 0;
   tile.texture = 8;
   tile.walltex = 0;
*/
   // hardcoded events

/*   event.type = Maze_EVENT_EXIT;
   event.title = "Ladder Up";
   event.message = "There is a ladder going up^Do You want to use it ?";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK + Maze_EVENT_TRIGICON_UP;
   p_event [ 1 ] = event;
   
   event.type = Maze_EVENT_TELEPORTER;
   event.title = "";
   event.message = "";
   event.text = 0;
   event.var [ Maze_EVTPORT_XPOS ] = 2;
   event.var [ Maze_EVTPORT_YPOS ] = 0;
   event.var [ Maze_EVTPORT_ZPOS ] = 0;
   event.var [ Maze_EVTPORT_FACE ] = Maze_FACE_WEST;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK + Maze_EVENT_TRIGICON_DOWN;
   p_event [ 2 ] = event;

   event.type = Maze_EVENT_ROTATOR;
   event.title = "";
   event.message = "";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK + Maze_EVENT_TRIGICON_DOWN;
   p_event [ 3 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 1";
   event.message = "Welcome to the Wizardry legacy demo maze^Walk foward and follow instructions $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 4 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 2";
   event.message = "This is a door. You can open doors^by pressing the SELECT button $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 5 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 3";
   event.message = "Move foward and turn left and you will be able^to read the message on the left wall $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 6 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Wall Inscription";
   event.message = "The floor arrows will guide you through this maze $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_FACEWEST;
   p_event [ 7 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 4";
   event.message = "If you turn around, you will realise that you^have crossed a one way wall. Watch out!^continue and follow the arrows. $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 8 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 5";
   event.message = "In the middle of the room, there is a rotator.^The chain will help you to know which way you have turned. $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 9 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 6";
   event.message = "The room ahead is filled with poison gas.^Walk through the room. $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 10 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 7";
   event.message = "The corridor ahead is filled with magikal darkness^Just move constantly foward and you'll reach ^ the end of the corridor $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 11 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 9";
   event.message = "There is currently nothing interesting in the room.^ontinue to the right. $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 12 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 10";
   event.message = "If you walk foward, you will enter a^teleportation device that will send you^elsewhere in the maze. $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 13 ] = event;

   event.type = Maze_EVENT_MESSAGE;
   event.title = "Divine Message 11";
   event.message = "The demo is over. Walk foward to exit the maze $ allo";
   event.text = 0;
   event.var [ 0 ] = 0;
   event.var [ 1 ] = 0;
   event.var [ 2 ] = 0;
   event.var [ 3 ] = 0;
   event.savevalID = 0;
   event.trigger = Maze_EVENT_TRIGGER_WALK;
   p_event [ 14 ] = event;                      */

}

Maze::~Maze ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                          Property Methods                             -*/
/*-------------------------------------------------------------------------*/

/*string& Maze::name ( void )
{
   return ( p_name );
} */

const char* Maze::name ( void )
{
   return ( p_name );
}

/*string& Maze::shortname ( void )
{
   return ( p_shortname );
} */

const char* Maze::shortname ( void )
{
   return ( p_shortname );
}

short Maze::xpos ( void )
{
   return ( p_xpos );
}

short Maze::ypos ( void )
{
   return ( p_ypos );
}

tiny Maze::type ( void )
{
   return ( p_type );
}

tiny Maze::mapID ( void )
{
   return ( p_mapID );
}
/*
DBTag Maze::warp ( tiny index )
{
   return ( p_warp [ index ] );
}

dword Maze::target ( tiny index )
{
   return ( p_target [ index ] );
} */

tiny Maze::eprob ( void )
{
   return ( p_eprob );
}

tiny Maze::ebase ( void )
{
   return ( p_ebase );
}
tiny Maze::erange ( void )
{
   return ( p_erange );
}
tiny Maze::einc ( void )
{
   return ( p_einc );
}


DBTag Maze::exitwarptag ( tiny exitval )
{
   tiny index;

   index = exitval - Maze_BASE_EXIT;

   return ( p_warp [ index ] . tag );
}

void Maze::polytype ( short type )
{
   p_polytype = type;
}

short Maze::polytype ( void )
{
   return ( p_polytype );
}

void Maze::mask_polytype ( short type )
{
   p_mask_polytype = type;
}

short Maze::mask_polytype ( void )
{
   return ( p_mask_polytype );
}

byte Maze::display ( void )
{
   return ( p_display );
}

void Maze::display ( byte value )
{
   p_display = value;
}

void Maze::transparency ( bool value )
{
   p_transparency = value;
}

bool Maze::transparency ( void )
{
   return ( p_transparency );
}

void Maze::adjust_color ( bool value )
{
   p_adjust_color = value;
}

bool Maze::adjust_color ( void )
{
   return ( p_adjust_color );
}

s_Party_position Maze::start_position ( void )
{
   return ( p_startpos );
}

/*-------------------------------------------------------------------------*/
/*-                            Methods                                    -*/
/*-------------------------------------------------------------------------*/

tiny Maze::start ( DBTag party )
{
   tiny maze_interrupt = Maze_CONTINUE;
   tiny tmp_key = KEY_ESC;
   byte tmp_solid;
   s_Maze_tile tmptile;
   bool ouch = false;
   bool draw = true;
   bool eventodo = false;
   s_Party_position tpos;
   tiny fog;
   bool encountval = false;
   bool checkencounter = false;
   bool dooropened = false;
   WinTitle wttl_ouch ( "Ouch!", 320, 208 );

   wttl_ouch.hide();

   p_party.DBselect ( party );

   WinData<Party> wdat_party_bar ( WDatProc_party_bar, p_party,
     WDatProc_POSITION_PARTY_BAR );

//   tiny tmplight = Maze_LIGHT_LEVEL_3;
//   light ( tmplight );
   
// variable used for screenshot
   char shotstr [ 8 ] [ 13 ]= { "mazshot1.bmp", "mazshot2.bmp", "mazshot3.bmp",
      "mazshot4.bmp", "mazshot5.bmp", "mazshot6.bmp", "mazshot7.bmp", "mazshot8.bmp" };
   tiny shotID = 0;

   play_music_track ( p_music );

   draw = true;

   while ( maze_interrupt == Maze_CONTINUE )
   {
      if ( draw == true )
      {
         tpos = p_party.position ();
         tmptile = mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ] ;
         // set light level
         if ( ( tmptile.special & Maze_SPECIAL_FILL_MASK ) == Maze_SPECIAL_FOG )
            fog = 1;
         else
            fog = 0;

         if ( ( tmptile.special & Maze_SPECIAL_DARKNESS ) != Maze_SPECIAL_DARKNESS )
         {
            if ( p_party.spell_duration ( Party_SPELL_LIGHT ) > 0 )
               light ( Maze_LIGHT_LEVEL_3 - fog );
            else
               light ( Maze_LIGHT_LEVEL_2 - fog );
         }
         else
         {
            light ( Maze_LIGHT_LEVEL_0 );
         }
      
         draw_maze ();

         // hide or unhide icons and party bar in the maze
         if ( ( p_display & Maze_DISPLAY_PARTY ) > 0 )
            wdat_party_bar.unhide();
         else
            wdat_party_bar.hide();
         if ( ( p_display & Maze_DISPLAY_SPELL ) > 0 )
            draw_party_spell ( p_party );
         if ( ( p_display & Maze_DISPLAY_SPECIAL ) > 0 )
            draw_maze_icons ( tmptile );

         Window::instruction ( 320, 0, Window_INSTRUCTION_MOVE
            + Window_INSTRUCTION_CAMP + Window_INSTRUCTION_SELECT );

         if ( ouch == true )
         {
            wttl_ouch.unhide();
            play_sample ( SMP_sound025, 128, 128, 1000, 0 );
         }
         Window::draw_all();
         wttl_ouch.hide();
//         textprintf ( buffer, font, 0, 0, General_COLOR_TEXT, "Counter : %d", encount.counter() );
         copy_buffer ();
         draw = false;
      }

      tpos = p_party.position ();
      tmp_solid = mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ] .solid;
//uncomment later if necessary
//      Opponent::set_maze_special
//            ( p_data.tile [ tpos.y ] [ tpos.x ] [ tpos.z ] . special );


      // check for event
      if ( tmptile.event != Maze_NO_EVENT )
      {
         // test for walk events
         if ( tmp_key == KEY_UP && ouch == false )
         {

            if ( ( p_event [ tmptile.event ] .trigger
               & Maze_EVENT_TRIGGER_MASK ) == Maze_EVENT_TRIGGER_WALK )
            {
               maze_interrupt = execute_event ();
               draw = true;
            }
         }

         // test for facing events
         if ( tmp_key == KEY_LEFT || tmp_key == KEY_RIGHT )
         {
            eventodo = false;

            switch ( p_event [ tmptile.event ] .trigger
               & Maze_EVENT_TRIGGER_MASK )
            {
               case Maze_EVENT_TRIGGER_FACENORTH :
                  if ( tpos.facing == Party_FACE_NORTH )
                     eventodo = true;
               break;

               case Maze_EVENT_TRIGGER_FACEEAST :
                  if ( tpos.facing == Party_FACE_EAST )
                     eventodo = true;
               break;
            
               case Maze_EVENT_TRIGGER_FACESOUTH :
                  if ( tpos.facing == Party_FACE_SOUTH )
                     eventodo = true;
               break;

               case Maze_EVENT_TRIGGER_FACEWEST :
                  if ( tpos.facing == Party_FACE_WEST )
                     eventodo = true;
               break;
            }

            if ( eventodo == true )
            {
               maze_interrupt = execute_event ();
               draw = true;
            }
         }
         tmp_key = 0;
      }

      // remove keyup from keyboard buffer if hit a wall
      if ( draw == false )
      {
         if ( ouch == true )
            do
            {
               tmp_key = readkey () >> 8;
            }
            while ( tmp_key == KEY_UP );
         else
         // read next key
            tmp_key = readkey () >> 8;
         clear_keybuf ();
      }
      ouch = false;
      
      if( tmp_key == KEY_UP )
      {
         if ( p_party.test_front_wall ( tmp_solid ) == true )
            ouch = true;
         else
         {
            p_party.walk_forward ();
            p_party.autoability();
            checkencounter = true;
         }
         draw = true;
      }

      if ( tmp_key == KEY_LEFT )
      {
         p_party.turn_left();
         draw = true;
      }
         
      if ( tmp_key == KEY_RIGHT )
      {
         p_party.turn_right();
         draw = true;
      }

/*      if ( tmp_key == DISPLAY_KEY  )
      {
         change_display ();
         draw = true;
      }*/

      if ( tmp_key == SELECT_KEY )
      {
         if ( p_party.test_front_door ( tmp_solid ) == true )
         {
            p_party.walk_forward ();
            play_sample ( SMP_sound024, 128, 128, 1000, 0 );
            checkencounter = true;
            dooropened = true;
            draw = true;
            tmp_key = KEY_UP;
         }
      }

      if ( tmp_key == CANCEL_KEY )
      {
         maze_interrupt = Maze_CAMP;
      }

      if ( tmp_key == KEY_SPACE )
      {
/*         tmplight--;
         if ( tmplight < 0 )
            tmplight = 3;
         light ( tmplight );*/
         make_screen_shot ( shotstr [ shotID ] );
         shotID++;
      }

      // check for encounter
      if ( checkencounter == true )
      {
      // need to do some maintenance
         tpos = p_party.position ();
         tmp_solid = mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ]  .solid;
      
         encountval = encount.check_encounter ( tmp_solid, dooropened );
         if ( encountval == true )
            maze_interrupt = Maze_COMBAT;
      }
      checkencounter = false;
      dooropened = false;
      

   }

   draw_maze();
   copy_buffer();
   save_backup_screen();
   clear ( buffer );
   p_party.DBupdate();
//   stop_midi ();
   return ( maze_interrupt );

}


void Maze::light ( tiny value )
{
   switch ( value )
   {
      case Maze_LIGHT_LEVEL_3 :
//         p_wall_vision = Maze_WALL_VISION_3SPACE;
//         p_floor_vision = Maze_FLOOR_VISION_3SPACE;
         p_darkness = 0;
         p_light = value;
      break;
      
      case Maze_LIGHT_LEVEL_2 :
//         p_wall_vision = Maze_WALL_VISION_2SPACE;
//         p_floor_vision = Maze_FLOOR_VISION_2SPACE;
         p_darkness = 80;
         p_light = value;
      break;
      
      case Maze_LIGHT_LEVEL_1 :
//         p_wall_vision = Maze_WALL_VISION_1SPACE;
//         p_floor_vision = Maze_FLOOR_VISION_1SPACE;
         p_darkness = 160;
         p_light = value;
      break;
      
      case Maze_LIGHT_LEVEL_0 :
//         p_wall_vision = Maze_WALL_VISION_0SPACE;
//         p_floor_vision = Maze_FLOOR_VISION_0SPACE;
         p_darkness = 255;
         p_light = value;
      break;
   }
}

void Maze::reference_bitmap ( void )
{
   byte i;
   byte j;

   // referencing masked textures
   for ( i = 0 ; i < Maze_NB_GAME_MASKTEX ; i++ )
      p_masktex [ i ] = ( BITMAP* ) datfmaze [ BMP_MASKTEX000 + i ] . dat;
      
   for ( i = 0 ; i < Maze_NB_ADV_MASKTEX ; i++ )
      p_masktex [ Maze_NB_GAME_MASKTEX + i ] = BMP_masktexdum;

   // referencing Object Images
   for ( i = 0 ; i < Maze_NB_GAME_OBJIMG ; i++ )
      p_objimg [ i ] = ( BITMAP* ) datfmaze [ BMP_MAZEOBJ000 + i ] . dat;
      
   for ( i = 0 ; i < Maze_NB_ADV_OBJIMG ; i++ )
      p_objimg [ Maze_NB_GAME_OBJIMG + i ] = BMP_mazeobjdum;

   // referencing Texture set
   for ( i = 0 ; i < Maze_NB_GAME_TEXSET ; i++ )
      for ( j = 0 ; j < 4 ; j++ )
         p_texset [ i ] [ j ] =
            (BITMAP*) datfmaze [ BMP_TEXSET000 + ( i * 4 ) + j ].dat;

   for ( i = 0 ; i < Maze_NB_ADV_TEXSET ; i++ )
      for ( j = 0 ; j < 4 ; j++ )
         p_texset [ Maze_NB_GAME_TEXSET + i ] [ j ] = BMP_texsetdum;

/*   clear_bitmap ( buffer );
   textout ( buffer, font, "Passed Here", 10, 10, General_COLOR_TEXT );
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/
}

void Maze::reference_adv_bitmap ( void )
{
   byte i;
   byte j;

   // referencing masked textures
   for ( i = 0 ; i < Maze_NB_ADV_MASKTEX ; i++ )
      p_masktex [ i + Maze_NB_GAME_MASKTEX ]
         = ( BITMAP* ) adatf [ BMP_AMASKTEX000 + i ] . dat;

   // referencing Object Images
   for ( i = 0 ; i < Maze_NB_ADV_OBJIMG ; i++ )
      p_objimg [ i + Maze_NB_GAME_OBJIMG ]
         = ( BITMAP* ) adatf [ BMP_AMAZEOBJ000 + i ] . dat;

   // referencing Texture set
   for ( i = 0 ; i < Maze_NB_ADV_TEXSET ; i++ )
      for ( j = 0 ; j < 4 ; j++ )
         p_texset [ i + Maze_NB_GAME_TEXSET ] [ j ] =
            (BITMAP*) adatf [ BMP_ATEXSET000 + ( i * 4 ) + j ] . dat;
/*   clear_bitmap ( buffer );
   textout ( buffer, font, "Passed there", 10, 10, General_COLOR_TEXT );
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/

}

void Maze::reference_target ( DBTag citytaglist [ 16 ], DBTag mazetaglist [ 16 ] )
{
   tiny i;
   DBTag tmptag;

//   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
//      p_warp [ i ] . tag . number ( 0 );

   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
   {
      if ( p_warp[ i ].target  != - 1 )
      {
         if ( p_warp[ i ].target  < 16  )
         {
            p_warp [ i ].tag = citytaglist [ p_warp [ i ] .target ];
         }
         else
            p_warp [ i ].tag = mazetaglist [ p_warp [ i ] . target - 16 ];
      }
   }
}

void Maze::load ( void )
{
   byte* subptr = static_cast<byte*>( adatf [ MAZ_AMAP00 + p_mapID ] . dat);
   fs_maz_header header;
   s_Maze_tile tile;
   tiny z;
   tiny y;
   tiny x;
   short progress;
   short counter;
   short maxcount;

   clear_bitmap(screen);

/*   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT,
      "Map ID : %d", p_mapID );
   textprintf ( buffer, font, 0, 16, General_COLOR_TEXT,
      "Name : %s [ %s ]", p_name, p_shortname );
      
   copy_buffer();
   while ( ( readkey()>> 8 ) != KEY_ENTER );*/

   if ( subptr != NULL )
   {
      show_loading_screen ( p_name, 1 );
      memcpy ( &header, subptr, sizeof ( fs_maz_header ) );
      subptr = subptr + ( sizeof ( fs_maz_header ) );

      p_width = header.f_width;
      p_depth = header.f_depth;
      p_sky = header.f_sky;
      p_rclevel = header.f_rclevel;
      p_startpos.x = header.f_startx;
      p_startpos.y = header.f_starty;
      p_startpos.z = header.f_startz;
      p_startpos.facing = header.f_startface;

      progress = 0;
      counter = 0;
      maxcount = ( p_width * p_width * p_depth ) / 500;

      for ( z = 0 ; z < p_depth ; z++ )
         for ( y = 0 ; y < p_width ; y++ )
            for ( x = 0 ; x < p_width ; x++ )
            {
               memcpy ( &tile, subptr, sizeof ( s_Maze_tile ) );
               subptr = subptr + ( sizeof ( s_Maze_tile ) );
            
               mazetile [ z ] [ y ] [ x ] = tile;

               counter++;
               if ( counter >= maxcount )
               {
                  counter = 0;
                  progress++;
               }
               rectfill ( screen, 70, 256 + 1, 70 + ( progress ), 256 + 9,
                                                 makecol ( 150, 150, 255 ) );
               
//               show_loading_screen ( maze.name(), progress );
            }
      clear_bitmap ( screen );

      // loading event

      Database tmpdb;
      dword index;
      dbs_Maze_event tmpevent;
      short i = 0;

      tmpdb.load_dba_from_dat ( DBA_aevent, DBSOURCE_TEMP );

      index = tmpdb.search_table_entry ( p_mapID + 1 );

      clear_bitmap ( buffer );
      while ( tmpdb.entry_table_tag ( index ) == ( p_mapID + 1 ) )
      {
         tmpdb.select ( &tmpevent, index, sizeof ( tmpevent ) );

         p_event [ i ].type = tmpevent.type;
         p_event [ i ].trigger = tmpevent.trigger;
         p_event [ i ].var [ 0 ] = tmpevent.var [ 0 ];
         p_event [ i ].var [ 1 ] = tmpevent.var [ 1 ];
         p_event [ i ].var [ 2 ] = tmpevent.var [ 2 ];
         p_event [ i ].var [ 3 ] = tmpevent.var [ 3 ];
         p_event [ i ].savevalID = tmpevent.savevalID;
         p_event [ i ].text = tmpevent.text;
         strcpy ( p_event [ i ].title, tmpevent.title );
         strcpy ( p_event [ i ].message, tmpevent.message );
/*         textprintf ( buffer, font, 0, i * 16, General_COLOR_TEXT,
            "type %d | %s | %s", p_event [ i ] . trigger,
            p_event [ i ] . title.data(), p_event [ i ] . message.data() );
  */
         index++;
         i++;
      }

/*      copy_buffer();
      while ( ( readkey() >> 8 ) != KEY_ENTER );*/
      

      
   }
}

/*-------------------------------------------------------------------------*/
/*-                         Private Methods                               -*/
/*-------------------------------------------------------------------------*/

//---------------------------- Maze Drawing ---------------------------------

void Maze::draw_wall ( s_Maze_wall_info &wallinfo, BITMAP *texture, bool flipodd )
{

   tiny i;
   V3D tmpv [ 4 ];
   fixed texu;
   fixed texv;
   int tmpval;
   bool flip = false;
   tiny tmpx;
   tiny tmpy;
   int tmpcolor;
   int swpcolor = 1<<31;

   if ( wallinfo.flipok == true )
   {
      if ( flipodd == true )
         flip = true;
   }
   
   for ( i = 0 ; i < 4 ; i++ )
   {
      tmpv [ i ] = wallinfo.vertex [ i ];

      tmpx = LIGHT_DISTANCE [ wallinfo.ltile ] . tablex;
      tmpy = LIGHT_DISTANCE [ wallinfo.ltile ] . tabley;
      tmpv [ i ].c = p_light_table [ tmpy ] [ tmpx ]
         [ wallinfo.lvtex [ i ] ];

      if ( p_adjust_color == true )
      {
         if ( p_polytype == POLYTYPE_FLAT )
         {
            if ( tmpv [ i ] . c != 0 )
               tmpval = ( tmpv [ i ] . c  / 4 ) + 96;
            else
               tmpval = 0;
            tmpcolor = makecol ( tmpval, tmpval, tmpval );
            if ( tmpcolor < swpcolor )
               swpcolor = tmpcolor;
         }
         else
         {
            tmpval = ( tmpv [ i ] . c );
            if ( tmpval < 0 ) tmpval = 0;
            tmpv [ i ] . c = makecol24 ( tmpval, tmpval, tmpval );
         }
      }
   }

   // color adjustment : color decay uniformisation
   if ( p_adjust_color == true && p_polytype == POLYTYPE_FLAT)
   {
      for ( i = 0 ; i < 4 ; i++ )
         tmpv [ i ] . c = swpcolor;
   }
   

   if ( flip == true )
   {
      // switch texture cordonates for vertex 0 and 3
      texu = tmpv [ 0 ] . u;
      texv = tmpv [ 0 ] . v;
      tmpv [ 0 ] . u = tmpv [ 3 ] . u;
      tmpv [ 0 ] . v = tmpv [ 3 ] . v;
      tmpv [ 3 ] . u = texu;
      tmpv [ 3 ] . v = texv;

      // switch texture cordonates for vertex 1 and 2
      texu = tmpv [ 1 ] . u;
      texv = tmpv [ 1 ] . v;
      tmpv [ 1 ] . u = tmpv [ 2 ] . u;
      tmpv [ 1 ] . v = tmpv [ 2 ] . v;
      tmpv [ 2 ] . u = texu;
      tmpv [ 2 ] . v = texv;
   }

   if ( tmpv[0].c != 0 || tmpv[1].c != 0 || tmpv[2].c != 0 || tmpv[3].c != 0 )
      quad3d ( buffer, p_polytype, texture, &tmpv[ 0 ],
                           &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );

}

void Maze::draw_masked_wall ( s_Maze_wall_info &wallinfo, BITMAP *texture )
{
   tiny i;
   V3D tmpv [ 4 ];
   tiny tmpx;
   tiny tmpy;


   for ( i = 0 ; i < 4 ; i++ )
   {
      tmpv [ i ] = wallinfo.vertex [ i ];   
      tmpx = LIGHT_DISTANCE [ wallinfo.ltile ] . tablex;
      tmpy = LIGHT_DISTANCE [ wallinfo.ltile ] . tabley;
      tmpv [ i ].c = p_light_table [ tmpy ] [ tmpx ]
         [ wallinfo.lvtex [ i ] ];
   }
   
   if ( tmpv[0].c != 0 || tmpv[1].c != 0 || tmpv[2].c != 0 || tmpv[3].c != 0 )
      quad3d ( buffer, p_mask_polytype, texture
         , &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );
}

void Maze::draw_thickness ( s_Maze_wall_info &wallinfo, BITMAP *texture )
{
   tiny i;
   V3D tmpv [ 4 ];
   tiny tmpx;
   tiny tmpy;

   for ( i = 0 ; i < 4 ; i++ )
   {
      tmpv [ i ] = wallinfo.vertex [ i ];   
      tmpx = LIGHT_DISTANCE [ wallinfo.ltile ] . tablex;
      tmpy = LIGHT_DISTANCE [ wallinfo.ltile ] . tabley;
      tmpv [ i ].c = p_light_table [ tmpy ] [ tmpx ]
         [ wallinfo.lvtex [ i ] ];
   }

   if ( tmpv[0].c != 0 || tmpv[1].c != 0 || tmpv[2].c != 0 || tmpv[3].c != 0)
      quad3d ( buffer, p_polytype, texture
         , &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );
}


void Maze::draw_transparent_wall ( s_Maze_wall_info &wallinfo, byte type, tiny wallID, bool heavy )
{
   tiny i;
   V3D tmpv [ 4 ];
//   tiny type;
   int tmpcolor;
   short tmpalpha;
   float divider = 1.5;
   float alphamul = 1;
   s_Party_position tpos;

   tpos = p_party.position();

//   type = p_special_wall [ wallID ];

   if ( p_transparency == true
      /*&& Maze_SWALL_INFO [ type ] . drawmode == DRAW_MODE_TRANS*/
      && ( wallinfo.vertex[0].c != 0 || wallinfo.vertex[1].c != 0
         || wallinfo.vertex[2].c != 0|| wallinfo.vertex[3].c != 0) )
   {
//?? revise , not sure of the right values

      if ( p_sky == -1 || tpos.z != 0 )
      {
      if ( config.get ( Config_SHADING ) == Config_SHD_YES )
      if ( wallID <= 5 )
         {
         divider = 18;
               alphamul = 2;
         }
      else
         if ( wallID <= 11 )
         {
            divider = 24;
            alphamul = 2;
         }
         else
             if ( wallID <= 16 )
             {
                divider = 12;
                alphamul = 1.5;
             }
             else
                if ( wallID <= 22 )
                {
                   divider = 6;
                   alphamul = 1.5;
                }
                else
                   if ( wallID <= 23 )
                   {
                      divider = 3;
                      alphamul = 1;
                   }
                   else
                   {
                      divider = 1.5;
                      alphamul = 1;
                   }
      }

      if ( heavy == true )
      {
         divider = divider * 2;
         alphamul = alphamul /2;
      }

      tmpcolor = makecol (
         static_cast<int>( Maze_SWALL_INFO [ type ].red / divider),
         static_cast<int>( Maze_SWALL_INFO [ type ].green / divider),
         static_cast<int>( Maze_SWALL_INFO [ type ].blue / divider ) );
                        
      for ( i = 0 ; i < 4 ; i++ )
      {
         tmpv [ i ] = wallinfo.vertex [ i ];
         tmpv [ i ].c =  tmpcolor;
      }

      tmpalpha = static_cast<short>
         ( Maze_SWALL_INFO [ type ] . alpha * alphamul );
      if ( tmpalpha > 255 )
         tmpalpha = 255;

      drawing_mode ( Maze_SWALL_INFO [ type ] . drawmode , NULL, 0, 0 );
      set_trans_blender ( 0, 0, 0, tmpalpha );

//      quad3d ( buffer, POLYTYPE_GRGB, NULL
//         , &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );


      quad3d ( buffer, POLYTYPE_FLAT, NULL
         , &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );

      drawing_mode ( DRAW_MODE_SOLID, NULL, 0, 0 );
      set_trans_blender ( 0, 0, 0, 255 );
   }

}


void Maze::draw_floor ( s_Maze_floor_info &floorinfo, BITMAP *texture, tiny nb_rotation )
{
   tiny i;
   tiny j;
   V3D tmpv [ 4 ];
   fixed texu;
   fixed texv;
   int tmpval;
   tiny tmpx;
   tiny tmpy;
   int tmpcolor;
   int swpcolor = makecol ( 255, 255, 255 );
   
   for ( i = 0 ; i < 4 ; i++ )
   {
      tmpv [ i ] = floorinfo.vertex [ i ];

      tmpx = LIGHT_DISTANCE [ floorinfo.ltile ] . tablex;
      tmpy = LIGHT_DISTANCE [ floorinfo.ltile ] . tabley;
      tmpv [ i ].c = p_light_table [ tmpy ] [ tmpx ] [ i ];

      if ( p_adjust_color == true )
      {
         if ( p_polytype == POLYTYPE_FLAT )
         {
            if ( tmpv [ i ] . c != 0 )
               tmpval = ( tmpv [ i ] . c  / 4 ) + 96;
            else
               tmpval = 0;
            tmpcolor = makecol ( tmpval, tmpval, tmpval );
            if ( tmpcolor < swpcolor )
               swpcolor = tmpcolor;
            // note : color will be saved at the end
         }
         else
         {
            tmpval = ( tmpv [ i ] . c ) - 32;
            if ( tmpval < 0 ) tmpval = 0;
            tmpv [ i ] . c = makecol24 ( tmpval, tmpval, tmpval );
         }
      }
   }

   // color adjustment : color decay uniformisation
   if ( p_adjust_color == true && p_polytype == POLYTYPE_FLAT)
   {
      for ( i = 0 ; i < 4 ; i++ )
         tmpv [ i ] . c = swpcolor;
   }
      
   // texture rotation
   for ( j = nb_rotation ; j > 0 ; j-- )
   {
      texu = tmpv [ 0 ] . u;
      texv = tmpv [ 0 ] . v;
      for ( i = 0 ; i < 3 ; i++ )
      {
         tmpv [ i ] . u = tmpv [ i + 1 ] . u;
         tmpv [ i ] . v = tmpv [ i + 1 ] . v;
      }
      tmpv [ 3 ] . u = texu;
      tmpv [ 3 ] . v = texv;
   }

   if ( tmpv[0].c != 0 || tmpv[1].c != 0 || tmpv[2].c != 0 || tmpv[3].c != 0 )
      quad3d ( buffer, p_polytype, texture
         , &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );

}

void Maze::draw_masked_floor ( s_Maze_floor_info &floorinfo, BITMAP *texture, tiny nb_rotation )
{
   tiny i;
   tiny j;
   V3D tmpv [ 4 ];
   tiny tmpx;
   tiny tmpy;
   fixed texu;
   fixed texv;


   for ( i = 0 ; i < 4 ; i++ )
   {
      tmpv [ i ] = floorinfo.vertex [ i ];   
      tmpx = LIGHT_DISTANCE [ floorinfo.ltile ] . tablex;
      tmpy = LIGHT_DISTANCE [ floorinfo.ltile ] . tabley;
      tmpv [ i ].c = p_light_table [ tmpy ] [ tmpx ] [ i ];
   }

   // texture rotation
   for ( j = nb_rotation ; j > 0 ; j-- )
   {
      texu = tmpv [ 0 ] . u;
      texv = tmpv [ 0 ] . v;
      for ( i = 0 ; i < 3 ; i++ )
      {
         tmpv [ i ] . u = tmpv [ i + 1 ] . u;
         tmpv [ i ] . v = tmpv [ i + 1 ] . v;
      }
      tmpv [ 3 ] . u = texu;
      tmpv [ 3 ] . v = texv;
   }


   if ( tmpv[0].c != 0 || tmpv[1].c != 0 || tmpv[2].c != 0 || tmpv[3].c != 0 )
      quad3d ( buffer, p_mask_polytype, texture,
         &tmpv[ 0 ],  &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );
}

void Maze::draw_screen ( void )
{
   tiny i;
   V3D tmpv [ 4 ];
   int tmpcolor;
   tiny type;
   s_Party_position tpos = p_party.position ();

   type = mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ]  . special &
      Maze_SPECIAL_FILL_MASK ;

   if ( ( mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ]  . special &
      Maze_SPECIAL_DARKNESS ) > 0 )
      type = 9; // darkness

   if ( p_transparency == true && type > 0 )
   {
      tmpcolor = makecol ( Maze_SWALL_INFO [ type ].red,
                        Maze_SWALL_INFO [ type ].green,
                        Maze_SWALL_INFO [ type ].blue );

      for ( i = 0 ; i < 4 ; i++ )
      {
         tmpv [ i ] = SCREEN [ i ];
         tmpv [ i ].c = tmpcolor;
      }

      drawing_mode ( Maze_SWALL_INFO [ type ] . drawmode , NULL, 0, 0 );
      set_trans_blender ( 0, 0, 0, Maze_SWALL_INFO [ type ] . alpha );

      quad3d ( buffer, POLYTYPE_FLAT, NULL,
         &tmpv[ 0 ], &tmpv [ 1 ], &tmpv [ 2 ], &tmpv [ 3 ] );

      drawing_mode ( DRAW_MODE_SOLID, NULL, 0, 0 );
      set_trans_blender ( 0, 0, 0, 255 );
   }
}

void Maze::draw_object ( s_Maze_object_info &objinfo, BITMAP *image, byte light )
{
   BITMAP *tmpbuf;

   //?? must test if shading is set

   if ( light != 0 )
   {
      if ( p_polytype == POLYTYPE_FLAT || p_polytype == POLYTYPE_PTEX
         || p_polytype == POLYTYPE_ATEX )
      {
         stretch_sprite ( buffer, image, objinfo.x, objinfo.y, objinfo.width,
            objinfo.height );
      }
      else
      {
         tmpbuf = create_bitmap ( 128, 128 );
         clear_to_color ( tmpbuf, makecol ( 255, 0, 255 ) );
         draw_lit_sprite ( tmpbuf, image, 0, 0, ( 255 - light ) );
         stretch_sprite ( buffer, tmpbuf, objinfo.x, objinfo.y, objinfo.width,
            objinfo.height );
         destroy_bitmap ( tmpbuf );
      }
   }
}

void Maze::draw_sky ( void )
{
   s_Party_position tpos;

   tpos = p_party.position();

   if ( p_sky != -1 && tpos.z == 0 )
   {
      if ( tpos.facing == Party_FACE_NORTH ||
         tpos.facing == Party_FACE_SOUTH )
      {
         stretch_sprite ( buffer, ( BITMAP* ) datfmaze [ BMP_SKY000  + p_sky ] . dat,
            0, -80, 320, 290 );
         stretch_sprite ( buffer, ( BITMAP* ) datfmaze [ BMP_SKY000  + p_sky ] . dat,
            320, -80, 320, 290 );
      }
      else
      {
         stretch_sprite ( buffer, ( BITMAP* ) datfmaze [ BMP_SKY000  + p_sky ] . dat,
            -160, -80, 320, 290 );
         stretch_sprite ( buffer, ( BITMAP* ) datfmaze [ BMP_SKY000  + p_sky ] . dat,
            160, -80, 320, 290 );
          stretch_sprite ( buffer, ( BITMAP* ) datfmaze [ BMP_SKY000  + p_sky ] . dat,
            480, -80, 320, 290 );
                 
      }
      

   }
}


void Maze::draw_maze ( void )
{
   s_Party_position tpos;
   short tmpx;
   short tmpy;
   s_Maze_tile tmptile;
   tiny i;
   tiny j;
   byte tmpmask;
   word tmpbitset;
   byte tmpspec;
   short tmpval;
   bool tmpodd; // result of moduloed oddeven
   tiny oddeven; // accumulate and then modulo to determin if odd drawing
   bool tmpheavy= false; // draw thickier transparancy when inside it.
   bool drawmwall;

   tpos = p_party.position ();

   evaluate_light ();

   draw_sky ();

   if ( (mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ] .special &
      Maze_SPECIAL_FILL_MASK ) > 0 )
      tmpheavy = true;

   // loop that draws floors, then walls then objects
   for ( i = 0 ; i < 15 ; i++ )
   {
      tmpx = tpos.x + Maze_DRAW_INFO.test [tpos.facing].offset [ i ].xoff;
      tmpy = tpos.y + Maze_DRAW_INFO.test [tpos.facing].offset [ i ].yoff;
      
      if ( tmpx >=0 && tmpx < p_width && tmpy >=0 && tmpy < p_width )
      {
         tmptile = mazetile [ tpos.z ] [ tmpy ] [ tmpx ];

         tmpodd = false;
         oddeven = 0;
          // set odd even values to be used by drawwall for texture flipping
         if ( tmpx % 2 > 0 )
            oddeven++;
         if ( tmpy % 2 > 0 )
            oddeven++;
         if ( tpos.facing == Maze_FACE_EAST || tpos.facing == Maze_FACE_WEST )
            oddeven++;

         if ( oddeven % 2 > 0 )
            tmpodd = true;
         else
            tmpodd = false;

         // drawing floor and ceiling
         if ( config.get ( Config_FLOOR_CEILING ) == Config_FAC_YES )
         {
            draw_floor ( FLOOR [ i ], p_texset
               [ tmptile.texture & Maze_TEXSET_MASK ] [ 1 ],
               Maze_DRAW_INFO.test [tpos.facing].ftex_rotation );

            if ( p_sky == -1 || tpos.z != 0 )
            {
               draw_floor ( CEILING [ i ], p_texset
                  [ tmptile.texture & Maze_TEXSET_MASK] [ 3 ],
                  Maze_DRAW_INFO.test [tpos.facing].ftex_rotation );
            }
         }

         // drawing special floor and ceiling
         if ( ( tmptile.texture & Maze_FLOOR_MTEX_MASK ) > 0 )
         {
            if ( ( tmptile.texture & Maze_FLOOR_MTEX_DOWN ) > 0 )
               draw_masked_floor ( FLOOR [ i ] ,
                  p_masktex [ tmptile.floortex ],
                  Maze_DRAW_INFO.test [tpos.facing].ftex_rotation );

            if ( ( tmptile.texture & Maze_FLOOR_MTEX_UP ) > 0 )
               draw_masked_floor ( CEILING [ i ] ,
                  p_masktex [ tmptile.floortex ],
                  Maze_DRAW_INFO.test [tpos.facing].ftex_rotation );
         }

         // walls and doors drawing
         for ( j = 0 ; j < 3 ; j++ )
         {
            // draw wall
            tmpmask = Maze_DRAW_INFO.test [tpos.facing].wall [j];
            if ( ( tmptile.solid & tmpmask ) == tmpmask &&
               Maze_DRAW_INFO.tested_wallID [ i ] [ j ] != -1 )
            {
               draw_wall ( WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ],
                  p_texset [ tmptile.texture & Maze_TEXSET_MASK ] [ 0 ],
                  tmpodd );
               // drawing wall thickness
               if ( WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ].thickwallID
                  != -1 )
                  draw_thickness ( THICKWALL [
                     WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ].thickwallID ],
                        p_texset [ tmptile.texture & Maze_TEXSET_MASK ] [ 0 ] );
            }
            
            // draw door
            tmpmask = Maze_DRAW_INFO.test [tpos.facing].door [j];
            if ( ( tmptile.solid & tmpmask ) == tmpmask &&
               Maze_DRAW_INFO.tested_wallID [ i ] [ j ] != -1 )
            {
               draw_masked_wall (
                  WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ],
                  p_texset [ tmptile.texture & Maze_TEXSET_MASK ] [ 2 ] );
            }
            // draw grid
            else
            {
               tmpmask = Maze_DRAW_INFO.test [tpos.facing].grid [j];
               if ( ( tmptile.solid & tmpmask ) == tmpmask &&
                  Maze_DRAW_INFO.tested_wallID [ i ] [ j ] != -1 )
               {
                  draw_masked_wall (
                  WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ],
                  p_masktex [ tmptile.walltex ] );
               }

            }

            // draw masked wall
            if ( ( tmptile.texture & Maze_WALL_MTEX_MASK ) > 0 )
            {
               // convert from Maze_WALL_MTEX to Maze_4bit
               tmpbitset = ( ( tmptile.texture & Maze_WALL_MTEX_MASK ) >> 10 );

               drawmwall = false;

               switch ( Maze_DRAW_INFO.test [tpos.facing].wall [j] )
               {
                  case WNORTH :
                     if ( ( tmpbitset & Maze_4BIT_NORTH ) > 0 )
                        drawmwall = true;
                  break;
                  case WEAST :
                     if ( ( tmpbitset & Maze_4BIT_EAST ) > 0 )
                        drawmwall = true;
                  break;
                  case WSOUTH :
                     if ( ( tmpbitset & Maze_4BIT_SOUTH ) > 0 )
                        drawmwall = true;
                  break;
                  case WWEST :
                     if ( ( tmpbitset & Maze_4BIT_WEST ) > 0 )
                        drawmwall = true;
                  break;
               }
               if ( drawmwall == true
                  && ( Maze_DRAW_INFO.tested_wallID [ i ] [ j ] != -1 ) )
                  draw_masked_wall (
                     WALL [ Maze_DRAW_INFO.tested_wallID [ i ] [ j ] ],
                     p_masktex [ tmptile.walltex ] );
            }
         }

         // place objects in the maze
         tmpval = ( tmptile.texture & Maze_OBJECT_MASK ) >> 6;
         if ( tmpval > 0 )
         {
            tmpbitset = Maze_DRAW_INFO.test [ tpos.facing ].object [ tmpval ];
            
            for ( j = 0 ; j < 9 ; j++ )
            {
               if ( tmpbitset & ( 256 >> j ) )
                  draw_object ( OBJECT [ i ] [ j ],
                     p_objimg [ tmptile.objectimg ],
                     p_light_table [ LIGHT_DISTANCE [ i ].tabley ]
                        [ LIGHT_DISTANCE [ i ].tablex ] [ 4 ] );
            }
         }

         // drawing transparent wall
         tmpspec = tmptile.special & Maze_SPECIAL_FILL_MASK;
         if ( tmpspec > 0 )
            for ( j = 0 ; j < 2 ; j++ )
            {
               if ( Maze_DRAW_INFO.trans_wallID [ i ] [ j ] != -1 )
                  draw_transparent_wall (
                     WALL [ Maze_DRAW_INFO.trans_wallID [ i ] [ j ] ],
                     tmpspec, Maze_DRAW_INFO.trans_wallID [ i ] [ j ], tmpheavy );
            }
            
         if ( ( tmptile.special & Maze_SPECIAL_DARKNESS )  > 0 )
            for ( j = 0 ; j < 2 ; j++ )
            {
               if ( Maze_DRAW_INFO.trans_wallID [ i ] [ j ] != -1 )
                  draw_transparent_wall (
                     WALL [ Maze_DRAW_INFO.trans_wallID [ i ] [ j ] ],
                     8 , Maze_DRAW_INFO.trans_wallID [ i ] [ j ]
                     , false );
            }
            
      }
   }

   draw_screen ();
}

//---------------------------------------------------------------------------

tiny Maze::execute_event ( void )
{
   s_Party_position tpos;
   s_Maze_tile tmptile;
   tiny retval = Maze_CONTINUE;
   byte procID;

   tpos = p_party.position ();
   tmptile = mazetile [ tpos.z ] [ tpos.y ] [ tpos.x ] ;

   save_backup_screen ();

   // verify the event ID and call the right function according to event type
   if ( tmptile.event != 0 )
   {
      procID = p_event [ tmptile.event ] . type;
      if ( MazeProc_EVENT [ procID  ] . proc != NULL )
         retval = MazeProc_EVENT [ procID ] . proc
            ( p_event [ tmptile.event ] , p_party );
   }

   return ( retval );
}

void Maze::evaluate_light ( void )
{
   s_Party_position tpos;
   tiny x;
   tiny y;
   tiny tblx;
   tiny tbly;
   tiny i;
   tiny j;
   tiny k;
   int tmpval;
   s_Maze_tile tmptile;
   tiny tmplight = p_light;

   tpos = p_party.position ();

   if ( p_sky != -1 && tpos.z == 0 )
   {
      tmplight = Maze_LIGHT_LEVEL_3;
   }

   for ( y = 0 ; y < 5 ; y++ )
      for ( x = 0 ; x < 9 ; x++ )
         for ( i = 0 ; i < 5 ; i++ )
            p_light_table [ y ] [ x ] [ i ] = 0;

   // copy basic light diffusion from party

   if ( p_sky != -1 && tpos.z == 0 )
   {
      for ( i = 0 ; i < 15 ; i++ )
      {
         x = LIGHT_DISTANCE [ i ] .tablex;
         y = LIGHT_DISTANCE [ i ] .tabley;
   
         for ( j = 0 ; j < 5 ; j++ )
         {
//            tmpval = LIGHT_DISTANCE [ i ] . vtex [ j ] - p_darkness;
//            if ( tmpval < 0 )
//               p_light_table [ y ] [ x ] [ j ] = 0;
//            else
               p_light_table [ y ] [ x ] [ j ] = 255;
         }
      }

   }
   else
   {
      for ( i = 0 ; i < 15 ; i++ )
      {
         x = LIGHT_DISTANCE [ i ] .tablex;
         y = LIGHT_DISTANCE [ i ] .tabley;
   
         for ( j = 0 ; j < 5 ; j++ )
         {
            tmpval = LIGHT_DISTANCE [ i ] . vtex [ j ] - p_darkness;
            if ( tmpval < 0 )
               p_light_table [ y ] [ x ] [ j ] = 0;
            else
               p_light_table [ y ] [ x ] [ j ] = tmpval;
         }
      }
   }

   // patch light diffussion for non shaded drawing
   if ( p_polytype == POLYTYPE_FLAT || p_polytype == POLYTYPE_PTEX
         || p_polytype == POLYTYPE_ATEX )
   {
      if ( p_sky == -1 || tpos.z != 0 )
      {
         for ( i = 0 ; i < 15 ; i++ )
         {
            if ( LIGHT_VISION [ tmplight ] [ i ] == false )
            {
               x = LIGHT_DISTANCE [ i ] .tablex;
               y = LIGHT_DISTANCE [ i ] .tabley;

               for ( j = 0 ; j < 5 ; j++ )
                  p_light_table [ y ] [ x ] [ j ] = 0;
            }
         }
      }
   }

   for ( i = 0 ; i < 15 ; i++ )
   {
      x = tpos.x + Maze_DRAW_INFO . test [ tpos.facing ] . offset [ i ] . xoff;
      y = tpos.y + Maze_DRAW_INFO . test [ tpos.facing ] . offset [ i ] . yoff;
      tblx = LIGHT_DISTANCE [ i ] .tablex;
      tbly = LIGHT_DISTANCE [ i ] .tabley;
      tmptile =  mazetile [ tpos.z ] [ y ] [ x ] ;
      
      // implement light
      if ( ( tmptile.special & Maze_SPECIAL_LIGHT ) > 0 )
      {
         //  on lighted tile
         for ( k = 0 ; k < 5 ; k++ )
         {
            if ( p_light_table [ tbly ] [ tblx ] [ k ] < 175 )
               p_light_table [ tbly ] [ tblx ] [ k ] = 175;
         }
      }
      // ?? light propagation on standby
         
      // implement darkness
      if ( ( tmptile.special & Maze_SPECIAL_DARKNESS ) > 0 )
      {
         //  on darkened tile
         for ( k = 0 ; k < 5 ; k++ )
         {
            p_light_table [ tbly ] [ tblx ] [ k ] = 0;
         }
      }
      //?? darkness propagation on standby
   }



}

/*void Maze::change_display ( void )
{
   p_display++;
   if ( p_display == Maze_DISPLAY_LAST_ITEM )
      p_display = 0;
} */

/*-------------------------------------------------------------------------*/
/*-                          Virtual Methods                              -*/
/*-------------------------------------------------------------------------*/

void Maze::objdat_to_strdat ( void *dataptr )
{
   dbs_Maze_data &tmpdat = *(static_cast<dbs_Maze_data*> ( dataptr ));
   tiny i;
   short j;

   strncpy ( tmpdat.name, p_name, 31 );
   strncpy ( tmpdat.shortname, p_shortname, 11 );
   tmpdat.type = p_type;
   tmpdat.xpos = p_xpos;
   tmpdat.ypos = p_ypos;
   tmpdat.mapID = p_mapID;
   tmpdat.music = p_music;
   tmpdat.eprob = p_eprob;
   tmpdat.ebase = p_ebase;
   tmpdat.erange = p_erange;
   tmpdat.einc = p_einc;

   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
   {
      tmpdat.warp [ i ].tag = p_warp [ i ].tag.number();
      tmpdat.warp [ i ].target = p_warp [ i ].target;
   }

   for ( j = 0 ; j < Maze_NB_SAVEVALUE ; j++ )
      tmpdat.savevalue [ j ] = p_savevalue [ j ];
}

void Maze::strdat_to_objdat ( void *dataptr )
{
   dbs_Maze_data &tmpdat = *(static_cast<dbs_Maze_data*> ( dataptr ));
   tiny i;
   short j;

   strcpy ( p_name, tmpdat.name );
   strcpy ( p_shortname, tmpdat.shortname );
   p_type = tmpdat.type;
   p_xpos = tmpdat.xpos;
   p_ypos = tmpdat.ypos;
   p_mapID = tmpdat.mapID;
   p_music = tmpdat.music;
   p_eprob = tmpdat.eprob;
   p_ebase = tmpdat.ebase;
   p_erange = tmpdat.erange;
   p_einc = tmpdat.einc;

   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
   {
      p_warp [ i ].tag.number ( tmpdat.warp [ i ].tag );
      p_warp [ i ].target = tmpdat.warp [ i ].target;
   }

   for ( j = 0 ; j < Maze_NB_SAVEVALUE ; j++ )
      p_savevalue [ j ] = tmpdat.savevalue [ j ];
}

void Maze::child_DBremove ( void )
{
// this function is empty
}

void Maze::alternate_strdat_to_objdat ( tiny datatypeID, void *dataptr )
{
   //note : only 1 alternate loading so datatype is not considered
   dbs_ADV_Maze_data &tmpdat = *(static_cast<dbs_ADV_Maze_data*> ( dataptr ));
   tiny i;
   short j;

   strcpy ( p_name, tmpdat.name );
   strcpy ( p_shortname, tmpdat.shortname );
   p_type = tmpdat.type;
   p_xpos = tmpdat.xpos;
   p_ypos = tmpdat.ypos;
   p_mapID = tmpdat.mapID;
   p_music = tmpdat.music;
   p_eprob = tmpdat.eprob;
   p_ebase = tmpdat.ebase;
   p_erange = tmpdat.erange;
   p_einc = tmpdat.einc;

   for ( i = 0 ; i < Maze_NB_WARP ; i++ )
   {
      p_warp [ i ].tag.number ( 0 );
      p_warp [ i ].target = tmpdat.warp [ i ];
   }

   for ( j = 0 ; j < Maze_NB_SAVEVALUE ; j++ )
      p_savevalue [ j ] = 0;

}


/*-------------------------------------------------------------------------*/
/*-                      Non-Class Procedures                             -*/
/*-------------------------------------------------------------------------*/

void Maze::draw_maze_icons ( s_Maze_tile tmptile )
{
   s_Party_position tpos;
   tpos = p_party.position ();
   short y = 0;

   switch ( tmptile.special & Maze_SPECIAL_FILL_MASK )
   {
      case Maze_SPECIAL_FIZZLE :
         draw_sprite( buffer, BMP_icn_fizzle , 608, y );
         y = y + 32;
      break;
      case Maze_SPECIAL_POISON_GAS :
         draw_sprite( buffer, BMP_icn_poison_gas , 608, y );
         y = y + 32;
      break;
      case Maze_SPECIAL_FOG :
         draw_sprite( buffer, BMP_icn_fog , 608, y );
         y = y + 32;
      break;
      case Maze_SPECIAL_WATER :
         draw_sprite( buffer, BMP_icn_water , 608, y );
         y = y + 32;
      break;
   }

   if ( ( tmptile.special & Maze_SPECIAL_DARKNESS ) > 0 )
   {
      draw_sprite( buffer, BMP_icn_darkness , 608, y );
      y = y + 32;
   }

   // add icon for light
   // add icon for magic bounce
   // add icon for solid

   if ( tmptile.event > 0 )
   {
      switch ( p_event [ tmptile.event ] . trigger
         & Maze_EVENT_TRIGICON_MASK )
      {
          case Maze_EVENT_TRIGICON_DOWN :
             draw_sprite( buffer, BMP_icn_sdown , 608, y );
             y = y + 32;
          break;
          case Maze_EVENT_TRIGICON_UP :
             draw_sprite( buffer, BMP_icn_sup , 608, y );
             y = y + 32;
          break;
          case Maze_EVENT_TRIGICON_BOTH :
             draw_sprite( buffer, BMP_icn_supdown , 608, y );
             y = y + 32;
          break;
          case Maze_EVENT_TRIGICON_NORTH :
          break;
          case Maze_EVENT_TRIGICON_EAST :
          break;
          case Maze_EVENT_TRIGICON_SOUTH :
          break;
          case Maze_EVENT_TRIGICON_WEST :
          break;
          case Maze_EVENT_TRIGICON_DOBJECT :
             draw_sprite( buffer, BMP_icn_sobj , 608, y );
             y = y + 32;
          break;
      }
   }

/*--- this is the old maze code ---



  //?? note use event information for determining icon, not texture position

  if ( ( tmptile.space & Maze_FLOOR_MTEX_BOTH ) == Maze_FLOOR_MTEX_BOTH )
  {
     draw_sprite( buffer, BMP_icn_supdown , 608, y );
     y = y + 32;
  }
  else
     if ( ( tmptile.space & Maze_FLOOR_MTEX_UP ) == Maze_FLOOR_MTEX_UP )
     {
        draw_sprite( buffer, BMP_icn_sup , 608, y );
        y = y + 32;
     }
     else
        if ( ( tmptile.space & Maze_FLOOR_MTEX_DOWN ) == Maze_FLOOR_MTEX_DOWN )
        {
           draw_sprite( buffer, BMP_icn_sdown , 608, y );
           y = y + 32;
        }
   */

}


