/***************************************************************************/
/*                                                                         */
/*                          M A N A G E R . C P P                          */
/*                           Class source Code                             */
/*                                                                         */
/*     Content : Class Manager                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : July 24th, 2003                                     */
/*     License : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <adventur.h>
#include <item.h>
#include <armor.h>
#include <weapon.h>
#include <shield.h>
#include <accesory.h>
#include <expandbl.h>
#include <list.h>
#include <race.h>
#include <opponent.h>
#include <charactr.h>
//#include <monster.h>
#include <party.h>
#include <manager.h>
#include <player.h>
#include <account.h>
#include <game.h>
#include <city.h>
#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>
#include <window.h>
#include <winmenu.h>
#include <winlist.h>
#include <winempty.h>
#include <wintitle.h>
#include <windata.h>
#include <wdatproc.h>
#include <winmessa.h>
#include <winquest.h>
#include <wininput.h>
#include <strmake.h>


/*-------------------------------------------------------------------------*/
/*-                     Constructor and Destructor                        -*/
/*-------------------------------------------------------------------------*/

Manager::Manager ( void )
{
   p_account_logged.number ( 0 );
}

Manager::~Manager ( void )
{

}

/*-------------------------------------------------------------------------*/
/*-                            Property Methods                           -*/
/*-------------------------------------------------------------------------*/

DBTag Manager::account_logged ( void )
{
   return ( p_account_logged );
}

tiny Manager::nb_game ( void )
{
//   Game tmpgame;
//   dword index =
   tiny nb_game = 0;
   dword i = db.search_table_entry ( DBTABLE_GAME );
//   dword nb_entry = db.nb_entry ();

   while ( db.entry_table_tag ( i ) == DBTABLE_GAME )
//   for ( i = db.search_table_entry ( DBTABLE_GAME ) ; i < nb_entry ; i++ )
   {
//      if ( db.entry_table_tag ( i ) == DBTABLE_GAME )
      nb_game++;
      i++;
   }
   
   return ( nb_game );
}

tiny Manager::nb_account ( void )
{
//   Game tmpgame;
   dword index = db.search_table_entry ( DBTABLE_ACCOUNT );
   tiny nb_account = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_ACCOUNT )
   {
      nb_account++;
      index++;
   }
   
   return ( nb_account );

}

tiny Manager::nb_adventure ( void )
{
   dword index = db.search_table_entry ( DBTABLE_ADVENTURE );
   tiny nb_adventure = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_ADVENTURE )
   {
      nb_adventure++;
      index++;
   }
   
   return ( nb_adventure );

}

tiny Manager::nb_race ( void )
{
   dword index = db.search_table_entry ( DBTABLE_RACE );
   tiny nb_race = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_RACE )
   {
      if ( db.entry_source_tag ( index ) == DBSOURCE_SYSTEM )
         nb_race++;
      index++;
   }
   
   return ( nb_race );

}

tiny Manager::nb_class ( void )
{
   dword index = db.search_table_entry ( DBTABLE_CCLASS );
   tiny nb_class = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_CCLASS )
   {
      if ( db.entry_source_tag ( index ) == DBSOURCE_SYSTEM )   
         nb_class++;
      index++;
   }
   
   return ( nb_class );

}


/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

tiny Manager::start ( void )
{
   Menu mnu_command ("System manager's Options");
   tiny retvalue = Manager_CONTINUE;
   short answer;
   short answer2;

   mnu_command.add_item ("Login" );
   mnu_command.add_item ("Adventure Registering");
   mnu_command.add_item ("Game Management");
   mnu_command.add_item ("Account Management");
   mnu_command.add_item ("Extra Races");
   mnu_command.add_item ("Extra Classes");
   mnu_command.add_item ("Exit");

   db.default_source ( DBSOURCE_SYSTEM );
   play_music_track ( System_MUSIC_w3edge );
   
   WinEmpty wemp_background;
   WinTitle wttl_title ( "Wizardry Management Section");

   while ( retvalue == Manager_CONTINUE )
   {
      mnu_command.unmask_all_item ();
      Window::instruction ( 320, 460 );
      if ( nb_adventure() == 0 )
      {
         mnu_command.mask_item ( Manager_MENU_LOGIN );
         mnu_command.mask_item ( Manager_MENU_GAME );
      }

      if ( nb_game() == 0 )
         mnu_command.mask_item ( Manager_MENU_LOGIN );

      if ( nb_account() == 0 )
         mnu_command.mask_item ( Manager_MENU_LOGIN );

   
      WinMenu wmnu_command ( mnu_command, 20, 40, true );
      answer = Window::show_all();

      wmnu_command.hide();
      switch ( answer )
      {
         case Manager_MENU_LOGIN :
            retvalue = show_login ();
         break;
         case Manager_MENU_ADVENTURE :
            show_adventure();
         break;
         case Manager_MENU_GAME :
            show_game();
         break;
         case Manager_MENU_ACCOUNT :
            show_account();
         break;
         case Manager_MENU_RACE :
            show_race();
         break;
         case Manager_MENU_CLASS :
            show_class();
         break;
         case Manager_MENU_EXIT :
            retvalue = Manager_EXIT;
         break;
      }
   }

   return ( retvalue );
}



tiny Manager::show_login ( void )
{
   tiny retvalue = Manager_CONTINUE;
//   string loginame;
//   string password;
   char strlogin [ 16 ];
   char strpasswd [ 11 ];
   bool account_found = false;
   Account tmpacc;
   dword index;

   WinInput winp_loginame ("Enter your Account's login name?", 15, 20, 40 );
   Window::show_all();

   WinInput winp_password ("Enter your Account's password?", 10, 20, 90 );
   Window::show_all();

   winp_loginame.get_string ( strlogin );
   winp_password.get_string ( strpasswd );

   index = db.search_table_entry ( DBTABLE_ACCOUNT );

   while ( db.entry_table_tag ( index ) == DBTABLE_ACCOUNT
      && account_found == false )
   {
      tmpacc.DBselect ( index );
         if ( strcmp ( strlogin, tmpacc.loginame() ) == 0 )
            account_found = true;
      index++;
   }

   if ( account_found == true )
   {
      if ( tmpacc.verify_password ( strpasswd ) == true )
      {
         p_account_logged = tmpacc.tag();
         db.default_source ( DBSOURCE_SAVEGAME );
         retvalue = Manager_LOGIN;
         db.save_dba_file ( "system.dba", DBSOURCE_SYSTEM );
      }
      else
      {
         WinMessage wmsg_error ("Login Operation failed");
         Window::show_all();
      }

   }
   else
   {
      WinMessage wmsg_error ("Login Operation failed");
      Window::show_all();
   }

   return ( retvalue );
}

void Manager::show_adventure ( void )
{
   Menu mnu_subcmd ("Select Operation");
   short answer2;

   mnu_subcmd.add_item ("Create");
   mnu_subcmd.add_item ("Inspect");
   mnu_subcmd.add_item ("Delete");
   mnu_subcmd.add_item ("Exit");


            if ( nb_adventure() == 0 )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
            }
            
            if ( nb_adventure() >= Manager_NB_MAX_ADVENTURE )
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );

            WinMenu wmnu_subcmd ( mnu_subcmd, 20, 40 );
            answer2 = Window::show_all();
            wmnu_subcmd.hide();
            switch ( answer2 )
            {
               case Manager_SUBMENU_CREATE :
                  show_create_adventure ();
               break;
               case Manager_SUBMENU_INSPECT :
                  show_inspect_adventure ();
               break;
               case Manager_SUBMENU_DELETE :
                  show_delete_adventure ();
               break;
            }

}

void Manager::show_game ( void )
{
   Menu mnu_subcmd ("Select Operation");
   short answer2;   

   mnu_subcmd.add_item ("Create");
   mnu_subcmd.add_item ("Inspect");
   mnu_subcmd.add_item ("Delete");
   mnu_subcmd.add_item ("Exit");

            if ( nb_game() == 0 )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
            }

            if ( nb_game() >= Manager_NB_MAX_GAME )
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );

            WinMenu wmnu_subcmd ( mnu_subcmd, 20, 40 );
            answer2 = Window::show_all();
            wmnu_subcmd.hide();
            switch ( answer2 )
            {
               case Manager_SUBMENU_CREATE :
                  show_create_game ();
               break;
               case Manager_SUBMENU_INSPECT :
                  show_inspect_game ();
               break;
               case Manager_SUBMENU_DELETE :
                  show_delete_game ();
               break;
            }

}

void Manager::show_account ( void )
{
   Menu mnu_subcmd ("Select Operation");
   short answer2;   

   mnu_subcmd.add_item ("Create");
   mnu_subcmd.add_item ("Inspect");
   mnu_subcmd.add_item ("Delete");
   mnu_subcmd.add_item ("Exit");

            if ( nb_account() == 0 )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
            }
            if ( nb_account() >= Manager_NB_MAX_ACCOUNT )
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );

            WinMenu wmnu_subcmd ( mnu_subcmd, 20, 40 );
            answer2 = Window::show_all();
            wmnu_subcmd.hide();
            switch ( answer2 )
            {
               case Manager_SUBMENU_CREATE :
                  show_create_account ();
               break;
               case Manager_SUBMENU_INSPECT :
                  show_inspect_account ();
               break;
               case Manager_SUBMENU_DELETE :
                  show_delete_account ();
               break;
            }

}

void Manager::show_race ( void )
{
   Menu mnu_subcmd ("Select Operation");
   short answer2;   

   mnu_subcmd.add_item ("Create");
   mnu_subcmd.add_item ("Inspect");
   mnu_subcmd.add_item ("Delete");
   mnu_subcmd.add_item ("Import");
   mnu_subcmd.add_item ("Export");
   mnu_subcmd.add_item ("Exit");

            if ( nb_race() == 0 )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_EXPORT );
            }

            if ( nb_race() >= Manager_NB_MAX_RACE )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_IMPORT );
            }

            //?? tmpcode//
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
            mnu_subcmd.mask_item ( Manager_SUBMENU_IMPORT );
            mnu_subcmd.mask_item ( Manager_SUBMENU_EXPORT );
            //----------//

            WinMenu wmnu_subcmd ( mnu_subcmd, 20, 40 );
            answer2 = Window::show_all();
            wmnu_subcmd.hide();
            switch ( answer2 )
            {
               case Manager_SUBMENU_CREATE :
                  show_create_race ();
               break;
               case Manager_SUBMENU_INSPECT :
                  show_inspect_race ();
               break;
               case Manager_SUBMENU_DELETE :
                  show_delete_race ();
               break;
               case Manager_SUBMENU_IMPORT :
                  show_import_race ();
               break;
               case Manager_SUBMENU_EXPORT :
                  show_export_race ();
               break;
            }

}

void Manager::show_class ( void )
{
   Menu mnu_subcmd ("Select Operation");
   short answer2;   

   mnu_subcmd.add_item ("Create");
   mnu_subcmd.add_item ("Inspect");
   mnu_subcmd.add_item ("Delete");
   mnu_subcmd.add_item ("Import");
   mnu_subcmd.add_item ("Export");
   mnu_subcmd.add_item ("Exit");

            if ( nb_class() == 0 )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_EXPORT );
            }
            if ( nb_class() >= Manager_NB_MAX_CLASS )
            {
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_IMPORT );
            }

            //?? tmpcode//
               mnu_subcmd.mask_item ( Manager_SUBMENU_CREATE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_IMPORT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_INSPECT );
               mnu_subcmd.mask_item ( Manager_SUBMENU_DELETE );
               mnu_subcmd.mask_item ( Manager_SUBMENU_EXPORT );
            //-----------//
            
            WinMenu wmnu_subcmd ( mnu_subcmd, 20, 40 );
            answer2 = Window::show_all();
            wmnu_subcmd.hide();
            switch ( answer2 )
            {
               case Manager_SUBMENU_CREATE :
                  show_create_class ();
               break;
               case Manager_SUBMENU_INSPECT :
                  show_inspect_class ();
               break;
               case Manager_SUBMENU_DELETE :
                  show_delete_class ();
               break;
               case Manager_SUBMENU_IMPORT :
                  show_import_class ();
               break;
               case Manager_SUBMENU_EXPORT :
                  show_export_class ();
               break;
            }

}


void Manager::show_create_adventure ( void )
{
   List lst_file ("Select adventure file to open ( adventur// )", 20 );
   Adventure tmpadv;
   dword advindex;
   DATAFILE *tmpobj = NULL;
   Database tmpdb;
   char tmpstr [ 256 ];
   short i;
   short answer;
   short answer2;
   short retval;
   char filelist [ 128 ] [ 13 ];
   short flistindex;
//   string tmpfilename;
   char strfname [ 25 ];


   al_ffblk info;
   retval = al_findfirst("adventur//*.wza", &info, 33 );

   flistindex = 0;
   if ( retval == 0 )
   {
      strncpy ( filelist [ flistindex ], info.name, 12 );
      flistindex++;
      while ( al_findnext ( &info ) == 0 )
      {
         strncpy ( filelist [ flistindex ], info.name, 12 );
         flistindex++;
      }
      al_findclose( &info);
   }

   for ( i = 0 ; i < flistindex ; i++ )
   {
      lst_file.add_item ( filelist [ i ] );
   }

   WinList wlst_file ( lst_file, 20, 40 );
   answer = Window::show_all();
   wlst_file.hide();

   if ( answer != -1 )
   {
      Window::draw_all();
      textprintf_centre ( buffer, FNT_print, 320, 200, General_COLOR_TEXT,
         "Reading %s", filelist [ answer ] );
      textout_centre ( buffer, FNT_print, "Please Wait", 320, 220, General_COLOR_TEXT );
      copy_buffer();

      //tmpobj = load_datafile ( filelist [ answer ] );
      sprintf ( strfname,"adventur//%s", filelist [ answer ] );
      tmpobj = load_datafile_object( strfname , "DBA_ADATABASE" );

      if ( tmpobj != NULL )
      {
         tmpdb.load_dba_from_dat ( tmpobj -> dat, DBSOURCE_ADVENTURE );
         advindex = tmpdb.search_table_entry ( DBTABLE_ADVENTURE );

//         textprintf ( buffer, font, 10, 10, General_COLOR_TEXT,
//            "Index number : %d", advindex );
//         copy_buffer();
//         while ( readkey() >> 8 != KEY_ENTER );

//         if ( tmpdb.entry_table_tag( advindex ) == DBTABLE_ADVENTURE )
         tmpadv.exDBselect ( tmpdb, advindex );

//         db.default_source ( DBSOURCE_ADVENTURE );
//         DBTag tag = tmpadv.DBinsert();
//         tmpadv.DBselect ( tag );
//         db.default_source ( DBSOURCE_SYSTEM );

         sprintf ( tmpstr, "Do you want to register this adventure?\n%s - Version %s\n%s - Episode %d",
            tmpadv.adventurename(), tmpadv.version(), tmpadv.saganame(), tmpadv.episode() );

         WinQuestion wqst_confirm ( tmpstr );
         answer2 = Window::show_all();
         wqst_confirm.hide();

         if ( answer2 == WinQuestion_ANSWER_YES )
         {
            tmpadv.filename ( strfname );
            
            tmpadv.DBinsert ();
            WinMessage wmsg_info ("Adventure has been registered");
            Window::show_all();
         }
         else
         {
            WinMessage wmsg_info ("Adventure has NOT been registered");
            Window::show_all();
         }

      }
      else
      {
         sprintf ( tmpstr, "An error occured while reading file %s",
            filelist [ answer ] );
         WinMessage wmsg_error ( tmpstr );
         Window::show_all();
      }
      unload_datafile_object ( tmpobj );
   }
}

void Manager::show_inspect_adventure ( void )
{
   List lst_adv ("Select an Adventure to INSPECT", 22);
   Adventure tmpadv;
   dword i = db.search_table_entry ( DBTABLE_ADVENTURE );
//   string tmpstr;
   char strentry [ 81 ];
   short answer = 0;

   while ( db.entry_table_tag ( i ) == DBTABLE_ADVENTURE )
   {
//      db.entry_table_tag ( i ) == DBTABLE_GAME
      tmpadv.DBselect ( i );
      strmake_adventure_list ( tmpadv, strentry );
      lst_adv.add_item ( strentry );
      i++;
   }

   WinList wlst_adv ( lst_adv, 20, 40 );
   while ( answer != -1 )
   {
      answer = Window::show_all();
   }

}

void Manager::show_delete_adventure ( void )
{
   Adventure tmpadv;

//   string tmpstr;
   char strentry [ 81 ];
//   char tmpstr2 [ 81 ];
   short answer = 0;
   short answer2 = 0;
//   bool selected = false;
   dword copyindex [ Manager_NB_MAX_ADVENTURE ];
   short j;

   while ( answer != -1 && nb_adventure() > 0 )
   {
      List lst_adv ("Select an adventure to DELETE", 22);
      dword index = db.search_table_entry ( DBTABLE_ADVENTURE );
      j = 0;
      while ( db.entry_table_tag ( index ) == DBTABLE_ADVENTURE )
      {
         tmpadv.DBselect ( index );
         strmake_adventure_list ( tmpadv, strentry );
         lst_adv.add_item ( strentry );
         copyindex [ j ] = index;
         index++;
         j++;
      }
      
      WinList wlst_adv ( lst_adv, 20, 40 );
      answer = Window::show_all();
      if ( answer != -1 )
      {
         tmpadv.DBselect ( copyindex [ answer ] );
//         sprintf ( tmpstr2, "Are you sure you want to delete the [%s] account",
//            tmpgame.cloginame() );
         WinQuestion wmsg_confirm ( "Are you sure you want to delete this adventure?\nIt will also delete all games that use this adventure!" );
         answer2 = Window::show_all();
         wmsg_confirm.hide();
         if ( answer2 == 0 )
         {
         /*

            // ??maybe ask for a master password
            // else it will be possile to delete protected game
            // by deleting the adventure
            
            if ( tmpgame.pass_protect() == true )
            {
//               WinMessage ("Message1");
//               Window::show_all();
               WinInput winp_password ("Enter your Game's password?", 10, 200, 100 );
//               Window::show_all();
//               WinMessage ("Message2");
               Window::show_all();
               winp_password.hide();
               winp_password.get_string ( password );

               if ( tmpgame.verify_password( password ) == true )
               {
//                  WinMessage ("Message3");
//                  Window::show_all();
               
                  tmpgame.DBremove();
               }
               else
               {
                  WinMessage wmsg_error ("Password Incorrect!");
                  Window::show_all();
               }
            }
            else*/
            tmpadv.DBremove();
         }
      }
   }


}


void Manager::show_create_game ( void )
{
   Menu mnu_difficulty ("Select the difficulty level of the game ?");
   Menu mnu_levelup ("Select the character levelup speed ?");
   List lst_adv ("Select an Adventure", 22);
   Game tmpgame;
   Adventure tmpadv;   
   short answer;
   DBTag tmptag;
//   string tmpstr;
   char strentry [ 81 ];
//   string tmpstr2;
   char strpasswd [ 11 ];
   char strconfirm [ 11 ];
   char strfname [ 25 ];
//   char tmpstr3 [ 20 ];
   dword index;
   dword copyindex [ Manager_NB_MAX_ADVENTURE ];
   short j = 0;
   short i;
   Database tmpdb;
   City tmpcity;
   Maze tmpmaze;
   DATAFILE *tmpobj;
   DBTag citylist [ 16 ];
   DBTag mazelist [ 16 ];
   

   mnu_difficulty.add_item ( "Easy" );
   mnu_difficulty.add_item ( "Normal" );
   mnu_difficulty.add_item ( "Hard" );

   index = db.search_table_entry ( DBTABLE_ADVENTURE );
   answer = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_ADVENTURE )
   {
      tmpadv.DBselect ( index );
      strmake_adventure_list ( tmpadv, strentry );
      lst_adv.add_item ( strentry );
      copyindex [ j ] = index;
      index++;
      j++;

   }      

   WinList wlst_adv ( lst_adv, 20, 40, true );
   answer = Window::show_all();
   wlst_adv.hide();
   tmpadv.DBselect ( copyindex [ answer ] );
   tmpgame.adventure ( tmpadv.tag() );



   WinMenu wmnu_difficulty ( mnu_difficulty, 20, 40, true );
   answer = Window::show_all();
   wmnu_difficulty.hide();
   tmpgame.difficulty ( answer );

   if ( answer == 0 /* easy */ )
      mnu_levelup.add_item ( "Fast", true );
   else
      mnu_levelup.add_item ( "Fast", false );
   mnu_levelup.add_item ( "Normal" );
   mnu_levelup.add_item ( "Slow" );

   WinMenu wmnu_levelup ( mnu_levelup, 20, 40, true );
   answer = Window::show_all();
   wmnu_levelup.hide ();
   tmpgame.levelup ( answer );

   WinQuestion wqst_password ("Do you want to protect your game with a password?");
   answer = Window::show_all();
   wqst_password.hide ();



   if ( answer == WinQuestion_ANSWER_YES )
   {
      tmpgame.protect();
      do
      {
         WinInput winp_password ("Enter the Password", 10, 20, 40 );
         Window::show_all();
         winp_password.get_string ( strpasswd );
//      winp_password.hide();

         WinInput winp_confirm ("Confirm the Password", 10, 20, 90 );
         Window::show_all();
         winp_confirm.get_string ( strconfirm );
//      winp_password.hide();

         if ( strcmp ( strpasswd, strconfirm ) != 0 )
         {

            WinMessage wmsg_error ("Your password does not match, try again");
            Window::show_all();
         }
      }
      while ( strcmp ( strpasswd, strconfirm ) != 0 );
      
      tmpgame.password ( strpasswd );
   }
   else
   {

      tmpgame.open();
   }   



   tmptag = tmpgame.DBinsert();

   sprintf ( strfname, "savegame//sav%03d.dba", tmptag.key() );

/*   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT, "%s", tmpstr.data() );
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/

   tmpgame.savegame ( strfname );
   tmpgame.DBupdate();

/*   textprintf ( buffer, font, 0, 0, General_COLOR_TEXT, "%s", tmpgame.csavegame() );
   copy_buffer();
   while ( ( readkey() >> 8 ) != KEY_ENTER );*/

   

   // ---------- create sagegame file ----------

/*   for ( i = 0 ; i < 16 ; i++ )
   {
      citylist [ i ] . number ( 0 );
      mazelist [ i ] . number ( 0 );
   }*/

   tmpdb.default_source ( DBSOURCE_SAVEGAME );


   tmpobj = load_datafile_object( tmpadv.filename() , "DBA_ADATABASE" );

   if ( tmpobj != NULL )
   {

      db.load_dba_from_dat ( tmpobj -> dat, DBSOURCE_ADVENTURE );

      // load and convert adventure city info as city info
      index = db.search_table_entry ( DBTABLE_ADVCITY );
      i = 0;
      while ( db.entry_table_tag ( index ) == DBTABLE_ADVCITY )
      {
         tmpcity.alDBselect ( City_DATATYPE_ADVENTURE, sizeof ( dbs_ADV_City_data) ,index );
         citylist [ i ] = tmpcity.exDBinsert ( tmpdb );
         index = index + 1;
         i++;
      }

      // load and converert adventure maze info as maze info
      index = db.search_table_entry ( DBTABLE_ADVMAZE );
      i = 0;
      while ( db.entry_table_tag ( index ) == DBTABLE_ADVMAZE )
      {
         tmpmaze.alDBselect ( City_DATATYPE_ADVENTURE, sizeof ( dbs_ADV_Maze_data) ,index );
         mazelist [ i ] = tmpmaze.exDBinsert ( tmpdb );
         index = index + 1;
         i++;
      }

      // reference target ID as tags
      index = tmpdb.search_table_entry ( DBTABLE_CITY );
      while ( tmpdb.entry_table_tag ( index ) == DBTABLE_CITY )
      {
         tmpcity.exDBselect ( tmpdb, index );
         tmpcity.reference_target ( citylist, mazelist );
         tmpcity.exDBupdate ( tmpdb );
         index++;
      }

      index = tmpdb.search_table_entry ( DBTABLE_MAZE );
      while ( tmpdb.entry_table_tag ( index ) == DBTABLE_MAZE )
      {
         tmpmaze.exDBselect ( tmpdb, index );
         tmpmaze.reference_target ( citylist, mazelist );
         tmpmaze.exDBupdate ( tmpdb );
         index++;
      }
       

      //?? todo transfer extra classes and races

//      strcpy ( strfname, tmpgame.csavegame() );
      tmpdb.save_dba_file ( tmpgame.savegame(), DBSOURCE_SAVEGAME );
      db.remove_source ( DBSOURCE_ADVENTURE );
   }
   else
   {


      WinMessage wmsg_error ( "Game could no be created!\nError Reading the adventure file" );
      Window::show_all();
      tmpgame.DBremove();
   }
   
}

void Manager::show_inspect_game ( void )
{
   List lst_game ("Select an Game to INSPECT", 22);
   Game tmpgame;
   dword i = db.search_table_entry ( DBTABLE_GAME );
   char strentry [ 81 ];
   short answer = 0;

   while ( db.entry_table_tag ( i ) == DBTABLE_GAME )
   {
//      db.entry_table_tag ( i ) == DBTABLE_GAME
      tmpgame.DBselect ( i );
      strmake_game_list ( tmpgame, strentry );
      lst_game.add_item ( strentry );
      i++;
   }

   WinList wlst_game ( lst_game, 20, 40 );
   while ( answer != -1 )
   {
      answer = Window::show_all();
   }

}

void Manager::show_delete_game ( void )
{
   Game tmpgame;

//   string tmpstr;
   char strentry [ 81 ];
//   char tmpstr2 [ 81 ];
   short answer = 0;
   short answer2 = 0;
//   bool selected = false;
   dword copyindex [ Manager_NB_MAX_GAME ];
   short j;
   char password [ 11 ];

   while ( answer != -1 && nb_game() > 0 )
   {
      List lst_game ("Select an game to DELETE", 22);
      dword index = db.search_table_entry ( DBTABLE_GAME );
      j = 0;
      while ( db.entry_table_tag ( index ) == DBTABLE_GAME )
      {
         tmpgame.DBselect ( index );
         strmake_game_list ( tmpgame, strentry );
         lst_game.add_item ( strentry );
         copyindex [ j ] = index;
         index++;
         j++;
      }
      
      WinList wlst_game ( lst_game, 20, 40 );
      answer = Window::show_all();
      if ( answer != -1 )
      {
         tmpgame.DBselect ( copyindex [ answer ] );
//         sprintf ( tmpstr2, "Are you sure you want to delete the [%s] account",
//            tmpgame.cloginame() );
         WinQuestion wmsg_confirm ( "Are you sure you want to delete this game?\nIt will also delete all players in this game!" );
         answer2 = Window::show_all();
         wmsg_confirm.hide();
         if ( answer2 == 0 )
         {
            if ( tmpgame.pass_protect() == true )
            {
//               WinMessage ("Message1");
//               Window::show_all();
               WinInput winp_password ("Enter your Game's password?", 10, 200, 100 );
//               Window::show_all();
//               WinMessage ("Message2");
               Window::show_all();
               winp_password.hide();
               winp_password.get_string ( password );

               if ( tmpgame.verify_password( password ) == true )
               {
//                  WinMessage ("Message3");
//                  Window::show_all();
               
                  tmpgame.DBremove();
               }
               else
               {
                  WinMessage wmsg_error ("Password Incorrect!");
                  Window::show_all();
               }
            }
            else
               tmpgame.DBremove();
         }
      }
   }
}

void Manager::show_create_account ( void )
{
   Account tmpacc;
   Account tmpacc2;
   dword index;
   char tmpstr [ 16 ];
//   char strentry [ 81 ];
   char tmpstr2 [ 16 ];
   bool doublelogin = false;

   WinData<Account> wdat_account ( WDatProc_new_account, tmpacc,
      WDatProc_POSITION_NEW_ACCOUNT );

   WinInput winp_loginame ("Enter the Login Name of your account", 10, 20, 40 );
   do
   {
      doublelogin = false;

      Window::show_all();
      winp_loginame.get_string ( tmpstr );

      index = db.search_table_entry ( DBTABLE_ACCOUNT );

      while ( db.entry_table_tag ( index ) == DBTABLE_ACCOUNT )
      {
         tmpacc2.DBselect ( index );
         if ( strcmp ( tmpstr, tmpacc2.loginame() ) == 0 )
            doublelogin = true;
         index++;
      }
      if ( doublelogin == true )
      {
         WinMessage msg_error ("This loginame already exist, type another one" );
         Window::show_all();
      }
   }
   while ( doublelogin == true );
   
   tmpacc.loginame ( tmpstr );
   winp_loginame.hide();
   wdat_account.refresh();

   WinInput winp_name ("Enter Your first name", 15, 20, 40 );
   Window::show_all();
   winp_name.get_string ( tmpstr );
   tmpacc.name ( tmpstr );
   winp_name.hide();
   wdat_account.refresh();   

   WinInput winp_family ("Enter Your family name", 15, 20, 40 );
   Window::show_all();
   winp_family.get_string ( tmpstr );
   tmpacc.family ( tmpstr );
   winp_family.hide();
   wdat_account.refresh();   

   WinInput winp_nickname ("Enter your Nick Name", 15, 20, 40 );
   Window::show_all();
   winp_nickname.get_string ( tmpstr );
   tmpacc.nickname ( tmpstr );
   winp_nickname.hide();
   wdat_account.refresh();   

   do
   {
      WinInput winp_password ("Enter the Password", 10, 20, 40 );
      Window::show_all();
      winp_password.get_string ( tmpstr );
//      winp_password.hide();

      WinInput winp_confirm ("Confirm the Password", 10, 20, 100 );
      Window::show_all();
      winp_confirm.get_string ( tmpstr2 );
//      winp_password.hide();

      if ( strcmp ( tmpstr, tmpstr2 ) != 0 )
      {
         WinMessage wmsg_error ("Your password does not match, try again");
         Window::show_all();
      }

   }
   while ( strcmp ( tmpstr, tmpstr2 ) != 0 );
   
   tmpacc.password ( tmpstr );

   tmpacc.DBinsert ();


}

void Manager::show_inspect_account ( void )
{
   List lst_account ("Select an account to INSPECT", 22);
   Account tmpacc;
   dword index = db.search_table_entry ( DBTABLE_ACCOUNT );
//   string tmpstr;
   char strentry [ 81 ];   
   short answer = 0;

   while ( db.entry_table_tag ( index ) == DBTABLE_ACCOUNT )
   {
      tmpacc.DBselect ( index );
      strmake_account_list ( tmpacc, strentry );
      lst_account.add_item ( strentry );
      index++;
   }

   WinList wlst_account ( lst_account, 20, 40 );
   while ( answer != -1 )
   {
      Window::instruction ( 320, 460 );   
      answer = Window::show_all();
   }

}

void Manager::show_delete_account ( void )
{

//   string tmpstr;
   char strentry [ 81 ];
   char tmpstr2 [ 101 ];
   short answer = 0;
   short answer2 = 0;
   char password [ 11 ];
//   bool selected = false;
   DBTag copytag [ Manager_NB_MAX_ACCOUNT ];
   short j;
   Account tmpacc;

   while ( answer != -1 && nb_account() > 0 )
   {
      List lst_account ("Select an account to DELETE", 22);
      dword index = db.search_table_entry ( DBTABLE_ACCOUNT );
      j = 0;
      Window::instruction ( 320, 460 );      
      while ( db.entry_table_tag ( index ) == DBTABLE_ACCOUNT )
      {
         tmpacc.DBselect ( index );
         strmake_account_list ( tmpacc, strentry );
         lst_account.add_item ( strentry );
         copytag [ j ] = tmpacc.tag();
         index++;
         j++;
      }
      
      WinList wlst_account ( lst_account, 20, 40 );
      answer = Window::show_all();
      if ( answer != -1 )
      {
         tmpacc.DBselect ( copytag [ answer ] );
         sprintf ( tmpstr2, "Are you sure you want to delete the [%s] account?\nIt will remove all your players from all games",
            tmpacc.loginame() );
         WinQuestion wmsg_confirm ( tmpstr2 );
         answer2 = Window::show_all();
         wmsg_confirm.hide();
         if ( answer2 == 0 )
         {
            WinInput winp_password ("Enter your Account's password?", 10, 200, 100 );
            Window::show_all();
            winp_password.hide();
            winp_password.get_string ( password );

            if ( tmpacc.verify_password( password ) == true )
            {
               tmpacc.DBremove();
            }
            else
            {
               WinMessage wmsg_error ("Password Incorrect!");
               Window::show_all();
            }
         }
      }
   }
}

void Manager::show_create_race ( void )
{
   Race tmprace;
   tiny answer;

   tmprace.edit();

   WinQuestion wqst_confirm ("Do you want to save this new race?");
   answer = Window::show_all();

   if ( answer == WinQuestion_ANSWER_YES )
   {
      db.default_source ( DBSOURCE_SYSTEM );
      tmprace.DBinsert();
   }
}

void Manager::show_inspect_race ( void )
{
   List lst_race ("Select an Race to INSPECT", 22);
   Race tmprace;
   dword index = db.search_table_entry ( DBTABLE_RACE );
//   string tmpstr;
   char strentry [ 81 ];
   short answer = 0;
   DBTag tmptag;

   while ( db.entry_table_tag( index ) == DBTABLE_RACE )
   {
      tmptag = db.get_tag ( index );
      if ( tmptag.source() == DBSOURCE_SYSTEM )
      {
         tmprace.DBselect ( index );
         strmake_race_list ( tmprace, strentry );
         lst_race.add_item ( strentry );
      }
      index++;
   }

   WinList wlst_race ( lst_race, 20, 40 );
   while ( answer != -1 )
   {
      Window::instruction ( 320, 460 );   
      answer = Window::show_all();
   }

}

void Manager::show_delete_race ( void )
{
   List lst_race ("Select an Race to DELETE", 22);
   Race tmprace;
   dword index = db.search_table_entry ( DBTABLE_RACE );
//   string tmpstr;
   char strentry [ 81 ];
   short answer = 0;
   short answer2 = 0;
   DBTag tmptag;
   dword copyindex [ Manager_NB_MAX_RACE ];
   tiny j = 0;
   char tmpstr2 [ 101 ];

   while ( db.entry_table_tag( index ) == DBTABLE_RACE )
   {
      tmptag = db.get_tag ( index );
      if ( tmptag.source() == DBSOURCE_SYSTEM )
      {
         tmprace.DBselect ( index );
         strmake_race_list ( tmprace, strentry );
         lst_race.add_item ( strentry );
         copyindex [ j ] = index;
         j++;
      }
      index++;
   }

   WinList wlst_race ( lst_race, 20, 40 );
   if ( answer != -1 )
   {
      Window::instruction ( 320, 460 );   
      answer = Window::show_all();

      if ( answer >= 0 )
      {
         tmprace.DBselect ( copyindex [ answer ] );
         sprintf ( tmpstr2, "Are you sure you want to delete the %s", tmprace.plural() );
         WinQuestion wqst_confirm ( tmpstr2 );

         answer2 = Window::show_all();
         wqst_confirm.hide();

         if ( answer2 == WinQuestion_ANSWER_YES )
         {
            tmprace.DBremove();
         }
      }
   }
}

void Manager::show_import_race ( void )
{

}

void Manager::show_export_race ( void )
{

}

void Manager::show_create_class ( void )
{

}

void Manager::show_inspect_class ( void )
{

}

void Manager::show_delete_class ( void )
{

}

void Manager::show_import_class ( void )
{

}

void Manager::show_export_class ( void )
{

}

   
