/***************************************************************************/
/*                                                                         */
/*                         L I S T . C P P                                 */
/*                                                                         */
/*     Content : Class List                                                */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : August 25th, 2002                                   */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>
#include <string.h>
#include <datafile.h>
#include <advdatf.h>
#include <datmacro.h>
#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <dbobject.h>
//#include <database.h>
//#include <dbdef.h>
//#include <item.h>
//#include <armor.h>
//#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
#include <list.h>
//#include <opponent.h>
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                  Constructor and Destructor                           -*/
/*-------------------------------------------------------------------------*/

List::List ( void )
{
   strcpy ( p_title,"" );
   p_nb_item = 0;
   p_page_size = 3;
   p_page_pos = 0;
   p_sensible = false;
}

List::List ( const char* str, tiny psize, bool sensible )
{
//   string *tmp = new string;
//   *tmp = dat;

   strncpy  ( p_title, str, 81 );
   p_nb_item = 0;
   p_page_size = psize;
   p_page_pos = 0;
   p_sensible = sensible;

//   delete tmp;
}
/*List::List ( string &str, tiny psize, bool sensible )
{
   p_title = str;
   p_nb_item = 0;
   p_page_size = psize;
   p_page_pos = 0;
   p_sensible = sensible;
} */

List::~List ( void )
{
}

/*-------------------------------------------------------------------------*/
/*-                         Property Methods                              -*/
/*-------------------------------------------------------------------------*/


/*void List::title ( string &str )
{
   p_title = str;
} */

void List::title ( const char* str )
{
//   string *tmp = new string;

//   *tmp= dat ;

   strncpy ( p_title, str, 81 );

//   delete tmp;
}

const char* List::title ( void )
{
   return ( p_title );
}

void List::page_size ( tiny value )
{
   p_page_size = value;
}

tiny List::page_size ( void )
{
   return ( p_page_size );
}

void List::page_pos ( short value )
{
   p_page_pos = value;
}

short List::page_pos ( void )
{
   return ( p_page_pos );
}

short List::nb_item ()
{
   return ( p_nb_item );
}

short List::char_width ( void )
{
   short max_width = strlen ( p_title );
   short tmp_width;
   short i;

   for ( i = 0 ; i < p_nb_item ; i++ )
   {
      tmp_width = strlen ( p_item [ i ].text );
      if ( tmp_width > max_width )
         max_width = tmp_width;
   }

   max_width = max_width + 3;

   return ( max_width );
}

void List::sensible ( bool value )
{
   p_sensible = value;
}

bool List::sensible ( void )
{
   return ( p_sensible );
}


/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

/*void List::add_item ( string &str, bool mask )
{
   p_item [ p_nb_item ] . text = str;
   p_item [ p_nb_item ] . mask = mask;
   p_nb_item++;
} */

void List::add_item ( const char* str, bool mask )
{
//   string* tmp = new string;

//   *tmp = dat;
   strncpy ( p_item [ p_nb_item ] . text, str, 81 );
   p_item [ p_nb_item ] . mask = mask;
   p_nb_item++;
   

//   add_item ( *tmp, mask );
//   delete tmp;
}

/*void List::update_item ( string &str, short index, bool mask )
{
   p_item [ index ] . text = str;
   p_item [ index ] . mask = mask;
} */

void List::update_item ( const char *str, short index, bool mask )
{
//   string* tmp = new string;

//   *tmp = dat;
   strncpy ( p_item [ index ] . text, str, 81 );
   p_item [ index ] . mask = mask;
   

//   update_item ( *tmp, index, mask );
//   delete tmp;
}

/*
void List::add_item ( Weapon &wdat, tiny style = List_ADD_WEAPON_NAME,
                                                         bool mask = false )
{
   char tmpstr [ 51 ];

   switch ( style )
   {
      case List_ADD_WEAPON_NAME :
         p_item [ p_nb_item ] . text = wdat.name ();
         p_item [ p_nb_item ] . mask = mask;
      break;

      case List_ADD_WEAPON_BUY :
         sprintf ( tmpstr, "%s      %5d Gp  %2.2f Kg",
            wdat.cname (), wdat.price(), (float) wdat.weight () );
         p_item [ p_nb_item ] . text = tmpstr;
         p_item [ p_nb_item ] . mask = mask;
      break;
   }
   p_nb_item++;
}

void List::add_item ( Armor &adat, tiny style = List_ADD_ARMOR_NAME,
                                                         bool mask = false )
{
   char tmpstr [ 51 ];
   
   switch ( style )
   {
      case List_ADD_ARMOR_NAME :
         p_item [ p_nb_item ] . text = adat.name();
         p_item [ p_nb_item ] . mask = mask;
      break;
      
      case List_ADD_ARMOR_BUY :
         sprintf ( tmpstr, "%s      %5d Gp  %2.2f Kg",
            adat.cname (), adat.price(), (float) adat.weight ());
         p_item [ p_nb_item ] . text = tmpstr;
         p_item [ p_nb_item ] . mask = mask;
      break;
      
   }
   p_nb_item++;
}
  */
void List::mask_item ( short  ID )
{
   p_item [ ID ] . mask = true;
}

void List::unmask_all_item ( void )
{
   short i;
   
   for ( i = 0 ; i < List_MAX_NB_ITEM ; i++ )
      p_item [ i ] . mask = false;
}

void List::clear_all_item ( void )
{
   short i;
   
   for ( i = 0 ; i < List_MAX_NB_ITEM ; i++ )
   {
      p_item [ i ] . mask = false;
      strcpy ( p_item [ i ] . text,"" );
   }
   p_nb_item = 0;
}

short List::show ( short x, short y, short cursor_pos,
   bool reset_page, bool nocancel )

{
   tiny font_height = text_height ( List_FONT );
   tiny space = font_height / 2;
//   s_Menu_item *tmp_ptr;
   short i;
   short cursor = cursor_pos;
   short page = p_page_pos;
   short item_count = 0;
//   String tmp_str;
   char kbvalue;
   short base_y = 0;
   short yinc;
   short answer = cursor_pos;
   bool answer_found = false;
   bool rereadkb = false;
   bool selected_masked = false;
   int clr = List_COLOR_TEXT;
   bool scroll = true;
   BITMAP* backbuf = create_bitmap ( 640, 480 );

   char shotstr [ 8 ] [ 13 ]= { "lstshot1.bmp", "lstshot2.bmp", "lstshot3.bmp",
      "lstshot4.bmp", "lstshot5.bmp", "lstshot6.bmp", "lstshot7.bmp", "lstshot8.bmp" };
   static tiny shotID = 0;


   if ( reset_page == true )
      page = 0;

   if ( /*cursor < 0 || */page >= p_nb_item )
      cursor = 0;
      
   if ( /*page < 0 || */page >= p_nb_item )
      page = 0;

   if ( cursor < page )
      cursor = page;

   if ( cursor > page + p_page_size )
      page = cursor;

   clear_keybuf();
   
   clr = List_COLOR_TEXT;
   // main loop
   while ( answer_found == false )
   {
      if ( scroll == true )
      {
         scroll = false;
         blit ( buffer, backbuf , 0 , 0 , 0 , 0 , 640 , 480 );
         // draw or skip title
         if ( strcmp ( p_title, "" ) != 0 )
         {
            textprintf ( backbuf, List_FONT, x, y, List_COLOR_TEXT,
               "   %s", p_title );
            base_y = y + font_height + space;
         }
         else
            base_y = y;

         yinc = base_y;
         item_count = 0;
         selected_masked = false;

         i = page;
         while ( i < page + p_page_size && i < p_nb_item )
         {
            if ( p_item [ i ] . mask == true )
               clr = List_COLOR_MASK;
            else
               clr = List_COLOR_TEXT;

               if ( item_count == 0 && page > 0 )
                  textprintf ( backbuf, List_FONT, x, yinc, clr, "  -%s",
                     p_item [ i ] . text );
               else
                  if ( item_count == ( p_page_size - 1 ) &&
                     ( item_count + page ) != ( p_nb_item -1 ) )
                     textprintf ( backbuf, List_FONT, x, yinc, clr, "  +%s",
                        p_item [ i ] . text );
                  else
                     textprintf ( backbuf, List_FONT, x, yinc, clr, "   %s",
                        p_item [ i ] . text );

            yinc = yinc + font_height;
            item_count++;
            i++;
         }
         
      }
   
      vsync ();
      blit ( backbuf, screen , 0 , 0 , 0 , 0 , 640 , 480 );


      yinc = base_y;
      item_count = 0;
      selected_masked = false;

      i = page;
      clr = List_COLOR_TEXT;
      while ( i < page + p_page_size && i < p_nb_item )
      {
         if ( item_count + page == cursor )
         {
//            if ( item_count == 0 && page > 0 )
               textprintf ( screen, List_FONT, x, yinc, clr, "->" );
               selected_masked = p_item [ i ] . mask;

               
//            else
//               if ( item_count == ( p_page_size - 1 ) &&
//                  ( item_count + page ) != ( p_nb_item -1 ) )
//                  textprintf ( screen, List_FONT, x, yinc, clr, "->+%s",
//                     p_item [ i ] . text.data() );
//               else
//               {
//                  textprintf ( screen, List_FONT, x, yinc, clr, "-> %s",
//                     p_item [ i ] .  text.data() );
//                  selected_masked = p_item [ i ] . mask;
//               }
         }

         yinc = yinc + font_height;
         item_count++;
         i++;
      }

      // Keyboard reading

      rereadkb = true;

      while ( rereadkb == true )
      {
         kbvalue = readkey() >> 8;
         clear_keybuf();

         rereadkb = true;


         if ( kbvalue == SELECT_KEY )
         {
            if ( selected_masked == false )
            {
               answer = cursor;
               rereadkb = false;
               answer_found = true;
            }
         }
         
         if ( kbvalue == CANCEL_KEY )
         {
            if ( nocancel == true )
               rereadkb = true;
            else
            {
               answer = -1;
               rereadkb = false;
               answer_found = true;
            }
         }

         if ( kbvalue == KEY_UP )
         {
            if ( cursor > 0 )
            {
               cursor--;
               rereadkb = false;
               if ( cursor < page )
               {
                  page--;
                  scroll = true;
               }
               if ( p_sensible == true )
               {
                  answer = cursor;
                  rereadkb = false;
                  answer_found = true;
               }
            }
         }

         if ( kbvalue == KEY_DOWN )
         {
            if ( cursor < ( p_nb_item -1 ) )
            {
               cursor++;
               rereadkb = false;
               if ( cursor > ( page + p_page_size - 1 ) )
               {
                  page++;
                  scroll = true;
               }
               if ( p_sensible == true )
               {
                  answer = cursor;
                  rereadkb = false;
                  answer_found = true;
               }
            }
         }

         if ( kbvalue == KEY_SPACE )
         {
            make_screen_shot ( shotstr [ shotID ] );
            shotID++;
         }
         
      }
   }

   destroy_bitmap ( backbuf );
   p_page_pos = page;
   clear ( buffer );
   return ( answer );
}


