/***************************************************************************/
/*                                                                         */
/*                             I T E M . C P P                             */
/*                            Class source code                            */
/*                                                                         */
/*     Content : Class Item source code                                    */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 30th 2002                                     */
/*                                                                         */
/***************************************************************************/

#include <general.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <time.h>
#include <allegro.h>  //?? temporary, to remove
#include <string.h>
//#include <datafile.h>
//#include <datmacro.h>
//#include <system.h>
//#include <init.h>
//#include <menu.h>
//#include <option.h>
//#include <screen.h>
//#include <dbdata.h>
//#include <dbtag.h>
//#include <database.h>
//#include <dbobject.h>
#include <ddt.h>
#include <dbdef.h>
#include <item.h>
//#include <armor.h>
#include <weapon.h>
//#include <shield.h>
//#include <accesory.h>
//#include <expandbl.h>
//#include <list.h>
#include <opponent.h> //?? temporary, to remove
//#include <charactr.h>
//#include <monster.h>
//#include <party.h>
//#include <player.h>
//#include <game.h>
//#include <city.h>
//#include <maze.h>
//#include <adventur.h>
//#include <camp.h>
//#include <config.h>
//#include <draw.h>
//#include <dialog.h>
//#include <combat.h>

/*-------------------------------------------------------------------------*/
/*-                    Constructor & destructor                           -*/
/*-------------------------------------------------------------------------*/


Item::Item ( void )
{
   strcpy ( p_name, "" );
   strcpy ( p_fname, "" );
   p_type = Item_TYPE_OTHER;

   p_key = -1;
   p_identification = 0;
   p_ability.type = Item_ABILITY_NONE;
   p_ability.value = 0;
   p_ability.exhausted = Item_EXHAUST_BREAK;
   p_ability.max_charge = 0;
   p_ability.drawback = 0;
   p_ability.nb_charge = 0;
   p_autoability = Item_AUTOABILITY_NONE;
   p_hlteffect = Item_HLTEFFECT_NONE;
   p_elmeffect = Item_ELMEFFECT_NONE;
   p_magikproperty = 0;


   // must be set for DBObject to work properly
   p_dblength = sizeof ( dbs_Item );
   p_dbtableID = DBTABLE_ITEM;


}

Item::~Item ( void )
{

}
/*-------------------------------------------------------------------------*/
/*-                           Property Methods                            -*/
/*-------------------------------------------------------------------------*/


const char* Item::name ( void )
{
   return ( p_name );
}

const char* Item::fname ( void )
{
   return ( p_fname );
}

void Item::name ( const char* real, const char* hidden )
{
   strncpy ( p_name, real, Item_NAME_SIZE + 1 );
   strncpy ( p_fname, hidden, Item_NAME_SIZE + 1 );
}

dbs_Item_ability Item::ability ( void )
{
   return ( p_ability );
}

void Item::ability ( dbs_Item_ability data )
{
   p_ability = data;
   p_ability.nb_charge = p_ability.max_charge;
}

void Item::ability ( tiny type, tiny value, tiny max_charge, tiny exhausted,
    tiny drawback )
{
   p_ability.type = type;
   p_ability.value = value;
   p_ability.max_charge = max_charge;
   p_ability.exhausted = exhausted;
   p_ability.drawback = drawback;
   p_ability.nb_charge = max_charge;
}

byte Item::autoability ( void )
{
   return ( p_autoability );
}

void Item::autoability ( byte value )
{
   p_autoability = value;
}


word Item::hlteffect ( void )
{
   return ( p_hlteffect );
}

void Item::hlteffect ( word value )
{
   p_hlteffect = value;
}

word Item::elmeffect ( void )
{
   return ( p_elmeffect );
}

void Item::elmeffect ( word value )
{
   p_elmeffect = value;
}


tiny  Item::nb_charge ( void )
{
   return ( p_ability.nb_charge );
}

bool  Item::cursed ( void )
{
   if (( p_status & Item_STATUS_CURSED ) > 0 )
      return ( true );
   else
      return ( false );
}

tiny  Item::key ( void )
{
   return ( p_key );
}

byte  Item::identification ( void )
{
   return ( p_identification );
}

void Item::identification ( byte value )
{
   p_identification = value;
}

float Item::weight ( void )
{
   return ( p_weight );
}

void Item::weight ( float value )
{
   p_weight = value;
}

short  Item::price ( void )
{
   return (p_price );
}

void Item::price ( short value )
{
   p_price = value;
}

byte Item::status ( void )
{
   return ( p_status );
}

void Item::status ( byte value )
{
   p_status = value;
}

tiny Item::rarity ( void )
{
   return ( p_rarity );
}

void Item::rarity ( tiny value )
{
   p_rarity = value;
}


word Item::magikproperty ( void )
{
   return ( p_magikproperty );
}

void Item::magikproperty ( word value )
{
   p_magikproperty = value;
}

tiny Item::location ( void )
{
   return ( p_location );
}

void Item::location ( tiny value )
{
   p_location = value;
}


const char* Item::vname ( void )
{
   if ( ( p_identification & Item_IDENTIFICATION_NAME ) > 0 )
      return ( p_name );
   else
      return ( p_fname );
}

void Item::statusS1 ( char *str )
{
   strcpy ( str, "" );

/*   if ( p_status == 0 )
      strcat ( str , "Normal " );

   if ( ( p_status & Item_STATUS_FOUND ) > 0 )
      strcat ( str, "Normal " );*/

   strcat ( str, STR_ITM_RARITY [ p_rarity ] );

//   if ( ( p_status & Item_STATUS_FINE ) > 0 )
//      strcat ( str , "Fine " );

   if ( ( p_status & Item_STATUS_ENCHANTED ) > 0 )
      strcat ( str, "Enchanted ");

   if ( ( p_status & Item_STATUS_ARTIFACT ) > 0 )
      strcat ( str , "Artifact " );


}


void Item::statusS2 ( char *str )
{
   strcpy ( str, "" );

   if ( ( p_status & Item_STATUS_CURSED ) > 0 )
      strcat ( str, "Cursed " );

//   if ( ( p_status & Item_STATUS_UNIQUE ) > 0 )
//      strcat ( str, "Unique " );

   if ( p_key != -1 )
      strcat ( str, "Key " );

   strcat ( str, "Item" );


}

const char* Item::typeS ( void )
{
   return ( STR_ITM_TYPE [ p_type ] );
}

void Item::abilityS ( char* str )
{

   // utiliser une table de string printf avec 1 variable en parametre
   
   switch ( p_ability.type )
   {
      case Item_ABILITY_NONE :
      break;
      case Item_ABILITY_SPELL :
         sprintf ( str, "%s Spell", STR_ITM_ABILITY [ p_ability.type ] );
      break;
      case Item_ABILITY_RAISE_MAXHP :
      case Item_ABILITY_RAISE_MAXSP :
      case Item_ABILITY_GAIN_EXP :
      case Item_ABILITY_LOWER_AGE :
      case Item_ABILITY_RAISE_SOUL :
         sprintf ( str, "%s %d", STR_ITM_ABILITY [ p_ability.type ],
            p_ability.value );
      break;
      case Item_ABILITY_RECOVER_HP :
      case Item_ABILITY_RECOVER_MP :
         sprintf ( str, "%s %d-%d", STR_ITM_ABILITY[ p_ability.type ],
            ( p_ability.value / 2 ), p_ability.value );
      break;
      case Item_ABILITY_RAISE_ATTRIBUTE :
      break;
      case Item_ABILITY_CURE_HEALTH :
      break;
      case Item_ABILITY_RAISE_STAT :
      break;
   }
}
const char* Item::autoabilityS ( void )
{
   return ("");
}


const char* Item::exhaustedS( void )
{
   return ("-");
}


const char* Item::drawbackS( void )
{
   return ("-");
}


/*-------------------------------------------------------------------------*/
/*-                              Methods                                  -*/
/*-------------------------------------------------------------------------*/

void Item::recharge ( void )
{
   p_ability.nb_charge = p_ability.max_charge;
}

bool Item::is_key ( tiny lockID )
{
   if ( p_key == lockID )
      return ( true );
   else
      return ( false );
}


/*-------------------------------------------------------------------------*/
/*-                         Private Methods                               -*/
/*-------------------------------------------------------------------------*/

bool Item::identified ( tiny type )
{
   if ( ( p_identification & type ) > 0 )
      return ( true );
   else
      return ( false );
}


/*-------------------------------------------------------------------------*/
/*-                        Virtual Methods                                -*/
/*-------------------------------------------------------------------------*/

tiny Item::type ( void )
{
   return ( p_type );
}

void Item::objdat_to_strdat ( void* dataptr )
{
   dbs_Item &tmpdat = *(static_cast<dbs_Item*> ( dataptr ));

   strncpy ( tmpdat.name, p_name, Item_NAME_SIZE + 1);
   strncpy ( tmpdat.fname, p_fname, Item_NAME_SIZE + 1);
   tmpdat.type = p_type;
   tmpdat.location = p_location;
   tmpdat.ability.type = p_ability.type;
   tmpdat.ability.value = p_ability.value;
   tmpdat.ability.max_charge = p_ability.max_charge;
   tmpdat.ability.exhausted = p_ability.exhausted;
   tmpdat.ability.drawback = p_ability.drawback;
   tmpdat.ability.nb_charge = p_ability.nb_charge;
   tmpdat.autoability = p_autoability;
   tmpdat.hlteffect = p_hlteffect;
   tmpdat.elmeffect = p_elmeffect;
   tmpdat.magikproperty = p_magikproperty;   
   tmpdat.key = p_key;
   tmpdat.identification = p_identification;
   tmpdat.weight = p_weight;
   tmpdat.status = p_status;
   tmpdat.rarity = p_rarity;
   tmpdat.price = p_price;

}

void Item::strdat_to_objdat ( void *dataptr )
{
   dbs_Item &tmpdat = *(static_cast<dbs_Item*> ( dataptr ));

   strcpy ( p_name, tmpdat.name );
   strcpy ( p_fname, tmpdat.fname );
   p_type = tmpdat.type;
   p_location = tmpdat.location;
   p_ability.type = tmpdat.ability.type;
   p_ability.value = tmpdat.ability.value;
   p_ability.max_charge = tmpdat.ability.max_charge;
   p_ability.exhausted = tmpdat.ability.exhausted;
   p_ability.drawback = tmpdat.ability.drawback;
   p_ability.nb_charge = tmpdat.ability.nb_charge;
   p_autoability = tmpdat.autoability;
   p_hlteffect = tmpdat.hlteffect;
   p_elmeffect = tmpdat.elmeffect;
   p_magikproperty = tmpdat.magikproperty;
   p_key = tmpdat.key;
   p_identification = tmpdat.identification;
   p_weight = tmpdat.weight;
   p_status = tmpdat.status;
   p_rarity = tmpdat.rarity;
   p_price = tmpdat.price;

}

void Item::child_DBremove ( void )
{
   // no child to remove
}





